/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.field.InspectionSpecificationTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.link.InspectionSpecificationTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.selectable.InspectionSpecificationTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Master Inspection Characteristic Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionSpecificationTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionSpecificationText extends VdmEntity<InspectionSpecificationText>
{

    /**
     * Selector for all available fields of InspectionSpecificationText.
     *
     */
    public final static InspectionSpecificationTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecification</b>
     * </p>
     *
     * @return Master Inspection Characteristic
     */
    @Key
    @SerializedName( "InspectionSpecification" )
    @JsonProperty( "InspectionSpecification" )
    @Nullable
    @ODataField( odataName = "InspectionSpecification" )
    private String inspectionSpecification;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecification</b> field to query operations.
     *
     */
    public final static InspectionSpecificationTextField<String> INSPECTION_SPECIFICATION =
        new InspectionSpecificationTextField<String>("InspectionSpecification");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationVersion</b>
     * </p>
     *
     * @return Version Number of Inspection Method
     */
    @Key
    @SerializedName( "InspectionSpecificationVersion" )
    @JsonProperty( "InspectionSpecificationVersion" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationVersion" )
    private String inspectionSpecificationVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationVersion</b> field to query operations.
     *
     */
    public final static InspectionSpecificationTextField<String> INSPECTION_SPECIFICATION_VERSION =
        new InspectionSpecificationTextField<String>("InspectionSpecificationVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationPlant</b>
     * </p>
     *
     * @return Plant for Master Inspection Characteristic
     */
    @Key
    @SerializedName( "InspectionSpecificationPlant" )
    @JsonProperty( "InspectionSpecificationPlant" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationPlant" )
    private String inspectionSpecificationPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationPlant</b> field to query operations.
     *
     */
    public final static InspectionSpecificationTextField<String> INSPECTION_SPECIFICATION_PLANT =
        new InspectionSpecificationTextField<String>("InspectionSpecificationPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static InspectionSpecificationTextField<String> LANGUAGE =
        new InspectionSpecificationTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationText</b>
     * </p>
     *
     * @return Text of Master Inspection Characteristic
     */
    @SerializedName( "InspectionSpecificationText" )
    @JsonProperty( "InspectionSpecificationText" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationText" )
    private String inspectionSpecificationText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationText</b> field to query operations.
     *
     */
    public final static InspectionSpecificationTextField<String> INSPECTION_SPECIFICATION_TEXT =
        new InspectionSpecificationTextField<String>("InspectionSpecificationText");
    /**
     * Navigation property <b>to_InspectionSpecification</b> for <b>InspectionSpecificationText</b> to single
     * <b>InspectionSpecification</b>.
     *
     */
    @SerializedName( "to_InspectionSpecification" )
    @JsonProperty( "to_InspectionSpecification" )
    @ODataField( odataName = "to_InspectionSpecification" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private InspectionSpecification toInspectionSpecification;
    /**
     * Use with available fluent helpers to apply the <b>to_InspectionSpecification</b> navigation property to query
     * operations.
     *
     */
    public final static InspectionSpecificationTextOneToOneLink<InspectionSpecification> TO_INSPECTION_SPECIFICATION =
        new InspectionSpecificationTextOneToOneLink<InspectionSpecification>("to_InspectionSpecification");

    @Nonnull
    @Override
    public Class<InspectionSpecificationText> getType()
    {
        return InspectionSpecificationText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecification</b>
     * </p>
     *
     * @param inspectionSpecification
     *            Master Inspection Characteristic
     */
    public void setInspectionSpecification( @Nullable final String inspectionSpecification )
    {
        rememberChangedField("InspectionSpecification", this.inspectionSpecification);
        this.inspectionSpecification = inspectionSpecification;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationVersion</b>
     * </p>
     *
     * @param inspectionSpecificationVersion
     *            Version Number of Inspection Method
     */
    public void setInspectionSpecificationVersion( @Nullable final String inspectionSpecificationVersion )
    {
        rememberChangedField("InspectionSpecificationVersion", this.inspectionSpecificationVersion);
        this.inspectionSpecificationVersion = inspectionSpecificationVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationPlant</b>
     * </p>
     *
     * @param inspectionSpecificationPlant
     *            Plant for Master Inspection Characteristic
     */
    public void setInspectionSpecificationPlant( @Nullable final String inspectionSpecificationPlant )
    {
        rememberChangedField("InspectionSpecificationPlant", this.inspectionSpecificationPlant);
        this.inspectionSpecificationPlant = inspectionSpecificationPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationText</b>
     * </p>
     *
     * @param inspectionSpecificationText
     *            Text of Master Inspection Characteristic
     */
    public void setInspectionSpecificationText( @Nullable final String inspectionSpecificationText )
    {
        rememberChangedField("InspectionSpecificationText", this.inspectionSpecificationText);
        this.inspectionSpecificationText = inspectionSpecificationText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionSpecificationText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionSpecification", getInspectionSpecification());
        result.put("InspectionSpecificationVersion", getInspectionSpecificationVersion());
        result.put("InspectionSpecificationPlant", getInspectionSpecificationPlant());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionSpecification", getInspectionSpecification());
        values.put("InspectionSpecificationVersion", getInspectionSpecificationVersion());
        values.put("InspectionSpecificationPlant", getInspectionSpecificationPlant());
        values.put("Language", getLanguage());
        values.put("InspectionSpecificationText", getInspectionSpecificationText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionSpecification") ) {
                final Object value = values.remove("InspectionSpecification");
                if( (value == null) || (!value.equals(getInspectionSpecification())) ) {
                    setInspectionSpecification(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationVersion") ) {
                final Object value = values.remove("InspectionSpecificationVersion");
                if( (value == null) || (!value.equals(getInspectionSpecificationVersion())) ) {
                    setInspectionSpecificationVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationPlant") ) {
                final Object value = values.remove("InspectionSpecificationPlant");
                if( (value == null) || (!value.equals(getInspectionSpecificationPlant())) ) {
                    setInspectionSpecificationPlant(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationText") ) {
                final Object value = values.remove("InspectionSpecificationText");
                if( (value == null) || (!value.equals(getInspectionSpecificationText())) ) {
                    setInspectionSpecificationText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_InspectionSpecification") ) {
                final Object value = (values).remove("to_InspectionSpecification");
                if( value instanceof Map ) {
                    if( toInspectionSpecification == null ) {
                        toInspectionSpecification = new InspectionSpecification();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toInspectionSpecification.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InspectionSpecificationTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new InspectionSpecificationTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionSpecificationTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionSpecificationTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toInspectionSpecification != null ) {
            (values).put("to_InspectionSpecification", toInspectionSpecification);
        }
        return values;
    }

    /**
     * Fetches the <b>InspectionSpecification</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_InspectionSpecification</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>InspectionSpecification</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InspectionSpecification fetchInspectionSpecification()
    {
        return fetchFieldAsSingle("to_InspectionSpecification", InspectionSpecification.class);
    }

    /**
     * Retrieval of associated <b>InspectionSpecification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_InspectionSpecification</b>.
     * <p>
     * If the navigation property <b>to_InspectionSpecification</b> of a queried <b>InspectionSpecificationText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InspectionSpecification</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InspectionSpecification getInspectionSpecificationOrFetch()
    {
        if( toInspectionSpecification == null ) {
            toInspectionSpecification = fetchInspectionSpecification();
        }
        return toInspectionSpecification;
    }

    /**
     * Retrieval of associated <b>InspectionSpecification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_InspectionSpecification</b>.
     * <p>
     * If the navigation property for an entity <b>InspectionSpecificationText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_InspectionSpecification</b> is already loaded, the
     *         result will contain the <b>InspectionSpecification</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<InspectionSpecification> getInspectionSpecificationIfPresent()
    {
        return Option.of(toInspectionSpecification);
    }

    /**
     * Overwrites the associated <b>InspectionSpecification</b> entity for the loaded navigation property
     * <b>to_InspectionSpecification</b>.
     *
     * @param value
     *            New <b>InspectionSpecification</b> entity.
     */
    public void setInspectionSpecification( final InspectionSpecification value )
    {
        toInspectionSpecification = value;
    }

    /**
     * Helper class to allow for fluent creation of InspectionSpecificationText instances.
     *
     */
    public final static class InspectionSpecificationTextBuilder
    {

        private InspectionSpecification toInspectionSpecification;
        private String inspectionSpecification = null;

        private InspectionSpecificationText.InspectionSpecificationTextBuilder toInspectionSpecification(
            final InspectionSpecification value )
        {
            toInspectionSpecification = value;
            return this;
        }

        /**
         * Navigation property <b>to_InspectionSpecification</b> for <b>InspectionSpecificationText</b> to single
         * <b>InspectionSpecification</b>.
         *
         * @param value
         *            The InspectionSpecification to build this InspectionSpecificationText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspectionSpecificationText.InspectionSpecificationTextBuilder inspectionSpecification(
            final InspectionSpecification value )
        {
            return toInspectionSpecification(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 8
         * <p>
         * Original property name from the Odata EDM: <b>InspectionSpecification</b>
         * </p>
         *
         * @param value
         *            The inspectionSpecification to build this InspectionSpecificationText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspectionSpecificationText.InspectionSpecificationTextBuilder inspectionSpecification(
            final String value )
        {
            inspectionSpecification = value;
            return this;
        }

    }

}
