/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MasterInspectionCharacteristicServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService
 * MasterInspectionCharacteristicService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultMasterInspectionCharacteristicServiceBatch
    extends
    BatchFluentHelperBasic<MasterInspectionCharacteristicServiceBatch, MasterInspectionCharacteristicServiceBatchChangeSet>
    implements
    MasterInspectionCharacteristicServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMasterInspectionCharacteristicServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMasterInspectionCharacteristicServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMasterInspectionCharacteristicServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMasterInspectionCharacteristicServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMasterInspectionCharacteristicServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MasterInspectionCharacteristicServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMasterInspectionCharacteristicServiceBatchChangeSet(this, service);
    }

}
