/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link MasterInspectionCharacteristicServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService
 * MasterInspectionCharacteristicService}.
 *
 */
public class DefaultMasterInspectionCharacteristicServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MasterInspectionCharacteristicServiceBatch, MasterInspectionCharacteristicServiceBatchChangeSet>
    implements
    MasterInspectionCharacteristicServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService service;

    @SuppressWarnings( "deprecation" )
    DefaultMasterInspectionCharacteristicServiceBatchChangeSet(
        @Nonnull final DefaultMasterInspectionCharacteristicServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMasterInspectionCharacteristicServiceBatchChangeSet getThis()
    {
        return this;
    }

}
