/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification
 * InspectionSpecification}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.field.InspectionSpecificationField
 * InspectionSpecificationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.link.InspectionSpecificationLink
 * InspectionSpecificationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSPECTION_SPECIFICATION
 * INSPECTION_SPECIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSPECTION_SPECIFICATION_VERSION
 * INSPECTION_SPECIFICATION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSPECTION_SPECIFICATION_PLANT
 * INSPECTION_SPECIFICATION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSPECTION_SPECIFICATION_SRCH_TXT
 * INSPECTION_SPECIFICATION_SRCH_TXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_GLOBAL_NAME
 * INSP_SPEC_GLOBAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSPECTION_SPECIFICATION_STATUS
 * INSPECTION_SPECIFICATION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_TRANSFER_TYPE
 * INSP_SPEC_TRANSFER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_CREATED_BY_USER
 * INSP_SPEC_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_CREATION_DATE
 * INSP_SPEC_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_CHANGED_BY_USER
 * INSP_SPEC_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_CHANGE_DATE
 * INSP_SPEC_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_QUANTITATIVE
 * INSP_SPEC_IS_QUANTITATIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_CHARACTERISTIC_TYPE
 * INSP_SPEC_CHARACTERISTIC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_MEASURED_VALUE_RQD
 * INSP_SPEC_IS_MEASURED_VALUE_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_SELECTED_SET_REQUIRED
 * INSP_SPEC_IS_SELECTED_SET_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_UPPER_LIMIT_REQUIRED
 * INSP_SPEC_IS_UPPER_LIMIT_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_LOWER_LIMIT_REQUIRED
 * INSP_SPEC_IS_LOWER_LIMIT_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_TARGET_VALUE_IN_LIMIT
 * INSP_SPEC_IS_TARGET_VALUE_IN_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSPECTION_SCOPE
 * INSPECTION_SCOPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_LONG_TERM_INSPECTION
 * INSP_SPEC_IS_LONG_TERM_INSPECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_RECORDING_TYPE
 * INSP_SPEC_RECORDING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_RESULT_IS_DOCUMENTATION_RQD
 * INSP_RESULT_IS_DOCUMENTATION_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_CHARC_CATEGORY
 * INSP_SPEC_CHARC_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC
 * INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_SAMPLE_QTY_ADDITIVE
 * INSP_SPEC_IS_SAMPLE_QTY_ADDITIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_DESTRUCTIVE
 * INSP_SPEC_IS_DESTRUCTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_RESULT_CALCULATION
 * INSP_SPEC_RESULT_CALCULATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_SAMPLING_PROCED_RQD
 * INSP_SPEC_IS_SAMPLING_PROCED_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_SCRAP_RELEVANT
 * INSP_SPEC_IS_SCRAP_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_TEST_EQUIPMENT_RQD
 * INSP_SPEC_IS_TEST_EQUIPMENT_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_CHG_DOC_REQUIRED
 * INSP_SPEC_IS_CHG_DOC_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IS_CONTROL_CHART_USED
 * INSP_SPEC_IS_CONTROL_CHART_USED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_PRINT_CONTROL
 * INSP_SPEC_PRINT_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_IMPORTANCE_CODE
 * INSP_SPEC_IMPORTANCE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSPECTOR_QUALIFICATION
 * INSPECTOR_QUALIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_INFORMATION_FIELD1
 * INSP_SPEC_INFORMATION_FIELD1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_INFORMATION_FIELD2
 * INSP_SPEC_INFORMATION_FIELD2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_INFORMATION_FIELD3
 * INSP_SPEC_INFORMATION_FIELD3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#QLTY_MSTR_DATA_AUTHORIZATION_GROUP
 * QLTY_MSTR_DATA_AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_TOLERANCE_SPECIFICATION
 * INSP_TOLERANCE_SPECIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_DECIMAL_PLACES
 * INSP_SPEC_DECIMAL_PLACES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSPECTION_SPECIFICATION_UNIT
 * INSPECTION_SPECIFICATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPECIFICATION_UNIT_TECH_NAME
 * INSP_SPECIFICATION_UNIT_TECH_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPECIFICATION_UNIT_ISO_CODE
 * INSP_SPECIFICATION_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPECIFICATION_UNIT_SAP_CODE
 * INSP_SPECIFICATION_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_TARGET_VALUE
 * INSP_SPEC_TARGET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_TARGET_VALUE
 * INSP_SPEC_HAS_TARGET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_LOWER_LIMIT
 * INSP_SPEC_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_LOWER_LIMIT
 * INSP_SPEC_HAS_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_LOWER_PLAUSIBILITY_LIMIT
 * INSP_SPEC_LOWER_PLAUSIBILITY_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_LOWR_PLAUSIBILITY_LMT
 * INSP_SPEC_HAS_LOWR_PLAUSIBILITY_LMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_FIRST_LOWER_SPEC_LIMIT
 * INSP_SPEC_FIRST_LOWER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_FIRST_LOWER_SPEC_LIMIT
 * INSP_SPEC_HAS_FIRST_LOWER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_SECOND_LOWER_SPEC_LIMIT
 * INSP_SPEC_SECOND_LOWER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_SECOND_LOWR_SPEC_LIMIT
 * INSP_SPEC_HAS_SECOND_LOWR_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_LOWER_SPEC_LIMIT_CHANGE
 * INSP_SPEC_LOWER_SPEC_LIMIT_CHANGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_LOWR_SPEC_LIMIT_CHANGE
 * INSP_SPEC_HAS_LOWR_SPEC_LIMIT_CHANGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_UPPER_LIMIT
 * INSP_SPEC_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_UPPER_LIMIT
 * INSP_SPEC_HAS_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_UPPER_PLAUSIBILITY_LIMIT
 * INSP_SPEC_UPPER_PLAUSIBILITY_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_UPR_PLAUSIBILITY_LMT
 * INSP_SPEC_HAS_UPR_PLAUSIBILITY_LMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_FIRST_UPPER_SPEC_LIMIT
 * INSP_SPEC_FIRST_UPPER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_FIRST_UPPER_SPEC_LIMIT
 * INSP_SPEC_HAS_FIRST_UPPER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_SECOND_UPPER_SPEC_LIMIT
 * INSP_SPEC_SECOND_UPPER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_SECOND_UPR_SPEC_LIMIT
 * INSP_SPEC_HAS_SECOND_UPR_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_UPPER_SPEC_LIMIT_CHANGE
 * INSP_SPEC_UPPER_SPEC_LIMIT_CHANGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_HAS_UPR_SPEC_LIMIT_CHANGE
 * INSP_SPEC_HAS_UPR_SPEC_LIMIT_CHANGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_TOLERANCE_CHG_VALID_FROM
 * INSP_SPEC_TOLERANCE_CHG_VALID_FROM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_TOLERANCE_CHG_VALID_TO
 * INSP_SPEC_TOLERANCE_CHG_VALID_TO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_DEFECT_CODE_GRP_REJECTION
 * INSP_SPEC_DEFECT_CODE_GRP_REJECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_DEFECT_CODE_REJECTION
 * INSP_SPEC_DEFECT_CODE_REJECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_DEFECT_CODE_GRP_RJCN_UPPER
 * INSP_SPEC_DEFECT_CODE_GRP_RJCN_UPPER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_DEFECT_CODE_RJCN_UPPER
 * INSP_SPEC_DEFECT_CODE_RJCN_UPPER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_DEFECT_CODE_GRP_RJCN_LOWER
 * INSP_SPEC_DEFECT_CODE_GRP_RJCN_LOWER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#INSP_SPEC_DEFECT_CODE_RJCN_LOWER
 * INSP_SPEC_DEFECT_CODE_RJCN_LOWER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#CHARACTERISTIC_INTERNAL_ID
 * CHARACTERISTIC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#DEFECT_FRACTION_ESTIMATION_PROCED
 * DEFECT_FRACTION_ESTIMATION_PROCED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface InspectionSpecificationSelectable extends EntitySelectable<InspectionSpecification>
{

}
