/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText
 * InspectionSpecificationText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.field.InspectionSpecificationTextField
 * InspectionSpecificationTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.link.InspectionSpecificationTextLink
 * InspectionSpecificationTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText#INSPECTION_SPECIFICATION
 * INSPECTION_SPECIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText#INSPECTION_SPECIFICATION_VERSION
 * INSPECTION_SPECIFICATION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText#INSPECTION_SPECIFICATION_PLANT
 * INSPECTION_SPECIFICATION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText#INSPECTION_SPECIFICATION_TEXT
 * INSPECTION_SPECIFICATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText#TO_INSPECTION_SPECIFICATION
 * TO_INSPECTION_SPECIFICATION}</li>
 * </ul>
 *
 */
public interface InspectionSpecificationTextSelectable extends EntitySelectable<InspectionSpecificationText>
{

}
