/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.field.MasterRecipeHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.link.MasterRecipeHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable.MasterRecipeHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MasterRecipeHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MasterRecipeHeader extends VdmEntity<MasterRecipeHeader>
{

    /**
     * Selector for all available fields of MasterRecipeHeader.
     *
     */
    public final static MasterRecipeHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "MasterRecipeGroup" )
    @JsonProperty( "MasterRecipeGroup" )
    @Nullable
    @ODataField( odataName = "MasterRecipeGroup" )
    private String masterRecipeGroup;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipeGroup</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> MASTER_RECIPE_GROUP =
        new MasterRecipeHeaderField<String>("MasterRecipeGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipe</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "MasterRecipe" )
    @JsonProperty( "MasterRecipe" )
    @Nullable
    @ODataField( odataName = "MasterRecipe" )
    private String masterRecipe;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipe</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> MASTER_RECIPE =
        new MasterRecipeHeaderField<String>("MasterRecipe");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeInternalVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "MasterRecipeInternalVersion" )
    @JsonProperty( "MasterRecipeInternalVersion" )
    @Nullable
    @ODataField( odataName = "MasterRecipeInternalVersion" )
    private String masterRecipeInternalVersion;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipeInternalVersion</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> MASTER_RECIPE_INTERNAL_VERSION =
        new MasterRecipeHeaderField<String>("MasterRecipeInternalVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Indicator: Delete completely in reorganization run
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<Boolean> IS_MARKED_FOR_DELETION =
        new MasterRecipeHeaderField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsDesc</b>
     * </p>
     *
     * @return Routing Description
     */
    @SerializedName( "BillOfOperationsDesc" )
    @JsonProperty( "BillOfOperationsDesc" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsDesc" )
    private String billOfOperationsDesc;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsDesc</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> BILL_OF_OPERATIONS_DESC =
        new MasterRecipeHeaderField<String>("BillOfOperationsDesc");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LongTextLanguageCode</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "LongTextLanguageCode" )
    @JsonProperty( "LongTextLanguageCode" )
    @Nullable
    @ODataField( odataName = "LongTextLanguageCode" )
    private String longTextLanguageCode;
    /**
     * Use with available fluent helpers to apply the <b>LongTextLanguageCode</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> LONG_TEXT_LANGUAGE_CODE =
        new MasterRecipeHeaderField<String>("LongTextLanguageCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "PlainLongText" )
    @JsonProperty( "PlainLongText" )
    @Nullable
    @ODataField( odataName = "PlainLongText" )
    private String plainLongText;
    /**
     * Use with available fluent helpers to apply the <b>PlainLongText</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> PLAIN_LONG_TEXT =
        new MasterRecipeHeaderField<String>("PlainLongText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> PLANT = new MasterRecipeHeaderField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsStatus</b>
     * </p>
     *
     * @return Status
     */
    @SerializedName( "BillOfOperationsStatus" )
    @JsonProperty( "BillOfOperationsStatus" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsStatus" )
    private String billOfOperationsStatus;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsStatus</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> BILL_OF_OPERATIONS_STATUS =
        new MasterRecipeHeaderField<String>("BillOfOperationsStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUsage</b>
     * </p>
     *
     * @return Task List Usage
     */
    @SerializedName( "BillOfOperationsUsage" )
    @JsonProperty( "BillOfOperationsUsage" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsUsage" )
    private String billOfOperationsUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsUsage</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> BILL_OF_OPERATIONS_USAGE =
        new MasterRecipeHeaderField<String>("BillOfOperationsUsage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     *
     * @return Responsible Planner Group or Department
     */
    @SerializedName( "ResponsiblePlannerGroup" )
    @JsonProperty( "ResponsiblePlannerGroup" )
    @Nullable
    @ODataField( odataName = "ResponsiblePlannerGroup" )
    private String responsiblePlannerGroup;
    /**
     * Use with available fluent helpers to apply the <b>ResponsiblePlannerGroup</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> RESPONSIBLE_PLANNER_GROUP =
        new MasterRecipeHeaderField<String>("ResponsiblePlannerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsProfile</b>
     * </p>
     *
     * @return Profile
     */
    @SerializedName( "BillOfOperationsProfile" )
    @JsonProperty( "BillOfOperationsProfile" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsProfile" )
    private String billOfOperationsProfile;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsProfile</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> BILL_OF_OPERATIONS_PROFILE =
        new MasterRecipeHeaderField<String>("BillOfOperationsProfile");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size
     */
    @SerializedName( "MinimumLotSizeQuantity" )
    @JsonProperty( "MinimumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumLotSizeQuantity" )
    private BigDecimal minimumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<BigDecimal> MINIMUM_LOT_SIZE_QUANTITY =
        new MasterRecipeHeaderField<BigDecimal>("MinimumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size
     */
    @SerializedName( "MaximumLotSizeQuantity" )
    @JsonProperty( "MaximumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumLotSizeQuantity" )
    private BigDecimal maximumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<BigDecimal> MAXIMUM_LOT_SIZE_QUANTITY =
        new MasterRecipeHeaderField<BigDecimal>("MaximumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUnit</b>
     * </p>
     *
     * @return Task List Unit of Measure
     */
    @SerializedName( "BillOfOperationsUnit" )
    @JsonProperty( "BillOfOperationsUnit" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsUnit" )
    private String billOfOperationsUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsUnit</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> BILL_OF_OPERATIONS_UNIT =
        new MasterRecipeHeaderField<String>("BillOfOperationsUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<LocalDateTime> CREATION_DATE =
        new MasterRecipeHeaderField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> CREATED_BY_USER =
        new MasterRecipeHeaderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<LocalDateTime> LAST_CHANGE_DATE =
        new MasterRecipeHeaderField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> LAST_CHANGED_BY_USER =
        new MasterRecipeHeaderField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<LocalDateTime> VALIDITY_START_DATE =
        new MasterRecipeHeaderField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<LocalDateTime> VALIDITY_END_DATE =
        new MasterRecipeHeaderField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> CHANGE_NUMBER =
        new MasterRecipeHeaderField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<ZonedDateTime> CHANGED_DATE_TIME =
        new MasterRecipeHeaderField<ZonedDateTime>("ChangedDateTime");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationReferenceQuantity</b>
     * </p>
     *
     * @return Base Quantity
     */
    @SerializedName( "OperationReferenceQuantity" )
    @JsonProperty( "OperationReferenceQuantity" )
    @Nullable
    @ODataField( odataName = "OperationReferenceQuantity" )
    private BigDecimal operationReferenceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OperationReferenceQuantity</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<BigDecimal> OPERATION_REFERENCE_QUANTITY =
        new MasterRecipeHeaderField<BigDecimal>("OperationReferenceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @return Unit of Measure for Activity/Operation
     */
    @SerializedName( "OperationUnit" )
    @JsonProperty( "OperationUnit" )
    @Nullable
    @ODataField( odataName = "OperationUnit" )
    private String operationUnit;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnit</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<String> OPERATION_UNIT =
        new MasterRecipeHeaderField<String>("OperationUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for Converting Routing and Operation UoM
     */
    @SerializedName( "OpQtyToBaseQtyNmrtr" )
    @JsonProperty( "OpQtyToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "OpQtyToBaseQtyNmrtr" )
    private BigDecimal opQtyToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OpQtyToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<BigDecimal> OP_QTY_TO_BASE_QTY_NMRTR =
        new MasterRecipeHeaderField<BigDecimal>("OpQtyToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for Converting Routing and Operation UoM
     */
    @SerializedName( "OpQtyToBaseQtyDnmntr" )
    @JsonProperty( "OpQtyToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "OpQtyToBaseQtyDnmntr" )
    private BigDecimal opQtyToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OpQtyToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static MasterRecipeHeaderField<BigDecimal> OP_QTY_TO_BASE_QTY_DNMNTR =
        new MasterRecipeHeaderField<BigDecimal>("OpQtyToBaseQtyDnmntr");
    /**
     * Navigation property <b>to_MatlAssgmt</b> for <b>MasterRecipeHeader</b> to multiple <b>MasterRecipeMatlAssgmt</b>.
     *
     */
    @SerializedName( "to_MatlAssgmt" )
    @JsonProperty( "to_MatlAssgmt" )
    @ODataField( odataName = "to_MatlAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MasterRecipeMatlAssgmt> toMatlAssgmt;
    /**
     * Navigation property <b>to_Operation</b> for <b>MasterRecipeHeader</b> to multiple <b>MasterRecipeOperation</b>.
     *
     */
    @SerializedName( "to_Operation" )
    @JsonProperty( "to_Operation" )
    @ODataField( odataName = "to_Operation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MasterRecipeOperation> toOperation;
    /**
     * Use with available fluent helpers to apply the <b>to_MatlAssgmt</b> navigation property to query operations.
     *
     */
    public final static MasterRecipeHeaderLink<MasterRecipeMatlAssgmt> TO_MATL_ASSGMT =
        new MasterRecipeHeaderLink<MasterRecipeMatlAssgmt>("to_MatlAssgmt");
    /**
     * Use with available fluent helpers to apply the <b>to_Operation</b> navigation property to query operations.
     *
     */
    public final static MasterRecipeHeaderLink<MasterRecipeOperation> TO_OPERATION =
        new MasterRecipeHeaderLink<MasterRecipeOperation>("to_Operation");

    @Nonnull
    @Override
    public Class<MasterRecipeHeader> getType()
    {
        return MasterRecipeHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeGroup</b>
     * </p>
     *
     * @param masterRecipeGroup
     *            Key for Task List Group
     */
    public void setMasterRecipeGroup( @Nullable final String masterRecipeGroup )
    {
        rememberChangedField("MasterRecipeGroup", this.masterRecipeGroup);
        this.masterRecipeGroup = masterRecipeGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipe</b>
     * </p>
     *
     * @param masterRecipe
     *            Group Counter
     */
    public void setMasterRecipe( @Nullable final String masterRecipe )
    {
        rememberChangedField("MasterRecipe", this.masterRecipe);
        this.masterRecipe = masterRecipe;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeInternalVersion</b>
     * </p>
     *
     * @param masterRecipeInternalVersion
     *            Internal counter
     */
    public void setMasterRecipeInternalVersion( @Nullable final String masterRecipeInternalVersion )
    {
        rememberChangedField("MasterRecipeInternalVersion", this.masterRecipeInternalVersion);
        this.masterRecipeInternalVersion = masterRecipeInternalVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Indicator: Delete completely in reorganization run
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsDesc</b>
     * </p>
     *
     * @param billOfOperationsDesc
     *            Routing Description
     */
    public void setBillOfOperationsDesc( @Nullable final String billOfOperationsDesc )
    {
        rememberChangedField("BillOfOperationsDesc", this.billOfOperationsDesc);
        this.billOfOperationsDesc = billOfOperationsDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LongTextLanguageCode</b>
     * </p>
     *
     * @param longTextLanguageCode
     *            Language Key
     */
    public void setLongTextLanguageCode( @Nullable final String longTextLanguageCode )
    {
        rememberChangedField("LongTextLanguageCode", this.longTextLanguageCode);
        this.longTextLanguageCode = longTextLanguageCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @param plainLongText
     *            Long Text
     */
    public void setPlainLongText( @Nullable final String plainLongText )
    {
        rememberChangedField("PlainLongText", this.plainLongText);
        this.plainLongText = plainLongText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsStatus</b>
     * </p>
     *
     * @param billOfOperationsStatus
     *            Status
     */
    public void setBillOfOperationsStatus( @Nullable final String billOfOperationsStatus )
    {
        rememberChangedField("BillOfOperationsStatus", this.billOfOperationsStatus);
        this.billOfOperationsStatus = billOfOperationsStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUsage</b>
     * </p>
     *
     * @param billOfOperationsUsage
     *            Task List Usage
     */
    public void setBillOfOperationsUsage( @Nullable final String billOfOperationsUsage )
    {
        rememberChangedField("BillOfOperationsUsage", this.billOfOperationsUsage);
        this.billOfOperationsUsage = billOfOperationsUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     *
     * @param responsiblePlannerGroup
     *            Responsible Planner Group or Department
     */
    public void setResponsiblePlannerGroup( @Nullable final String responsiblePlannerGroup )
    {
        rememberChangedField("ResponsiblePlannerGroup", this.responsiblePlannerGroup);
        this.responsiblePlannerGroup = responsiblePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsProfile</b>
     * </p>
     *
     * @param billOfOperationsProfile
     *            Profile
     */
    public void setBillOfOperationsProfile( @Nullable final String billOfOperationsProfile )
    {
        rememberChangedField("BillOfOperationsProfile", this.billOfOperationsProfile);
        this.billOfOperationsProfile = billOfOperationsProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @param minimumLotSizeQuantity
     *            Minimum Lot Size
     */
    public void setMinimumLotSizeQuantity( @Nullable final BigDecimal minimumLotSizeQuantity )
    {
        rememberChangedField("MinimumLotSizeQuantity", this.minimumLotSizeQuantity);
        this.minimumLotSizeQuantity = minimumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @param maximumLotSizeQuantity
     *            Maximum Lot Size
     */
    public void setMaximumLotSizeQuantity( @Nullable final BigDecimal maximumLotSizeQuantity )
    {
        rememberChangedField("MaximumLotSizeQuantity", this.maximumLotSizeQuantity);
        this.maximumLotSizeQuantity = maximumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUnit</b>
     * </p>
     *
     * @param billOfOperationsUnit
     *            Task List Unit of Measure
     */
    public void setBillOfOperationsUnit( @Nullable final String billOfOperationsUnit )
    {
        rememberChangedField("BillOfOperationsUnit", this.billOfOperationsUnit);
        this.billOfOperationsUnit = billOfOperationsUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationReferenceQuantity</b>
     * </p>
     *
     * @param operationReferenceQuantity
     *            Base Quantity
     */
    public void setOperationReferenceQuantity( @Nullable final BigDecimal operationReferenceQuantity )
    {
        rememberChangedField("OperationReferenceQuantity", this.operationReferenceQuantity);
        this.operationReferenceQuantity = operationReferenceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @param operationUnit
     *            Unit of Measure for Activity/Operation
     */
    public void setOperationUnit( @Nullable final String operationUnit )
    {
        rememberChangedField("OperationUnit", this.operationUnit);
        this.operationUnit = operationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @param opQtyToBaseQtyNmrtr
     *            Numerator for Converting Routing and Operation UoM
     */
    public void setOpQtyToBaseQtyNmrtr( @Nullable final BigDecimal opQtyToBaseQtyNmrtr )
    {
        rememberChangedField("OpQtyToBaseQtyNmrtr", this.opQtyToBaseQtyNmrtr);
        this.opQtyToBaseQtyNmrtr = opQtyToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @param opQtyToBaseQtyDnmntr
     *            Denominator for Converting Routing and Operation UoM
     */
    public void setOpQtyToBaseQtyDnmntr( @Nullable final BigDecimal opQtyToBaseQtyDnmntr )
    {
        rememberChangedField("OpQtyToBaseQtyDnmntr", this.opQtyToBaseQtyDnmntr);
        this.opQtyToBaseQtyDnmntr = opQtyToBaseQtyDnmntr;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MasterRecipeHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MasterRecipeGroup", getMasterRecipeGroup());
        result.put("MasterRecipe", getMasterRecipe());
        result.put("MasterRecipeInternalVersion", getMasterRecipeInternalVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MasterRecipeGroup", getMasterRecipeGroup());
        values.put("MasterRecipe", getMasterRecipe());
        values.put("MasterRecipeInternalVersion", getMasterRecipeInternalVersion());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("BillOfOperationsDesc", getBillOfOperationsDesc());
        values.put("LongTextLanguageCode", getLongTextLanguageCode());
        values.put("PlainLongText", getPlainLongText());
        values.put("Plant", getPlant());
        values.put("BillOfOperationsStatus", getBillOfOperationsStatus());
        values.put("BillOfOperationsUsage", getBillOfOperationsUsage());
        values.put("ResponsiblePlannerGroup", getResponsiblePlannerGroup());
        values.put("BillOfOperationsProfile", getBillOfOperationsProfile());
        values.put("MinimumLotSizeQuantity", getMinimumLotSizeQuantity());
        values.put("MaximumLotSizeQuantity", getMaximumLotSizeQuantity());
        values.put("BillOfOperationsUnit", getBillOfOperationsUnit());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ChangedDateTime", getChangedDateTime());
        values.put("OperationReferenceQuantity", getOperationReferenceQuantity());
        values.put("OperationUnit", getOperationUnit());
        values.put("OpQtyToBaseQtyNmrtr", getOpQtyToBaseQtyNmrtr());
        values.put("OpQtyToBaseQtyDnmntr", getOpQtyToBaseQtyDnmntr());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MasterRecipeGroup") ) {
                final Object value = values.remove("MasterRecipeGroup");
                if( (value == null) || (!value.equals(getMasterRecipeGroup())) ) {
                    setMasterRecipeGroup(((String) value));
                }
            }
            if( values.containsKey("MasterRecipe") ) {
                final Object value = values.remove("MasterRecipe");
                if( (value == null) || (!value.equals(getMasterRecipe())) ) {
                    setMasterRecipe(((String) value));
                }
            }
            if( values.containsKey("MasterRecipeInternalVersion") ) {
                final Object value = values.remove("MasterRecipeInternalVersion");
                if( (value == null) || (!value.equals(getMasterRecipeInternalVersion())) ) {
                    setMasterRecipeInternalVersion(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("BillOfOperationsDesc") ) {
                final Object value = values.remove("BillOfOperationsDesc");
                if( (value == null) || (!value.equals(getBillOfOperationsDesc())) ) {
                    setBillOfOperationsDesc(((String) value));
                }
            }
            if( values.containsKey("LongTextLanguageCode") ) {
                final Object value = values.remove("LongTextLanguageCode");
                if( (value == null) || (!value.equals(getLongTextLanguageCode())) ) {
                    setLongTextLanguageCode(((String) value));
                }
            }
            if( values.containsKey("PlainLongText") ) {
                final Object value = values.remove("PlainLongText");
                if( (value == null) || (!value.equals(getPlainLongText())) ) {
                    setPlainLongText(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsStatus") ) {
                final Object value = values.remove("BillOfOperationsStatus");
                if( (value == null) || (!value.equals(getBillOfOperationsStatus())) ) {
                    setBillOfOperationsStatus(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsUsage") ) {
                final Object value = values.remove("BillOfOperationsUsage");
                if( (value == null) || (!value.equals(getBillOfOperationsUsage())) ) {
                    setBillOfOperationsUsage(((String) value));
                }
            }
            if( values.containsKey("ResponsiblePlannerGroup") ) {
                final Object value = values.remove("ResponsiblePlannerGroup");
                if( (value == null) || (!value.equals(getResponsiblePlannerGroup())) ) {
                    setResponsiblePlannerGroup(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsProfile") ) {
                final Object value = values.remove("BillOfOperationsProfile");
                if( (value == null) || (!value.equals(getBillOfOperationsProfile())) ) {
                    setBillOfOperationsProfile(((String) value));
                }
            }
            if( values.containsKey("MinimumLotSizeQuantity") ) {
                final Object value = values.remove("MinimumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMinimumLotSizeQuantity())) ) {
                    setMinimumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumLotSizeQuantity") ) {
                final Object value = values.remove("MaximumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaximumLotSizeQuantity())) ) {
                    setMaximumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillOfOperationsUnit") ) {
                final Object value = values.remove("BillOfOperationsUnit");
                if( (value == null) || (!value.equals(getBillOfOperationsUnit())) ) {
                    setBillOfOperationsUnit(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("OperationReferenceQuantity") ) {
                final Object value = values.remove("OperationReferenceQuantity");
                if( (value == null) || (!value.equals(getOperationReferenceQuantity())) ) {
                    setOperationReferenceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationUnit") ) {
                final Object value = values.remove("OperationUnit");
                if( (value == null) || (!value.equals(getOperationUnit())) ) {
                    setOperationUnit(((String) value));
                }
            }
            if( values.containsKey("OpQtyToBaseQtyNmrtr") ) {
                final Object value = values.remove("OpQtyToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getOpQtyToBaseQtyNmrtr())) ) {
                    setOpQtyToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpQtyToBaseQtyDnmntr") ) {
                final Object value = values.remove("OpQtyToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getOpQtyToBaseQtyDnmntr())) ) {
                    setOpQtyToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MatlAssgmt") ) {
                final Object value = (values).remove("to_MatlAssgmt");
                if( value instanceof Iterable ) {
                    if( toMatlAssgmt == null ) {
                        toMatlAssgmt = Lists.newArrayList();
                    } else {
                        toMatlAssgmt = Lists.newArrayList(toMatlAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MasterRecipeMatlAssgmt entity;
                        if( toMatlAssgmt.size() > i ) {
                            entity = toMatlAssgmt.get(i);
                        } else {
                            entity = new MasterRecipeMatlAssgmt();
                            toMatlAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Operation") ) {
                final Object value = (values).remove("to_Operation");
                if( value instanceof Iterable ) {
                    if( toOperation == null ) {
                        toOperation = Lists.newArrayList();
                    } else {
                        toOperation = Lists.newArrayList(toOperation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MasterRecipeOperation entity;
                        if( toOperation.size() > i ) {
                            entity = toOperation.get(i);
                        } else {
                            entity = new MasterRecipeOperation();
                            toOperation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MasterRecipeHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MasterRecipeHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MasterRecipeHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MasterRecipeHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMatlAssgmt != null ) {
            (values).put("to_MatlAssgmt", toMatlAssgmt);
        }
        if( toOperation != null ) {
            (values).put("to_Operation", toOperation);
        }
        return values;
    }

    /**
     * Fetches the <b>MasterRecipeMatlAssgmt</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MatlAssgmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MasterRecipeMatlAssgmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipeMatlAssgmt> fetchMatlAssgmt()
    {
        return fetchFieldAsList("to_MatlAssgmt", MasterRecipeMatlAssgmt.class);
    }

    /**
     * Retrieval of associated <b>MasterRecipeMatlAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MatlAssgmt</b>.
     * <p>
     * If the navigation property <b>to_MatlAssgmt</b> of a queried <b>MasterRecipeHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MasterRecipeMatlAssgmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipeMatlAssgmt> getMatlAssgmtOrFetch()
    {
        if( toMatlAssgmt == null ) {
            toMatlAssgmt = fetchMatlAssgmt();
        }
        return toMatlAssgmt;
    }

    /**
     * Retrieval of associated <b>MasterRecipeMatlAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MatlAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>MasterRecipeHeader</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MatlAssgmt</b> is already loaded, the result will
     *         contain the <b>MasterRecipeMatlAssgmt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MasterRecipeMatlAssgmt>> getMatlAssgmtIfPresent()
    {
        return Option.of(toMatlAssgmt);
    }

    /**
     * Overwrites the list of associated <b>MasterRecipeMatlAssgmt</b> entities for the loaded navigation property
     * <b>to_MatlAssgmt</b>.
     * <p>
     * If the navigation property <b>to_MatlAssgmt</b> of a queried <b>MasterRecipeHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MasterRecipeMatlAssgmt</b> entities.
     */
    public void setMatlAssgmt( @Nonnull final List<MasterRecipeMatlAssgmt> value )
    {
        if( toMatlAssgmt == null ) {
            toMatlAssgmt = Lists.newArrayList();
        }
        toMatlAssgmt.clear();
        toMatlAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MasterRecipeMatlAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>to_MatlAssgmt</b>.
     * <p>
     * If the navigation property <b>to_MatlAssgmt</b> of a queried <b>MasterRecipeHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MasterRecipeMatlAssgmt</b> entities.
     */
    public void addMatlAssgmt( MasterRecipeMatlAssgmt... entity )
    {
        if( toMatlAssgmt == null ) {
            toMatlAssgmt = Lists.newArrayList();
        }
        toMatlAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MasterRecipeOperation</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Operation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MasterRecipeOperation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipeOperation> fetchOperation()
    {
        return fetchFieldAsList("to_Operation", MasterRecipeOperation.class);
    }

    /**
     * Retrieval of associated <b>MasterRecipeOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Operation</b>.
     * <p>
     * If the navigation property <b>to_Operation</b> of a queried <b>MasterRecipeHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MasterRecipeOperation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipeOperation> getOperationOrFetch()
    {
        if( toOperation == null ) {
            toOperation = fetchOperation();
        }
        return toOperation;
    }

    /**
     * Retrieval of associated <b>MasterRecipeOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Operation</b>.
     * <p>
     * If the navigation property for an entity <b>MasterRecipeHeader</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Operation</b> is already loaded, the result will contain
     *         the <b>MasterRecipeOperation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MasterRecipeOperation>> getOperationIfPresent()
    {
        return Option.of(toOperation);
    }

    /**
     * Overwrites the list of associated <b>MasterRecipeOperation</b> entities for the loaded navigation property
     * <b>to_Operation</b>.
     * <p>
     * If the navigation property <b>to_Operation</b> of a queried <b>MasterRecipeHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MasterRecipeOperation</b> entities.
     */
    public void setOperation( @Nonnull final List<MasterRecipeOperation> value )
    {
        if( toOperation == null ) {
            toOperation = Lists.newArrayList();
        }
        toOperation.clear();
        toOperation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MasterRecipeOperation</b> entities. This corresponds to the OData
     * navigation property <b>to_Operation</b>.
     * <p>
     * If the navigation property <b>to_Operation</b> of a queried <b>MasterRecipeHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MasterRecipeOperation</b> entities.
     */
    public void addOperation( MasterRecipeOperation... entity )
    {
        if( toOperation == null ) {
            toOperation = Lists.newArrayList();
        }
        toOperation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MasterRecipeHeader instances.
     *
     */
    public final static class MasterRecipeHeaderBuilder
    {

        private List<MasterRecipeMatlAssgmt> toMatlAssgmt = Lists.newArrayList();
        private List<MasterRecipeOperation> toOperation = Lists.newArrayList();

        private MasterRecipeHeader.MasterRecipeHeaderBuilder toMatlAssgmt( final List<MasterRecipeMatlAssgmt> value )
        {
            toMatlAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MatlAssgmt</b> for <b>MasterRecipeHeader</b> to multiple
         * <b>MasterRecipeMatlAssgmt</b>.
         *
         * @param value
         *            The MasterRecipeMatlAssgmts to build this MasterRecipeHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MasterRecipeHeader.MasterRecipeHeaderBuilder matlAssgmt( MasterRecipeMatlAssgmt... value )
        {
            return toMatlAssgmt(Lists.newArrayList(value));
        }

        private MasterRecipeHeader.MasterRecipeHeaderBuilder toOperation( final List<MasterRecipeOperation> value )
        {
            toOperation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Operation</b> for <b>MasterRecipeHeader</b> to multiple
         * <b>MasterRecipeOperation</b>.
         *
         * @param value
         *            The MasterRecipeOperations to build this MasterRecipeHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MasterRecipeHeader.MasterRecipeHeaderBuilder operation( MasterRecipeOperation... value )
        {
            return toOperation(Lists.newArrayList(value));
        }

    }

}
