/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable.MasterRecipeMatlAssgmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmt
 * MasterRecipeMatlAssgmt} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class MasterRecipeMatlAssgmtByKeyFluentHelper
    extends
    FluentHelperByKey<MasterRecipeMatlAssgmtByKeyFluentHelper, MasterRecipeMatlAssgmt, MasterRecipeMatlAssgmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmt
     * MasterRecipeMatlAssgmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MasterRecipeMatlAssgmt}
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MasterRecipeMatlAssgmt}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param mstrRcpMatlAssgmtIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeMaterialAssignment
     *            Counter for additional criteria
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     */
    public MasterRecipeMatlAssgmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String product,
        final String plant,
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeMaterialAssignment,
        final String mstrRcpMatlAssgmtIntVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("Product", product);
        this.key.put("Plant", plant);
        this.key.put("MasterRecipeGroup", masterRecipeGroup);
        this.key.put("MasterRecipe", masterRecipe);
        this.key.put("MasterRecipeMaterialAssignment", masterRecipeMaterialAssignment);
        this.key.put("MstrRcpMatlAssgmtIntVersion", mstrRcpMatlAssgmtIntVersion);
    }

    @Override
    @Nonnull
    protected Class<MasterRecipeMatlAssgmt> getEntityClass()
    {
        return MasterRecipeMatlAssgmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
