/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.field.MasterRecipeOperationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.link.MasterRecipeOperationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable.MasterRecipeOperationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Operation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MasterRecipeOperationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MasterRecipeOperation extends VdmEntity<MasterRecipeOperation>
{

    /**
     * Selector for all available fields of MasterRecipeOperation.
     *
     */
    public final static MasterRecipeOperationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "MasterRecipeGroup" )
    @JsonProperty( "MasterRecipeGroup" )
    @Nullable
    @ODataField( odataName = "MasterRecipeGroup" )
    private String masterRecipeGroup;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipeGroup</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> MASTER_RECIPE_GROUP =
        new MasterRecipeOperationField<String>("MasterRecipeGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipe</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "MasterRecipe" )
    @JsonProperty( "MasterRecipe" )
    @Nullable
    @ODataField( odataName = "MasterRecipe" )
    private String masterRecipe;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipe</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> MASTER_RECIPE =
        new MasterRecipeOperationField<String>("MasterRecipe");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeOperationIntID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @Key
    @SerializedName( "MasterRecipeOperationIntID" )
    @JsonProperty( "MasterRecipeOperationIntID" )
    @Nullable
    @ODataField( odataName = "MasterRecipeOperationIntID" )
    private String masterRecipeOperationIntID;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipeOperationIntID</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> MASTER_RECIPE_OPERATION_INT_ID =
        new MasterRecipeOperationField<String>("MasterRecipeOperationIntID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MstrRcpOperationIntVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "MstrRcpOperationIntVersion" )
    @JsonProperty( "MstrRcpOperationIntVersion" )
    @Nullable
    @ODataField( odataName = "MstrRcpOperationIntVersion" )
    private String mstrRcpOperationIntVersion;
    /**
     * Use with available fluent helpers to apply the <b>MstrRcpOperationIntVersion</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> MSTR_RCP_OPERATION_INT_VERSION =
        new MasterRecipeOperationField<String>("MstrRcpOperationIntVersion");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @return Operation / Phase Number
     */
    @SerializedName( "Operation" )
    @JsonProperty( "Operation" )
    @Nullable
    @ODataField( odataName = "Operation" )
    private String operation;
    /**
     * Use with available fluent helpers to apply the <b>Operation</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> OPERATION =
        new MasterRecipeOperationField<String>("Operation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @return Operation Short Text
     */
    @SerializedName( "OperationText" )
    @JsonProperty( "OperationText" )
    @Nullable
    @ODataField( odataName = "OperationText" )
    private String operationText;
    /**
     * Use with available fluent helpers to apply the <b>OperationText</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> OPERATION_TEXT =
        new MasterRecipeOperationField<String>("OperationText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LongTextLanguageCode</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "LongTextLanguageCode" )
    @JsonProperty( "LongTextLanguageCode" )
    @Nullable
    @ODataField( odataName = "LongTextLanguageCode" )
    private String longTextLanguageCode;
    /**
     * Use with available fluent helpers to apply the <b>LongTextLanguageCode</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> LONG_TEXT_LANGUAGE_CODE =
        new MasterRecipeOperationField<String>("LongTextLanguageCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "PlainLongText" )
    @JsonProperty( "PlainLongText" )
    @Nullable
    @ODataField( odataName = "PlainLongText" )
    private String plainLongText;
    /**
     * Use with available fluent helpers to apply the <b>PlainLongText</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> PLAIN_LONG_TEXT =
        new MasterRecipeOperationField<String>("PlainLongText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> WORK_CENTER_TYPE_CODE =
        new MasterRecipeOperationField<String>("WorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> WORK_CENTER_INTERNAL_ID =
        new MasterRecipeOperationField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardTextCode</b>
     * </p>
     *
     * @return Standard Text Key
     */
    @SerializedName( "OperationStandardTextCode" )
    @JsonProperty( "OperationStandardTextCode" )
    @Nullable
    @ODataField( odataName = "OperationStandardTextCode" )
    private String operationStandardTextCode;
    /**
     * Use with available fluent helpers to apply the <b>OperationStandardTextCode</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> OPERATION_STANDARD_TEXT_CODE =
        new MasterRecipeOperationField<String>("OperationStandardTextCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> PLANT = new MasterRecipeOperationField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @return Control Key
     */
    @SerializedName( "OperationControlProfile" )
    @JsonProperty( "OperationControlProfile" )
    @Nullable
    @ODataField( odataName = "OperationControlProfile" )
    private String operationControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>OperationControlProfile</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> OPERATION_CONTROL_PROFILE =
        new MasterRecipeOperationField<String>("OperationControlProfile");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationReferenceQuantity</b>
     * </p>
     *
     * @return Base Quantity
     */
    @SerializedName( "OperationReferenceQuantity" )
    @JsonProperty( "OperationReferenceQuantity" )
    @Nullable
    @ODataField( odataName = "OperationReferenceQuantity" )
    private BigDecimal operationReferenceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OperationReferenceQuantity</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<BigDecimal> OPERATION_REFERENCE_QUANTITY =
        new MasterRecipeOperationField<BigDecimal>("OperationReferenceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @return Unit of Measure for Activity/Operation
     */
    @SerializedName( "OperationUnit" )
    @JsonProperty( "OperationUnit" )
    @Nullable
    @ODataField( odataName = "OperationUnit" )
    private String operationUnit;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnit</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> OPERATION_UNIT =
        new MasterRecipeOperationField<String>("OperationUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for Converting Routing and Operation UoM
     */
    @SerializedName( "OpQtyToBaseQtyNmrtr" )
    @JsonProperty( "OpQtyToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "OpQtyToBaseQtyNmrtr" )
    private BigDecimal opQtyToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OpQtyToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<BigDecimal> OP_QTY_TO_BASE_QTY_NMRTR =
        new MasterRecipeOperationField<BigDecimal>("OpQtyToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for Converting Routing and Operation UoM
     */
    @SerializedName( "OpQtyToBaseQtyDnmntr" )
    @JsonProperty( "OpQtyToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "OpQtyToBaseQtyDnmntr" )
    private BigDecimal opQtyToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OpQtyToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<BigDecimal> OP_QTY_TO_BASE_QTY_DNMNTR =
        new MasterRecipeOperationField<BigDecimal>("OpQtyToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfTimeTickets</b>
     * </p>
     *
     * @return Number of Time Tickets
     */
    @SerializedName( "NumberOfTimeTickets" )
    @JsonProperty( "NumberOfTimeTickets" )
    @Nullable
    @ODataField( odataName = "NumberOfTimeTickets" )
    private BigDecimal numberOfTimeTickets;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfTimeTickets</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<BigDecimal> NUMBER_OF_TIME_TICKETS =
        new MasterRecipeOperationField<BigDecimal>("NumberOfTimeTickets");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfConfirmationSlips</b>
     * </p>
     *
     * @return Number of Confirmation Slips
     */
    @SerializedName( "NumberOfConfirmationSlips" )
    @JsonProperty( "NumberOfConfirmationSlips" )
    @Nullable
    @ODataField( odataName = "NumberOfConfirmationSlips" )
    private String numberOfConfirmationSlips;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfConfirmationSlips</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> NUMBER_OF_CONFIRMATION_SLIPS =
        new MasterRecipeOperationField<String>("NumberOfConfirmationSlips");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCostingRelevancyType</b>
     * </p>
     *
     * @return Operation Costing Relevancy Type
     */
    @SerializedName( "OperationCostingRelevancyType" )
    @JsonProperty( "OperationCostingRelevancyType" )
    @Nullable
    @ODataField( odataName = "OperationCostingRelevancyType" )
    private String operationCostingRelevancyType;
    /**
     * Use with available fluent helpers to apply the <b>OperationCostingRelevancyType</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> OPERATION_COSTING_RELEVANCY_TYPE =
        new MasterRecipeOperationField<String>("OperationCostingRelevancyType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> BUSINESS_PROCESS =
        new MasterRecipeOperationField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupType</b>
     * </p>
     *
     * @return Setup Type Key
     */
    @SerializedName( "OperationSetupType" )
    @JsonProperty( "OperationSetupType" )
    @Nullable
    @ODataField( odataName = "OperationSetupType" )
    private String operationSetupType;
    /**
     * Use with available fluent helpers to apply the <b>OperationSetupType</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> OPERATION_SETUP_TYPE =
        new MasterRecipeOperationField<String>("OperationSetupType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupGroupCategory</b>
     * </p>
     *
     * @return Setup group category
     */
    @SerializedName( "OperationSetupGroupCategory" )
    @JsonProperty( "OperationSetupGroupCategory" )
    @Nullable
    @ODataField( odataName = "OperationSetupGroupCategory" )
    private String operationSetupGroupCategory;
    /**
     * Use with available fluent helpers to apply the <b>OperationSetupGroupCategory</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> OPERATION_SETUP_GROUP_CATEGORY =
        new MasterRecipeOperationField<String>("OperationSetupGroupCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupGroup</b>
     * </p>
     *
     * @return Setup group key
     */
    @SerializedName( "OperationSetupGroup" )
    @JsonProperty( "OperationSetupGroup" )
    @Nullable
    @ODataField( odataName = "OperationSetupGroup" )
    private String operationSetupGroup;
    /**
     * Use with available fluent helpers to apply the <b>OperationSetupGroup</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> OPERATION_SETUP_GROUP =
        new MasterRecipeOperationField<String>("OperationSetupGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @return Capacity category
     */
    @SerializedName( "CapacityCategoryCode" )
    @JsonProperty( "CapacityCategoryCode" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryCode" )
    private String capacityCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryCode</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> CAPACITY_CATEGORY_CODE =
        new MasterRecipeOperationField<String>("CapacityCategoryCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<LocalDateTime> CREATION_DATE =
        new MasterRecipeOperationField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> CREATED_BY_USER =
        new MasterRecipeOperationField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<LocalDateTime> LAST_CHANGE_DATE =
        new MasterRecipeOperationField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> LAST_CHANGED_BY_USER =
        new MasterRecipeOperationField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<LocalDateTime> VALIDITY_START_DATE =
        new MasterRecipeOperationField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<LocalDateTime> VALIDITY_END_DATE =
        new MasterRecipeOperationField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<String> CHANGE_NUMBER =
        new MasterRecipeOperationField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static MasterRecipeOperationField<ZonedDateTime> CHANGED_DATE_TIME =
        new MasterRecipeOperationField<ZonedDateTime>("ChangedDateTime");
    /**
     * Navigation property <b>to_OpCompAlloc</b> for <b>MasterRecipeOperation</b> to multiple
     * <b>MasterRecipeOpCompAlloc</b>.
     *
     */
    @SerializedName( "to_OpCompAlloc" )
    @JsonProperty( "to_OpCompAlloc" )
    @ODataField( odataName = "to_OpCompAlloc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MasterRecipeOpCompAlloc> toOpCompAlloc;
    /**
     * Navigation property <b>to_OpSecdryRsce</b> for <b>MasterRecipeOperation</b> to multiple
     * <b>MasterRecipeOpSecdryRsce</b>.
     *
     */
    @SerializedName( "to_OpSecdryRsce" )
    @JsonProperty( "to_OpSecdryRsce" )
    @ODataField( odataName = "to_OpSecdryRsce" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MasterRecipeOpSecdryRsce> toOpSecdryRsce;
    /**
     * Navigation property <b>to_Phase</b> for <b>MasterRecipeOperation</b> to multiple <b>MasterRecipePhase</b>.
     *
     */
    @SerializedName( "to_Phase" )
    @JsonProperty( "to_Phase" )
    @ODataField( odataName = "to_Phase" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MasterRecipePhase> toPhase;
    /**
     * Use with available fluent helpers to apply the <b>to_OpCompAlloc</b> navigation property to query operations.
     *
     */
    public final static MasterRecipeOperationLink<MasterRecipeOpCompAlloc> TO_OP_COMP_ALLOC =
        new MasterRecipeOperationLink<MasterRecipeOpCompAlloc>("to_OpCompAlloc");
    /**
     * Use with available fluent helpers to apply the <b>to_OpSecdryRsce</b> navigation property to query operations.
     *
     */
    public final static MasterRecipeOperationLink<MasterRecipeOpSecdryRsce> TO_OP_SECDRY_RSCE =
        new MasterRecipeOperationLink<MasterRecipeOpSecdryRsce>("to_OpSecdryRsce");
    /**
     * Use with available fluent helpers to apply the <b>to_Phase</b> navigation property to query operations.
     *
     */
    public final static MasterRecipeOperationLink<MasterRecipePhase> TO_PHASE =
        new MasterRecipeOperationLink<MasterRecipePhase>("to_Phase");

    @Nonnull
    @Override
    public Class<MasterRecipeOperation> getType()
    {
        return MasterRecipeOperation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeGroup</b>
     * </p>
     *
     * @param masterRecipeGroup
     *            Key for Task List Group
     */
    public void setMasterRecipeGroup( @Nullable final String masterRecipeGroup )
    {
        rememberChangedField("MasterRecipeGroup", this.masterRecipeGroup);
        this.masterRecipeGroup = masterRecipeGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipe</b>
     * </p>
     *
     * @param masterRecipe
     *            Group Counter
     */
    public void setMasterRecipe( @Nullable final String masterRecipe )
    {
        rememberChangedField("MasterRecipe", this.masterRecipe);
        this.masterRecipe = masterRecipe;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeOperationIntID</b>
     * </p>
     *
     * @param masterRecipeOperationIntID
     *            Number of the Task List Node
     */
    public void setMasterRecipeOperationIntID( @Nullable final String masterRecipeOperationIntID )
    {
        rememberChangedField("MasterRecipeOperationIntID", this.masterRecipeOperationIntID);
        this.masterRecipeOperationIntID = masterRecipeOperationIntID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MstrRcpOperationIntVersion</b>
     * </p>
     *
     * @param mstrRcpOperationIntVersion
     *            Internal counter
     */
    public void setMstrRcpOperationIntVersion( @Nullable final String mstrRcpOperationIntVersion )
    {
        rememberChangedField("MstrRcpOperationIntVersion", this.mstrRcpOperationIntVersion);
        this.mstrRcpOperationIntVersion = mstrRcpOperationIntVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @param operation
     *            Operation / Phase Number
     */
    public void setOperation( @Nullable final String operation )
    {
        rememberChangedField("Operation", this.operation);
        this.operation = operation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @param operationText
     *            Operation Short Text
     */
    public void setOperationText( @Nullable final String operationText )
    {
        rememberChangedField("OperationText", this.operationText);
        this.operationText = operationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LongTextLanguageCode</b>
     * </p>
     *
     * @param longTextLanguageCode
     *            Language Key
     */
    public void setLongTextLanguageCode( @Nullable final String longTextLanguageCode )
    {
        rememberChangedField("LongTextLanguageCode", this.longTextLanguageCode);
        this.longTextLanguageCode = longTextLanguageCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @param plainLongText
     *            Long Text
     */
    public void setPlainLongText( @Nullable final String plainLongText )
    {
        rememberChangedField("PlainLongText", this.plainLongText);
        this.plainLongText = plainLongText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardTextCode</b>
     * </p>
     *
     * @param operationStandardTextCode
     *            Standard Text Key
     */
    public void setOperationStandardTextCode( @Nullable final String operationStandardTextCode )
    {
        rememberChangedField("OperationStandardTextCode", this.operationStandardTextCode);
        this.operationStandardTextCode = operationStandardTextCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @param operationControlProfile
     *            Control Key
     */
    public void setOperationControlProfile( @Nullable final String operationControlProfile )
    {
        rememberChangedField("OperationControlProfile", this.operationControlProfile);
        this.operationControlProfile = operationControlProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationReferenceQuantity</b>
     * </p>
     *
     * @param operationReferenceQuantity
     *            Base Quantity
     */
    public void setOperationReferenceQuantity( @Nullable final BigDecimal operationReferenceQuantity )
    {
        rememberChangedField("OperationReferenceQuantity", this.operationReferenceQuantity);
        this.operationReferenceQuantity = operationReferenceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @param operationUnit
     *            Unit of Measure for Activity/Operation
     */
    public void setOperationUnit( @Nullable final String operationUnit )
    {
        rememberChangedField("OperationUnit", this.operationUnit);
        this.operationUnit = operationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @param opQtyToBaseQtyNmrtr
     *            Numerator for Converting Routing and Operation UoM
     */
    public void setOpQtyToBaseQtyNmrtr( @Nullable final BigDecimal opQtyToBaseQtyNmrtr )
    {
        rememberChangedField("OpQtyToBaseQtyNmrtr", this.opQtyToBaseQtyNmrtr);
        this.opQtyToBaseQtyNmrtr = opQtyToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @param opQtyToBaseQtyDnmntr
     *            Denominator for Converting Routing and Operation UoM
     */
    public void setOpQtyToBaseQtyDnmntr( @Nullable final BigDecimal opQtyToBaseQtyDnmntr )
    {
        rememberChangedField("OpQtyToBaseQtyDnmntr", this.opQtyToBaseQtyDnmntr);
        this.opQtyToBaseQtyDnmntr = opQtyToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfTimeTickets</b>
     * </p>
     *
     * @param numberOfTimeTickets
     *            Number of Time Tickets
     */
    public void setNumberOfTimeTickets( @Nullable final BigDecimal numberOfTimeTickets )
    {
        rememberChangedField("NumberOfTimeTickets", this.numberOfTimeTickets);
        this.numberOfTimeTickets = numberOfTimeTickets;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfConfirmationSlips</b>
     * </p>
     *
     * @param numberOfConfirmationSlips
     *            Number of Confirmation Slips
     */
    public void setNumberOfConfirmationSlips( @Nullable final String numberOfConfirmationSlips )
    {
        rememberChangedField("NumberOfConfirmationSlips", this.numberOfConfirmationSlips);
        this.numberOfConfirmationSlips = numberOfConfirmationSlips;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCostingRelevancyType</b>
     * </p>
     *
     * @param operationCostingRelevancyType
     *            Operation Costing Relevancy Type
     */
    public void setOperationCostingRelevancyType( @Nullable final String operationCostingRelevancyType )
    {
        rememberChangedField("OperationCostingRelevancyType", this.operationCostingRelevancyType);
        this.operationCostingRelevancyType = operationCostingRelevancyType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupType</b>
     * </p>
     *
     * @param operationSetupType
     *            Setup Type Key
     */
    public void setOperationSetupType( @Nullable final String operationSetupType )
    {
        rememberChangedField("OperationSetupType", this.operationSetupType);
        this.operationSetupType = operationSetupType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupGroupCategory</b>
     * </p>
     *
     * @param operationSetupGroupCategory
     *            Setup group category
     */
    public void setOperationSetupGroupCategory( @Nullable final String operationSetupGroupCategory )
    {
        rememberChangedField("OperationSetupGroupCategory", this.operationSetupGroupCategory);
        this.operationSetupGroupCategory = operationSetupGroupCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSetupGroup</b>
     * </p>
     *
     * @param operationSetupGroup
     *            Setup group key
     */
    public void setOperationSetupGroup( @Nullable final String operationSetupGroup )
    {
        rememberChangedField("OperationSetupGroup", this.operationSetupGroup);
        this.operationSetupGroup = operationSetupGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @param capacityCategoryCode
     *            Capacity category
     */
    public void setCapacityCategoryCode( @Nullable final String capacityCategoryCode )
    {
        rememberChangedField("CapacityCategoryCode", this.capacityCategoryCode);
        this.capacityCategoryCode = capacityCategoryCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MasterRecipeOperation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MasterRecipeGroup", getMasterRecipeGroup());
        result.put("MasterRecipe", getMasterRecipe());
        result.put("MasterRecipeOperationIntID", getMasterRecipeOperationIntID());
        result.put("MstrRcpOperationIntVersion", getMstrRcpOperationIntVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MasterRecipeGroup", getMasterRecipeGroup());
        values.put("MasterRecipe", getMasterRecipe());
        values.put("MasterRecipeOperationIntID", getMasterRecipeOperationIntID());
        values.put("MstrRcpOperationIntVersion", getMstrRcpOperationIntVersion());
        values.put("Operation", getOperation());
        values.put("OperationText", getOperationText());
        values.put("LongTextLanguageCode", getLongTextLanguageCode());
        values.put("PlainLongText", getPlainLongText());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("OperationStandardTextCode", getOperationStandardTextCode());
        values.put("Plant", getPlant());
        values.put("OperationControlProfile", getOperationControlProfile());
        values.put("OperationReferenceQuantity", getOperationReferenceQuantity());
        values.put("OperationUnit", getOperationUnit());
        values.put("OpQtyToBaseQtyNmrtr", getOpQtyToBaseQtyNmrtr());
        values.put("OpQtyToBaseQtyDnmntr", getOpQtyToBaseQtyDnmntr());
        values.put("NumberOfTimeTickets", getNumberOfTimeTickets());
        values.put("NumberOfConfirmationSlips", getNumberOfConfirmationSlips());
        values.put("OperationCostingRelevancyType", getOperationCostingRelevancyType());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("OperationSetupType", getOperationSetupType());
        values.put("OperationSetupGroupCategory", getOperationSetupGroupCategory());
        values.put("OperationSetupGroup", getOperationSetupGroup());
        values.put("CapacityCategoryCode", getCapacityCategoryCode());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MasterRecipeGroup") ) {
                final Object value = values.remove("MasterRecipeGroup");
                if( (value == null) || (!value.equals(getMasterRecipeGroup())) ) {
                    setMasterRecipeGroup(((String) value));
                }
            }
            if( values.containsKey("MasterRecipe") ) {
                final Object value = values.remove("MasterRecipe");
                if( (value == null) || (!value.equals(getMasterRecipe())) ) {
                    setMasterRecipe(((String) value));
                }
            }
            if( values.containsKey("MasterRecipeOperationIntID") ) {
                final Object value = values.remove("MasterRecipeOperationIntID");
                if( (value == null) || (!value.equals(getMasterRecipeOperationIntID())) ) {
                    setMasterRecipeOperationIntID(((String) value));
                }
            }
            if( values.containsKey("MstrRcpOperationIntVersion") ) {
                final Object value = values.remove("MstrRcpOperationIntVersion");
                if( (value == null) || (!value.equals(getMstrRcpOperationIntVersion())) ) {
                    setMstrRcpOperationIntVersion(((String) value));
                }
            }
            if( values.containsKey("Operation") ) {
                final Object value = values.remove("Operation");
                if( (value == null) || (!value.equals(getOperation())) ) {
                    setOperation(((String) value));
                }
            }
            if( values.containsKey("OperationText") ) {
                final Object value = values.remove("OperationText");
                if( (value == null) || (!value.equals(getOperationText())) ) {
                    setOperationText(((String) value));
                }
            }
            if( values.containsKey("LongTextLanguageCode") ) {
                final Object value = values.remove("LongTextLanguageCode");
                if( (value == null) || (!value.equals(getLongTextLanguageCode())) ) {
                    setLongTextLanguageCode(((String) value));
                }
            }
            if( values.containsKey("PlainLongText") ) {
                final Object value = values.remove("PlainLongText");
                if( (value == null) || (!value.equals(getPlainLongText())) ) {
                    setPlainLongText(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("OperationStandardTextCode") ) {
                final Object value = values.remove("OperationStandardTextCode");
                if( (value == null) || (!value.equals(getOperationStandardTextCode())) ) {
                    setOperationStandardTextCode(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("OperationControlProfile") ) {
                final Object value = values.remove("OperationControlProfile");
                if( (value == null) || (!value.equals(getOperationControlProfile())) ) {
                    setOperationControlProfile(((String) value));
                }
            }
            if( values.containsKey("OperationReferenceQuantity") ) {
                final Object value = values.remove("OperationReferenceQuantity");
                if( (value == null) || (!value.equals(getOperationReferenceQuantity())) ) {
                    setOperationReferenceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationUnit") ) {
                final Object value = values.remove("OperationUnit");
                if( (value == null) || (!value.equals(getOperationUnit())) ) {
                    setOperationUnit(((String) value));
                }
            }
            if( values.containsKey("OpQtyToBaseQtyNmrtr") ) {
                final Object value = values.remove("OpQtyToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getOpQtyToBaseQtyNmrtr())) ) {
                    setOpQtyToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpQtyToBaseQtyDnmntr") ) {
                final Object value = values.remove("OpQtyToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getOpQtyToBaseQtyDnmntr())) ) {
                    setOpQtyToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("NumberOfTimeTickets") ) {
                final Object value = values.remove("NumberOfTimeTickets");
                if( (value == null) || (!value.equals(getNumberOfTimeTickets())) ) {
                    setNumberOfTimeTickets(((BigDecimal) value));
                }
            }
            if( values.containsKey("NumberOfConfirmationSlips") ) {
                final Object value = values.remove("NumberOfConfirmationSlips");
                if( (value == null) || (!value.equals(getNumberOfConfirmationSlips())) ) {
                    setNumberOfConfirmationSlips(((String) value));
                }
            }
            if( values.containsKey("OperationCostingRelevancyType") ) {
                final Object value = values.remove("OperationCostingRelevancyType");
                if( (value == null) || (!value.equals(getOperationCostingRelevancyType())) ) {
                    setOperationCostingRelevancyType(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("OperationSetupType") ) {
                final Object value = values.remove("OperationSetupType");
                if( (value == null) || (!value.equals(getOperationSetupType())) ) {
                    setOperationSetupType(((String) value));
                }
            }
            if( values.containsKey("OperationSetupGroupCategory") ) {
                final Object value = values.remove("OperationSetupGroupCategory");
                if( (value == null) || (!value.equals(getOperationSetupGroupCategory())) ) {
                    setOperationSetupGroupCategory(((String) value));
                }
            }
            if( values.containsKey("OperationSetupGroup") ) {
                final Object value = values.remove("OperationSetupGroup");
                if( (value == null) || (!value.equals(getOperationSetupGroup())) ) {
                    setOperationSetupGroup(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryCode") ) {
                final Object value = values.remove("CapacityCategoryCode");
                if( (value == null) || (!value.equals(getCapacityCategoryCode())) ) {
                    setCapacityCategoryCode(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_OpCompAlloc") ) {
                final Object value = (values).remove("to_OpCompAlloc");
                if( value instanceof Iterable ) {
                    if( toOpCompAlloc == null ) {
                        toOpCompAlloc = Lists.newArrayList();
                    } else {
                        toOpCompAlloc = Lists.newArrayList(toOpCompAlloc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MasterRecipeOpCompAlloc entity;
                        if( toOpCompAlloc.size() > i ) {
                            entity = toOpCompAlloc.get(i);
                        } else {
                            entity = new MasterRecipeOpCompAlloc();
                            toOpCompAlloc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_OpSecdryRsce") ) {
                final Object value = (values).remove("to_OpSecdryRsce");
                if( value instanceof Iterable ) {
                    if( toOpSecdryRsce == null ) {
                        toOpSecdryRsce = Lists.newArrayList();
                    } else {
                        toOpSecdryRsce = Lists.newArrayList(toOpSecdryRsce);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MasterRecipeOpSecdryRsce entity;
                        if( toOpSecdryRsce.size() > i ) {
                            entity = toOpSecdryRsce.get(i);
                        } else {
                            entity = new MasterRecipeOpSecdryRsce();
                            toOpSecdryRsce.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Phase") ) {
                final Object value = (values).remove("to_Phase");
                if( value instanceof Iterable ) {
                    if( toPhase == null ) {
                        toPhase = Lists.newArrayList();
                    } else {
                        toPhase = Lists.newArrayList(toPhase);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MasterRecipePhase entity;
                        if( toPhase.size() > i ) {
                            entity = toPhase.get(i);
                        } else {
                            entity = new MasterRecipePhase();
                            toPhase.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MasterRecipeOperationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MasterRecipeOperationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MasterRecipeOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MasterRecipeOperationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toOpCompAlloc != null ) {
            (values).put("to_OpCompAlloc", toOpCompAlloc);
        }
        if( toOpSecdryRsce != null ) {
            (values).put("to_OpSecdryRsce", toOpSecdryRsce);
        }
        if( toPhase != null ) {
            (values).put("to_Phase", toPhase);
        }
        return values;
    }

    /**
     * Fetches the <b>MasterRecipeOpCompAlloc</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_OpCompAlloc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MasterRecipeOpCompAlloc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipeOpCompAlloc> fetchOpCompAlloc()
    {
        return fetchFieldAsList("to_OpCompAlloc", MasterRecipeOpCompAlloc.class);
    }

    /**
     * Retrieval of associated <b>MasterRecipeOpCompAlloc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_OpCompAlloc</b>.
     * <p>
     * If the navigation property <b>to_OpCompAlloc</b> of a queried <b>MasterRecipeOperation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MasterRecipeOpCompAlloc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipeOpCompAlloc> getOpCompAllocOrFetch()
    {
        if( toOpCompAlloc == null ) {
            toOpCompAlloc = fetchOpCompAlloc();
        }
        return toOpCompAlloc;
    }

    /**
     * Retrieval of associated <b>MasterRecipeOpCompAlloc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_OpCompAlloc</b>.
     * <p>
     * If the navigation property for an entity <b>MasterRecipeOperation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_OpCompAlloc</b> is already loaded, the result will
     *         contain the <b>MasterRecipeOpCompAlloc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MasterRecipeOpCompAlloc>> getOpCompAllocIfPresent()
    {
        return Option.of(toOpCompAlloc);
    }

    /**
     * Overwrites the list of associated <b>MasterRecipeOpCompAlloc</b> entities for the loaded navigation property
     * <b>to_OpCompAlloc</b>.
     * <p>
     * If the navigation property <b>to_OpCompAlloc</b> of a queried <b>MasterRecipeOperation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MasterRecipeOpCompAlloc</b> entities.
     */
    public void setOpCompAlloc( @Nonnull final List<MasterRecipeOpCompAlloc> value )
    {
        if( toOpCompAlloc == null ) {
            toOpCompAlloc = Lists.newArrayList();
        }
        toOpCompAlloc.clear();
        toOpCompAlloc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MasterRecipeOpCompAlloc</b> entities. This corresponds to the OData
     * navigation property <b>to_OpCompAlloc</b>.
     * <p>
     * If the navigation property <b>to_OpCompAlloc</b> of a queried <b>MasterRecipeOperation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MasterRecipeOpCompAlloc</b> entities.
     */
    public void addOpCompAlloc( MasterRecipeOpCompAlloc... entity )
    {
        if( toOpCompAlloc == null ) {
            toOpCompAlloc = Lists.newArrayList();
        }
        toOpCompAlloc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MasterRecipeOpSecdryRsce</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_OpSecdryRsce</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MasterRecipeOpSecdryRsce</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipeOpSecdryRsce> fetchOpSecdryRsce()
    {
        return fetchFieldAsList("to_OpSecdryRsce", MasterRecipeOpSecdryRsce.class);
    }

    /**
     * Retrieval of associated <b>MasterRecipeOpSecdryRsce</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_OpSecdryRsce</b>.
     * <p>
     * If the navigation property <b>to_OpSecdryRsce</b> of a queried <b>MasterRecipeOperation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MasterRecipeOpSecdryRsce</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipeOpSecdryRsce> getOpSecdryRsceOrFetch()
    {
        if( toOpSecdryRsce == null ) {
            toOpSecdryRsce = fetchOpSecdryRsce();
        }
        return toOpSecdryRsce;
    }

    /**
     * Retrieval of associated <b>MasterRecipeOpSecdryRsce</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_OpSecdryRsce</b>.
     * <p>
     * If the navigation property for an entity <b>MasterRecipeOperation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_OpSecdryRsce</b> is already loaded, the result will
     *         contain the <b>MasterRecipeOpSecdryRsce</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MasterRecipeOpSecdryRsce>> getOpSecdryRsceIfPresent()
    {
        return Option.of(toOpSecdryRsce);
    }

    /**
     * Overwrites the list of associated <b>MasterRecipeOpSecdryRsce</b> entities for the loaded navigation property
     * <b>to_OpSecdryRsce</b>.
     * <p>
     * If the navigation property <b>to_OpSecdryRsce</b> of a queried <b>MasterRecipeOperation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MasterRecipeOpSecdryRsce</b> entities.
     */
    public void setOpSecdryRsce( @Nonnull final List<MasterRecipeOpSecdryRsce> value )
    {
        if( toOpSecdryRsce == null ) {
            toOpSecdryRsce = Lists.newArrayList();
        }
        toOpSecdryRsce.clear();
        toOpSecdryRsce.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MasterRecipeOpSecdryRsce</b> entities. This corresponds to the OData
     * navigation property <b>to_OpSecdryRsce</b>.
     * <p>
     * If the navigation property <b>to_OpSecdryRsce</b> of a queried <b>MasterRecipeOperation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MasterRecipeOpSecdryRsce</b> entities.
     */
    public void addOpSecdryRsce( MasterRecipeOpSecdryRsce... entity )
    {
        if( toOpSecdryRsce == null ) {
            toOpSecdryRsce = Lists.newArrayList();
        }
        toOpSecdryRsce.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MasterRecipePhase</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Phase</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MasterRecipePhase</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipePhase> fetchPhase()
    {
        return fetchFieldAsList("to_Phase", MasterRecipePhase.class);
    }

    /**
     * Retrieval of associated <b>MasterRecipePhase</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Phase</b>.
     * <p>
     * If the navigation property <b>to_Phase</b> of a queried <b>MasterRecipeOperation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MasterRecipePhase</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MasterRecipePhase> getPhaseOrFetch()
    {
        if( toPhase == null ) {
            toPhase = fetchPhase();
        }
        return toPhase;
    }

    /**
     * Retrieval of associated <b>MasterRecipePhase</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Phase</b>.
     * <p>
     * If the navigation property for an entity <b>MasterRecipeOperation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Phase</b> is already loaded, the result will contain the
     *         <b>MasterRecipePhase</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<MasterRecipePhase>> getPhaseIfPresent()
    {
        return Option.of(toPhase);
    }

    /**
     * Overwrites the list of associated <b>MasterRecipePhase</b> entities for the loaded navigation property
     * <b>to_Phase</b>.
     * <p>
     * If the navigation property <b>to_Phase</b> of a queried <b>MasterRecipeOperation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MasterRecipePhase</b> entities.
     */
    public void setPhase( @Nonnull final List<MasterRecipePhase> value )
    {
        if( toPhase == null ) {
            toPhase = Lists.newArrayList();
        }
        toPhase.clear();
        toPhase.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MasterRecipePhase</b> entities. This corresponds to the OData
     * navigation property <b>to_Phase</b>.
     * <p>
     * If the navigation property <b>to_Phase</b> of a queried <b>MasterRecipeOperation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MasterRecipePhase</b> entities.
     */
    public void addPhase( MasterRecipePhase... entity )
    {
        if( toPhase == null ) {
            toPhase = Lists.newArrayList();
        }
        toPhase.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MasterRecipeOperation instances.
     *
     */
    public final static class MasterRecipeOperationBuilder
    {

        private List<MasterRecipeOpCompAlloc> toOpCompAlloc = Lists.newArrayList();
        private List<MasterRecipeOpSecdryRsce> toOpSecdryRsce = Lists.newArrayList();
        private List<MasterRecipePhase> toPhase = Lists.newArrayList();

        private MasterRecipeOperation.MasterRecipeOperationBuilder toOpCompAlloc(
            final List<MasterRecipeOpCompAlloc> value )
        {
            toOpCompAlloc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_OpCompAlloc</b> for <b>MasterRecipeOperation</b> to multiple
         * <b>MasterRecipeOpCompAlloc</b>.
         *
         * @param value
         *            The MasterRecipeOpCompAllocs to build this MasterRecipeOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MasterRecipeOperation.MasterRecipeOperationBuilder opCompAlloc( MasterRecipeOpCompAlloc... value )
        {
            return toOpCompAlloc(Lists.newArrayList(value));
        }

        private MasterRecipeOperation.MasterRecipeOperationBuilder toOpSecdryRsce(
            final List<MasterRecipeOpSecdryRsce> value )
        {
            toOpSecdryRsce.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_OpSecdryRsce</b> for <b>MasterRecipeOperation</b> to multiple
         * <b>MasterRecipeOpSecdryRsce</b>.
         *
         * @param value
         *            The MasterRecipeOpSecdryRsces to build this MasterRecipeOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MasterRecipeOperation.MasterRecipeOperationBuilder opSecdryRsce( MasterRecipeOpSecdryRsce... value )
        {
            return toOpSecdryRsce(Lists.newArrayList(value));
        }

        private MasterRecipeOperation.MasterRecipeOperationBuilder toPhase( final List<MasterRecipePhase> value )
        {
            toPhase.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Phase</b> for <b>MasterRecipeOperation</b> to multiple <b>MasterRecipePhase</b>.
         *
         * @param value
         *            The MasterRecipePhases to build this MasterRecipeOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MasterRecipeOperation.MasterRecipeOperationBuilder phase( MasterRecipePhase... value )
        {
            return toPhase(Lists.newArrayList(value));
        }

    }

}
