/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation MasterRecipeOperation}
 * entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class MasterRecipeOperationUpdateFluentHelper
    extends
    FluentHelperUpdate<MasterRecipeOperationUpdateFluentHelper, MasterRecipeOperation>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     * MasterRecipeOperation} entity object that will be updated in the S/4HANA system.
     *
     */
    private final MasterRecipeOperation entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     * MasterRecipeOperation} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The MasterRecipeOperation to take the updated values from.
     */
    public MasterRecipeOperationUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final MasterRecipeOperation entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected MasterRecipeOperation getEntity()
    {
        return entity;
    }

}
