/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.field.MasterRecipePhseCompAllocField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable.MasterRecipePhseCompAllocSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Phase Component Allocation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MasterRecipePhseCompAllocType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MasterRecipePhseCompAlloc extends VdmEntity<MasterRecipePhseCompAlloc>
{

    /**
     * Selector for all available fields of MasterRecipePhseCompAlloc.
     *
     */
    public final static MasterRecipePhseCompAllocSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "MasterRecipeGroup" )
    @JsonProperty( "MasterRecipeGroup" )
    @Nullable
    @ODataField( odataName = "MasterRecipeGroup" )
    private String masterRecipeGroup;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipeGroup</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> MASTER_RECIPE_GROUP =
        new MasterRecipePhseCompAllocField<String>("MasterRecipeGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipe</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "MasterRecipe" )
    @JsonProperty( "MasterRecipe" )
    @Nullable
    @ODataField( odataName = "MasterRecipe" )
    private String masterRecipe;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipe</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> MASTER_RECIPE =
        new MasterRecipePhseCompAllocField<String>("MasterRecipe");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeOperationIntID</b>
     * </p>
     *
     * @return Task list node number for operation
     */
    @Key
    @SerializedName( "MasterRecipeOperationIntID" )
    @JsonProperty( "MasterRecipeOperationIntID" )
    @Nullable
    @ODataField( odataName = "MasterRecipeOperationIntID" )
    private String masterRecipeOperationIntID;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipeOperationIntID</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> MASTER_RECIPE_OPERATION_INT_ID =
        new MasterRecipePhseCompAllocField<String>("MasterRecipeOperationIntID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MstrRcpOpBOMItemInternalID</b>
     * </p>
     *
     * @return No. for material comp. allocation to task list
     */
    @Key
    @SerializedName( "MstrRcpOpBOMItemInternalID" )
    @JsonProperty( "MstrRcpOpBOMItemInternalID" )
    @Nullable
    @ODataField( odataName = "MstrRcpOpBOMItemInternalID" )
    private String mstrRcpOpBOMItemInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MstrRcpOpBOMItemInternalID</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> MSTR_RCP_OP_BOM_ITEM_INTERNAL_ID =
        new MasterRecipePhseCompAllocField<String>("MstrRcpOpBOMItemInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MstrRcpOpBOMItemIntVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "MstrRcpOpBOMItemIntVersion" )
    @JsonProperty( "MstrRcpOpBOMItemIntVersion" )
    @Nullable
    @ODataField( odataName = "MstrRcpOpBOMItemIntVersion" )
    private String mstrRcpOpBOMItemIntVersion;
    /**
     * Use with available fluent helpers to apply the <b>MstrRcpOpBOMItemIntVersion</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> MSTR_RCP_OP_BOM_ITEM_INT_VERSION =
        new MasterRecipePhseCompAllocField<String>("MstrRcpOpBOMItemIntVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return BOM category
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> BILL_OF_MATERIAL_CATEGORY =
        new MasterRecipePhseCompAllocField<String>("BillOfMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @return Bill Of Material
     */
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterial</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> BILL_OF_MATERIAL =
        new MasterRecipePhseCompAllocField<String>("BillOfMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> BILL_OF_MATERIAL_VARIANT =
        new MasterRecipePhseCompAllocField<String>("BillOfMaterialVariant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @return Node Number
     */
    @SerializedName( "BillOfMaterialItemNodeNumber" )
    @JsonProperty( "BillOfMaterialItemNodeNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNodeNumber" )
    private String billOfMaterialItemNodeNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNodeNumber</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> BILL_OF_MATERIAL_ITEM_NODE_NUMBER =
        new MasterRecipePhseCompAllocField<String>("BillOfMaterialItemNodeNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @return Indicator: Backflush
     */
    @SerializedName( "MatlCompIsMarkedForBackflush" )
    @JsonProperty( "MatlCompIsMarkedForBackflush" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlCompIsMarkedForBackflush" )
    private Boolean matlCompIsMarkedForBackflush;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompIsMarkedForBackflush</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<Boolean> MATL_COMP_IS_MARKED_FOR_BACKFLUSH =
        new MasterRecipePhseCompAllocField<Boolean>("MatlCompIsMarkedForBackflush");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<LocalDateTime> CREATION_DATE =
        new MasterRecipePhseCompAllocField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> CREATED_BY_USER =
        new MasterRecipePhseCompAllocField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<LocalDateTime> LAST_CHANGE_DATE =
        new MasterRecipePhseCompAllocField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> LAST_CHANGED_BY_USER =
        new MasterRecipePhseCompAllocField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<LocalDateTime> VALIDITY_START_DATE =
        new MasterRecipePhseCompAllocField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<LocalDateTime> VALIDITY_END_DATE =
        new MasterRecipePhseCompAllocField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<String> CHANGE_NUMBER =
        new MasterRecipePhseCompAllocField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static MasterRecipePhseCompAllocField<ZonedDateTime> CHANGED_DATE_TIME =
        new MasterRecipePhseCompAllocField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<MasterRecipePhseCompAlloc> getType()
    {
        return MasterRecipePhseCompAlloc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeGroup</b>
     * </p>
     *
     * @param masterRecipeGroup
     *            Key for Task List Group
     */
    public void setMasterRecipeGroup( @Nullable final String masterRecipeGroup )
    {
        rememberChangedField("MasterRecipeGroup", this.masterRecipeGroup);
        this.masterRecipeGroup = masterRecipeGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipe</b>
     * </p>
     *
     * @param masterRecipe
     *            Group Counter
     */
    public void setMasterRecipe( @Nullable final String masterRecipe )
    {
        rememberChangedField("MasterRecipe", this.masterRecipe);
        this.masterRecipe = masterRecipe;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeOperationIntID</b>
     * </p>
     *
     * @param masterRecipeOperationIntID
     *            Task list node number for operation
     */
    public void setMasterRecipeOperationIntID( @Nullable final String masterRecipeOperationIntID )
    {
        rememberChangedField("MasterRecipeOperationIntID", this.masterRecipeOperationIntID);
        this.masterRecipeOperationIntID = masterRecipeOperationIntID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MstrRcpOpBOMItemInternalID</b>
     * </p>
     *
     * @param mstrRcpOpBOMItemInternalID
     *            No. for material comp. allocation to task list
     */
    public void setMstrRcpOpBOMItemInternalID( @Nullable final String mstrRcpOpBOMItemInternalID )
    {
        rememberChangedField("MstrRcpOpBOMItemInternalID", this.mstrRcpOpBOMItemInternalID);
        this.mstrRcpOpBOMItemInternalID = mstrRcpOpBOMItemInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MstrRcpOpBOMItemIntVersion</b>
     * </p>
     *
     * @param mstrRcpOpBOMItemIntVersion
     *            Internal counter
     */
    public void setMstrRcpOpBOMItemIntVersion( @Nullable final String mstrRcpOpBOMItemIntVersion )
    {
        rememberChangedField("MstrRcpOpBOMItemIntVersion", this.mstrRcpOpBOMItemIntVersion);
        this.mstrRcpOpBOMItemIntVersion = mstrRcpOpBOMItemIntVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            Bill Of Material
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNodeNumber
     *            Node Number
     */
    public void setBillOfMaterialItemNodeNumber( @Nullable final String billOfMaterialItemNodeNumber )
    {
        rememberChangedField("BillOfMaterialItemNodeNumber", this.billOfMaterialItemNodeNumber);
        this.billOfMaterialItemNodeNumber = billOfMaterialItemNodeNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @param matlCompIsMarkedForBackflush
     *            Indicator: Backflush
     */
    public void setMatlCompIsMarkedForBackflush( @Nullable final Boolean matlCompIsMarkedForBackflush )
    {
        rememberChangedField("MatlCompIsMarkedForBackflush", this.matlCompIsMarkedForBackflush);
        this.matlCompIsMarkedForBackflush = matlCompIsMarkedForBackflush;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MasterRecipePhseCompAlloc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MasterRecipeGroup", getMasterRecipeGroup());
        result.put("MasterRecipe", getMasterRecipe());
        result.put("MasterRecipeOperationIntID", getMasterRecipeOperationIntID());
        result.put("MstrRcpOpBOMItemInternalID", getMstrRcpOpBOMItemInternalID());
        result.put("MstrRcpOpBOMItemIntVersion", getMstrRcpOpBOMItemIntVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MasterRecipeGroup", getMasterRecipeGroup());
        values.put("MasterRecipe", getMasterRecipe());
        values.put("MasterRecipeOperationIntID", getMasterRecipeOperationIntID());
        values.put("MstrRcpOpBOMItemInternalID", getMstrRcpOpBOMItemInternalID());
        values.put("MstrRcpOpBOMItemIntVersion", getMstrRcpOpBOMItemIntVersion());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("BillOfMaterialItemNodeNumber", getBillOfMaterialItemNodeNumber());
        values.put("MatlCompIsMarkedForBackflush", getMatlCompIsMarkedForBackflush());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MasterRecipeGroup") ) {
                final Object value = values.remove("MasterRecipeGroup");
                if( (value == null) || (!value.equals(getMasterRecipeGroup())) ) {
                    setMasterRecipeGroup(((String) value));
                }
            }
            if( values.containsKey("MasterRecipe") ) {
                final Object value = values.remove("MasterRecipe");
                if( (value == null) || (!value.equals(getMasterRecipe())) ) {
                    setMasterRecipe(((String) value));
                }
            }
            if( values.containsKey("MasterRecipeOperationIntID") ) {
                final Object value = values.remove("MasterRecipeOperationIntID");
                if( (value == null) || (!value.equals(getMasterRecipeOperationIntID())) ) {
                    setMasterRecipeOperationIntID(((String) value));
                }
            }
            if( values.containsKey("MstrRcpOpBOMItemInternalID") ) {
                final Object value = values.remove("MstrRcpOpBOMItemInternalID");
                if( (value == null) || (!value.equals(getMstrRcpOpBOMItemInternalID())) ) {
                    setMstrRcpOpBOMItemInternalID(((String) value));
                }
            }
            if( values.containsKey("MstrRcpOpBOMItemIntVersion") ) {
                final Object value = values.remove("MstrRcpOpBOMItemIntVersion");
                if( (value == null) || (!value.equals(getMstrRcpOpBOMItemIntVersion())) ) {
                    setMstrRcpOpBOMItemIntVersion(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNodeNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNodeNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNodeNumber())) ) {
                    setBillOfMaterialItemNodeNumber(((String) value));
                }
            }
            if( values.containsKey("MatlCompIsMarkedForBackflush") ) {
                final Object value = values.remove("MatlCompIsMarkedForBackflush");
                if( (value == null) || (!value.equals(getMatlCompIsMarkedForBackflush())) ) {
                    setMatlCompIsMarkedForBackflush(((Boolean) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MasterRecipePhseCompAllocField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MasterRecipePhseCompAllocField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MasterRecipePhseCompAllocField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MasterRecipePhseCompAllocField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService.DEFAULT_SERVICE_PATH);
    }

}
