/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.field.MasterRecipePhseRelshpField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable.MasterRecipePhseRelshpSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Phase Relationship
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MasterRecipePhseRelshpType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MasterRecipePhseRelshp extends VdmEntity<MasterRecipePhseRelshp>
{

    /**
     * Selector for all available fields of MasterRecipePhseRelshp.
     *
     */
    public final static MasterRecipePhseRelshpSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrMasterRecipeGroup</b>
     * </p>
     *
     * @return Number of the Standard Network
     */
    @Key
    @SerializedName( "PrdcssrMasterRecipeGroup" )
    @JsonProperty( "PrdcssrMasterRecipeGroup" )
    @Nullable
    @ODataField( odataName = "PrdcssrMasterRecipeGroup" )
    private String prdcssrMasterRecipeGroup;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrMasterRecipeGroup</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> PRDCSSR_MASTER_RECIPE_GROUP =
        new MasterRecipePhseRelshpField<String>("PrdcssrMasterRecipeGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrMasterRecipe</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "PrdcssrMasterRecipe" )
    @JsonProperty( "PrdcssrMasterRecipe" )
    @Nullable
    @ODataField( odataName = "PrdcssrMasterRecipe" )
    private String prdcssrMasterRecipe;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrMasterRecipe</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> PRDCSSR_MASTER_RECIPE =
        new MasterRecipePhseRelshpField<String>("PrdcssrMasterRecipe");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrMstrRcpOpInternalID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @Key
    @SerializedName( "PrdcssrMstrRcpOpInternalID" )
    @JsonProperty( "PrdcssrMstrRcpOpInternalID" )
    @Nullable
    @ODataField( odataName = "PrdcssrMstrRcpOpInternalID" )
    private String prdcssrMstrRcpOpInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrMstrRcpOpInternalID</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> PRDCSSR_MSTR_RCP_OP_INTERNAL_ID =
        new MasterRecipePhseRelshpField<String>("PrdcssrMstrRcpOpInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuccssrMasterRecipeGroup</b>
     * </p>
     *
     * @return Number of the Standard Network
     */
    @Key
    @SerializedName( "SuccssrMasterRecipeGroup" )
    @JsonProperty( "SuccssrMasterRecipeGroup" )
    @Nullable
    @ODataField( odataName = "SuccssrMasterRecipeGroup" )
    private String succssrMasterRecipeGroup;
    /**
     * Use with available fluent helpers to apply the <b>SuccssrMasterRecipeGroup</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> SUCCSSR_MASTER_RECIPE_GROUP =
        new MasterRecipePhseRelshpField<String>("SuccssrMasterRecipeGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuccssrMasterRecipe</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "SuccssrMasterRecipe" )
    @JsonProperty( "SuccssrMasterRecipe" )
    @Nullable
    @ODataField( odataName = "SuccssrMasterRecipe" )
    private String succssrMasterRecipe;
    /**
     * Use with available fluent helpers to apply the <b>SuccssrMasterRecipe</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> SUCCSSR_MASTER_RECIPE =
        new MasterRecipePhseRelshpField<String>("SuccssrMasterRecipe");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuccssrMstrRcpOpInternalID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @Key
    @SerializedName( "SuccssrMstrRcpOpInternalID" )
    @JsonProperty( "SuccssrMstrRcpOpInternalID" )
    @Nullable
    @ODataField( odataName = "SuccssrMstrRcpOpInternalID" )
    private String succssrMstrRcpOpInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SuccssrMstrRcpOpInternalID</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> SUCCSSR_MSTR_RCP_OP_INTERNAL_ID =
        new MasterRecipePhseRelshpField<String>("SuccssrMstrRcpOpInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeRelationshipType</b>
     * </p>
     *
     * @return Type of relationship
     */
    @Key
    @SerializedName( "MasterRecipeRelationshipType" )
    @JsonProperty( "MasterRecipeRelationshipType" )
    @Nullable
    @ODataField( odataName = "MasterRecipeRelationshipType" )
    private String masterRecipeRelationshipType;
    /**
     * Use with available fluent helpers to apply the <b>MasterRecipeRelationshipType</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> MASTER_RECIPE_RELATIONSHIP_TYPE =
        new MasterRecipePhseRelshpField<String>("MasterRecipeRelationshipType");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaxTimeIntvlIsUsedForSchedg</b>
     * </p>
     *
     * @return Indicates whether maximum time interval will be considered
     */
    @Key
    @SerializedName( "MaxTimeIntvlIsUsedForSchedg" )
    @JsonProperty( "MaxTimeIntvlIsUsedForSchedg" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaxTimeIntvlIsUsedForSchedg" )
    private Boolean maxTimeIntvlIsUsedForSchedg;
    /**
     * Use with available fluent helpers to apply the <b>MaxTimeIntvlIsUsedForSchedg</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<Boolean> MAX_TIME_INTVL_IS_USED_FOR_SCHEDG =
        new MasterRecipePhseRelshpField<Boolean>("MaxTimeIntvlIsUsedForSchedg");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MstrRcpRelationshipIntVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "MstrRcpRelationshipIntVersion" )
    @JsonProperty( "MstrRcpRelationshipIntVersion" )
    @Nullable
    @ODataField( odataName = "MstrRcpRelationshipIntVersion" )
    private String mstrRcpRelationshipIntVersion;
    /**
     * Use with available fluent helpers to apply the <b>MstrRcpRelationshipIntVersion</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> MSTR_RCP_RELATIONSHIP_INT_VERSION =
        new MasterRecipePhseRelshpField<String>("MstrRcpRelationshipIntVersion");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>TimeIntvlBtwnRelshp</b>
     * </p>
     *
     * @return Time interval between relationships
     */
    @SerializedName( "TimeIntvlBtwnRelshp" )
    @JsonProperty( "TimeIntvlBtwnRelshp" )
    @Nullable
    @ODataField( odataName = "TimeIntvlBtwnRelshp" )
    private BigDecimal timeIntvlBtwnRelshp;
    /**
     * Use with available fluent helpers to apply the <b>TimeIntvlBtwnRelshp</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<BigDecimal> TIME_INTVL_BTWN_RELSHP =
        new MasterRecipePhseRelshpField<BigDecimal>("TimeIntvlBtwnRelshp");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaxTimeIntvlBtwnRelshp</b>
     * </p>
     *
     * @return Maximum time interval for relationship
     */
    @SerializedName( "MaxTimeIntvlBtwnRelshp" )
    @JsonProperty( "MaxTimeIntvlBtwnRelshp" )
    @Nullable
    @ODataField( odataName = "MaxTimeIntvlBtwnRelshp" )
    private BigDecimal maxTimeIntvlBtwnRelshp;
    /**
     * Use with available fluent helpers to apply the <b>MaxTimeIntvlBtwnRelshp</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<BigDecimal> MAX_TIME_INTVL_BTWN_RELSHP =
        new MasterRecipePhseRelshpField<BigDecimal>("MaxTimeIntvlBtwnRelshp");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TimeIntvlBtwnRelshpUnit</b>
     * </p>
     *
     * @return Unit for the time interval between relationships
     */
    @SerializedName( "TimeIntvlBtwnRelshpUnit" )
    @JsonProperty( "TimeIntvlBtwnRelshpUnit" )
    @Nullable
    @ODataField( odataName = "TimeIntvlBtwnRelshpUnit" )
    private String timeIntvlBtwnRelshpUnit;
    /**
     * Use with available fluent helpers to apply the <b>TimeIntvlBtwnRelshpUnit</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> TIME_INTVL_BTWN_RELSHP_UNIT =
        new MasterRecipePhseRelshpField<String>("TimeIntvlBtwnRelshpUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Factory Calendar
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> FACTORY_CALENDAR =
        new MasterRecipePhseRelshpField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> WORK_CENTER_INTERNAL_ID =
        new MasterRecipePhseRelshpField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> PLANT = new MasterRecipePhseRelshpField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<LocalDateTime> CREATION_DATE =
        new MasterRecipePhseRelshpField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> CREATED_BY_USER =
        new MasterRecipePhseRelshpField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<LocalDateTime> LAST_CHANGE_DATE =
        new MasterRecipePhseRelshpField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> LAST_CHANGED_BY_USER =
        new MasterRecipePhseRelshpField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<LocalDateTime> VALIDITY_START_DATE =
        new MasterRecipePhseRelshpField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<LocalDateTime> VALIDITY_END_DATE =
        new MasterRecipePhseRelshpField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<String> CHANGE_NUMBER =
        new MasterRecipePhseRelshpField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static MasterRecipePhseRelshpField<ZonedDateTime> CHANGED_DATE_TIME =
        new MasterRecipePhseRelshpField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<MasterRecipePhseRelshp> getType()
    {
        return MasterRecipePhseRelshp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrMasterRecipeGroup</b>
     * </p>
     *
     * @param prdcssrMasterRecipeGroup
     *            Number of the Standard Network
     */
    public void setPrdcssrMasterRecipeGroup( @Nullable final String prdcssrMasterRecipeGroup )
    {
        rememberChangedField("PrdcssrMasterRecipeGroup", this.prdcssrMasterRecipeGroup);
        this.prdcssrMasterRecipeGroup = prdcssrMasterRecipeGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrMasterRecipe</b>
     * </p>
     *
     * @param prdcssrMasterRecipe
     *            Group Counter
     */
    public void setPrdcssrMasterRecipe( @Nullable final String prdcssrMasterRecipe )
    {
        rememberChangedField("PrdcssrMasterRecipe", this.prdcssrMasterRecipe);
        this.prdcssrMasterRecipe = prdcssrMasterRecipe;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrMstrRcpOpInternalID</b>
     * </p>
     *
     * @param prdcssrMstrRcpOpInternalID
     *            Number of the Task List Node
     */
    public void setPrdcssrMstrRcpOpInternalID( @Nullable final String prdcssrMstrRcpOpInternalID )
    {
        rememberChangedField("PrdcssrMstrRcpOpInternalID", this.prdcssrMstrRcpOpInternalID);
        this.prdcssrMstrRcpOpInternalID = prdcssrMstrRcpOpInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuccssrMasterRecipeGroup</b>
     * </p>
     *
     * @param succssrMasterRecipeGroup
     *            Number of the Standard Network
     */
    public void setSuccssrMasterRecipeGroup( @Nullable final String succssrMasterRecipeGroup )
    {
        rememberChangedField("SuccssrMasterRecipeGroup", this.succssrMasterRecipeGroup);
        this.succssrMasterRecipeGroup = succssrMasterRecipeGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuccssrMasterRecipe</b>
     * </p>
     *
     * @param succssrMasterRecipe
     *            Group Counter
     */
    public void setSuccssrMasterRecipe( @Nullable final String succssrMasterRecipe )
    {
        rememberChangedField("SuccssrMasterRecipe", this.succssrMasterRecipe);
        this.succssrMasterRecipe = succssrMasterRecipe;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuccssrMstrRcpOpInternalID</b>
     * </p>
     *
     * @param succssrMstrRcpOpInternalID
     *            Number of the Task List Node
     */
    public void setSuccssrMstrRcpOpInternalID( @Nullable final String succssrMstrRcpOpInternalID )
    {
        rememberChangedField("SuccssrMstrRcpOpInternalID", this.succssrMstrRcpOpInternalID);
        this.succssrMstrRcpOpInternalID = succssrMstrRcpOpInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeRelationshipType</b>
     * </p>
     *
     * @param masterRecipeRelationshipType
     *            Type of relationship
     */
    public void setMasterRecipeRelationshipType( @Nullable final String masterRecipeRelationshipType )
    {
        rememberChangedField("MasterRecipeRelationshipType", this.masterRecipeRelationshipType);
        this.masterRecipeRelationshipType = masterRecipeRelationshipType;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaxTimeIntvlIsUsedForSchedg</b>
     * </p>
     *
     * @param maxTimeIntvlIsUsedForSchedg
     *            Indicates whether maximum time interval will be considered
     */
    public void setMaxTimeIntvlIsUsedForSchedg( @Nullable final Boolean maxTimeIntvlIsUsedForSchedg )
    {
        rememberChangedField("MaxTimeIntvlIsUsedForSchedg", this.maxTimeIntvlIsUsedForSchedg);
        this.maxTimeIntvlIsUsedForSchedg = maxTimeIntvlIsUsedForSchedg;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MstrRcpRelationshipIntVersion</b>
     * </p>
     *
     * @param mstrRcpRelationshipIntVersion
     *            Internal counter
     */
    public void setMstrRcpRelationshipIntVersion( @Nullable final String mstrRcpRelationshipIntVersion )
    {
        rememberChangedField("MstrRcpRelationshipIntVersion", this.mstrRcpRelationshipIntVersion);
        this.mstrRcpRelationshipIntVersion = mstrRcpRelationshipIntVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>TimeIntvlBtwnRelshp</b>
     * </p>
     *
     * @param timeIntvlBtwnRelshp
     *            Time interval between relationships
     */
    public void setTimeIntvlBtwnRelshp( @Nullable final BigDecimal timeIntvlBtwnRelshp )
    {
        rememberChangedField("TimeIntvlBtwnRelshp", this.timeIntvlBtwnRelshp);
        this.timeIntvlBtwnRelshp = timeIntvlBtwnRelshp;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaxTimeIntvlBtwnRelshp</b>
     * </p>
     *
     * @param maxTimeIntvlBtwnRelshp
     *            Maximum time interval for relationship
     */
    public void setMaxTimeIntvlBtwnRelshp( @Nullable final BigDecimal maxTimeIntvlBtwnRelshp )
    {
        rememberChangedField("MaxTimeIntvlBtwnRelshp", this.maxTimeIntvlBtwnRelshp);
        this.maxTimeIntvlBtwnRelshp = maxTimeIntvlBtwnRelshp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TimeIntvlBtwnRelshpUnit</b>
     * </p>
     *
     * @param timeIntvlBtwnRelshpUnit
     *            Unit for the time interval between relationships
     */
    public void setTimeIntvlBtwnRelshpUnit( @Nullable final String timeIntvlBtwnRelshpUnit )
    {
        rememberChangedField("TimeIntvlBtwnRelshpUnit", this.timeIntvlBtwnRelshpUnit);
        this.timeIntvlBtwnRelshpUnit = timeIntvlBtwnRelshpUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Factory Calendar
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MasterRecipePhseRelshp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PrdcssrMasterRecipeGroup", getPrdcssrMasterRecipeGroup());
        result.put("PrdcssrMasterRecipe", getPrdcssrMasterRecipe());
        result.put("PrdcssrMstrRcpOpInternalID", getPrdcssrMstrRcpOpInternalID());
        result.put("SuccssrMasterRecipeGroup", getSuccssrMasterRecipeGroup());
        result.put("SuccssrMasterRecipe", getSuccssrMasterRecipe());
        result.put("SuccssrMstrRcpOpInternalID", getSuccssrMstrRcpOpInternalID());
        result.put("MasterRecipeRelationshipType", getMasterRecipeRelationshipType());
        result.put("MaxTimeIntvlIsUsedForSchedg", getMaxTimeIntvlIsUsedForSchedg());
        result.put("MstrRcpRelationshipIntVersion", getMstrRcpRelationshipIntVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PrdcssrMasterRecipeGroup", getPrdcssrMasterRecipeGroup());
        values.put("PrdcssrMasterRecipe", getPrdcssrMasterRecipe());
        values.put("PrdcssrMstrRcpOpInternalID", getPrdcssrMstrRcpOpInternalID());
        values.put("SuccssrMasterRecipeGroup", getSuccssrMasterRecipeGroup());
        values.put("SuccssrMasterRecipe", getSuccssrMasterRecipe());
        values.put("SuccssrMstrRcpOpInternalID", getSuccssrMstrRcpOpInternalID());
        values.put("MasterRecipeRelationshipType", getMasterRecipeRelationshipType());
        values.put("MaxTimeIntvlIsUsedForSchedg", getMaxTimeIntvlIsUsedForSchedg());
        values.put("MstrRcpRelationshipIntVersion", getMstrRcpRelationshipIntVersion());
        values.put("TimeIntvlBtwnRelshp", getTimeIntvlBtwnRelshp());
        values.put("MaxTimeIntvlBtwnRelshp", getMaxTimeIntvlBtwnRelshp());
        values.put("TimeIntvlBtwnRelshpUnit", getTimeIntvlBtwnRelshpUnit());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("Plant", getPlant());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PrdcssrMasterRecipeGroup") ) {
                final Object value = values.remove("PrdcssrMasterRecipeGroup");
                if( (value == null) || (!value.equals(getPrdcssrMasterRecipeGroup())) ) {
                    setPrdcssrMasterRecipeGroup(((String) value));
                }
            }
            if( values.containsKey("PrdcssrMasterRecipe") ) {
                final Object value = values.remove("PrdcssrMasterRecipe");
                if( (value == null) || (!value.equals(getPrdcssrMasterRecipe())) ) {
                    setPrdcssrMasterRecipe(((String) value));
                }
            }
            if( values.containsKey("PrdcssrMstrRcpOpInternalID") ) {
                final Object value = values.remove("PrdcssrMstrRcpOpInternalID");
                if( (value == null) || (!value.equals(getPrdcssrMstrRcpOpInternalID())) ) {
                    setPrdcssrMstrRcpOpInternalID(((String) value));
                }
            }
            if( values.containsKey("SuccssrMasterRecipeGroup") ) {
                final Object value = values.remove("SuccssrMasterRecipeGroup");
                if( (value == null) || (!value.equals(getSuccssrMasterRecipeGroup())) ) {
                    setSuccssrMasterRecipeGroup(((String) value));
                }
            }
            if( values.containsKey("SuccssrMasterRecipe") ) {
                final Object value = values.remove("SuccssrMasterRecipe");
                if( (value == null) || (!value.equals(getSuccssrMasterRecipe())) ) {
                    setSuccssrMasterRecipe(((String) value));
                }
            }
            if( values.containsKey("SuccssrMstrRcpOpInternalID") ) {
                final Object value = values.remove("SuccssrMstrRcpOpInternalID");
                if( (value == null) || (!value.equals(getSuccssrMstrRcpOpInternalID())) ) {
                    setSuccssrMstrRcpOpInternalID(((String) value));
                }
            }
            if( values.containsKey("MasterRecipeRelationshipType") ) {
                final Object value = values.remove("MasterRecipeRelationshipType");
                if( (value == null) || (!value.equals(getMasterRecipeRelationshipType())) ) {
                    setMasterRecipeRelationshipType(((String) value));
                }
            }
            if( values.containsKey("MaxTimeIntvlIsUsedForSchedg") ) {
                final Object value = values.remove("MaxTimeIntvlIsUsedForSchedg");
                if( (value == null) || (!value.equals(getMaxTimeIntvlIsUsedForSchedg())) ) {
                    setMaxTimeIntvlIsUsedForSchedg(((Boolean) value));
                }
            }
            if( values.containsKey("MstrRcpRelationshipIntVersion") ) {
                final Object value = values.remove("MstrRcpRelationshipIntVersion");
                if( (value == null) || (!value.equals(getMstrRcpRelationshipIntVersion())) ) {
                    setMstrRcpRelationshipIntVersion(((String) value));
                }
            }
            if( values.containsKey("TimeIntvlBtwnRelshp") ) {
                final Object value = values.remove("TimeIntvlBtwnRelshp");
                if( (value == null) || (!value.equals(getTimeIntvlBtwnRelshp())) ) {
                    setTimeIntvlBtwnRelshp(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaxTimeIntvlBtwnRelshp") ) {
                final Object value = values.remove("MaxTimeIntvlBtwnRelshp");
                if( (value == null) || (!value.equals(getMaxTimeIntvlBtwnRelshp())) ) {
                    setMaxTimeIntvlBtwnRelshp(((BigDecimal) value));
                }
            }
            if( values.containsKey("TimeIntvlBtwnRelshpUnit") ) {
                final Object value = values.remove("TimeIntvlBtwnRelshpUnit");
                if( (value == null) || (!value.equals(getTimeIntvlBtwnRelshpUnit())) ) {
                    setTimeIntvlBtwnRelshpUnit(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MasterRecipePhseRelshpField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MasterRecipePhseRelshpField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MasterRecipePhseRelshpField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MasterRecipePhseRelshpField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService.DEFAULT_SERVICE_PATH);
    }

}
