/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable.MasterRecipePhseRelshpSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
 * MasterRecipePhseRelshp} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class MasterRecipePhseRelshpByKeyFluentHelper
    extends
    FluentHelperByKey<MasterRecipePhseRelshpByKeyFluentHelper, MasterRecipePhseRelshp, MasterRecipePhseRelshpSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     * MasterRecipePhseRelshp} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MasterRecipePhseRelshp}
     * @param succssrMstrRcpOpInternalID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeRelationshipType
     *            Type of relationship
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param succssrMasterRecipeGroup
     *            Number of the Standard Network
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mstrRcpRelationshipIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MasterRecipePhseRelshp}
     * @param prdcssrMstrRcpOpInternalID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param succssrMasterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param prdcssrMasterRecipeGroup
     *            Number of the Standard Network
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param maxTimeIntvlIsUsedForSchedg
     *            Indicates whether maximum time interval will be considered
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param prdcssrMasterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public MasterRecipePhseRelshpByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String prdcssrMasterRecipeGroup,
        final String prdcssrMasterRecipe,
        final String prdcssrMstrRcpOpInternalID,
        final String succssrMasterRecipeGroup,
        final String succssrMasterRecipe,
        final String succssrMstrRcpOpInternalID,
        final String masterRecipeRelationshipType,
        final Boolean maxTimeIntvlIsUsedForSchedg,
        final String mstrRcpRelationshipIntVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("PrdcssrMasterRecipeGroup", prdcssrMasterRecipeGroup);
        this.key.put("PrdcssrMasterRecipe", prdcssrMasterRecipe);
        this.key.put("PrdcssrMstrRcpOpInternalID", prdcssrMstrRcpOpInternalID);
        this.key.put("SuccssrMasterRecipeGroup", succssrMasterRecipeGroup);
        this.key.put("SuccssrMasterRecipe", succssrMasterRecipe);
        this.key.put("SuccssrMstrRcpOpInternalID", succssrMstrRcpOpInternalID);
        this.key.put("MasterRecipeRelationshipType", masterRecipeRelationshipType);
        this.key.put("MaxTimeIntvlIsUsedForSchedg", maxTimeIntvlIsUsedForSchedg);
        this.key.put("MstrRcpRelationshipIntVersion", mstrRcpRelationshipIntVersion);
    }

    @Override
    @Nonnull
    protected Class<MasterRecipePhseRelshp> getEntityClass()
    {
        return MasterRecipePhseRelshp.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
