/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable.MasterRecipePhseSecdryRsceSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
 * MasterRecipePhseSecdryRsce} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MasterRecipePhseSecdryRsceByKeyFluentHelper
    extends
    FluentHelperByKey<MasterRecipePhseSecdryRsceByKeyFluentHelper, MasterRecipePhseSecdryRsce, MasterRecipePhseSecdryRsceSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     * MasterRecipePhseSecdryRsce} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MasterRecipePhseSecdryRsce}
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MasterRecipePhseSecdryRsce}
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeOperationIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mstrRcpOperationIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public MasterRecipePhseSecdryRsceByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOperationIntVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("MasterRecipeGroup", masterRecipeGroup);
        this.key.put("MasterRecipe", masterRecipe);
        this.key.put("MasterRecipeOperationIntID", masterRecipeOperationIntID);
        this.key.put("MstrRcpOperationIntVersion", mstrRcpOperationIntVersion);
    }

    @Override
    @Nonnull
    protected Class<MasterRecipePhseSecdryRsce> getEntityClass()
    {
        return MasterRecipePhseSecdryRsce.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
