/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MasterRecipeServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService MasterRecipeService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultMasterRecipeServiceBatch
    extends
    BatchFluentHelperBasic<MasterRecipeServiceBatch, MasterRecipeServiceBatchChangeSet>
    implements
    MasterRecipeServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMasterRecipeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMasterRecipeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMasterRecipeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMasterRecipeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMasterRecipeServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMasterRecipeServiceBatchChangeSet(this, service);
    }

}
