/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce;

/**
 * Implementation of the {@link MasterRecipeServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService MasterRecipeService}.
 *
 */
public class DefaultMasterRecipeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MasterRecipeServiceBatch, MasterRecipeServiceBatchChangeSet>
    implements
    MasterRecipeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService service;

    @SuppressWarnings( "deprecation" )
    DefaultMasterRecipeServiceBatchChangeSet(
        @Nonnull final DefaultMasterRecipeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMasterRecipeServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet createMasterRecipeHeader(
        @Nonnull final MasterRecipeHeader masterRecipeHeader )
    {
        return addRequestCreate(service::createMasterRecipeHeader, masterRecipeHeader);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet updateMasterRecipeHeader(
        @Nonnull final MasterRecipeHeader masterRecipeHeader )
    {
        return addRequestUpdate(service::updateMasterRecipeHeader, masterRecipeHeader);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet createMasterRecipeOperation(
        @Nonnull final MasterRecipeOperation masterRecipeOperation )
    {
        return addRequestCreate(service::createMasterRecipeOperation, masterRecipeOperation);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet updateMasterRecipeOperation(
        @Nonnull final MasterRecipeOperation masterRecipeOperation )
    {
        return addRequestUpdate(service::updateMasterRecipeOperation, masterRecipeOperation);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet createMasterRecipeOpSecdryRsce(
        @Nonnull final MasterRecipeOpSecdryRsce masterRecipeOpSecdryRsce )
    {
        return addRequestCreate(service::createMasterRecipeOpSecdryRsce, masterRecipeOpSecdryRsce);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet updateMasterRecipeOpSecdryRsce(
        @Nonnull final MasterRecipeOpSecdryRsce masterRecipeOpSecdryRsce )
    {
        return addRequestUpdate(service::updateMasterRecipeOpSecdryRsce, masterRecipeOpSecdryRsce);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet createMasterRecipePhase(
        @Nonnull final MasterRecipePhase masterRecipePhase )
    {
        return addRequestCreate(service::createMasterRecipePhase, masterRecipePhase);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet updateMasterRecipePhase(
        @Nonnull final MasterRecipePhase masterRecipePhase )
    {
        return addRequestUpdate(service::updateMasterRecipePhase, masterRecipePhase);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet createMasterRecipePhseCompAlloc(
        @Nonnull final MasterRecipePhseCompAlloc masterRecipePhseCompAlloc )
    {
        return addRequestCreate(service::createMasterRecipePhseCompAlloc, masterRecipePhseCompAlloc);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet updateMasterRecipePhseCompAlloc(
        @Nonnull final MasterRecipePhseCompAlloc masterRecipePhseCompAlloc )
    {
        return addRequestUpdate(service::updateMasterRecipePhseCompAlloc, masterRecipePhseCompAlloc);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet createMasterRecipePhseSecdryRsce(
        @Nonnull final MasterRecipePhseSecdryRsce masterRecipePhseSecdryRsce )
    {
        return addRequestCreate(service::createMasterRecipePhseSecdryRsce, masterRecipePhseSecdryRsce);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet updateMasterRecipePhseSecdryRsce(
        @Nonnull final MasterRecipePhseSecdryRsce masterRecipePhseSecdryRsce )
    {
        return addRequestUpdate(service::updateMasterRecipePhseSecdryRsce, masterRecipePhseSecdryRsce);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet createMasterRecipePhseRelshp(
        @Nonnull final MasterRecipePhseRelshp masterRecipePhseRelshp )
    {
        return addRequestCreate(service::createMasterRecipePhseRelshp, masterRecipePhseRelshp);
    }

    @Nonnull
    @Override
    public MasterRecipeServiceBatchChangeSet updateMasterRecipePhseRelshp(
        @Nonnull final MasterRecipePhseRelshp masterRecipePhseRelshp )
    {
        return addRequestUpdate(service::updateMasterRecipePhseRelshp, masterRecipePhseRelshp);
    }

}
