/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterRecipeService MasterRecipeService}.
 *
 */
public interface MasterRecipeServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<MasterRecipeServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<MasterRecipeServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     * MasterRecipeHeader} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     *            MasterRecipeHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet createMasterRecipeHeader( @Nonnull final MasterRecipeHeader masterRecipeHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     * MasterRecipeHeader} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     *            MasterRecipeHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet updateMasterRecipeHeader( @Nonnull final MasterRecipeHeader masterRecipeHeader );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     * MasterRecipeOperation} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     *            MasterRecipeOperation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        createMasterRecipeOperation( @Nonnull final MasterRecipeOperation masterRecipeOperation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     * MasterRecipeOperation} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     *            MasterRecipeOperation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        updateMasterRecipeOperation( @Nonnull final MasterRecipeOperation masterRecipeOperation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     * MasterRecipeOpSecdryRsce} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeOpSecdryRsce
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     *            MasterRecipeOpSecdryRsce} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        createMasterRecipeOpSecdryRsce( @Nonnull final MasterRecipeOpSecdryRsce masterRecipeOpSecdryRsce );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     * MasterRecipeOpSecdryRsce} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeOpSecdryRsce
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     *            MasterRecipeOpSecdryRsce} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        updateMasterRecipeOpSecdryRsce( @Nonnull final MasterRecipeOpSecdryRsce masterRecipeOpSecdryRsce );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     * MasterRecipePhase} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhase
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     *            MasterRecipePhase} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet createMasterRecipePhase( @Nonnull final MasterRecipePhase masterRecipePhase );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     * MasterRecipePhase} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhase
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     *            MasterRecipePhase} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet updateMasterRecipePhase( @Nonnull final MasterRecipePhase masterRecipePhase );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     * MasterRecipePhseCompAlloc} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseCompAlloc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     *            MasterRecipePhseCompAlloc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        createMasterRecipePhseCompAlloc( @Nonnull final MasterRecipePhseCompAlloc masterRecipePhseCompAlloc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     * MasterRecipePhseCompAlloc} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseCompAlloc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     *            MasterRecipePhseCompAlloc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        updateMasterRecipePhseCompAlloc( @Nonnull final MasterRecipePhseCompAlloc masterRecipePhseCompAlloc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     * MasterRecipePhseSecdryRsce} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseSecdryRsce
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     *            MasterRecipePhseSecdryRsce} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        createMasterRecipePhseSecdryRsce( @Nonnull final MasterRecipePhseSecdryRsce masterRecipePhseSecdryRsce );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     * MasterRecipePhseSecdryRsce} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseSecdryRsce
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     *            MasterRecipePhseSecdryRsce} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        updateMasterRecipePhseSecdryRsce( @Nonnull final MasterRecipePhseSecdryRsce masterRecipePhseSecdryRsce );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     * MasterRecipePhseRelshp} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseRelshp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     *            MasterRecipePhseRelshp} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        createMasterRecipePhseRelshp( @Nonnull final MasterRecipePhseRelshp masterRecipePhseRelshp );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     * MasterRecipePhseRelshp} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseRelshp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     *            MasterRecipePhseRelshp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MasterRecipeServiceBatchChangeSet
        updateMasterRecipePhseRelshp( @Nonnull final MasterRecipePhseRelshp masterRecipePhseRelshp );

}
