/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable.MasterRecipePhseCompAllocSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
 * MasterRecipePhseCompAlloc} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class MasterRecipePhseCompAllocLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<MasterRecipePhseCompAllocLink<ObjectT>, MasterRecipePhseCompAlloc, ObjectT>
    implements
    MasterRecipePhseCompAllocSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public MasterRecipePhseCompAllocLink( final String fieldName )
    {
        super(fieldName);
    }

    private MasterRecipePhseCompAllocLink(
        final EntityLink<MasterRecipePhseCompAllocLink<ObjectT>, MasterRecipePhseCompAlloc, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected MasterRecipePhseCompAllocLink<ObjectT> translateLinkType(
        final EntityLink<MasterRecipePhseCompAllocLink<ObjectT>, MasterRecipePhseCompAlloc, ObjectT> link )
    {
        return new MasterRecipePhseCompAllocLink<ObjectT>(link);
    }

}
