/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable.MasterRecipePhseRelshpSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
 * MasterRecipePhseRelshp} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class MasterRecipePhseRelshpLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<MasterRecipePhseRelshpLink<ObjectT>, MasterRecipePhseRelshp, ObjectT>
    implements
    MasterRecipePhseRelshpSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public MasterRecipePhseRelshpLink( final String fieldName )
    {
        super(fieldName);
    }

    private MasterRecipePhseRelshpLink(
        final EntityLink<MasterRecipePhseRelshpLink<ObjectT>, MasterRecipePhseRelshp, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected MasterRecipePhseRelshpLink<ObjectT> translateLinkType(
        final EntityLink<MasterRecipePhseRelshpLink<ObjectT>, MasterRecipePhseRelshp, ObjectT> link )
    {
        return new MasterRecipePhseRelshpLink<ObjectT>(link);
    }

}
