/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase MasterRecipePhase}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.field.MasterRecipePhaseField
 * MasterRecipePhaseField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.link.MasterRecipePhaseLink
 * MasterRecipePhaseLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#MASTER_RECIPE_GROUP
 * MASTER_RECIPE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#MASTER_RECIPE
 * MASTER_RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#MASTER_RECIPE_OPERATION_INT_ID
 * MASTER_RECIPE_OPERATION_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#MSTR_RCP_SUPERIOR_OP_INT_VERSION
 * MSTR_RCP_SUPERIOR_OP_INT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#MSTR_RCP_OPERATION_INT_VERSION
 * MSTR_RCP_OPERATION_INT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#SUPERIOR_OPERATION_INTERNAL_ID
 * SUPERIOR_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION
 * OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION_TEXT
 * OPERATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#LONG_TEXT_LANGUAGE_CODE
 * LONG_TEXT_LANGUAGE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#PLAIN_LONG_TEXT
 * PLAIN_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION_CONTROL_PROFILE
 * OPERATION_CONTROL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#CONTROL_RECIPE_DESTINATION
 * CONTROL_RECIPE_DESTINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION_STANDARD_TEXT_CODE
 * OPERATION_STANDARD_TEXT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION_REFERENCE_QUANTITY
 * OPERATION_REFERENCE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION_UNIT
 * OPERATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OP_QTY_TO_BASE_QTY_NMRTR
 * OP_QTY_TO_BASE_QTY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OP_QTY_TO_BASE_QTY_DNMNTR
 * OP_QTY_TO_BASE_QTY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM1
 * STANDARD_WORK_FORMULA_PARAM1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM_NAME1
 * STANDARD_WORK_FORMULA_PARAM_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY1
 * STANDARD_WORK_QUANTITY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY_UNIT1
 * STANDARD_WORK_QUANTITY_UNIT1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#COST_CTR_ACTIVITY_TYPE1
 * COST_CTR_ACTIVITY_TYPE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM2
 * STANDARD_WORK_FORMULA_PARAM2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM_NAME2
 * STANDARD_WORK_FORMULA_PARAM_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY2
 * STANDARD_WORK_QUANTITY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY_UNIT2
 * STANDARD_WORK_QUANTITY_UNIT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#COST_CTR_ACTIVITY_TYPE2
 * COST_CTR_ACTIVITY_TYPE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM3
 * STANDARD_WORK_FORMULA_PARAM3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM_NAME3
 * STANDARD_WORK_FORMULA_PARAM_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY3
 * STANDARD_WORK_QUANTITY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY_UNIT3
 * STANDARD_WORK_QUANTITY_UNIT3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#COST_CTR_ACTIVITY_TYPE3
 * COST_CTR_ACTIVITY_TYPE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM4
 * STANDARD_WORK_FORMULA_PARAM4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM_NAME4
 * STANDARD_WORK_FORMULA_PARAM_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY4
 * STANDARD_WORK_QUANTITY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY_UNIT4
 * STANDARD_WORK_QUANTITY_UNIT4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#COST_CTR_ACTIVITY_TYPE4
 * COST_CTR_ACTIVITY_TYPE4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM5
 * STANDARD_WORK_FORMULA_PARAM5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM_NAME5
 * STANDARD_WORK_FORMULA_PARAM_NAME5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY5
 * STANDARD_WORK_QUANTITY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY_UNIT5
 * STANDARD_WORK_QUANTITY_UNIT5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#COST_CTR_ACTIVITY_TYPE5
 * COST_CTR_ACTIVITY_TYPE5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM6
 * STANDARD_WORK_FORMULA_PARAM6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_FORMULA_PARAM_NAME6
 * STANDARD_WORK_FORMULA_PARAM_NAME6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY6
 * STANDARD_WORK_QUANTITY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#STANDARD_WORK_QUANTITY_UNIT6
 * STANDARD_WORK_QUANTITY_UNIT6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#COST_CTR_ACTIVITY_TYPE6
 * COST_CTR_ACTIVITY_TYPE6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#NUMBER_OF_TIME_TICKETS
 * NUMBER_OF_TIME_TICKETS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#NUMBER_OF_CONFIRMATION_SLIPS
 * NUMBER_OF_CONFIRMATION_SLIPS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION_COSTING_RELEVANCY_TYPE
 * OPERATION_COSTING_RELEVANCY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#BUSINESS_PROCESS
 * BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION_SETUP_TYPE
 * OPERATION_SETUP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION_SETUP_GROUP_CATEGORY
 * OPERATION_SETUP_GROUP_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OPERATION_SETUP_GROUP
 * OPERATION_SETUP_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#CAPACITY_CATEGORY_CODE
 * CAPACITY_CATEGORY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OP_IS_EXTLY_PROCD_WITH_SUBCONTRG
 * OP_IS_EXTLY_PROCD_WITH_SUBCONTRG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#INSPECTION_LOT_TYPE
 * INSPECTION_LOT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#PURCHASING_INFO_RECORD
 * PURCHASING_INFO_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#PURCHASE_CONTRACT
 * PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#PURCHASE_CONTRACT_ITEM
 * PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#PURCHASING_INFO_RECD_ADDL_GRPG_NAME
 * PURCHASING_INFO_RECD_ADDL_GRPG_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#PLANNED_DELIVERY_DURATION
 * PLANNED_DELIVERY_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#SUPPLIER SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#NUMBER_OF_OPERATION_PRICE_UNITS
 * NUMBER_OF_OPERATION_PRICE_UNITS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#COST_ELEMENT
 * COST_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OP_EXTERNAL_PROCESSING_PRICE
 * OP_EXTERNAL_PROCESSING_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#OP_EXTERNAL_PROCESSING_CURRENCY
 * OP_EXTERNAL_PROCESSING_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#TO_PHSE_COMP_ALLOC
 * TO_PHSE_COMP_ALLOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#TO_PHSE_RELSHP
 * TO_PHSE_RELSHP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase#TO_PHSE_SECDRY_RSCE
 * TO_PHSE_SECDRY_RSCE}</li>
 * </ul>
 *
 */
public interface MasterRecipePhaseSelectable extends EntitySelectable<MasterRecipePhase>
{

}
