/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
 * MasterRecipePhseCompAlloc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.field.MasterRecipePhseCompAllocField
 * MasterRecipePhseCompAllocField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.link.MasterRecipePhseCompAllocLink
 * MasterRecipePhseCompAllocLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#MASTER_RECIPE_GROUP
 * MASTER_RECIPE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#MASTER_RECIPE
 * MASTER_RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#MASTER_RECIPE_OPERATION_INT_ID
 * MASTER_RECIPE_OPERATION_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#MSTR_RCP_OP_BOM_ITEM_INTERNAL_ID
 * MSTR_RCP_OP_BOM_ITEM_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#MSTR_RCP_OP_BOM_ITEM_INT_VERSION
 * MSTR_RCP_OP_BOM_ITEM_INT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#BILL_OF_MATERIAL
 * BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#BILL_OF_MATERIAL_VARIANT
 * BILL_OF_MATERIAL_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#BILL_OF_MATERIAL_ITEM_NODE_NUMBER
 * BILL_OF_MATERIAL_ITEM_NODE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#MATL_COMP_IS_MARKED_FOR_BACKFLUSH
 * MATL_COMP_IS_MARKED_FOR_BACKFLUSH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface MasterRecipePhseCompAllocSelectable extends EntitySelectable<MasterRecipePhseCompAlloc>
{

}
