/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.field.MaterialDocumentHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.link.MaterialDocumentHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.selectable.MaterialDocumentHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_MaterialDocumentHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialDocumentHeader extends VdmEntity<MaterialDocumentHeader>
{

    /**
     * Selector for all available fields of MaterialDocumentHeader.
     *
     */
    public final static MaterialDocumentHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @Key
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> MATERIAL_DOCUMENT_YEAR =
        new MaterialDocumentHeaderField<String>("MaterialDocumentYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Number of Material Document
     */
    @Key
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> MATERIAL_DOCUMENT =
        new MaterialDocumentHeaderField<String>("MaterialDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InventoryTransactionType</b>
     * </p>
     *
     * @return Transaction/Event Type
     */
    @SerializedName( "InventoryTransactionType" )
    @JsonProperty( "InventoryTransactionType" )
    @Nullable
    @ODataField( odataName = "InventoryTransactionType" )
    private String inventoryTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryTransactionType</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> INVENTORY_TRANSACTION_TYPE =
        new MaterialDocumentHeaderField<String>("InventoryTransactionType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Document Date in Document
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<LocalDateTime> DOCUMENT_DATE =
        new MaterialDocumentHeaderField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<LocalDateTime> POSTING_DATE =
        new MaterialDocumentHeaderField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Day On Which Accounting Document Was Entered
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<LocalDateTime> CREATION_DATE =
        new MaterialDocumentHeaderField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Time of Entry
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<LocalTime> CREATION_TIME =
        new MaterialDocumentHeaderField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User Name
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> CREATED_BY_USER =
        new MaterialDocumentHeaderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentHeaderText</b>
     * </p>
     *
     * @return Document Header Text
     */
    @SerializedName( "MaterialDocumentHeaderText" )
    @JsonProperty( "MaterialDocumentHeaderText" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentHeaderText" )
    private String materialDocumentHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentHeaderText</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> MATERIAL_DOCUMENT_HEADER_TEXT =
        new MaterialDocumentHeaderField<String>("MaterialDocumentHeaderText");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> REFERENCE_DOCUMENT =
        new MaterialDocumentHeaderField<String>("ReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VersionForPrintingSlip</b>
     * </p>
     *
     * @return Version for Printing GR/GI Slip
     */
    @SerializedName( "VersionForPrintingSlip" )
    @JsonProperty( "VersionForPrintingSlip" )
    @Nullable
    @ODataField( odataName = "VersionForPrintingSlip" )
    private String versionForPrintingSlip;
    /**
     * Use with available fluent helpers to apply the <b>VersionForPrintingSlip</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> VERSION_FOR_PRINTING_SLIP =
        new MaterialDocumentHeaderField<String>("VersionForPrintingSlip");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ManualPrintIsTriggered</b>
     * </p>
     *
     * @return Print via Output Control
     */
    @SerializedName( "ManualPrintIsTriggered" )
    @JsonProperty( "ManualPrintIsTriggered" )
    @Nullable
    @ODataField( odataName = "ManualPrintIsTriggered" )
    private String manualPrintIsTriggered;
    /**
     * Use with available fluent helpers to apply the <b>ManualPrintIsTriggered</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> MANUAL_PRINT_IS_TRIGGERED =
        new MaterialDocumentHeaderField<String>("ManualPrintIsTriggered");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CtrlPostgForExtWhseMgmtSyst</b>
     * </p>
     *
     * @return Control posting for external WMS
     */
    @SerializedName( "CtrlPostgForExtWhseMgmtSyst" )
    @JsonProperty( "CtrlPostgForExtWhseMgmtSyst" )
    @Nullable
    @ODataField( odataName = "CtrlPostgForExtWhseMgmtSyst" )
    private String ctrlPostgForExtWhseMgmtSyst;
    /**
     * Use with available fluent helpers to apply the <b>CtrlPostgForExtWhseMgmtSyst</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> CTRL_POSTG_FOR_EXT_WHSE_MGMT_SYST =
        new MaterialDocumentHeaderField<String>("CtrlPostgForExtWhseMgmtSyst");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementCode</b>
     * </p>
     *
     * @return Goods Movement Code
     */
    @SerializedName( "GoodsMovementCode" )
    @JsonProperty( "GoodsMovementCode" )
    @Nullable
    @ODataField( odataName = "GoodsMovementCode" )
    private String goodsMovementCode;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementCode</b> field to query operations.
     *
     */
    public final static MaterialDocumentHeaderField<String> GOODS_MOVEMENT_CODE =
        new MaterialDocumentHeaderField<String>("GoodsMovementCode");
    /**
     * Navigation property <b>to_MaterialDocumentItem</b> for <b>MaterialDocumentHeader</b> to multiple
     * <b>MaterialDocumentItem</b>.
     *
     */
    @SerializedName( "to_MaterialDocumentItem" )
    @JsonProperty( "to_MaterialDocumentItem" )
    @ODataField( odataName = "to_MaterialDocumentItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaterialDocumentItem> toMaterialDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>to_MaterialDocumentItem</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialDocumentHeaderLink<MaterialDocumentItem> TO_MATERIAL_DOCUMENT_ITEM =
        new MaterialDocumentHeaderLink<MaterialDocumentItem>("to_MaterialDocumentItem");

    @Nonnull
    @Override
    public Class<MaterialDocumentHeader> getType()
    {
        return MaterialDocumentHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Number of Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InventoryTransactionType</b>
     * </p>
     *
     * @param inventoryTransactionType
     *            Transaction/Event Type
     */
    public void setInventoryTransactionType( @Nullable final String inventoryTransactionType )
    {
        rememberChangedField("InventoryTransactionType", this.inventoryTransactionType);
        this.inventoryTransactionType = inventoryTransactionType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Document Date in Document
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date in the Document
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Day On Which Accounting Document Was Entered
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Time of Entry
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User Name
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentHeaderText</b>
     * </p>
     *
     * @param materialDocumentHeaderText
     *            Document Header Text
     */
    public void setMaterialDocumentHeaderText( @Nullable final String materialDocumentHeaderText )
    {
        rememberChangedField("MaterialDocumentHeaderText", this.materialDocumentHeaderText);
        this.materialDocumentHeaderText = materialDocumentHeaderText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Reference Document Number
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VersionForPrintingSlip</b>
     * </p>
     *
     * @param versionForPrintingSlip
     *            Version for Printing GR/GI Slip
     */
    public void setVersionForPrintingSlip( @Nullable final String versionForPrintingSlip )
    {
        rememberChangedField("VersionForPrintingSlip", this.versionForPrintingSlip);
        this.versionForPrintingSlip = versionForPrintingSlip;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ManualPrintIsTriggered</b>
     * </p>
     *
     * @param manualPrintIsTriggered
     *            Print via Output Control
     */
    public void setManualPrintIsTriggered( @Nullable final String manualPrintIsTriggered )
    {
        rememberChangedField("ManualPrintIsTriggered", this.manualPrintIsTriggered);
        this.manualPrintIsTriggered = manualPrintIsTriggered;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CtrlPostgForExtWhseMgmtSyst</b>
     * </p>
     *
     * @param ctrlPostgForExtWhseMgmtSyst
     *            Control posting for external WMS
     */
    public void setCtrlPostgForExtWhseMgmtSyst( @Nullable final String ctrlPostgForExtWhseMgmtSyst )
    {
        rememberChangedField("CtrlPostgForExtWhseMgmtSyst", this.ctrlPostgForExtWhseMgmtSyst);
        this.ctrlPostgForExtWhseMgmtSyst = ctrlPostgForExtWhseMgmtSyst;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementCode</b>
     * </p>
     *
     * @param goodsMovementCode
     *            Goods Movement Code
     */
    public void setGoodsMovementCode( @Nullable final String goodsMovementCode )
    {
        rememberChangedField("GoodsMovementCode", this.goodsMovementCode);
        this.goodsMovementCode = goodsMovementCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_MaterialDocumentHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaterialDocumentYear", getMaterialDocumentYear());
        result.put("MaterialDocument", getMaterialDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("InventoryTransactionType", getInventoryTransactionType());
        values.put("DocumentDate", getDocumentDate());
        values.put("PostingDate", getPostingDate());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("MaterialDocumentHeaderText", getMaterialDocumentHeaderText());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("VersionForPrintingSlip", getVersionForPrintingSlip());
        values.put("ManualPrintIsTriggered", getManualPrintIsTriggered());
        values.put("CtrlPostgForExtWhseMgmtSyst", getCtrlPostgForExtWhseMgmtSyst());
        values.put("GoodsMovementCode", getGoodsMovementCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("InventoryTransactionType") ) {
                final Object value = values.remove("InventoryTransactionType");
                if( (value == null) || (!value.equals(getInventoryTransactionType())) ) {
                    setInventoryTransactionType(((String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentHeaderText") ) {
                final Object value = values.remove("MaterialDocumentHeaderText");
                if( (value == null) || (!value.equals(getMaterialDocumentHeaderText())) ) {
                    setMaterialDocumentHeaderText(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("VersionForPrintingSlip") ) {
                final Object value = values.remove("VersionForPrintingSlip");
                if( (value == null) || (!value.equals(getVersionForPrintingSlip())) ) {
                    setVersionForPrintingSlip(((String) value));
                }
            }
            if( values.containsKey("ManualPrintIsTriggered") ) {
                final Object value = values.remove("ManualPrintIsTriggered");
                if( (value == null) || (!value.equals(getManualPrintIsTriggered())) ) {
                    setManualPrintIsTriggered(((String) value));
                }
            }
            if( values.containsKey("CtrlPostgForExtWhseMgmtSyst") ) {
                final Object value = values.remove("CtrlPostgForExtWhseMgmtSyst");
                if( (value == null) || (!value.equals(getCtrlPostgForExtWhseMgmtSyst())) ) {
                    setCtrlPostgForExtWhseMgmtSyst(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementCode") ) {
                final Object value = values.remove("GoodsMovementCode");
                if( (value == null) || (!value.equals(getGoodsMovementCode())) ) {
                    setGoodsMovementCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaterialDocumentItem") ) {
                final Object value = (values).remove("to_MaterialDocumentItem");
                if( value instanceof Iterable ) {
                    if( toMaterialDocumentItem == null ) {
                        toMaterialDocumentItem = Lists.newArrayList();
                    } else {
                        toMaterialDocumentItem = Lists.newArrayList(toMaterialDocumentItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaterialDocumentItem entity;
                        if( toMaterialDocumentItem.size() > i ) {
                            entity = toMaterialDocumentItem.get(i);
                        } else {
                            entity = new MaterialDocumentItem();
                            toMaterialDocumentItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaterialDocumentHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialDocumentHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialDocumentHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialDocumentHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaterialDocumentItem != null ) {
            (values).put("to_MaterialDocumentItem", toMaterialDocumentItem);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialDocumentItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaterialDocumentItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaterialDocumentItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialDocumentItem> fetchMaterialDocumentItem()
    {
        return fetchFieldAsList("to_MaterialDocumentItem", MaterialDocumentItem.class);
    }

    /**
     * Retrieval of associated <b>MaterialDocumentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaterialDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_MaterialDocumentItem</b> of a queried <b>MaterialDocumentHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialDocumentItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialDocumentItem> getMaterialDocumentItemOrFetch()
    {
        if( toMaterialDocumentItem == null ) {
            toMaterialDocumentItem = fetchMaterialDocumentItem();
        }
        return toMaterialDocumentItem;
    }

    /**
     * Retrieval of associated <b>MaterialDocumentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaterialDocumentItem</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialDocumentHeader</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaterialDocumentItem</b> is already loaded, the result
     *         will contain the <b>MaterialDocumentItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaterialDocumentItem>> getMaterialDocumentItemIfPresent()
    {
        return Option.of(toMaterialDocumentItem);
    }

    /**
     * Overwrites the list of associated <b>MaterialDocumentItem</b> entities for the loaded navigation property
     * <b>to_MaterialDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_MaterialDocumentItem</b> of a queried <b>MaterialDocumentHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaterialDocumentItem</b> entities.
     */
    public void setMaterialDocumentItem( @Nonnull final List<MaterialDocumentItem> value )
    {
        if( toMaterialDocumentItem == null ) {
            toMaterialDocumentItem = Lists.newArrayList();
        }
        toMaterialDocumentItem.clear();
        toMaterialDocumentItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaterialDocumentItem</b> entities. This corresponds to the OData
     * navigation property <b>to_MaterialDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_MaterialDocumentItem</b> of a queried <b>MaterialDocumentHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaterialDocumentItem</b> entities.
     */
    public void addMaterialDocumentItem( MaterialDocumentItem... entity )
    {
        if( toMaterialDocumentItem == null ) {
            toMaterialDocumentItem = Lists.newArrayList();
        }
        toMaterialDocumentItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaterialDocumentHeader instances.
     *
     */
    public final static class MaterialDocumentHeaderBuilder
    {

        private List<MaterialDocumentItem> toMaterialDocumentItem = Lists.newArrayList();

        private MaterialDocumentHeader.MaterialDocumentHeaderBuilder toMaterialDocumentItem(
            final List<MaterialDocumentItem> value )
        {
            toMaterialDocumentItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaterialDocumentItem</b> for <b>MaterialDocumentHeader</b> to multiple
         * <b>MaterialDocumentItem</b>.
         *
         * @param value
         *            The MaterialDocumentItems to build this MaterialDocumentHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialDocumentHeader.MaterialDocumentHeaderBuilder materialDocumentItem(
            MaterialDocumentItem... value )
        {
            return toMaterialDocumentItem(Lists.newArrayList(value));
        }

    }

}
