/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.field.MaterialDocumentItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.link.MaterialDocumentItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.link.MaterialDocumentItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.selectable.MaterialDocumentItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_MaterialDocumentItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialDocumentItem extends VdmEntity<MaterialDocumentItem>
{

    /**
     * Selector for all available fields of MaterialDocumentItem.
     *
     */
    public final static MaterialDocumentItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @Key
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MATERIAL_DOCUMENT_YEAR =
        new MaterialDocumentItemField<String>("MaterialDocumentYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Number of Material Document
     */
    @Key
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MATERIAL_DOCUMENT =
        new MaterialDocumentItemField<String>("MaterialDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @return Material Document Item
     */
    @Key
    @SerializedName( "MaterialDocumentItem" )
    @JsonProperty( "MaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItem" )
    private String materialDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItem</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MATERIAL_DOCUMENT_ITEM =
        new MaterialDocumentItemField<String>("MaterialDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MATERIAL = new MaterialDocumentItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> PLANT = new MaterialDocumentItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> STORAGE_LOCATION =
        new MaterialDocumentItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> BATCH = new MaterialDocumentItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Movement Type (Inventory Management)
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> GOODS_MOVEMENT_TYPE =
        new MaterialDocumentItemField<String>("GoodsMovementType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InventoryStockType</b>
     * </p>
     *
     * @return Stock Type of Goods Movement (Stock Identifier)
     */
    @SerializedName( "InventoryStockType" )
    @JsonProperty( "InventoryStockType" )
    @Nullable
    @ODataField( odataName = "InventoryStockType" )
    private String inventoryStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryStockType</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> INVENTORY_STOCK_TYPE =
        new MaterialDocumentItemField<String>("InventoryStockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @SerializedName( "InventoryValuationType" )
    @JsonProperty( "InventoryValuationType" )
    @Nullable
    @ODataField( odataName = "InventoryValuationType" )
    private String inventoryValuationType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryValuationType</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> INVENTORY_VALUATION_TYPE =
        new MaterialDocumentItemField<String>("InventoryValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @return Special Stock Type
     */
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> INVENTORY_SPECIAL_STOCK_TYPE =
        new MaterialDocumentItemField<String>("InventorySpecialStockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> SUPPLIER = new MaterialDocumentItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Account number of customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> CUSTOMER = new MaterialDocumentItemField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> SALES_ORDER =
        new MaterialDocumentItemField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> SALES_ORDER_ITEM =
        new MaterialDocumentItemField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @return Sales Order Schedule
     */
    @SerializedName( "SalesOrderScheduleLine" )
    @JsonProperty( "SalesOrderScheduleLine" )
    @Nullable
    @ODataField( odataName = "SalesOrderScheduleLine" )
    private String salesOrderScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderScheduleLine</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> SALES_ORDER_SCHEDULE_LINE =
        new MaterialDocumentItemField<String>("SalesOrderScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchase Order Number
     */
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> PURCHASE_ORDER =
        new MaterialDocumentItemField<String>("PurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> PURCHASE_ORDER_ITEM =
        new MaterialDocumentItemField<String>("PurchaseOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> WBS_ELEMENT =
        new MaterialDocumentItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Manufacturing Order
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MANUFACTURING_ORDER =
        new MaterialDocumentItemField<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderItem</b>
     * </p>
     *
     * @return Manufacturing Order Item
     */
    @SerializedName( "ManufacturingOrderItem" )
    @JsonProperty( "ManufacturingOrderItem" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderItem" )
    private String manufacturingOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderItem</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MANUFACTURING_ORDER_ITEM =
        new MaterialDocumentItemField<String>("ManufacturingOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementRefDocType</b>
     * </p>
     *
     * @return Goods movement ref doc type
     */
    @SerializedName( "GoodsMovementRefDocType" )
    @JsonProperty( "GoodsMovementRefDocType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementRefDocType" )
    private String goodsMovementRefDocType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementRefDocType</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> GOODS_MOVEMENT_REF_DOC_TYPE =
        new MaterialDocumentItemField<String>("GoodsMovementRefDocType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementReasonCode</b>
     * </p>
     *
     * @return Reason for Movement
     */
    @SerializedName( "GoodsMovementReasonCode" )
    @JsonProperty( "GoodsMovementReasonCode" )
    @Nullable
    @ODataField( odataName = "GoodsMovementReasonCode" )
    private String goodsMovementReasonCode;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementReasonCode</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> GOODS_MOVEMENT_REASON_CODE =
        new MaterialDocumentItemField<String>("GoodsMovementReasonCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Delivery</b>
     * </p>
     *
     * @return Delivery
     */
    @SerializedName( "Delivery" )
    @JsonProperty( "Delivery" )
    @Nullable
    @ODataField( odataName = "Delivery" )
    private String delivery;
    /**
     * Use with available fluent helpers to apply the <b>Delivery</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> DELIVERY = new MaterialDocumentItemField<String>("Delivery");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItem</b>
     * </p>
     *
     * @return Delivery Item
     */
    @SerializedName( "DeliveryItem" )
    @JsonProperty( "DeliveryItem" )
    @Nullable
    @ODataField( odataName = "DeliveryItem" )
    private String deliveryItem;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryItem</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> DELIVERY_ITEM =
        new MaterialDocumentItemField<String>("DeliveryItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @return Account Assignment Category
     */
    @SerializedName( "AccountAssignmentCategory" )
    @JsonProperty( "AccountAssignmentCategory" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentCategory" )
    private String accountAssignmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentCategory</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> ACCOUNT_ASSIGNMENT_CATEGORY =
        new MaterialDocumentItemField<String>("AccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> COST_CENTER =
        new MaterialDocumentItemField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> CONTROLLING_AREA =
        new MaterialDocumentItemField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> COST_OBJECT =
        new MaterialDocumentItemField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> GL_ACCOUNT =
        new MaterialDocumentItemField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> FUNCTIONAL_AREA =
        new MaterialDocumentItemField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @return Profitability Segment
     */
    @SerializedName( "ProfitabilitySegment" )
    @JsonProperty( "ProfitabilitySegment" )
    @Nullable
    @ODataField( odataName = "ProfitabilitySegment" )
    private String profitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>ProfitabilitySegment</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> PROFITABILITY_SEGMENT =
        new MaterialDocumentItemField<String>("ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> PROFIT_CENTER =
        new MaterialDocumentItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MASTER_FIXED_ASSET =
        new MaterialDocumentItemField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> FIXED_ASSET =
        new MaterialDocumentItemField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "MaterialBaseUnit" )
    @JsonProperty( "MaterialBaseUnit" )
    @Nullable
    @ODataField( odataName = "MaterialBaseUnit" )
    private String materialBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseUnit</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MATERIAL_BASE_UNIT =
        new MaterialDocumentItemField<String>("MaterialBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "QuantityInBaseUnit" )
    @JsonProperty( "QuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInBaseUnit" )
    private BigDecimal quantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<BigDecimal> QUANTITY_IN_BASE_UNIT =
        new MaterialDocumentItemField<BigDecimal>("QuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "EntryUnit" )
    @JsonProperty( "EntryUnit" )
    @Nullable
    @ODataField( odataName = "EntryUnit" )
    private String entryUnit;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnit</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> ENTRY_UNIT =
        new MaterialDocumentItemField<String>("EntryUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @return Quantity in unit of entry
     */
    @SerializedName( "QuantityInEntryUnit" )
    @JsonProperty( "QuantityInEntryUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInEntryUnit" )
    private BigDecimal quantityInEntryUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInEntryUnit</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<BigDecimal> QUANTITY_IN_ENTRY_UNIT =
        new MaterialDocumentItemField<BigDecimal>("QuantityInEntryUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> COMPANY_CODE_CURRENCY =
        new MaterialDocumentItemField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GdsMvtExtAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Externally Entered Posting Amount in Local Currency
     */
    @SerializedName( "GdsMvtExtAmtInCoCodeCrcy" )
    @JsonProperty( "GdsMvtExtAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "GdsMvtExtAmtInCoCodeCrcy" )
    private BigDecimal gdsMvtExtAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>GdsMvtExtAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<BigDecimal> GDS_MVT_EXT_AMT_IN_CO_CODE_CRCY =
        new MaterialDocumentItemField<BigDecimal>("GdsMvtExtAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SlsPrcAmtInclVATInCoCodeCrcy</b>
     * </p>
     *
     * @return Value at Sales Prices Including Value-Added Tax
     */
    @SerializedName( "SlsPrcAmtInclVATInCoCodeCrcy" )
    @JsonProperty( "SlsPrcAmtInclVATInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "SlsPrcAmtInclVATInCoCodeCrcy" )
    private BigDecimal slsPrcAmtInclVATInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>SlsPrcAmtInclVATInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<BigDecimal> SLS_PRC_AMT_INCL_VAT_IN_CO_CODE_CRCY =
        new MaterialDocumentItemField<BigDecimal>("SlsPrcAmtInclVATInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> FISCAL_YEAR =
        new MaterialDocumentItemField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @return Period Year
     */
    @SerializedName( "FiscalYearPeriod" )
    @JsonProperty( "FiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearPeriod" )
    private String fiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearPeriod</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> FISCAL_YEAR_PERIOD =
        new MaterialDocumentItemField<String>("FiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> FISCAL_YEAR_VARIANT =
        new MaterialDocumentItemField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgMaterial</b>
     * </p>
     *
     * @return Transfer Material
     */
    @SerializedName( "IssgOrRcvgMaterial" )
    @JsonProperty( "IssgOrRcvgMaterial" )
    @Nullable
    @ODataField( odataName = "IssgOrRcvgMaterial" )
    private String issgOrRcvgMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IssgOrRcvgMaterial</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> ISSG_OR_RCVG_MATERIAL =
        new MaterialDocumentItemField<String>("IssgOrRcvgMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgBatch</b>
     * </p>
     *
     * @return Transfer Batch
     */
    @SerializedName( "IssgOrRcvgBatch" )
    @JsonProperty( "IssgOrRcvgBatch" )
    @Nullable
    @ODataField( odataName = "IssgOrRcvgBatch" )
    private String issgOrRcvgBatch;
    /**
     * Use with available fluent helpers to apply the <b>IssgOrRcvgBatch</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> ISSG_OR_RCVG_BATCH =
        new MaterialDocumentItemField<String>("IssgOrRcvgBatch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingPlant</b>
     * </p>
     *
     * @return Receiving/Issuing Plant
     */
    @SerializedName( "IssuingOrReceivingPlant" )
    @JsonProperty( "IssuingOrReceivingPlant" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingPlant" )
    private String issuingOrReceivingPlant;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingPlant</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> ISSUING_OR_RECEIVING_PLANT =
        new MaterialDocumentItemField<String>("IssuingOrReceivingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStorageLoc</b>
     * </p>
     *
     * @return Receiving/issuing storage location
     */
    @SerializedName( "IssuingOrReceivingStorageLoc" )
    @JsonProperty( "IssuingOrReceivingStorageLoc" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingStorageLoc" )
    private String issuingOrReceivingStorageLoc;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingStorageLoc</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> ISSUING_OR_RECEIVING_STORAGE_LOC =
        new MaterialDocumentItemField<String>("IssuingOrReceivingStorageLoc");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStockType</b>
     * </p>
     *
     * @return Transfer Stock Type
     */
    @SerializedName( "IssuingOrReceivingStockType" )
    @JsonProperty( "IssuingOrReceivingStockType" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingStockType" )
    private String issuingOrReceivingStockType;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingStockType</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> ISSUING_OR_RECEIVING_STOCK_TYPE =
        new MaterialDocumentItemField<String>("IssuingOrReceivingStockType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgSpclStockInd</b>
     * </p>
     *
     * @return Transfer Special Stock Type
     */
    @SerializedName( "IssgOrRcvgSpclStockInd" )
    @JsonProperty( "IssgOrRcvgSpclStockInd" )
    @Nullable
    @ODataField( odataName = "IssgOrRcvgSpclStockInd" )
    private String issgOrRcvgSpclStockInd;
    /**
     * Use with available fluent helpers to apply the <b>IssgOrRcvgSpclStockInd</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> ISSG_OR_RCVG_SPCL_STOCK_IND =
        new MaterialDocumentItemField<String>("IssgOrRcvgSpclStockInd");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingValType</b>
     * </p>
     *
     * @return Valuation Type of Transfer Batch
     */
    @SerializedName( "IssuingOrReceivingValType" )
    @JsonProperty( "IssuingOrReceivingValType" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingValType" )
    private String issuingOrReceivingValType;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingValType</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> ISSUING_OR_RECEIVING_VAL_TYPE =
        new MaterialDocumentItemField<String>("IssuingOrReceivingValType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @return "Delivery Completed" Indicator
     */
    @SerializedName( "IsCompletelyDelivered" )
    @JsonProperty( "IsCompletelyDelivered" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCompletelyDelivered" )
    private Boolean isCompletelyDelivered;
    /**
     * Use with available fluent helpers to apply the <b>IsCompletelyDelivered</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<Boolean> IS_COMPLETELY_DELIVERED =
        new MaterialDocumentItemField<Boolean>("IsCompletelyDelivered");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "MaterialDocumentItemText" )
    @JsonProperty( "MaterialDocumentItemText" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItemText" )
    private String materialDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItemText</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MATERIAL_DOCUMENT_ITEM_TEXT =
        new MaterialDocumentItemField<String>("MaterialDocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> UNLOADING_POINT_NAME =
        new MaterialDocumentItemField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @return Shelf Life Expiration or Best-Before Date
     */
    @SerializedName( "ShelfLifeExpirationDate" )
    @JsonProperty( "ShelfLifeExpirationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShelfLifeExpirationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shelfLifeExpirationDate;
    /**
     * Use with available fluent helpers to apply the <b>ShelfLifeExpirationDate</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<LocalDateTime> SHELF_LIFE_EXPIRATION_DATE =
        new MaterialDocumentItemField<LocalDateTime>("ShelfLifeExpirationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @return Date of Manufacture
     */
    @SerializedName( "ManufactureDate" )
    @JsonProperty( "ManufactureDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ManufactureDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime manufactureDate;
    /**
     * Use with available fluent helpers to apply the <b>ManufactureDate</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<LocalDateTime> MANUFACTURE_DATE =
        new MaterialDocumentItemField<LocalDateTime>("ManufactureDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumbersAreCreatedAutomly</b>
     * </p>
     *
     * @return Create serial number automatically
     */
    @SerializedName( "SerialNumbersAreCreatedAutomly" )
    @JsonProperty( "SerialNumbersAreCreatedAutomly" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SerialNumbersAreCreatedAutomly" )
    private Boolean serialNumbersAreCreatedAutomly;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumbersAreCreatedAutomly</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<Boolean> SERIAL_NUMBERS_ARE_CREATED_AUTOMLY =
        new MaterialDocumentItemField<Boolean>("SerialNumbersAreCreatedAutomly");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> RESERVATION =
        new MaterialDocumentItemField<String>("Reservation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Item Number of Reservation / Dependent Requirements
     */
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> RESERVATION_ITEM =
        new MaterialDocumentItemField<String>("ReservationItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @return Final Issue for Reservation
     */
    @SerializedName( "ReservationIsFinallyIssued" )
    @JsonProperty( "ReservationIsFinallyIssued" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReservationIsFinallyIssued" )
    private Boolean reservationIsFinallyIssued;
    /**
     * Use with available fluent helpers to apply the <b>ReservationIsFinallyIssued</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<Boolean> RESERVATION_IS_FINALLY_ISSUED =
        new MaterialDocumentItemField<Boolean>("ReservationIsFinallyIssued");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrder</b>
     * </p>
     *
     * @return Sales order number of valuated sales order stock
     */
    @SerializedName( "SpecialStockIdfgSalesOrder" )
    @JsonProperty( "SpecialStockIdfgSalesOrder" )
    @Nullable
    @ODataField( odataName = "SpecialStockIdfgSalesOrder" )
    private String specialStockIdfgSalesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SpecialStockIdfgSalesOrder</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> SPECIAL_STOCK_IDFG_SALES_ORDER =
        new MaterialDocumentItemField<String>("SpecialStockIdfgSalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item of Valuated Sales Order Stock
     */
    @SerializedName( "SpecialStockIdfgSalesOrderItem" )
    @JsonProperty( "SpecialStockIdfgSalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SpecialStockIdfgSalesOrderItem" )
    private String specialStockIdfgSalesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SpecialStockIdfgSalesOrderItem</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM =
        new MaterialDocumentItemField<String>("SpecialStockIdfgSalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgWBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "SpecialStockIdfgWBSElement" )
    @JsonProperty( "SpecialStockIdfgWBSElement" )
    @Nullable
    @ODataField( odataName = "SpecialStockIdfgWBSElement" )
    private String specialStockIdfgWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>SpecialStockIdfgWBSElement</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> SPECIAL_STOCK_IDFG_WBS_ELEMENT =
        new MaterialDocumentItemField<String>("SpecialStockIdfgWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsAutomaticallyCreated</b>
     * </p>
     *
     * @return Item Automatically Created Indicator
     */
    @SerializedName( "IsAutomaticallyCreated" )
    @JsonProperty( "IsAutomaticallyCreated" )
    @Nullable
    @ODataField( odataName = "IsAutomaticallyCreated" )
    private String isAutomaticallyCreated;
    /**
     * Use with available fluent helpers to apply the <b>IsAutomaticallyCreated</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> IS_AUTOMATICALLY_CREATED =
        new MaterialDocumentItemField<String>("IsAutomaticallyCreated");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentLine</b>
     * </p>
     *
     * @return Unique Identification of Document Line
     */
    @SerializedName( "MaterialDocumentLine" )
    @JsonProperty( "MaterialDocumentLine" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentLine" )
    private String materialDocumentLine;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentLine</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MATERIAL_DOCUMENT_LINE =
        new MaterialDocumentItemField<String>("MaterialDocumentLine");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentParentLine</b>
     * </p>
     *
     * @return Identifier of immediately superior line
     */
    @SerializedName( "MaterialDocumentParentLine" )
    @JsonProperty( "MaterialDocumentParentLine" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentParentLine" )
    private String materialDocumentParentLine;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentParentLine</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MATERIAL_DOCUMENT_PARENT_LINE =
        new MaterialDocumentItemField<String>("MaterialDocumentParentLine");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy level of line in document
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> HIERARCHY_NODE_LEVEL =
        new MaterialDocumentItemField<String>("HierarchyNodeLevel");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementIsCancelled</b>
     * </p>
     *
     * @return Item has been Cancelled
     */
    @SerializedName( "GoodsMovementIsCancelled" )
    @JsonProperty( "GoodsMovementIsCancelled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsMovementIsCancelled" )
    private Boolean goodsMovementIsCancelled;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementIsCancelled</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<Boolean> GOODS_MOVEMENT_IS_CANCELLED =
        new MaterialDocumentItemField<Boolean>("GoodsMovementIsCancelled");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReversedMaterialDocumentYear</b>
     * </p>
     *
     * @return Reversed Material Document Year
     */
    @SerializedName( "ReversedMaterialDocumentYear" )
    @JsonProperty( "ReversedMaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "ReversedMaterialDocumentYear" )
    private String reversedMaterialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>ReversedMaterialDocumentYear</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> REVERSED_MATERIAL_DOCUMENT_YEAR =
        new MaterialDocumentItemField<String>("ReversedMaterialDocumentYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversedMaterialDocument</b>
     * </p>
     *
     * @return Reversed Material Document
     */
    @SerializedName( "ReversedMaterialDocument" )
    @JsonProperty( "ReversedMaterialDocument" )
    @Nullable
    @ODataField( odataName = "ReversedMaterialDocument" )
    private String reversedMaterialDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReversedMaterialDocument</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> REVERSED_MATERIAL_DOCUMENT =
        new MaterialDocumentItemField<String>("ReversedMaterialDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReversedMaterialDocumentItem</b>
     * </p>
     *
     * @return Reversed Material Document Item
     */
    @SerializedName( "ReversedMaterialDocumentItem" )
    @JsonProperty( "ReversedMaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReversedMaterialDocumentItem" )
    private String reversedMaterialDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReversedMaterialDocumentItem</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> REVERSED_MATERIAL_DOCUMENT_ITEM =
        new MaterialDocumentItemField<String>("ReversedMaterialDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of a Reference Document
     */
    @SerializedName( "ReferenceDocumentFiscalYear" )
    @JsonProperty( "ReferenceDocumentFiscalYear" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentFiscalYear" )
    private String referenceDocumentFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentFiscalYear</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> REFERENCE_DOCUMENT_FISCAL_YEAR =
        new MaterialDocumentItemField<String>("ReferenceDocumentFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InvtryMgmtRefDocumentItem</b>
     * </p>
     *
     * @return Item of a Reference Document
     */
    @SerializedName( "InvtryMgmtRefDocumentItem" )
    @JsonProperty( "InvtryMgmtRefDocumentItem" )
    @Nullable
    @ODataField( odataName = "InvtryMgmtRefDocumentItem" )
    private String invtryMgmtRefDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>InvtryMgmtRefDocumentItem</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> INVTRY_MGMT_REF_DOCUMENT_ITEM =
        new MaterialDocumentItemField<String>("InvtryMgmtRefDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvtryMgmtReferenceDocument</b>
     * </p>
     *
     * @return Document No. of a Reference Document
     */
    @SerializedName( "InvtryMgmtReferenceDocument" )
    @JsonProperty( "InvtryMgmtReferenceDocument" )
    @Nullable
    @ODataField( odataName = "InvtryMgmtReferenceDocument" )
    private String invtryMgmtReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>InvtryMgmtReferenceDocument</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> INVTRY_MGMT_REFERENCE_DOCUMENT =
        new MaterialDocumentItemField<String>("InvtryMgmtReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentPostingType</b>
     * </p>
     *
     * @return Reversal, return delivery, or transfer posting
     */
    @SerializedName( "MaterialDocumentPostingType" )
    @JsonProperty( "MaterialDocumentPostingType" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentPostingType" )
    private String materialDocumentPostingType;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentPostingType</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> MATERIAL_DOCUMENT_POSTING_TYPE =
        new MaterialDocumentItemField<String>("MaterialDocumentPostingType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @return Posting Control Stock Type
     */
    @SerializedName( "InventoryUsabilityCode" )
    @JsonProperty( "InventoryUsabilityCode" )
    @Nullable
    @ODataField( odataName = "InventoryUsabilityCode" )
    private String inventoryUsabilityCode;
    /**
     * Use with available fluent helpers to apply the <b>InventoryUsabilityCode</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> INVENTORY_USABILITY_CODE =
        new MaterialDocumentItemField<String>("InventoryUsabilityCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EWMWarehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @SerializedName( "EWMWarehouse" )
    @JsonProperty( "EWMWarehouse" )
    @Nullable
    @ODataField( odataName = "EWMWarehouse" )
    private String eWMWarehouse;
    /**
     * Use with available fluent helpers to apply the <b>EWMWarehouse</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> EWM_WAREHOUSE =
        new MaterialDocumentItemField<String>("EWMWarehouse");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "EWMStorageBin" )
    @JsonProperty( "EWMStorageBin" )
    @Nullable
    @ODataField( odataName = "EWMStorageBin" )
    private String eWMStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBin</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> EWM_STORAGE_BIN =
        new MaterialDocumentItemField<String>("EWMStorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Indicator
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static MaterialDocumentItemField<String> DEBIT_CREDIT_CODE =
        new MaterialDocumentItemField<String>("DebitCreditCode");
    /**
     * Navigation property <b>to_MaterialDocumentHeader</b> for <b>MaterialDocumentItem</b> to single
     * <b>MaterialDocumentHeader</b>.
     *
     */
    @SerializedName( "to_MaterialDocumentHeader" )
    @JsonProperty( "to_MaterialDocumentHeader" )
    @ODataField( odataName = "to_MaterialDocumentHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaterialDocumentHeader toMaterialDocumentHeader;
    /**
     * Navigation property <b>to_SerialNumbers</b> for <b>MaterialDocumentItem</b> to multiple
     * <b>SerialNumberMaterialDocument</b>.
     *
     */
    @SerializedName( "to_SerialNumbers" )
    @JsonProperty( "to_SerialNumbers" )
    @ODataField( odataName = "to_SerialNumbers" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SerialNumberMaterialDocument> toSerialNumbers;
    /**
     * Use with available fluent helpers to apply the <b>to_MaterialDocumentHeader</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialDocumentItemOneToOneLink<MaterialDocumentHeader> TO_MATERIAL_DOCUMENT_HEADER =
        new MaterialDocumentItemOneToOneLink<MaterialDocumentHeader>("to_MaterialDocumentHeader");
    /**
     * Use with available fluent helpers to apply the <b>to_SerialNumbers</b> navigation property to query operations.
     *
     */
    public final static MaterialDocumentItemLink<SerialNumberMaterialDocument> TO_SERIAL_NUMBERS =
        new MaterialDocumentItemLink<SerialNumberMaterialDocument>("to_SerialNumbers");

    @Nonnull
    @Override
    public Class<MaterialDocumentItem> getType()
    {
        return MaterialDocumentItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Number of Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *            Material Document Item
     */
    public void setMaterialDocumentItem( @Nullable final String materialDocumentItem )
    {
        rememberChangedField("MaterialDocumentItem", this.materialDocumentItem);
        this.materialDocumentItem = materialDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Movement Type (Inventory Management)
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InventoryStockType</b>
     * </p>
     *
     * @param inventoryStockType
     *            Stock Type of Goods Movement (Stock Identifier)
     */
    public void setInventoryStockType( @Nullable final String inventoryStockType )
    {
        rememberChangedField("InventoryStockType", this.inventoryStockType);
        this.inventoryStockType = inventoryStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @param inventoryValuationType
     *            Valuation Type
     */
    public void setInventoryValuationType( @Nullable final String inventoryValuationType )
    {
        rememberChangedField("InventoryValuationType", this.inventoryValuationType);
        this.inventoryValuationType = inventoryValuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Special Stock Type
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Account number of customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @param salesOrderScheduleLine
     *            Sales Order Schedule
     */
    public void setSalesOrderScheduleLine( @Nullable final String salesOrderScheduleLine )
    {
        rememberChangedField("SalesOrderScheduleLine", this.salesOrderScheduleLine);
        this.salesOrderScheduleLine = salesOrderScheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchase Order Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Manufacturing Order
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderItem</b>
     * </p>
     *
     * @param manufacturingOrderItem
     *            Manufacturing Order Item
     */
    public void setManufacturingOrderItem( @Nullable final String manufacturingOrderItem )
    {
        rememberChangedField("ManufacturingOrderItem", this.manufacturingOrderItem);
        this.manufacturingOrderItem = manufacturingOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementRefDocType</b>
     * </p>
     *
     * @param goodsMovementRefDocType
     *            Goods movement ref doc type
     */
    public void setGoodsMovementRefDocType( @Nullable final String goodsMovementRefDocType )
    {
        rememberChangedField("GoodsMovementRefDocType", this.goodsMovementRefDocType);
        this.goodsMovementRefDocType = goodsMovementRefDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementReasonCode</b>
     * </p>
     *
     * @param goodsMovementReasonCode
     *            Reason for Movement
     */
    public void setGoodsMovementReasonCode( @Nullable final String goodsMovementReasonCode )
    {
        rememberChangedField("GoodsMovementReasonCode", this.goodsMovementReasonCode);
        this.goodsMovementReasonCode = goodsMovementReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Delivery</b>
     * </p>
     *
     * @param delivery
     *            Delivery
     */
    public void setDelivery( @Nullable final String delivery )
    {
        rememberChangedField("Delivery", this.delivery);
        this.delivery = delivery;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItem</b>
     * </p>
     *
     * @param deliveryItem
     *            Delivery Item
     */
    public void setDeliveryItem( @Nullable final String deliveryItem )
    {
        rememberChangedField("DeliveryItem", this.deliveryItem);
        this.deliveryItem = deliveryItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @param accountAssignmentCategory
     *            Account Assignment Category
     */
    public void setAccountAssignmentCategory( @Nullable final String accountAssignmentCategory )
    {
        rememberChangedField("AccountAssignmentCategory", this.accountAssignmentCategory);
        this.accountAssignmentCategory = accountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @param profitabilitySegment
     *            Profitability Segment
     */
    public void setProfitabilitySegment( @Nullable final String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Main Asset Number
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @param materialBaseUnit
     *            Base Unit of Measure
     */
    public void setMaterialBaseUnit( @Nullable final String materialBaseUnit )
    {
        rememberChangedField("MaterialBaseUnit", this.materialBaseUnit);
        this.materialBaseUnit = materialBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @param quantityInBaseUnit
     *            Quantity
     */
    public void setQuantityInBaseUnit( @Nullable final BigDecimal quantityInBaseUnit )
    {
        rememberChangedField("QuantityInBaseUnit", this.quantityInBaseUnit);
        this.quantityInBaseUnit = quantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @param entryUnit
     *            Unit of entry
     */
    public void setEntryUnit( @Nullable final String entryUnit )
    {
        rememberChangedField("EntryUnit", this.entryUnit);
        this.entryUnit = entryUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @param quantityInEntryUnit
     *            Quantity in unit of entry
     */
    public void setQuantityInEntryUnit( @Nullable final BigDecimal quantityInEntryUnit )
    {
        rememberChangedField("QuantityInEntryUnit", this.quantityInEntryUnit);
        this.quantityInEntryUnit = quantityInEntryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GdsMvtExtAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param gdsMvtExtAmtInCoCodeCrcy
     *            Externally Entered Posting Amount in Local Currency
     */
    public void setGdsMvtExtAmtInCoCodeCrcy( @Nullable final BigDecimal gdsMvtExtAmtInCoCodeCrcy )
    {
        rememberChangedField("GdsMvtExtAmtInCoCodeCrcy", this.gdsMvtExtAmtInCoCodeCrcy);
        this.gdsMvtExtAmtInCoCodeCrcy = gdsMvtExtAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SlsPrcAmtInclVATInCoCodeCrcy</b>
     * </p>
     *
     * @param slsPrcAmtInclVATInCoCodeCrcy
     *            Value at Sales Prices Including Value-Added Tax
     */
    public void setSlsPrcAmtInclVATInCoCodeCrcy( @Nullable final BigDecimal slsPrcAmtInclVATInCoCodeCrcy )
    {
        rememberChangedField("SlsPrcAmtInclVATInCoCodeCrcy", this.slsPrcAmtInclVATInCoCodeCrcy);
        this.slsPrcAmtInclVATInCoCodeCrcy = slsPrcAmtInclVATInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @param fiscalYearPeriod
     *            Period Year
     */
    public void setFiscalYearPeriod( @Nullable final String fiscalYearPeriod )
    {
        rememberChangedField("FiscalYearPeriod", this.fiscalYearPeriod);
        this.fiscalYearPeriod = fiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgMaterial</b>
     * </p>
     *
     * @param issgOrRcvgMaterial
     *            Transfer Material
     */
    public void setIssgOrRcvgMaterial( @Nullable final String issgOrRcvgMaterial )
    {
        rememberChangedField("IssgOrRcvgMaterial", this.issgOrRcvgMaterial);
        this.issgOrRcvgMaterial = issgOrRcvgMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgBatch</b>
     * </p>
     *
     * @param issgOrRcvgBatch
     *            Transfer Batch
     */
    public void setIssgOrRcvgBatch( @Nullable final String issgOrRcvgBatch )
    {
        rememberChangedField("IssgOrRcvgBatch", this.issgOrRcvgBatch);
        this.issgOrRcvgBatch = issgOrRcvgBatch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingPlant</b>
     * </p>
     *
     * @param issuingOrReceivingPlant
     *            Receiving/Issuing Plant
     */
    public void setIssuingOrReceivingPlant( @Nullable final String issuingOrReceivingPlant )
    {
        rememberChangedField("IssuingOrReceivingPlant", this.issuingOrReceivingPlant);
        this.issuingOrReceivingPlant = issuingOrReceivingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStorageLoc</b>
     * </p>
     *
     * @param issuingOrReceivingStorageLoc
     *            Receiving/issuing storage location
     */
    public void setIssuingOrReceivingStorageLoc( @Nullable final String issuingOrReceivingStorageLoc )
    {
        rememberChangedField("IssuingOrReceivingStorageLoc", this.issuingOrReceivingStorageLoc);
        this.issuingOrReceivingStorageLoc = issuingOrReceivingStorageLoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStockType</b>
     * </p>
     *
     * @param issuingOrReceivingStockType
     *            Transfer Stock Type
     */
    public void setIssuingOrReceivingStockType( @Nullable final String issuingOrReceivingStockType )
    {
        rememberChangedField("IssuingOrReceivingStockType", this.issuingOrReceivingStockType);
        this.issuingOrReceivingStockType = issuingOrReceivingStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IssgOrRcvgSpclStockInd</b>
     * </p>
     *
     * @param issgOrRcvgSpclStockInd
     *            Transfer Special Stock Type
     */
    public void setIssgOrRcvgSpclStockInd( @Nullable final String issgOrRcvgSpclStockInd )
    {
        rememberChangedField("IssgOrRcvgSpclStockInd", this.issgOrRcvgSpclStockInd);
        this.issgOrRcvgSpclStockInd = issgOrRcvgSpclStockInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingValType</b>
     * </p>
     *
     * @param issuingOrReceivingValType
     *            Valuation Type of Transfer Batch
     */
    public void setIssuingOrReceivingValType( @Nullable final String issuingOrReceivingValType )
    {
        rememberChangedField("IssuingOrReceivingValType", this.issuingOrReceivingValType);
        this.issuingOrReceivingValType = issuingOrReceivingValType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @param isCompletelyDelivered
     *            "Delivery Completed" Indicator
     */
    public void setIsCompletelyDelivered( @Nullable final Boolean isCompletelyDelivered )
    {
        rememberChangedField("IsCompletelyDelivered", this.isCompletelyDelivered);
        this.isCompletelyDelivered = isCompletelyDelivered;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItemText</b>
     * </p>
     *
     * @param materialDocumentItemText
     *            Item Text
     */
    public void setMaterialDocumentItemText( @Nullable final String materialDocumentItemText )
    {
        rememberChangedField("MaterialDocumentItemText", this.materialDocumentItemText);
        this.materialDocumentItemText = materialDocumentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @param shelfLifeExpirationDate
     *            Shelf Life Expiration or Best-Before Date
     */
    public void setShelfLifeExpirationDate( @Nullable final LocalDateTime shelfLifeExpirationDate )
    {
        rememberChangedField("ShelfLifeExpirationDate", this.shelfLifeExpirationDate);
        this.shelfLifeExpirationDate = shelfLifeExpirationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ManufactureDate</b>
     * </p>
     *
     * @param manufactureDate
     *            Date of Manufacture
     */
    public void setManufactureDate( @Nullable final LocalDateTime manufactureDate )
    {
        rememberChangedField("ManufactureDate", this.manufactureDate);
        this.manufactureDate = manufactureDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumbersAreCreatedAutomly</b>
     * </p>
     *
     * @param serialNumbersAreCreatedAutomly
     *            Create serial number automatically
     */
    public void setSerialNumbersAreCreatedAutomly( @Nullable final Boolean serialNumbersAreCreatedAutomly )
    {
        rememberChangedField("SerialNumbersAreCreatedAutomly", this.serialNumbersAreCreatedAutomly);
        this.serialNumbersAreCreatedAutomly = serialNumbersAreCreatedAutomly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Item Number of Reservation / Dependent Requirements
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @param reservationIsFinallyIssued
     *            Final Issue for Reservation
     */
    public void setReservationIsFinallyIssued( @Nullable final Boolean reservationIsFinallyIssued )
    {
        rememberChangedField("ReservationIsFinallyIssued", this.reservationIsFinallyIssued);
        this.reservationIsFinallyIssued = reservationIsFinallyIssued;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrder</b>
     * </p>
     *
     * @param specialStockIdfgSalesOrder
     *            Sales order number of valuated sales order stock
     */
    public void setSpecialStockIdfgSalesOrder( @Nullable final String specialStockIdfgSalesOrder )
    {
        rememberChangedField("SpecialStockIdfgSalesOrder", this.specialStockIdfgSalesOrder);
        this.specialStockIdfgSalesOrder = specialStockIdfgSalesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrderItem</b>
     * </p>
     *
     * @param specialStockIdfgSalesOrderItem
     *            Sales Order Item of Valuated Sales Order Stock
     */
    public void setSpecialStockIdfgSalesOrderItem( @Nullable final String specialStockIdfgSalesOrderItem )
    {
        rememberChangedField("SpecialStockIdfgSalesOrderItem", this.specialStockIdfgSalesOrderItem);
        this.specialStockIdfgSalesOrderItem = specialStockIdfgSalesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgWBSElement</b>
     * </p>
     *
     * @param specialStockIdfgWBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setSpecialStockIdfgWBSElement( @Nullable final String specialStockIdfgWBSElement )
    {
        rememberChangedField("SpecialStockIdfgWBSElement", this.specialStockIdfgWBSElement);
        this.specialStockIdfgWBSElement = specialStockIdfgWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsAutomaticallyCreated</b>
     * </p>
     *
     * @param isAutomaticallyCreated
     *            Item Automatically Created Indicator
     */
    public void setIsAutomaticallyCreated( @Nullable final String isAutomaticallyCreated )
    {
        rememberChangedField("IsAutomaticallyCreated", this.isAutomaticallyCreated);
        this.isAutomaticallyCreated = isAutomaticallyCreated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentLine</b>
     * </p>
     *
     * @param materialDocumentLine
     *            Unique Identification of Document Line
     */
    public void setMaterialDocumentLine( @Nullable final String materialDocumentLine )
    {
        rememberChangedField("MaterialDocumentLine", this.materialDocumentLine);
        this.materialDocumentLine = materialDocumentLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentParentLine</b>
     * </p>
     *
     * @param materialDocumentParentLine
     *            Identifier of immediately superior line
     */
    public void setMaterialDocumentParentLine( @Nullable final String materialDocumentParentLine )
    {
        rememberChangedField("MaterialDocumentParentLine", this.materialDocumentParentLine);
        this.materialDocumentParentLine = materialDocumentParentLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy level of line in document
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementIsCancelled</b>
     * </p>
     *
     * @param goodsMovementIsCancelled
     *            Item has been Cancelled
     */
    public void setGoodsMovementIsCancelled( @Nullable final Boolean goodsMovementIsCancelled )
    {
        rememberChangedField("GoodsMovementIsCancelled", this.goodsMovementIsCancelled);
        this.goodsMovementIsCancelled = goodsMovementIsCancelled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReversedMaterialDocumentYear</b>
     * </p>
     *
     * @param reversedMaterialDocumentYear
     *            Reversed Material Document Year
     */
    public void setReversedMaterialDocumentYear( @Nullable final String reversedMaterialDocumentYear )
    {
        rememberChangedField("ReversedMaterialDocumentYear", this.reversedMaterialDocumentYear);
        this.reversedMaterialDocumentYear = reversedMaterialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversedMaterialDocument</b>
     * </p>
     *
     * @param reversedMaterialDocument
     *            Reversed Material Document
     */
    public void setReversedMaterialDocument( @Nullable final String reversedMaterialDocument )
    {
        rememberChangedField("ReversedMaterialDocument", this.reversedMaterialDocument);
        this.reversedMaterialDocument = reversedMaterialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReversedMaterialDocumentItem</b>
     * </p>
     *
     * @param reversedMaterialDocumentItem
     *            Reversed Material Document Item
     */
    public void setReversedMaterialDocumentItem( @Nullable final String reversedMaterialDocumentItem )
    {
        rememberChangedField("ReversedMaterialDocumentItem", this.reversedMaterialDocumentItem);
        this.reversedMaterialDocumentItem = reversedMaterialDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentFiscalYear</b>
     * </p>
     *
     * @param referenceDocumentFiscalYear
     *            Fiscal Year of a Reference Document
     */
    public void setReferenceDocumentFiscalYear( @Nullable final String referenceDocumentFiscalYear )
    {
        rememberChangedField("ReferenceDocumentFiscalYear", this.referenceDocumentFiscalYear);
        this.referenceDocumentFiscalYear = referenceDocumentFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InvtryMgmtRefDocumentItem</b>
     * </p>
     *
     * @param invtryMgmtRefDocumentItem
     *            Item of a Reference Document
     */
    public void setInvtryMgmtRefDocumentItem( @Nullable final String invtryMgmtRefDocumentItem )
    {
        rememberChangedField("InvtryMgmtRefDocumentItem", this.invtryMgmtRefDocumentItem);
        this.invtryMgmtRefDocumentItem = invtryMgmtRefDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvtryMgmtReferenceDocument</b>
     * </p>
     *
     * @param invtryMgmtReferenceDocument
     *            Document No. of a Reference Document
     */
    public void setInvtryMgmtReferenceDocument( @Nullable final String invtryMgmtReferenceDocument )
    {
        rememberChangedField("InvtryMgmtReferenceDocument", this.invtryMgmtReferenceDocument);
        this.invtryMgmtReferenceDocument = invtryMgmtReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentPostingType</b>
     * </p>
     *
     * @param materialDocumentPostingType
     *            Reversal, return delivery, or transfer posting
     */
    public void setMaterialDocumentPostingType( @Nullable final String materialDocumentPostingType )
    {
        rememberChangedField("MaterialDocumentPostingType", this.materialDocumentPostingType);
        this.materialDocumentPostingType = materialDocumentPostingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @param inventoryUsabilityCode
     *            Posting Control Stock Type
     */
    public void setInventoryUsabilityCode( @Nullable final String inventoryUsabilityCode )
    {
        rememberChangedField("InventoryUsabilityCode", this.inventoryUsabilityCode);
        this.inventoryUsabilityCode = inventoryUsabilityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EWMWarehouse</b>
     * </p>
     *
     * @param eWMWarehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setEWMWarehouse( @Nullable final String eWMWarehouse )
    {
        rememberChangedField("EWMWarehouse", this.eWMWarehouse);
        this.eWMWarehouse = eWMWarehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBin</b>
     * </p>
     *
     * @param eWMStorageBin
     *            Storage Bin
     */
    public void setEWMStorageBin( @Nullable final String eWMStorageBin )
    {
        rememberChangedField("EWMStorageBin", this.eWMStorageBin);
        this.eWMStorageBin = eWMStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Indicator
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_MaterialDocumentItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaterialDocumentYear", getMaterialDocumentYear());
        result.put("MaterialDocument", getMaterialDocument());
        result.put("MaterialDocumentItem", getMaterialDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentItem", getMaterialDocumentItem());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("Batch", getBatch());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("InventoryStockType", getInventoryStockType());
        values.put("InventoryValuationType", getInventoryValuationType());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("SalesOrderScheduleLine", getSalesOrderScheduleLine());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("WBSElement", getWBSElement());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ManufacturingOrderItem", getManufacturingOrderItem());
        values.put("GoodsMovementRefDocType", getGoodsMovementRefDocType());
        values.put("GoodsMovementReasonCode", getGoodsMovementReasonCode());
        values.put("Delivery", getDelivery());
        values.put("DeliveryItem", getDeliveryItem());
        values.put("AccountAssignmentCategory", getAccountAssignmentCategory());
        values.put("CostCenter", getCostCenter());
        values.put("ControllingArea", getControllingArea());
        values.put("CostObject", getCostObject());
        values.put("GLAccount", getGLAccount());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("ProfitCenter", getProfitCenter());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("MaterialBaseUnit", getMaterialBaseUnit());
        values.put("QuantityInBaseUnit", getQuantityInBaseUnit());
        values.put("EntryUnit", getEntryUnit());
        values.put("QuantityInEntryUnit", getQuantityInEntryUnit());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("GdsMvtExtAmtInCoCodeCrcy", getGdsMvtExtAmtInCoCodeCrcy());
        values.put("SlsPrcAmtInclVATInCoCodeCrcy", getSlsPrcAmtInclVATInCoCodeCrcy());
        values.put("FiscalYear", getFiscalYear());
        values.put("FiscalYearPeriod", getFiscalYearPeriod());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("IssgOrRcvgMaterial", getIssgOrRcvgMaterial());
        values.put("IssgOrRcvgBatch", getIssgOrRcvgBatch());
        values.put("IssuingOrReceivingPlant", getIssuingOrReceivingPlant());
        values.put("IssuingOrReceivingStorageLoc", getIssuingOrReceivingStorageLoc());
        values.put("IssuingOrReceivingStockType", getIssuingOrReceivingStockType());
        values.put("IssgOrRcvgSpclStockInd", getIssgOrRcvgSpclStockInd());
        values.put("IssuingOrReceivingValType", getIssuingOrReceivingValType());
        values.put("IsCompletelyDelivered", getIsCompletelyDelivered());
        values.put("MaterialDocumentItemText", getMaterialDocumentItemText());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("ShelfLifeExpirationDate", getShelfLifeExpirationDate());
        values.put("ManufactureDate", getManufactureDate());
        values.put("SerialNumbersAreCreatedAutomly", getSerialNumbersAreCreatedAutomly());
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("ReservationIsFinallyIssued", getReservationIsFinallyIssued());
        values.put("SpecialStockIdfgSalesOrder", getSpecialStockIdfgSalesOrder());
        values.put("SpecialStockIdfgSalesOrderItem", getSpecialStockIdfgSalesOrderItem());
        values.put("SpecialStockIdfgWBSElement", getSpecialStockIdfgWBSElement());
        values.put("IsAutomaticallyCreated", getIsAutomaticallyCreated());
        values.put("MaterialDocumentLine", getMaterialDocumentLine());
        values.put("MaterialDocumentParentLine", getMaterialDocumentParentLine());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("GoodsMovementIsCancelled", getGoodsMovementIsCancelled());
        values.put("ReversedMaterialDocumentYear", getReversedMaterialDocumentYear());
        values.put("ReversedMaterialDocument", getReversedMaterialDocument());
        values.put("ReversedMaterialDocumentItem", getReversedMaterialDocumentItem());
        values.put("ReferenceDocumentFiscalYear", getReferenceDocumentFiscalYear());
        values.put("InvtryMgmtRefDocumentItem", getInvtryMgmtRefDocumentItem());
        values.put("InvtryMgmtReferenceDocument", getInvtryMgmtReferenceDocument());
        values.put("MaterialDocumentPostingType", getMaterialDocumentPostingType());
        values.put("InventoryUsabilityCode", getInventoryUsabilityCode());
        values.put("EWMWarehouse", getEWMWarehouse());
        values.put("EWMStorageBin", getEWMStorageBin());
        values.put("DebitCreditCode", getDebitCreditCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItem") ) {
                final Object value = values.remove("MaterialDocumentItem");
                if( (value == null) || (!value.equals(getMaterialDocumentItem())) ) {
                    setMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("InventoryStockType") ) {
                final Object value = values.remove("InventoryStockType");
                if( (value == null) || (!value.equals(getInventoryStockType())) ) {
                    setInventoryStockType(((String) value));
                }
            }
            if( values.containsKey("InventoryValuationType") ) {
                final Object value = values.remove("InventoryValuationType");
                if( (value == null) || (!value.equals(getInventoryValuationType())) ) {
                    setInventoryValuationType(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrderScheduleLine") ) {
                final Object value = values.remove("SalesOrderScheduleLine");
                if( (value == null) || (!value.equals(getSalesOrderScheduleLine())) ) {
                    setSalesOrderScheduleLine(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderItem") ) {
                final Object value = values.remove("ManufacturingOrderItem");
                if( (value == null) || (!value.equals(getManufacturingOrderItem())) ) {
                    setManufacturingOrderItem(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementRefDocType") ) {
                final Object value = values.remove("GoodsMovementRefDocType");
                if( (value == null) || (!value.equals(getGoodsMovementRefDocType())) ) {
                    setGoodsMovementRefDocType(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementReasonCode") ) {
                final Object value = values.remove("GoodsMovementReasonCode");
                if( (value == null) || (!value.equals(getGoodsMovementReasonCode())) ) {
                    setGoodsMovementReasonCode(((String) value));
                }
            }
            if( values.containsKey("Delivery") ) {
                final Object value = values.remove("Delivery");
                if( (value == null) || (!value.equals(getDelivery())) ) {
                    setDelivery(((String) value));
                }
            }
            if( values.containsKey("DeliveryItem") ) {
                final Object value = values.remove("DeliveryItem");
                if( (value == null) || (!value.equals(getDeliveryItem())) ) {
                    setDeliveryItem(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentCategory") ) {
                final Object value = values.remove("AccountAssignmentCategory");
                if( (value == null) || (!value.equals(getAccountAssignmentCategory())) ) {
                    setAccountAssignmentCategory(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("MaterialBaseUnit") ) {
                final Object value = values.remove("MaterialBaseUnit");
                if( (value == null) || (!value.equals(getMaterialBaseUnit())) ) {
                    setMaterialBaseUnit(((String) value));
                }
            }
            if( values.containsKey("QuantityInBaseUnit") ) {
                final Object value = values.remove("QuantityInBaseUnit");
                if( (value == null) || (!value.equals(getQuantityInBaseUnit())) ) {
                    setQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("EntryUnit") ) {
                final Object value = values.remove("EntryUnit");
                if( (value == null) || (!value.equals(getEntryUnit())) ) {
                    setEntryUnit(((String) value));
                }
            }
            if( values.containsKey("QuantityInEntryUnit") ) {
                final Object value = values.remove("QuantityInEntryUnit");
                if( (value == null) || (!value.equals(getQuantityInEntryUnit())) ) {
                    setQuantityInEntryUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("GdsMvtExtAmtInCoCodeCrcy") ) {
                final Object value = values.remove("GdsMvtExtAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getGdsMvtExtAmtInCoCodeCrcy())) ) {
                    setGdsMvtExtAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("SlsPrcAmtInclVATInCoCodeCrcy") ) {
                final Object value = values.remove("SlsPrcAmtInclVATInCoCodeCrcy");
                if( (value == null) || (!value.equals(getSlsPrcAmtInclVATInCoCodeCrcy())) ) {
                    setSlsPrcAmtInclVATInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("FiscalYearPeriod") ) {
                final Object value = values.remove("FiscalYearPeriod");
                if( (value == null) || (!value.equals(getFiscalYearPeriod())) ) {
                    setFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("IssgOrRcvgMaterial") ) {
                final Object value = values.remove("IssgOrRcvgMaterial");
                if( (value == null) || (!value.equals(getIssgOrRcvgMaterial())) ) {
                    setIssgOrRcvgMaterial(((String) value));
                }
            }
            if( values.containsKey("IssgOrRcvgBatch") ) {
                final Object value = values.remove("IssgOrRcvgBatch");
                if( (value == null) || (!value.equals(getIssgOrRcvgBatch())) ) {
                    setIssgOrRcvgBatch(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingPlant") ) {
                final Object value = values.remove("IssuingOrReceivingPlant");
                if( (value == null) || (!value.equals(getIssuingOrReceivingPlant())) ) {
                    setIssuingOrReceivingPlant(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingStorageLoc") ) {
                final Object value = values.remove("IssuingOrReceivingStorageLoc");
                if( (value == null) || (!value.equals(getIssuingOrReceivingStorageLoc())) ) {
                    setIssuingOrReceivingStorageLoc(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingStockType") ) {
                final Object value = values.remove("IssuingOrReceivingStockType");
                if( (value == null) || (!value.equals(getIssuingOrReceivingStockType())) ) {
                    setIssuingOrReceivingStockType(((String) value));
                }
            }
            if( values.containsKey("IssgOrRcvgSpclStockInd") ) {
                final Object value = values.remove("IssgOrRcvgSpclStockInd");
                if( (value == null) || (!value.equals(getIssgOrRcvgSpclStockInd())) ) {
                    setIssgOrRcvgSpclStockInd(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingValType") ) {
                final Object value = values.remove("IssuingOrReceivingValType");
                if( (value == null) || (!value.equals(getIssuingOrReceivingValType())) ) {
                    setIssuingOrReceivingValType(((String) value));
                }
            }
            if( values.containsKey("IsCompletelyDelivered") ) {
                final Object value = values.remove("IsCompletelyDelivered");
                if( (value == null) || (!value.equals(getIsCompletelyDelivered())) ) {
                    setIsCompletelyDelivered(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialDocumentItemText") ) {
                final Object value = values.remove("MaterialDocumentItemText");
                if( (value == null) || (!value.equals(getMaterialDocumentItemText())) ) {
                    setMaterialDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("ShelfLifeExpirationDate") ) {
                final Object value = values.remove("ShelfLifeExpirationDate");
                if( (value == null) || (!value.equals(getShelfLifeExpirationDate())) ) {
                    setShelfLifeExpirationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ManufactureDate") ) {
                final Object value = values.remove("ManufactureDate");
                if( (value == null) || (!value.equals(getManufactureDate())) ) {
                    setManufactureDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SerialNumbersAreCreatedAutomly") ) {
                final Object value = values.remove("SerialNumbersAreCreatedAutomly");
                if( (value == null) || (!value.equals(getSerialNumbersAreCreatedAutomly())) ) {
                    setSerialNumbersAreCreatedAutomly(((Boolean) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("ReservationIsFinallyIssued") ) {
                final Object value = values.remove("ReservationIsFinallyIssued");
                if( (value == null) || (!value.equals(getReservationIsFinallyIssued())) ) {
                    setReservationIsFinallyIssued(((Boolean) value));
                }
            }
            if( values.containsKey("SpecialStockIdfgSalesOrder") ) {
                final Object value = values.remove("SpecialStockIdfgSalesOrder");
                if( (value == null) || (!value.equals(getSpecialStockIdfgSalesOrder())) ) {
                    setSpecialStockIdfgSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SpecialStockIdfgSalesOrderItem") ) {
                final Object value = values.remove("SpecialStockIdfgSalesOrderItem");
                if( (value == null) || (!value.equals(getSpecialStockIdfgSalesOrderItem())) ) {
                    setSpecialStockIdfgSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("SpecialStockIdfgWBSElement") ) {
                final Object value = values.remove("SpecialStockIdfgWBSElement");
                if( (value == null) || (!value.equals(getSpecialStockIdfgWBSElement())) ) {
                    setSpecialStockIdfgWBSElement(((String) value));
                }
            }
            if( values.containsKey("IsAutomaticallyCreated") ) {
                final Object value = values.remove("IsAutomaticallyCreated");
                if( (value == null) || (!value.equals(getIsAutomaticallyCreated())) ) {
                    setIsAutomaticallyCreated(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentLine") ) {
                final Object value = values.remove("MaterialDocumentLine");
                if( (value == null) || (!value.equals(getMaterialDocumentLine())) ) {
                    setMaterialDocumentLine(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentParentLine") ) {
                final Object value = values.remove("MaterialDocumentParentLine");
                if( (value == null) || (!value.equals(getMaterialDocumentParentLine())) ) {
                    setMaterialDocumentParentLine(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementIsCancelled") ) {
                final Object value = values.remove("GoodsMovementIsCancelled");
                if( (value == null) || (!value.equals(getGoodsMovementIsCancelled())) ) {
                    setGoodsMovementIsCancelled(((Boolean) value));
                }
            }
            if( values.containsKey("ReversedMaterialDocumentYear") ) {
                final Object value = values.remove("ReversedMaterialDocumentYear");
                if( (value == null) || (!value.equals(getReversedMaterialDocumentYear())) ) {
                    setReversedMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("ReversedMaterialDocument") ) {
                final Object value = values.remove("ReversedMaterialDocument");
                if( (value == null) || (!value.equals(getReversedMaterialDocument())) ) {
                    setReversedMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("ReversedMaterialDocumentItem") ) {
                final Object value = values.remove("ReversedMaterialDocumentItem");
                if( (value == null) || (!value.equals(getReversedMaterialDocumentItem())) ) {
                    setReversedMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentFiscalYear") ) {
                final Object value = values.remove("ReferenceDocumentFiscalYear");
                if( (value == null) || (!value.equals(getReferenceDocumentFiscalYear())) ) {
                    setReferenceDocumentFiscalYear(((String) value));
                }
            }
            if( values.containsKey("InvtryMgmtRefDocumentItem") ) {
                final Object value = values.remove("InvtryMgmtRefDocumentItem");
                if( (value == null) || (!value.equals(getInvtryMgmtRefDocumentItem())) ) {
                    setInvtryMgmtRefDocumentItem(((String) value));
                }
            }
            if( values.containsKey("InvtryMgmtReferenceDocument") ) {
                final Object value = values.remove("InvtryMgmtReferenceDocument");
                if( (value == null) || (!value.equals(getInvtryMgmtReferenceDocument())) ) {
                    setInvtryMgmtReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentPostingType") ) {
                final Object value = values.remove("MaterialDocumentPostingType");
                if( (value == null) || (!value.equals(getMaterialDocumentPostingType())) ) {
                    setMaterialDocumentPostingType(((String) value));
                }
            }
            if( values.containsKey("InventoryUsabilityCode") ) {
                final Object value = values.remove("InventoryUsabilityCode");
                if( (value == null) || (!value.equals(getInventoryUsabilityCode())) ) {
                    setInventoryUsabilityCode(((String) value));
                }
            }
            if( values.containsKey("EWMWarehouse") ) {
                final Object value = values.remove("EWMWarehouse");
                if( (value == null) || (!value.equals(getEWMWarehouse())) ) {
                    setEWMWarehouse(((String) value));
                }
            }
            if( values.containsKey("EWMStorageBin") ) {
                final Object value = values.remove("EWMStorageBin");
                if( (value == null) || (!value.equals(getEWMStorageBin())) ) {
                    setEWMStorageBin(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaterialDocumentHeader") ) {
                final Object value = (values).remove("to_MaterialDocumentHeader");
                if( value instanceof Map ) {
                    if( toMaterialDocumentHeader == null ) {
                        toMaterialDocumentHeader = new MaterialDocumentHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaterialDocumentHeader.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SerialNumbers") ) {
                final Object value = (values).remove("to_SerialNumbers");
                if( value instanceof Iterable ) {
                    if( toSerialNumbers == null ) {
                        toSerialNumbers = Lists.newArrayList();
                    } else {
                        toSerialNumbers = Lists.newArrayList(toSerialNumbers);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SerialNumberMaterialDocument entity;
                        if( toSerialNumbers.size() > i ) {
                            entity = toSerialNumbers.get(i);
                        } else {
                            entity = new SerialNumberMaterialDocument();
                            toSerialNumbers.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaterialDocumentItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialDocumentItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialDocumentItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialDocumentItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaterialDocumentHeader != null ) {
            (values).put("to_MaterialDocumentHeader", toMaterialDocumentHeader);
        }
        if( toSerialNumbers != null ) {
            (values).put("to_SerialNumbers", toSerialNumbers);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialDocumentHeader</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaterialDocumentHeader</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaterialDocumentHeader</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialDocumentHeader fetchMaterialDocumentHeader()
    {
        return fetchFieldAsSingle("to_MaterialDocumentHeader", MaterialDocumentHeader.class);
    }

    /**
     * Retrieval of associated <b>MaterialDocumentHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaterialDocumentHeader</b>.
     * <p>
     * If the navigation property <b>to_MaterialDocumentHeader</b> of a queried <b>MaterialDocumentItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialDocumentHeader</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialDocumentHeader getMaterialDocumentHeaderOrFetch()
    {
        if( toMaterialDocumentHeader == null ) {
            toMaterialDocumentHeader = fetchMaterialDocumentHeader();
        }
        return toMaterialDocumentHeader;
    }

    /**
     * Retrieval of associated <b>MaterialDocumentHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaterialDocumentHeader</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialDocumentItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaterialDocumentHeader</b> is already loaded, the result
     *         will contain the <b>MaterialDocumentHeader</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaterialDocumentHeader> getMaterialDocumentHeaderIfPresent()
    {
        return Option.of(toMaterialDocumentHeader);
    }

    /**
     * Overwrites the associated <b>MaterialDocumentHeader</b> entity for the loaded navigation property
     * <b>to_MaterialDocumentHeader</b>.
     *
     * @param value
     *            New <b>MaterialDocumentHeader</b> entity.
     */
    public void setMaterialDocumentHeader( final MaterialDocumentHeader value )
    {
        toMaterialDocumentHeader = value;
    }

    /**
     * Fetches the <b>SerialNumberMaterialDocument</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SerialNumbers</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SerialNumberMaterialDocument</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SerialNumberMaterialDocument> fetchSerialNumbers()
    {
        return fetchFieldAsList("to_SerialNumbers", SerialNumberMaterialDocument.class);
    }

    /**
     * Retrieval of associated <b>SerialNumberMaterialDocument</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SerialNumbers</b>.
     * <p>
     * If the navigation property <b>to_SerialNumbers</b> of a queried <b>MaterialDocumentItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SerialNumberMaterialDocument</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SerialNumberMaterialDocument> getSerialNumbersOrFetch()
    {
        if( toSerialNumbers == null ) {
            toSerialNumbers = fetchSerialNumbers();
        }
        return toSerialNumbers;
    }

    /**
     * Retrieval of associated <b>SerialNumberMaterialDocument</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SerialNumbers</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialDocumentItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SerialNumbers</b> is already loaded, the result will
     *         contain the <b>SerialNumberMaterialDocument</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SerialNumberMaterialDocument>> getSerialNumbersIfPresent()
    {
        return Option.of(toSerialNumbers);
    }

    /**
     * Overwrites the list of associated <b>SerialNumberMaterialDocument</b> entities for the loaded navigation property
     * <b>to_SerialNumbers</b>.
     * <p>
     * If the navigation property <b>to_SerialNumbers</b> of a queried <b>MaterialDocumentItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SerialNumberMaterialDocument</b> entities.
     */
    public void setSerialNumbers( @Nonnull final List<SerialNumberMaterialDocument> value )
    {
        if( toSerialNumbers == null ) {
            toSerialNumbers = Lists.newArrayList();
        }
        toSerialNumbers.clear();
        toSerialNumbers.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SerialNumberMaterialDocument</b> entities. This corresponds to the
     * OData navigation property <b>to_SerialNumbers</b>.
     * <p>
     * If the navigation property <b>to_SerialNumbers</b> of a queried <b>MaterialDocumentItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SerialNumberMaterialDocument</b> entities.
     */
    public void addSerialNumbers( SerialNumberMaterialDocument... entity )
    {
        if( toSerialNumbers == null ) {
            toSerialNumbers = Lists.newArrayList();
        }
        toSerialNumbers.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaterialDocumentItem instances.
     *
     */
    public final static class MaterialDocumentItemBuilder
    {

        private MaterialDocumentHeader toMaterialDocumentHeader;
        private List<SerialNumberMaterialDocument> toSerialNumbers = Lists.newArrayList();

        private MaterialDocumentItem.MaterialDocumentItemBuilder toMaterialDocumentHeader(
            final MaterialDocumentHeader value )
        {
            toMaterialDocumentHeader = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaterialDocumentHeader</b> for <b>MaterialDocumentItem</b> to single
         * <b>MaterialDocumentHeader</b>.
         *
         * @param value
         *            The MaterialDocumentHeader to build this MaterialDocumentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialDocumentItem.MaterialDocumentItemBuilder materialDocumentHeader(
            final MaterialDocumentHeader value )
        {
            return toMaterialDocumentHeader(value);
        }

        private MaterialDocumentItem.MaterialDocumentItemBuilder toSerialNumbers(
            final List<SerialNumberMaterialDocument> value )
        {
            toSerialNumbers.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SerialNumbers</b> for <b>MaterialDocumentItem</b> to multiple
         * <b>SerialNumberMaterialDocument</b>.
         *
         * @param value
         *            The SerialNumberMaterialDocuments to build this MaterialDocumentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialDocumentItem.MaterialDocumentItemBuilder serialNumbers( SerialNumberMaterialDocument... value )
        {
            return toSerialNumbers(Lists.newArrayList(value));
        }

    }

}
