/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.selectable.SerialNumberMaterialDocumentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument
 * SerialNumberMaterialDocument} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SerialNumberMaterialDocumentByKeyFluentHelper
    extends
    FluentHelperByKey<SerialNumberMaterialDocumentByKeyFluentHelper, SerialNumberMaterialDocument, SerialNumberMaterialDocumentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument
     * SerialNumberMaterialDocument} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param materialDocument
     *            Number of Material Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SerialNumberMaterialDocument}
     * @param serialNumber
     *            Serial Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param materialDocumentItem
     *            Material Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SerialNumberMaterialDocument}
     * @param materialDocumentYear
     *            Material Document Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public SerialNumberMaterialDocumentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String material,
        final String serialNumber,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear )
    {
        super(servicePath, entityCollection);
        this.key.put("Material", material);
        this.key.put("SerialNumber", serialNumber);
        this.key.put("MaterialDocument", materialDocument);
        this.key.put("MaterialDocumentItem", materialDocumentItem);
        this.key.put("MaterialDocumentYear", materialDocumentYear);
    }

    @Override
    @Nonnull
    protected Class<SerialNumberMaterialDocument> getEntityClass()
    {
        return SerialNumberMaterialDocument.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
