/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader;

/**
 * Implementation of the {@link MaterialDocumentServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialDocumentService MaterialDocumentService}.
 *
 */
public class DefaultMaterialDocumentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaterialDocumentServiceBatch, MaterialDocumentServiceBatchChangeSet>
    implements
    MaterialDocumentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialDocumentService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaterialDocumentServiceBatchChangeSet(
        @Nonnull final DefaultMaterialDocumentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialDocumentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaterialDocumentServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaterialDocumentServiceBatchChangeSet createMaterialDocumentHeader(
        @Nonnull final MaterialDocumentHeader materialDocumentHeader )
    {
        return addRequestCreate(service::createMaterialDocumentHeader, materialDocumentHeader);
    }

}
