/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem
 * MaterialDocumentItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.field.MaterialDocumentItemField
 * MaterialDocumentItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.link.MaterialDocumentItemLink
 * MaterialDocumentItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MATERIAL_DOCUMENT_YEAR
 * MATERIAL_DOCUMENT_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MATERIAL_DOCUMENT
 * MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MATERIAL_DOCUMENT_ITEM
 * MATERIAL_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#GOODS_MOVEMENT_TYPE
 * GOODS_MOVEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#INVENTORY_STOCK_TYPE
 * INVENTORY_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#INVENTORY_VALUATION_TYPE
 * INVENTORY_VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#INVENTORY_SPECIAL_STOCK_TYPE
 * INVENTORY_SPECIAL_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SALES_ORDER_SCHEDULE_LINE
 * SALES_ORDER_SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#PURCHASE_ORDER
 * PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#PURCHASE_ORDER_ITEM
 * PURCHASE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MANUFACTURING_ORDER_ITEM
 * MANUFACTURING_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#GOODS_MOVEMENT_REF_DOC_TYPE
 * GOODS_MOVEMENT_REF_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#GOODS_MOVEMENT_REASON_CODE
 * GOODS_MOVEMENT_REASON_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#DELIVERY
 * DELIVERY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#DELIVERY_ITEM
 * DELIVERY_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#ACCOUNT_ASSIGNMENT_CATEGORY
 * ACCOUNT_ASSIGNMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MATERIAL_BASE_UNIT
 * MATERIAL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#QUANTITY_IN_BASE_UNIT
 * QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#ENTRY_UNIT
 * ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#QUANTITY_IN_ENTRY_UNIT
 * QUANTITY_IN_ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#GDS_MVT_EXT_AMT_IN_CO_CODE_CRCY
 * GDS_MVT_EXT_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SLS_PRC_AMT_INCL_VAT_IN_CO_CODE_CRCY
 * SLS_PRC_AMT_INCL_VAT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#FISCAL_YEAR_PERIOD
 * FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#ISSG_OR_RCVG_MATERIAL
 * ISSG_OR_RCVG_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#ISSG_OR_RCVG_BATCH
 * ISSG_OR_RCVG_BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#ISSUING_OR_RECEIVING_PLANT
 * ISSUING_OR_RECEIVING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#ISSUING_OR_RECEIVING_STORAGE_LOC
 * ISSUING_OR_RECEIVING_STORAGE_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#ISSUING_OR_RECEIVING_STOCK_TYPE
 * ISSUING_OR_RECEIVING_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#ISSG_OR_RCVG_SPCL_STOCK_IND
 * ISSG_OR_RCVG_SPCL_STOCK_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#ISSUING_OR_RECEIVING_VAL_TYPE
 * ISSUING_OR_RECEIVING_VAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#IS_COMPLETELY_DELIVERED
 * IS_COMPLETELY_DELIVERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MATERIAL_DOCUMENT_ITEM_TEXT
 * MATERIAL_DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SHELF_LIFE_EXPIRATION_DATE
 * SHELF_LIFE_EXPIRATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MANUFACTURE_DATE
 * MANUFACTURE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SERIAL_NUMBERS_ARE_CREATED_AUTOMLY
 * SERIAL_NUMBERS_ARE_CREATED_AUTOMLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#RESERVATION_IS_FINALLY_ISSUED
 * RESERVATION_IS_FINALLY_ISSUED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SPECIAL_STOCK_IDFG_SALES_ORDER
 * SPECIAL_STOCK_IDFG_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM
 * SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#SPECIAL_STOCK_IDFG_WBS_ELEMENT
 * SPECIAL_STOCK_IDFG_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#IS_AUTOMATICALLY_CREATED
 * IS_AUTOMATICALLY_CREATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MATERIAL_DOCUMENT_LINE
 * MATERIAL_DOCUMENT_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MATERIAL_DOCUMENT_PARENT_LINE
 * MATERIAL_DOCUMENT_PARENT_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#HIERARCHY_NODE_LEVEL
 * HIERARCHY_NODE_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#GOODS_MOVEMENT_IS_CANCELLED
 * GOODS_MOVEMENT_IS_CANCELLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#REVERSED_MATERIAL_DOCUMENT_YEAR
 * REVERSED_MATERIAL_DOCUMENT_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#REVERSED_MATERIAL_DOCUMENT
 * REVERSED_MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#REVERSED_MATERIAL_DOCUMENT_ITEM
 * REVERSED_MATERIAL_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#REFERENCE_DOCUMENT_FISCAL_YEAR
 * REFERENCE_DOCUMENT_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#INVTRY_MGMT_REF_DOCUMENT_ITEM
 * INVTRY_MGMT_REF_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#INVTRY_MGMT_REFERENCE_DOCUMENT
 * INVTRY_MGMT_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#MATERIAL_DOCUMENT_POSTING_TYPE
 * MATERIAL_DOCUMENT_POSTING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#INVENTORY_USABILITY_CODE
 * INVENTORY_USABILITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#EWM_WAREHOUSE
 * EWM_WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#EWM_STORAGE_BIN
 * EWM_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#DEBIT_CREDIT_CODE
 * DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#TO_MATERIAL_DOCUMENT_HEADER
 * TO_MATERIAL_DOCUMENT_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem#TO_SERIAL_NUMBERS
 * TO_SERIAL_NUMBERS}</li>
 * </ul>
 *
 */
public interface MaterialDocumentItemSelectable extends EntitySelectable<MaterialDocumentItem>
{

}
