/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument
 * SerialNumberMaterialDocument}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.field.SerialNumberMaterialDocumentField
 * SerialNumberMaterialDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.link.SerialNumberMaterialDocumentLink
 * SerialNumberMaterialDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument#SERIAL_NUMBER
 * SERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument#MATERIAL_DOCUMENT
 * MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument#MATERIAL_DOCUMENT_ITEM
 * MATERIAL_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument#MATERIAL_DOCUMENT_YEAR
 * MATERIAL_DOCUMENT_YEAR}</li>
 * </ul>
 *
 */
public interface SerialNumberMaterialDocumentSelectable extends EntitySelectable<SerialNumberMaterialDocument>
{

}
