/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.field.MRPMaterialField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.selectable.MRPMaterialSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Master Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_MRPMaterialType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MRPMaterial extends VdmEntity<MRPMaterial>
{

    /**
     * Selector for all available fields of MRPMaterial.
     *
     */
    public final static MRPMaterialSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL = new MRPMaterialField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "MRPPlant" )
    @JsonProperty( "MRPPlant" )
    @Nullable
    @ODataField( odataName = "MRPPlant" )
    private String mRPPlant;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlant</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_PLANT = new MRPMaterialField<String>("MRPPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_AREA = new MRPMaterialField<String>("MRPArea");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_NAME = new MRPMaterialField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @return Plant Name
     */
    @SerializedName( "PlantName" )
    @JsonProperty( "PlantName" )
    @Nullable
    @ODataField( odataName = "PlantName" )
    private String plantName;
    /**
     * Use with available fluent helpers to apply the <b>PlantName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> PLANT_NAME = new MRPMaterialField<String>("PlantName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MRPAreaText</b>
     * </p>
     *
     * @return MRP Area Text
     */
    @SerializedName( "MRPAreaText" )
    @JsonProperty( "MRPAreaText" )
    @Nullable
    @ODataField( odataName = "MRPAreaText" )
    private String mRPAreaText;
    /**
     * Use with available fluent helpers to apply the <b>MRPAreaText</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_AREA_TEXT = new MRPMaterialField<String>("MRPAreaText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPAreaCategory</b>
     * </p>
     *
     * @return MRP Area Category
     */
    @SerializedName( "MRPAreaCategory" )
    @JsonProperty( "MRPAreaCategory" )
    @Nullable
    @ODataField( odataName = "MRPAreaCategory" )
    private String mRPAreaCategory;
    /**
     * Use with available fluent helpers to apply the <b>MRPAreaCategory</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_AREA_CATEGORY = new MRPMaterialField<String>("MRPAreaCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MRPAreaCategoryName</b>
     * </p>
     *
     * @return MRP Area Category Name
     */
    @SerializedName( "MRPAreaCategoryName" )
    @JsonProperty( "MRPAreaCategoryName" )
    @Nullable
    @ODataField( odataName = "MRPAreaCategoryName" )
    private String mRPAreaCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>MRPAreaCategoryName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_AREA_CATEGORY_NAME =
        new MRPMaterialField<String>("MRPAreaCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_GROUP = new MRPMaterialField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @return Product Group Description
     */
    @SerializedName( "MaterialGroupName" )
    @JsonProperty( "MaterialGroupName" )
    @Nullable
    @ODataField( odataName = "MaterialGroupName" )
    private String materialGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_GROUP_NAME =
        new MRPMaterialField<String>("MaterialGroupName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "MaterialIsMarkedForDeletion" )
    @JsonProperty( "MaterialIsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialIsMarkedForDeletion" )
    private Boolean materialIsMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>MaterialIsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static MRPMaterialField<Boolean> MATERIAL_IS_MARKED_FOR_DELETION =
        new MRPMaterialField<Boolean>("MaterialIsMarkedForDeletion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlntMatlIsMarkedForDeletion</b>
     * </p>
     *
     * @return Flag Material for Deletion at Plant Level
     */
    @SerializedName( "PlntMatlIsMarkedForDeletion" )
    @JsonProperty( "PlntMatlIsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PlntMatlIsMarkedForDeletion" )
    private Boolean plntMatlIsMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>PlntMatlIsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static MRPMaterialField<Boolean> PLNT_MATL_IS_MARKED_FOR_DELETION =
        new MRPMaterialField<Boolean>("PlntMatlIsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantStatus</b>
     * </p>
     *
     * @return Cross-Plant Product Status
     */
    @SerializedName( "CrossPlantStatus" )
    @JsonProperty( "CrossPlantStatus" )
    @Nullable
    @ODataField( odataName = "CrossPlantStatus" )
    private String crossPlantStatus;
    /**
     * Use with available fluent helpers to apply the <b>CrossPlantStatus</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> CROSS_PLANT_STATUS = new MRPMaterialField<String>("CrossPlantStatus");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantStatusName</b>
     * </p>
     *
     * @return Cross Plant Status Text
     */
    @SerializedName( "CrossPlantStatusName" )
    @JsonProperty( "CrossPlantStatusName" )
    @Nullable
    @ODataField( odataName = "CrossPlantStatusName" )
    private String crossPlantStatusName;
    /**
     * Use with available fluent helpers to apply the <b>CrossPlantStatusName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> CROSS_PLANT_STATUS_NAME =
        new MRPMaterialField<String>("CrossPlantStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> BASE_UNIT = new MRPMaterialField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureName</b>
     * </p>
     *
     * @return Unit of Measurement Text (Maximum 10 Characters)
     */
    @SerializedName( "UnitOfMeasureName" )
    @JsonProperty( "UnitOfMeasureName" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureName" )
    private String unitOfMeasureName;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> UNIT_OF_MEASURE_NAME =
        new MRPMaterialField<String>("UnitOfMeasureName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LowLevelCode</b>
     * </p>
     *
     * @return Low-Level Code
     */
    @SerializedName( "LowLevelCode" )
    @JsonProperty( "LowLevelCode" )
    @Nullable
    @ODataField( odataName = "LowLevelCode" )
    private String lowLevelCode;
    /**
     * Use with available fluent helpers to apply the <b>LowLevelCode</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> LOW_LEVEL_CODE = new MRPMaterialField<String>("LowLevelCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsConfigurable</b>
     * </p>
     *
     * @return Product is Configurable
     */
    @SerializedName( "MaterialIsConfigurable" )
    @JsonProperty( "MaterialIsConfigurable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialIsConfigurable" )
    private Boolean materialIsConfigurable;
    /**
     * Use with available fluent helpers to apply the <b>MaterialIsConfigurable</b> field to query operations.
     *
     */
    public final static MRPMaterialField<Boolean> MATERIAL_IS_CONFIGURABLE =
        new MRPMaterialField<Boolean>("MaterialIsConfigurable");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialUsabilityProfile</b>
     * </p>
     *
     * @return Plant-Specific Material Status
     */
    @SerializedName( "MaterialUsabilityProfile" )
    @JsonProperty( "MaterialUsabilityProfile" )
    @Nullable
    @ODataField( odataName = "MaterialUsabilityProfile" )
    private String materialUsabilityProfile;
    /**
     * Use with available fluent helpers to apply the <b>MaterialUsabilityProfile</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_USABILITY_PROFILE =
        new MRPMaterialField<String>("MaterialUsabilityProfile");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>MaterialUsabilityProfileName</b>
     * </p>
     *
     * @return Cross Plant Status Text
     */
    @SerializedName( "MaterialUsabilityProfileName" )
    @JsonProperty( "MaterialUsabilityProfileName" )
    @Nullable
    @ODataField( odataName = "MaterialUsabilityProfileName" )
    private String materialUsabilityProfileName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialUsabilityProfileName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_USABILITY_PROFILE_NAME =
        new MRPMaterialField<String>("MaterialUsabilityProfileName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialABCClassification</b>
     * </p>
     *
     * @return ABC Indicator
     */
    @SerializedName( "MaterialABCClassification" )
    @JsonProperty( "MaterialABCClassification" )
    @Nullable
    @ODataField( odataName = "MaterialABCClassification" )
    private String materialABCClassification;
    /**
     * Use with available fluent helpers to apply the <b>MaterialABCClassification</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_ABC_CLASSIFICATION =
        new MRPMaterialField<String>("MaterialABCClassification");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaterialABCClassificationDesc</b>
     * </p>
     *
     * @return Consumption Value Category Text
     */
    @SerializedName( "MaterialABCClassificationDesc" )
    @JsonProperty( "MaterialABCClassificationDesc" )
    @Nullable
    @ODataField( odataName = "MaterialABCClassificationDesc" )
    private String materialABCClassificationDesc;
    /**
     * Use with available fluent helpers to apply the <b>MaterialABCClassificationDesc</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_ABC_CLASSIFICATION_DESC =
        new MRPMaterialField<String>("MaterialABCClassificationDesc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> PURCHASING_GROUP = new MRPMaterialField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroupName</b>
     * </p>
     *
     * @return Purchasing Group Name
     */
    @SerializedName( "PurchasingGroupName" )
    @JsonProperty( "PurchasingGroupName" )
    @Nullable
    @ODataField( odataName = "PurchasingGroupName" )
    private String purchasingGroupName;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroupName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> PURCHASING_GROUP_NAME =
        new MRPMaterialField<String>("PurchasingGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementCategory</b>
     * </p>
     *
     * @return Procurement Type
     */
    @SerializedName( "MaterialProcurementCategory" )
    @JsonProperty( "MaterialProcurementCategory" )
    @Nullable
    @ODataField( odataName = "MaterialProcurementCategory" )
    private String materialProcurementCategory;
    /**
     * Use with available fluent helpers to apply the <b>MaterialProcurementCategory</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_PROCUREMENT_CATEGORY =
        new MRPMaterialField<String>("MaterialProcurementCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementCatName</b>
     * </p>
     *
     * @return Material Procurement Category Name
     */
    @SerializedName( "MaterialProcurementCatName" )
    @JsonProperty( "MaterialProcurementCatName" )
    @Nullable
    @ODataField( odataName = "MaterialProcurementCatName" )
    private String materialProcurementCatName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialProcurementCatName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_PROCUREMENT_CAT_NAME =
        new MRPMaterialField<String>("MaterialProcurementCatName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DependentRequirementsType</b>
     * </p>
     *
     * @return Indicator for Individual and Collective Requirements
     */
    @SerializedName( "DependentRequirementsType" )
    @JsonProperty( "DependentRequirementsType" )
    @Nullable
    @ODataField( odataName = "DependentRequirementsType" )
    private String dependentRequirementsType;
    /**
     * Use with available fluent helpers to apply the <b>DependentRequirementsType</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> DEPENDENT_REQUIREMENTS_TYPE =
        new MRPMaterialField<String>("DependentRequirementsType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DependentRequirementsTypeName</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "DependentRequirementsTypeName" )
    @JsonProperty( "DependentRequirementsTypeName" )
    @Nullable
    @ODataField( odataName = "DependentRequirementsTypeName" )
    private String dependentRequirementsTypeName;
    /**
     * Use with available fluent helpers to apply the <b>DependentRequirementsTypeName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> DEPENDENT_REQUIREMENTS_TYPE_NAME =
        new MRPMaterialField<String>("DependentRequirementsTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompDiscontinuationType</b>
     * </p>
     *
     * @return The matlCompDiscontinuationType contained in this entity.
     */
    @SerializedName( "MatlCompDiscontinuationType" )
    @JsonProperty( "MatlCompDiscontinuationType" )
    @Nullable
    @ODataField( odataName = "MatlCompDiscontinuationType" )
    private String matlCompDiscontinuationType;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompDiscontinuationType</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATL_COMP_DISCONTINUATION_TYPE =
        new MRPMaterialField<String>("MatlCompDiscontinuationType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompDscontnTypeName</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "MatlCompDscontnTypeName" )
    @JsonProperty( "MatlCompDscontnTypeName" )
    @Nullable
    @ODataField( odataName = "MatlCompDscontnTypeName" )
    private String matlCompDscontnTypeName;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompDscontnTypeName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATL_COMP_DSCONTN_TYPE_NAME =
        new MRPMaterialField<String>("MatlCompDscontnTypeName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EffectiveOutDate</b>
     * </p>
     *
     * @return Effective-Out Date
     */
    @SerializedName( "EffectiveOutDate" )
    @JsonProperty( "EffectiveOutDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EffectiveOutDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime effectiveOutDate;
    /**
     * Use with available fluent helpers to apply the <b>EffectiveOutDate</b> field to query operations.
     *
     */
    public final static MRPMaterialField<LocalDateTime> EFFECTIVE_OUT_DATE =
        new MRPMaterialField<LocalDateTime>("EffectiveOutDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialType</b>
     * </p>
     *
     * @return Product Type
     */
    @SerializedName( "MaterialType" )
    @JsonProperty( "MaterialType" )
    @Nullable
    @ODataField( odataName = "MaterialType" )
    private String materialType;
    /**
     * Use with available fluent helpers to apply the <b>MaterialType</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_TYPE = new MRPMaterialField<String>("MaterialType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>MaterialTypeName</b>
     * </p>
     *
     * @return Description of product type
     */
    @SerializedName( "MaterialTypeName" )
    @JsonProperty( "MaterialTypeName" )
    @Nullable
    @ODataField( odataName = "MaterialTypeName" )
    private String materialTypeName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialTypeName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_TYPE_NAME = new MRPMaterialField<String>("MaterialTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroup</b>
     * </p>
     *
     * @return MRP Group
     */
    @SerializedName( "MRPGroup" )
    @JsonProperty( "MRPGroup" )
    @Nullable
    @ODataField( odataName = "MRPGroup" )
    private String mRPGroup;
    /**
     * Use with available fluent helpers to apply the <b>MRPGroup</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_GROUP = new MRPMaterialField<String>("MRPGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroupName</b>
     * </p>
     *
     * @return MRP Group Description
     */
    @SerializedName( "MRPGroupName" )
    @JsonProperty( "MRPGroupName" )
    @Nullable
    @ODataField( odataName = "MRPGroupName" )
    private String mRPGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MRPGroupName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_GROUP_NAME = new MRPMaterialField<String>("MRPGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_CONTROLLER = new MRPMaterialField<String>("MRPController");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MRPControllerName</b>
     * </p>
     *
     * @return MRP Controller Name
     */
    @SerializedName( "MRPControllerName" )
    @JsonProperty( "MRPControllerName" )
    @Nullable
    @ODataField( odataName = "MRPControllerName" )
    private String mRPControllerName;
    /**
     * Use with available fluent helpers to apply the <b>MRPControllerName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_CONTROLLER_NAME =
        new MRPMaterialField<String>("MRPControllerName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RangeOfCvrgPrflCode</b>
     * </p>
     *
     * @return Range-of-Coverage Profile
     */
    @SerializedName( "RangeOfCvrgPrflCode" )
    @JsonProperty( "RangeOfCvrgPrflCode" )
    @Nullable
    @ODataField( odataName = "RangeOfCvrgPrflCode" )
    private String rangeOfCvrgPrflCode;
    /**
     * Use with available fluent helpers to apply the <b>RangeOfCvrgPrflCode</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> RANGE_OF_CVRG_PRFL_CODE =
        new MRPMaterialField<String>("RangeOfCvrgPrflCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingFloatProfile</b>
     * </p>
     *
     * @return Scheduling Margin Key for Floats
     */
    @SerializedName( "SchedulingFloatProfile" )
    @JsonProperty( "SchedulingFloatProfile" )
    @Nullable
    @ODataField( odataName = "SchedulingFloatProfile" )
    private String schedulingFloatProfile;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingFloatProfile</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> SCHEDULING_FLOAT_PROFILE =
        new MRPMaterialField<String>("SchedulingFloatProfile");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurableProduct</b>
     * </p>
     *
     * @return Configurable Material
     */
    @SerializedName( "ConfigurableProduct" )
    @JsonProperty( "ConfigurableProduct" )
    @Nullable
    @ODataField( odataName = "ConfigurableProduct" )
    private String configurableProduct;
    /**
     * Use with available fluent helpers to apply the <b>ConfigurableProduct</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> CONFIGURABLE_PRODUCT =
        new MRPMaterialField<String>("ConfigurableProduct");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurableProductName</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "ConfigurableProductName" )
    @JsonProperty( "ConfigurableProductName" )
    @Nullable
    @ODataField( odataName = "ConfigurableProductName" )
    private String configurableProductName;
    /**
     * Use with available fluent helpers to apply the <b>ConfigurableProductName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> CONFIGURABLE_PRODUCT_NAME =
        new MRPMaterialField<String>("ConfigurableProductName");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingTime</b>
     * </p>
     *
     * @return Processing time
     */
    @SerializedName( "ProcessingTime" )
    @JsonProperty( "ProcessingTime" )
    @Nullable
    @ODataField( odataName = "ProcessingTime" )
    private BigDecimal processingTime;
    /**
     * Use with available fluent helpers to apply the <b>ProcessingTime</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> PROCESSING_TIME =
        new MRPMaterialField<BigDecimal>("ProcessingTime");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SetupAndTeardownTime</b>
     * </p>
     *
     * @return Setup and teardown time
     */
    @SerializedName( "SetupAndTeardownTime" )
    @JsonProperty( "SetupAndTeardownTime" )
    @Nullable
    @ODataField( odataName = "SetupAndTeardownTime" )
    private BigDecimal setupAndTeardownTime;
    /**
     * Use with available fluent helpers to apply the <b>SetupAndTeardownTime</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> SETUP_AND_TEARDOWN_TIME =
        new MRPMaterialField<BigDecimal>("SetupAndTeardownTime");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>TransitionTime</b>
     * </p>
     *
     * @return Interoperation time
     */
    @SerializedName( "TransitionTime" )
    @JsonProperty( "TransitionTime" )
    @Nullable
    @ODataField( odataName = "TransitionTime" )
    private BigDecimal transitionTime;
    /**
     * Use with available fluent helpers to apply the <b>TransitionTime</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> TRANSITION_TIME =
        new MRPMaterialField<BigDecimal>("TransitionTime");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @return Goods receipt processing time in days
     */
    @SerializedName( "GoodsReceiptDuration" )
    @JsonProperty( "GoodsReceiptDuration" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptDuration" )
    private BigDecimal goodsReceiptDuration;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptDuration</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> GOODS_RECEIPT_DURATION =
        new MRPMaterialField<BigDecimal>("GoodsReceiptDuration");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedDeliveryDurn</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "MaterialPlannedDeliveryDurn" )
    @JsonProperty( "MaterialPlannedDeliveryDurn" )
    @Nullable
    @ODataField( odataName = "MaterialPlannedDeliveryDurn" )
    private BigDecimal materialPlannedDeliveryDurn;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPlannedDeliveryDurn</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> MATERIAL_PLANNED_DELIVERY_DURN =
        new MRPMaterialField<BigDecimal>("MaterialPlannedDeliveryDurn");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedProductionDurn</b>
     * </p>
     *
     * @return In-house production time
     */
    @SerializedName( "MaterialPlannedProductionDurn" )
    @JsonProperty( "MaterialPlannedProductionDurn" )
    @Nullable
    @ODataField( odataName = "MaterialPlannedProductionDurn" )
    private BigDecimal materialPlannedProductionDurn;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPlannedProductionDurn</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> MATERIAL_PLANNED_PRODUCTION_DURN =
        new MRPMaterialField<BigDecimal>("MaterialPlannedProductionDurn");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalReplenishmentLeadDuration</b>
     * </p>
     *
     * @return Total replenishment lead time (in workdays)
     */
    @SerializedName( "TotalReplenishmentLeadDuration" )
    @JsonProperty( "TotalReplenishmentLeadDuration" )
    @Nullable
    @ODataField( odataName = "TotalReplenishmentLeadDuration" )
    private BigDecimal totalReplenishmentLeadDuration;
    /**
     * Use with available fluent helpers to apply the <b>TotalReplenishmentLeadDuration</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> TOTAL_REPLENISHMENT_LEAD_DURATION =
        new MRPMaterialField<BigDecimal>("TotalReplenishmentLeadDuration");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSafetyTime</b>
     * </p>
     *
     * @return Safety Time Indicator (with or without safety time)
     */
    @SerializedName( "IsSafetyTime" )
    @JsonProperty( "IsSafetyTime" )
    @Nullable
    @ODataField( odataName = "IsSafetyTime" )
    private String isSafetyTime;
    /**
     * Use with available fluent helpers to apply the <b>IsSafetyTime</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> IS_SAFETY_TIME = new MRPMaterialField<String>("IsSafetyTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPSafetyDuration</b>
     * </p>
     *
     * @return Safety Time (in Workdays)
     */
    @SerializedName( "MRPSafetyDuration" )
    @JsonProperty( "MRPSafetyDuration" )
    @Nullable
    @ODataField( odataName = "MRPSafetyDuration" )
    private String mRPSafetyDuration;
    /**
     * Use with available fluent helpers to apply the <b>MRPSafetyDuration</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_SAFETY_DURATION =
        new MRPMaterialField<String>("MRPSafetyDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PerdPrflForSftyTme</b>
     * </p>
     *
     * @return Period Profile for Safety Time
     */
    @SerializedName( "PerdPrflForSftyTme" )
    @JsonProperty( "PerdPrflForSftyTme" )
    @Nullable
    @ODataField( odataName = "PerdPrflForSftyTme" )
    private String perdPrflForSftyTme;
    /**
     * Use with available fluent helpers to apply the <b>PerdPrflForSftyTme</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> PERD_PRFL_FOR_SFTY_TME =
        new MRPMaterialField<String>("PerdPrflForSftyTme");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @return The reorderThresholdQuantity contained in this entity.
     */
    @SerializedName( "ReorderThresholdQuantity" )
    @JsonProperty( "ReorderThresholdQuantity" )
    @Nullable
    @ODataField( odataName = "ReorderThresholdQuantity" )
    private BigDecimal reorderThresholdQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ReorderThresholdQuantity</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> REORDER_THRESHOLD_QUANTITY =
        new MRPMaterialField<BigDecimal>("ReorderThresholdQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SafetyStockQuantity</b>
     * </p>
     *
     * @return The safetyStockQuantity contained in this entity.
     */
    @SerializedName( "SafetyStockQuantity" )
    @JsonProperty( "SafetyStockQuantity" )
    @Nullable
    @ODataField( odataName = "SafetyStockQuantity" )
    private BigDecimal safetyStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>SafetyStockQuantity</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> SAFETY_STOCK_QUANTITY =
        new MRPMaterialField<BigDecimal>("SafetyStockQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LotSizingProcedure</b>
     * </p>
     *
     * @return Lot Sizing Procedure in Materials Planning
     */
    @SerializedName( "LotSizingProcedure" )
    @JsonProperty( "LotSizingProcedure" )
    @Nullable
    @ODataField( odataName = "LotSizingProcedure" )
    private String lotSizingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>LotSizingProcedure</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> LOT_SIZING_PROCEDURE =
        new MRPMaterialField<String>("LotSizingProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialLotSizingProcedureName</b>
     * </p>
     *
     * @return Name of Lot-Sizing Procedure
     */
    @SerializedName( "MaterialLotSizingProcedureName" )
    @JsonProperty( "MaterialLotSizingProcedureName" )
    @Nullable
    @ODataField( odataName = "MaterialLotSizingProcedureName" )
    private String materialLotSizingProcedureName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialLotSizingProcedureName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_LOT_SIZING_PROCEDURE_NAME =
        new MRPMaterialField<String>("MaterialLotSizingProcedureName");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size
     */
    @SerializedName( "MinimumLotSizeQuantity" )
    @JsonProperty( "MinimumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumLotSizeQuantity" )
    private BigDecimal minimumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> MINIMUM_LOT_SIZE_QUANTITY =
        new MRPMaterialField<BigDecimal>("MinimumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size
     */
    @SerializedName( "MaximumLotSizeQuantity" )
    @JsonProperty( "MaximumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumLotSizeQuantity" )
    private BigDecimal maximumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> MAXIMUM_LOT_SIZE_QUANTITY =
        new MRPMaterialField<BigDecimal>("MaximumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @return Fixed lot size
     */
    @SerializedName( "FixedLotSizeQuantity" )
    @JsonProperty( "FixedLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "FixedLotSizeQuantity" )
    private BigDecimal fixedLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>FixedLotSizeQuantity</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> FIXED_LOT_SIZE_QUANTITY =
        new MRPMaterialField<BigDecimal>("FixedLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMaxStockLevelQuantity</b>
     * </p>
     *
     * @return Maximum Stock Level
     */
    @SerializedName( "MaterialMaxStockLevelQuantity" )
    @JsonProperty( "MaterialMaxStockLevelQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialMaxStockLevelQuantity" )
    private BigDecimal materialMaxStockLevelQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialMaxStockLevelQuantity</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> MATERIAL_MAX_STOCK_LEVEL_QUANTITY =
        new MRPMaterialField<BigDecimal>("MaterialMaxStockLevelQuantity");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeIndependentCosts</b>
     * </p>
     *
     * @return Lot-Size-Independent Costs
     */
    @SerializedName( "LotSizeIndependentCosts" )
    @JsonProperty( "LotSizeIndependentCosts" )
    @Nullable
    @ODataField( odataName = "LotSizeIndependentCosts" )
    private BigDecimal lotSizeIndependentCosts;
    /**
     * Use with available fluent helpers to apply the <b>LotSizeIndependentCosts</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> LOT_SIZE_INDEPENDENT_COSTS =
        new MRPMaterialField<BigDecimal>("LotSizeIndependentCosts");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> CURRENCY = new MRPMaterialField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StorageCostsPercentageCode</b>
     * </p>
     *
     * @return Storage Costs Percentage Code
     */
    @SerializedName( "StorageCostsPercentageCode" )
    @JsonProperty( "StorageCostsPercentageCode" )
    @Nullable
    @ODataField( odataName = "StorageCostsPercentageCode" )
    private String storageCostsPercentageCode;
    /**
     * Use with available fluent helpers to apply the <b>StorageCostsPercentageCode</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> STORAGE_COSTS_PERCENTAGE_CODE =
        new MRPMaterialField<String>("StorageCostsPercentageCode");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyScrapPercent</b>
     * </p>
     *
     * @return Assembly scrap in percent
     */
    @SerializedName( "AssemblyScrapPercent" )
    @JsonProperty( "AssemblyScrapPercent" )
    @Nullable
    @ODataField( odataName = "AssemblyScrapPercent" )
    private BigDecimal assemblyScrapPercent;
    /**
     * Use with available fluent helpers to apply the <b>AssemblyScrapPercent</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> ASSEMBLY_SCRAP_PERCENT =
        new MRPMaterialField<BigDecimal>("AssemblyScrapPercent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaktTime</b>
     * </p>
     *
     * @return Takt time
     */
    @SerializedName( "TaktTime" )
    @JsonProperty( "TaktTime" )
    @Nullable
    @ODataField( odataName = "TaktTime" )
    private BigDecimal taktTime;
    /**
     * Use with available fluent helpers to apply the <b>TaktTime</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> TAKT_TIME = new MRPMaterialField<BigDecimal>("TaktTime");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurOrderQtyRoundingQty</b>
     * </p>
     *
     * @return Rounding value for purchase order quantity
     */
    @SerializedName( "PurOrderQtyRoundingQty" )
    @JsonProperty( "PurOrderQtyRoundingQty" )
    @Nullable
    @ODataField( odataName = "PurOrderQtyRoundingQty" )
    private BigDecimal purOrderQtyRoundingQty;
    /**
     * Use with available fluent helpers to apply the <b>PurOrderQtyRoundingQty</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> PUR_ORDER_QTY_ROUNDING_QTY =
        new MRPMaterialField<BigDecimal>("PurOrderQtyRoundingQty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RoundingProfile</b>
     * </p>
     *
     * @return Rounding Profile
     */
    @SerializedName( "RoundingProfile" )
    @JsonProperty( "RoundingProfile" )
    @Nullable
    @ODataField( odataName = "RoundingProfile" )
    private String roundingProfile;
    /**
     * Use with available fluent helpers to apply the <b>RoundingProfile</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> ROUNDING_PROFILE = new MRPMaterialField<String>("RoundingProfile");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningStrategyGroup</b>
     * </p>
     *
     * @return Planning Strategy Group
     */
    @SerializedName( "PlanningStrategyGroup" )
    @JsonProperty( "PlanningStrategyGroup" )
    @Nullable
    @ODataField( odataName = "PlanningStrategyGroup" )
    private String planningStrategyGroup;
    /**
     * Use with available fluent helpers to apply the <b>PlanningStrategyGroup</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> PLANNING_STRATEGY_GROUP =
        new MRPMaterialField<String>("PlanningStrategyGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DfltStorageLocationExtProcmt</b>
     * </p>
     *
     * @return Default Storage Location for External Procurement
     */
    @SerializedName( "DfltStorageLocationExtProcmt" )
    @JsonProperty( "DfltStorageLocationExtProcmt" )
    @Nullable
    @ODataField( odataName = "DfltStorageLocationExtProcmt" )
    private String dfltStorageLocationExtProcmt;
    /**
     * Use with available fluent helpers to apply the <b>DfltStorageLocationExtProcmt</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> DFLT_STORAGE_LOCATION_EXT_PROCMT =
        new MRPMaterialField<String>("DfltStorageLocationExtProcmt");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningCalendar</b>
     * </p>
     *
     * @return Planning Calendar
     */
    @SerializedName( "MRPPlanningCalendar" )
    @JsonProperty( "MRPPlanningCalendar" )
    @Nullable
    @ODataField( odataName = "MRPPlanningCalendar" )
    private String mRPPlanningCalendar;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlanningCalendar</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_PLANNING_CALENDAR =
        new MRPMaterialField<String>("MRPPlanningCalendar");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveManufacturingIsAllwd</b>
     * </p>
     *
     * @return Indicator: Repetitive Manufacturing Allowed
     */
    @SerializedName( "RepetitiveManufacturingIsAllwd" )
    @JsonProperty( "RepetitiveManufacturingIsAllwd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RepetitiveManufacturingIsAllwd" )
    private Boolean repetitiveManufacturingIsAllwd;
    /**
     * Use with available fluent helpers to apply the <b>RepetitiveManufacturingIsAllwd</b> field to query operations.
     *
     */
    public final static MRPMaterialField<Boolean> REPETITIVE_MANUFACTURING_IS_ALLWD =
        new MRPMaterialField<Boolean>("RepetitiveManufacturingIsAllwd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveManufacturingProfile</b>
     * </p>
     *
     * @return Repetitive Manufacturing Profile
     */
    @SerializedName( "RepetitiveManufacturingProfile" )
    @JsonProperty( "RepetitiveManufacturingProfile" )
    @Nullable
    @ODataField( odataName = "RepetitiveManufacturingProfile" )
    private String repetitiveManufacturingProfile;
    /**
     * Use with available fluent helpers to apply the <b>RepetitiveManufacturingProfile</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> REPETITIVE_MANUFACTURING_PROFILE =
        new MRPMaterialField<String>("RepetitiveManufacturingProfile");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTimeFenceInDays</b>
     * </p>
     *
     * @return Planning time fence
     */
    @SerializedName( "PlanningTimeFenceInDays" )
    @JsonProperty( "PlanningTimeFenceInDays" )
    @Nullable
    @ODataField( odataName = "PlanningTimeFenceInDays" )
    private String planningTimeFenceInDays;
    /**
     * Use with available fluent helpers to apply the <b>PlanningTimeFenceInDays</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> PLANNING_TIME_FENCE_IN_DAYS =
        new MRPMaterialField<String>("PlanningTimeFenceInDays");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @return MRP Type
     */
    @SerializedName( "MRPType" )
    @JsonProperty( "MRPType" )
    @Nullable
    @ODataField( odataName = "MRPType" )
    private String mRPType;
    /**
     * Use with available fluent helpers to apply the <b>MRPType</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_TYPE = new MRPMaterialField<String>("MRPType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MRPTypeName</b>
     * </p>
     *
     * @return Material Requirements Planning Type Description
     */
    @SerializedName( "MRPTypeName" )
    @JsonProperty( "MRPTypeName" )
    @Nullable
    @ODataField( odataName = "MRPTypeName" )
    private String mRPTypeName;
    /**
     * Use with available fluent helpers to apply the <b>MRPTypeName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_TYPE_NAME = new MRPMaterialField<String>("MRPTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementProfile</b>
     * </p>
     *
     * @return Special Procurement Type
     */
    @SerializedName( "MaterialProcurementProfile" )
    @JsonProperty( "MaterialProcurementProfile" )
    @Nullable
    @ODataField( odataName = "MaterialProcurementProfile" )
    private String materialProcurementProfile;
    /**
     * Use with available fluent helpers to apply the <b>MaterialProcurementProfile</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_PROCUREMENT_PROFILE =
        new MRPMaterialField<String>("MaterialProcurementProfile");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementProfileName</b>
     * </p>
     *
     * @return Material Procurement Profile Name
     */
    @SerializedName( "MaterialProcurementProfileName" )
    @JsonProperty( "MaterialProcurementProfileName" )
    @Nullable
    @ODataField( odataName = "MaterialProcurementProfileName" )
    private String materialProcurementProfileName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialProcurementProfileName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MATERIAL_PROCUREMENT_PROFILE_NAME =
        new MRPMaterialField<String>("MaterialProcurementProfileName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupervisor</b>
     * </p>
     *
     * @return Production Supervisor
     */
    @SerializedName( "ProductionSupervisor" )
    @JsonProperty( "ProductionSupervisor" )
    @Nullable
    @ODataField( odataName = "ProductionSupervisor" )
    private String productionSupervisor;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupervisor</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> PRODUCTION_SUPERVISOR =
        new MRPMaterialField<String>("ProductionSupervisor");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupervisorName</b>
     * </p>
     *
     * @return Production Supervisor Name
     */
    @SerializedName( "ProductionSupervisorName" )
    @JsonProperty( "ProductionSupervisorName" )
    @Nullable
    @ODataField( odataName = "ProductionSupervisorName" )
    private String productionSupervisorName;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupervisorName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> PRODUCTION_SUPERVISOR_NAME =
        new MRPMaterialField<String>("ProductionSupervisorName");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseQuantity</b>
     * </p>
     *
     * @return Base quantity
     */
    @SerializedName( "MaterialBaseQuantity" )
    @JsonProperty( "MaterialBaseQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialBaseQuantity" )
    private BigDecimal materialBaseQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseQuantity</b> field to query operations.
     *
     */
    public final static MRPMaterialField<BigDecimal> MATERIAL_BASE_QUANTITY =
        new MRPMaterialField<BigDecimal>("MaterialBaseQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionInvtryManagedLoc</b>
     * </p>
     *
     * @return Issue Storage Location
     */
    @SerializedName( "ProductionInvtryManagedLoc" )
    @JsonProperty( "ProductionInvtryManagedLoc" )
    @Nullable
    @ODataField( odataName = "ProductionInvtryManagedLoc" )
    private String productionInvtryManagedLoc;
    /**
     * Use with available fluent helpers to apply the <b>ProductionInvtryManagedLoc</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> PRODUCTION_INVTRY_MANAGED_LOC =
        new MRPMaterialField<String>("ProductionInvtryManagedLoc");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocationName</b>
     * </p>
     *
     * @return Storage Location Name
     */
    @SerializedName( "StorageLocationName" )
    @JsonProperty( "StorageLocationName" )
    @Nullable
    @ODataField( odataName = "StorageLocationName" )
    private String storageLocationName;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocationName</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> STORAGE_LOCATION_NAME =
        new MRPMaterialField<String>("StorageLocationName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Authorization Group
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> AUTHORIZATION_GROUP =
        new MRPMaterialField<String>("AuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPSafetyStockMethod</b>
     * </p>
     *
     * @return MRP Safety Stock Method
     */
    @SerializedName( "MRPSafetyStockMethod" )
    @JsonProperty( "MRPSafetyStockMethod" )
    @Nullable
    @ODataField( odataName = "MRPSafetyStockMethod" )
    private String mRPSafetyStockMethod;
    /**
     * Use with available fluent helpers to apply the <b>MRPSafetyStockMethod</b> field to query operations.
     *
     */
    public final static MRPMaterialField<String> MRP_SAFETY_STOCK_METHOD =
        new MRPMaterialField<String>("MRPSafetyStockMethod");

    @Nonnull
    @Override
    public Class<MRPMaterial> getType()
    {
        return MRPMaterial.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @param mRPPlant
     *            Plant
     */
    public void setMRPPlant( @Nullable final String mRPPlant )
    {
        rememberChangedField("MRPPlant", this.mRPPlant);
        this.mRPPlant = mRPPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            Product Description
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @param plantName
     *            Plant Name
     */
    public void setPlantName( @Nullable final String plantName )
    {
        rememberChangedField("PlantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MRPAreaText</b>
     * </p>
     *
     * @param mRPAreaText
     *            MRP Area Text
     */
    public void setMRPAreaText( @Nullable final String mRPAreaText )
    {
        rememberChangedField("MRPAreaText", this.mRPAreaText);
        this.mRPAreaText = mRPAreaText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPAreaCategory</b>
     * </p>
     *
     * @param mRPAreaCategory
     *            MRP Area Category
     */
    public void setMRPAreaCategory( @Nullable final String mRPAreaCategory )
    {
        rememberChangedField("MRPAreaCategory", this.mRPAreaCategory);
        this.mRPAreaCategory = mRPAreaCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MRPAreaCategoryName</b>
     * </p>
     *
     * @param mRPAreaCategoryName
     *            MRP Area Category Name
     */
    public void setMRPAreaCategoryName( @Nullable final String mRPAreaCategoryName )
    {
        rememberChangedField("MRPAreaCategoryName", this.mRPAreaCategoryName);
        this.mRPAreaCategoryName = mRPAreaCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @param materialGroupName
     *            Product Group Description
     */
    public void setMaterialGroupName( @Nullable final String materialGroupName )
    {
        rememberChangedField("MaterialGroupName", this.materialGroupName);
        this.materialGroupName = materialGroupName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsMarkedForDeletion</b>
     * </p>
     *
     * @param materialIsMarkedForDeletion
     *            Deletion Indicator
     */
    public void setMaterialIsMarkedForDeletion( @Nullable final Boolean materialIsMarkedForDeletion )
    {
        rememberChangedField("MaterialIsMarkedForDeletion", this.materialIsMarkedForDeletion);
        this.materialIsMarkedForDeletion = materialIsMarkedForDeletion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlntMatlIsMarkedForDeletion</b>
     * </p>
     *
     * @param plntMatlIsMarkedForDeletion
     *            Flag Material for Deletion at Plant Level
     */
    public void setPlntMatlIsMarkedForDeletion( @Nullable final Boolean plntMatlIsMarkedForDeletion )
    {
        rememberChangedField("PlntMatlIsMarkedForDeletion", this.plntMatlIsMarkedForDeletion);
        this.plntMatlIsMarkedForDeletion = plntMatlIsMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantStatus</b>
     * </p>
     *
     * @param crossPlantStatus
     *            Cross-Plant Product Status
     */
    public void setCrossPlantStatus( @Nullable final String crossPlantStatus )
    {
        rememberChangedField("CrossPlantStatus", this.crossPlantStatus);
        this.crossPlantStatus = crossPlantStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantStatusName</b>
     * </p>
     *
     * @param crossPlantStatusName
     *            Cross Plant Status Text
     */
    public void setCrossPlantStatusName( @Nullable final String crossPlantStatusName )
    {
        rememberChangedField("CrossPlantStatusName", this.crossPlantStatusName);
        this.crossPlantStatusName = crossPlantStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureName</b>
     * </p>
     *
     * @param unitOfMeasureName
     *            Unit of Measurement Text (Maximum 10 Characters)
     */
    public void setUnitOfMeasureName( @Nullable final String unitOfMeasureName )
    {
        rememberChangedField("UnitOfMeasureName", this.unitOfMeasureName);
        this.unitOfMeasureName = unitOfMeasureName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LowLevelCode</b>
     * </p>
     *
     * @param lowLevelCode
     *            Low-Level Code
     */
    public void setLowLevelCode( @Nullable final String lowLevelCode )
    {
        rememberChangedField("LowLevelCode", this.lowLevelCode);
        this.lowLevelCode = lowLevelCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsConfigurable</b>
     * </p>
     *
     * @param materialIsConfigurable
     *            Product is Configurable
     */
    public void setMaterialIsConfigurable( @Nullable final Boolean materialIsConfigurable )
    {
        rememberChangedField("MaterialIsConfigurable", this.materialIsConfigurable);
        this.materialIsConfigurable = materialIsConfigurable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialUsabilityProfile</b>
     * </p>
     *
     * @param materialUsabilityProfile
     *            Plant-Specific Material Status
     */
    public void setMaterialUsabilityProfile( @Nullable final String materialUsabilityProfile )
    {
        rememberChangedField("MaterialUsabilityProfile", this.materialUsabilityProfile);
        this.materialUsabilityProfile = materialUsabilityProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>MaterialUsabilityProfileName</b>
     * </p>
     *
     * @param materialUsabilityProfileName
     *            Cross Plant Status Text
     */
    public void setMaterialUsabilityProfileName( @Nullable final String materialUsabilityProfileName )
    {
        rememberChangedField("MaterialUsabilityProfileName", this.materialUsabilityProfileName);
        this.materialUsabilityProfileName = materialUsabilityProfileName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialABCClassification</b>
     * </p>
     *
     * @param materialABCClassification
     *            ABC Indicator
     */
    public void setMaterialABCClassification( @Nullable final String materialABCClassification )
    {
        rememberChangedField("MaterialABCClassification", this.materialABCClassification);
        this.materialABCClassification = materialABCClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaterialABCClassificationDesc</b>
     * </p>
     *
     * @param materialABCClassificationDesc
     *            Consumption Value Category Text
     */
    public void setMaterialABCClassificationDesc( @Nullable final String materialABCClassificationDesc )
    {
        rememberChangedField("MaterialABCClassificationDesc", this.materialABCClassificationDesc);
        this.materialABCClassificationDesc = materialABCClassificationDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroupName</b>
     * </p>
     *
     * @param purchasingGroupName
     *            Purchasing Group Name
     */
    public void setPurchasingGroupName( @Nullable final String purchasingGroupName )
    {
        rememberChangedField("PurchasingGroupName", this.purchasingGroupName);
        this.purchasingGroupName = purchasingGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementCategory</b>
     * </p>
     *
     * @param materialProcurementCategory
     *            Procurement Type
     */
    public void setMaterialProcurementCategory( @Nullable final String materialProcurementCategory )
    {
        rememberChangedField("MaterialProcurementCategory", this.materialProcurementCategory);
        this.materialProcurementCategory = materialProcurementCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementCatName</b>
     * </p>
     *
     * @param materialProcurementCatName
     *            Material Procurement Category Name
     */
    public void setMaterialProcurementCatName( @Nullable final String materialProcurementCatName )
    {
        rememberChangedField("MaterialProcurementCatName", this.materialProcurementCatName);
        this.materialProcurementCatName = materialProcurementCatName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DependentRequirementsType</b>
     * </p>
     *
     * @param dependentRequirementsType
     *            Indicator for Individual and Collective Requirements
     */
    public void setDependentRequirementsType( @Nullable final String dependentRequirementsType )
    {
        rememberChangedField("DependentRequirementsType", this.dependentRequirementsType);
        this.dependentRequirementsType = dependentRequirementsType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DependentRequirementsTypeName</b>
     * </p>
     *
     * @param dependentRequirementsTypeName
     *            Short Text for Fixed Values
     */
    public void setDependentRequirementsTypeName( @Nullable final String dependentRequirementsTypeName )
    {
        rememberChangedField("DependentRequirementsTypeName", this.dependentRequirementsTypeName);
        this.dependentRequirementsTypeName = dependentRequirementsTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompDiscontinuationType</b>
     * </p>
     *
     * @param matlCompDiscontinuationType
     *            The matlCompDiscontinuationType to set.
     */
    public void setMatlCompDiscontinuationType( @Nullable final String matlCompDiscontinuationType )
    {
        rememberChangedField("MatlCompDiscontinuationType", this.matlCompDiscontinuationType);
        this.matlCompDiscontinuationType = matlCompDiscontinuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompDscontnTypeName</b>
     * </p>
     *
     * @param matlCompDscontnTypeName
     *            Short Text for Fixed Values
     */
    public void setMatlCompDscontnTypeName( @Nullable final String matlCompDscontnTypeName )
    {
        rememberChangedField("MatlCompDscontnTypeName", this.matlCompDscontnTypeName);
        this.matlCompDscontnTypeName = matlCompDscontnTypeName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EffectiveOutDate</b>
     * </p>
     *
     * @param effectiveOutDate
     *            Effective-Out Date
     */
    public void setEffectiveOutDate( @Nullable final LocalDateTime effectiveOutDate )
    {
        rememberChangedField("EffectiveOutDate", this.effectiveOutDate);
        this.effectiveOutDate = effectiveOutDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialType</b>
     * </p>
     *
     * @param materialType
     *            Product Type
     */
    public void setMaterialType( @Nullable final String materialType )
    {
        rememberChangedField("MaterialType", this.materialType);
        this.materialType = materialType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>MaterialTypeName</b>
     * </p>
     *
     * @param materialTypeName
     *            Description of product type
     */
    public void setMaterialTypeName( @Nullable final String materialTypeName )
    {
        rememberChangedField("MaterialTypeName", this.materialTypeName);
        this.materialTypeName = materialTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroup</b>
     * </p>
     *
     * @param mRPGroup
     *            MRP Group
     */
    public void setMRPGroup( @Nullable final String mRPGroup )
    {
        rememberChangedField("MRPGroup", this.mRPGroup);
        this.mRPGroup = mRPGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroupName</b>
     * </p>
     *
     * @param mRPGroupName
     *            MRP Group Description
     */
    public void setMRPGroupName( @Nullable final String mRPGroupName )
    {
        rememberChangedField("MRPGroupName", this.mRPGroupName);
        this.mRPGroupName = mRPGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            MRP Controller
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MRPControllerName</b>
     * </p>
     *
     * @param mRPControllerName
     *            MRP Controller Name
     */
    public void setMRPControllerName( @Nullable final String mRPControllerName )
    {
        rememberChangedField("MRPControllerName", this.mRPControllerName);
        this.mRPControllerName = mRPControllerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RangeOfCvrgPrflCode</b>
     * </p>
     *
     * @param rangeOfCvrgPrflCode
     *            Range-of-Coverage Profile
     */
    public void setRangeOfCvrgPrflCode( @Nullable final String rangeOfCvrgPrflCode )
    {
        rememberChangedField("RangeOfCvrgPrflCode", this.rangeOfCvrgPrflCode);
        this.rangeOfCvrgPrflCode = rangeOfCvrgPrflCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingFloatProfile</b>
     * </p>
     *
     * @param schedulingFloatProfile
     *            Scheduling Margin Key for Floats
     */
    public void setSchedulingFloatProfile( @Nullable final String schedulingFloatProfile )
    {
        rememberChangedField("SchedulingFloatProfile", this.schedulingFloatProfile);
        this.schedulingFloatProfile = schedulingFloatProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurableProduct</b>
     * </p>
     *
     * @param configurableProduct
     *            Configurable Material
     */
    public void setConfigurableProduct( @Nullable final String configurableProduct )
    {
        rememberChangedField("ConfigurableProduct", this.configurableProduct);
        this.configurableProduct = configurableProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurableProductName</b>
     * </p>
     *
     * @param configurableProductName
     *            Product Description
     */
    public void setConfigurableProductName( @Nullable final String configurableProductName )
    {
        rememberChangedField("ConfigurableProductName", this.configurableProductName);
        this.configurableProductName = configurableProductName;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingTime</b>
     * </p>
     *
     * @param processingTime
     *            Processing time
     */
    public void setProcessingTime( @Nullable final BigDecimal processingTime )
    {
        rememberChangedField("ProcessingTime", this.processingTime);
        this.processingTime = processingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SetupAndTeardownTime</b>
     * </p>
     *
     * @param setupAndTeardownTime
     *            Setup and teardown time
     */
    public void setSetupAndTeardownTime( @Nullable final BigDecimal setupAndTeardownTime )
    {
        rememberChangedField("SetupAndTeardownTime", this.setupAndTeardownTime);
        this.setupAndTeardownTime = setupAndTeardownTime;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>TransitionTime</b>
     * </p>
     *
     * @param transitionTime
     *            Interoperation time
     */
    public void setTransitionTime( @Nullable final BigDecimal transitionTime )
    {
        rememberChangedField("TransitionTime", this.transitionTime);
        this.transitionTime = transitionTime;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @param goodsReceiptDuration
     *            Goods receipt processing time in days
     */
    public void setGoodsReceiptDuration( @Nullable final BigDecimal goodsReceiptDuration )
    {
        rememberChangedField("GoodsReceiptDuration", this.goodsReceiptDuration);
        this.goodsReceiptDuration = goodsReceiptDuration;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedDeliveryDurn</b>
     * </p>
     *
     * @param materialPlannedDeliveryDurn
     *            Planned Delivery Time in Days
     */
    public void setMaterialPlannedDeliveryDurn( @Nullable final BigDecimal materialPlannedDeliveryDurn )
    {
        rememberChangedField("MaterialPlannedDeliveryDurn", this.materialPlannedDeliveryDurn);
        this.materialPlannedDeliveryDurn = materialPlannedDeliveryDurn;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedProductionDurn</b>
     * </p>
     *
     * @param materialPlannedProductionDurn
     *            In-house production time
     */
    public void setMaterialPlannedProductionDurn( @Nullable final BigDecimal materialPlannedProductionDurn )
    {
        rememberChangedField("MaterialPlannedProductionDurn", this.materialPlannedProductionDurn);
        this.materialPlannedProductionDurn = materialPlannedProductionDurn;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalReplenishmentLeadDuration</b>
     * </p>
     *
     * @param totalReplenishmentLeadDuration
     *            Total replenishment lead time (in workdays)
     */
    public void setTotalReplenishmentLeadDuration( @Nullable final BigDecimal totalReplenishmentLeadDuration )
    {
        rememberChangedField("TotalReplenishmentLeadDuration", this.totalReplenishmentLeadDuration);
        this.totalReplenishmentLeadDuration = totalReplenishmentLeadDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSafetyTime</b>
     * </p>
     *
     * @param isSafetyTime
     *            Safety Time Indicator (with or without safety time)
     */
    public void setIsSafetyTime( @Nullable final String isSafetyTime )
    {
        rememberChangedField("IsSafetyTime", this.isSafetyTime);
        this.isSafetyTime = isSafetyTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPSafetyDuration</b>
     * </p>
     *
     * @param mRPSafetyDuration
     *            Safety Time (in Workdays)
     */
    public void setMRPSafetyDuration( @Nullable final String mRPSafetyDuration )
    {
        rememberChangedField("MRPSafetyDuration", this.mRPSafetyDuration);
        this.mRPSafetyDuration = mRPSafetyDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PerdPrflForSftyTme</b>
     * </p>
     *
     * @param perdPrflForSftyTme
     *            Period Profile for Safety Time
     */
    public void setPerdPrflForSftyTme( @Nullable final String perdPrflForSftyTme )
    {
        rememberChangedField("PerdPrflForSftyTme", this.perdPrflForSftyTme);
        this.perdPrflForSftyTme = perdPrflForSftyTme;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @param reorderThresholdQuantity
     *            The reorderThresholdQuantity to set.
     */
    public void setReorderThresholdQuantity( @Nullable final BigDecimal reorderThresholdQuantity )
    {
        rememberChangedField("ReorderThresholdQuantity", this.reorderThresholdQuantity);
        this.reorderThresholdQuantity = reorderThresholdQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SafetyStockQuantity</b>
     * </p>
     *
     * @param safetyStockQuantity
     *            The safetyStockQuantity to set.
     */
    public void setSafetyStockQuantity( @Nullable final BigDecimal safetyStockQuantity )
    {
        rememberChangedField("SafetyStockQuantity", this.safetyStockQuantity);
        this.safetyStockQuantity = safetyStockQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LotSizingProcedure</b>
     * </p>
     *
     * @param lotSizingProcedure
     *            Lot Sizing Procedure in Materials Planning
     */
    public void setLotSizingProcedure( @Nullable final String lotSizingProcedure )
    {
        rememberChangedField("LotSizingProcedure", this.lotSizingProcedure);
        this.lotSizingProcedure = lotSizingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialLotSizingProcedureName</b>
     * </p>
     *
     * @param materialLotSizingProcedureName
     *            Name of Lot-Sizing Procedure
     */
    public void setMaterialLotSizingProcedureName( @Nullable final String materialLotSizingProcedureName )
    {
        rememberChangedField("MaterialLotSizingProcedureName", this.materialLotSizingProcedureName);
        this.materialLotSizingProcedureName = materialLotSizingProcedureName;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @param minimumLotSizeQuantity
     *            Minimum Lot Size
     */
    public void setMinimumLotSizeQuantity( @Nullable final BigDecimal minimumLotSizeQuantity )
    {
        rememberChangedField("MinimumLotSizeQuantity", this.minimumLotSizeQuantity);
        this.minimumLotSizeQuantity = minimumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @param maximumLotSizeQuantity
     *            Maximum Lot Size
     */
    public void setMaximumLotSizeQuantity( @Nullable final BigDecimal maximumLotSizeQuantity )
    {
        rememberChangedField("MaximumLotSizeQuantity", this.maximumLotSizeQuantity);
        this.maximumLotSizeQuantity = maximumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @param fixedLotSizeQuantity
     *            Fixed lot size
     */
    public void setFixedLotSizeQuantity( @Nullable final BigDecimal fixedLotSizeQuantity )
    {
        rememberChangedField("FixedLotSizeQuantity", this.fixedLotSizeQuantity);
        this.fixedLotSizeQuantity = fixedLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMaxStockLevelQuantity</b>
     * </p>
     *
     * @param materialMaxStockLevelQuantity
     *            Maximum Stock Level
     */
    public void setMaterialMaxStockLevelQuantity( @Nullable final BigDecimal materialMaxStockLevelQuantity )
    {
        rememberChangedField("MaterialMaxStockLevelQuantity", this.materialMaxStockLevelQuantity);
        this.materialMaxStockLevelQuantity = materialMaxStockLevelQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeIndependentCosts</b>
     * </p>
     *
     * @param lotSizeIndependentCosts
     *            Lot-Size-Independent Costs
     */
    public void setLotSizeIndependentCosts( @Nullable final BigDecimal lotSizeIndependentCosts )
    {
        rememberChangedField("LotSizeIndependentCosts", this.lotSizeIndependentCosts);
        this.lotSizeIndependentCosts = lotSizeIndependentCosts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StorageCostsPercentageCode</b>
     * </p>
     *
     * @param storageCostsPercentageCode
     *            Storage Costs Percentage Code
     */
    public void setStorageCostsPercentageCode( @Nullable final String storageCostsPercentageCode )
    {
        rememberChangedField("StorageCostsPercentageCode", this.storageCostsPercentageCode);
        this.storageCostsPercentageCode = storageCostsPercentageCode;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyScrapPercent</b>
     * </p>
     *
     * @param assemblyScrapPercent
     *            Assembly scrap in percent
     */
    public void setAssemblyScrapPercent( @Nullable final BigDecimal assemblyScrapPercent )
    {
        rememberChangedField("AssemblyScrapPercent", this.assemblyScrapPercent);
        this.assemblyScrapPercent = assemblyScrapPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaktTime</b>
     * </p>
     *
     * @param taktTime
     *            Takt time
     */
    public void setTaktTime( @Nullable final BigDecimal taktTime )
    {
        rememberChangedField("TaktTime", this.taktTime);
        this.taktTime = taktTime;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurOrderQtyRoundingQty</b>
     * </p>
     *
     * @param purOrderQtyRoundingQty
     *            Rounding value for purchase order quantity
     */
    public void setPurOrderQtyRoundingQty( @Nullable final BigDecimal purOrderQtyRoundingQty )
    {
        rememberChangedField("PurOrderQtyRoundingQty", this.purOrderQtyRoundingQty);
        this.purOrderQtyRoundingQty = purOrderQtyRoundingQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RoundingProfile</b>
     * </p>
     *
     * @param roundingProfile
     *            Rounding Profile
     */
    public void setRoundingProfile( @Nullable final String roundingProfile )
    {
        rememberChangedField("RoundingProfile", this.roundingProfile);
        this.roundingProfile = roundingProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningStrategyGroup</b>
     * </p>
     *
     * @param planningStrategyGroup
     *            Planning Strategy Group
     */
    public void setPlanningStrategyGroup( @Nullable final String planningStrategyGroup )
    {
        rememberChangedField("PlanningStrategyGroup", this.planningStrategyGroup);
        this.planningStrategyGroup = planningStrategyGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DfltStorageLocationExtProcmt</b>
     * </p>
     *
     * @param dfltStorageLocationExtProcmt
     *            Default Storage Location for External Procurement
     */
    public void setDfltStorageLocationExtProcmt( @Nullable final String dfltStorageLocationExtProcmt )
    {
        rememberChangedField("DfltStorageLocationExtProcmt", this.dfltStorageLocationExtProcmt);
        this.dfltStorageLocationExtProcmt = dfltStorageLocationExtProcmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningCalendar</b>
     * </p>
     *
     * @param mRPPlanningCalendar
     *            Planning Calendar
     */
    public void setMRPPlanningCalendar( @Nullable final String mRPPlanningCalendar )
    {
        rememberChangedField("MRPPlanningCalendar", this.mRPPlanningCalendar);
        this.mRPPlanningCalendar = mRPPlanningCalendar;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveManufacturingIsAllwd</b>
     * </p>
     *
     * @param repetitiveManufacturingIsAllwd
     *            Indicator: Repetitive Manufacturing Allowed
     */
    public void setRepetitiveManufacturingIsAllwd( @Nullable final Boolean repetitiveManufacturingIsAllwd )
    {
        rememberChangedField("RepetitiveManufacturingIsAllwd", this.repetitiveManufacturingIsAllwd);
        this.repetitiveManufacturingIsAllwd = repetitiveManufacturingIsAllwd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveManufacturingProfile</b>
     * </p>
     *
     * @param repetitiveManufacturingProfile
     *            Repetitive Manufacturing Profile
     */
    public void setRepetitiveManufacturingProfile( @Nullable final String repetitiveManufacturingProfile )
    {
        rememberChangedField("RepetitiveManufacturingProfile", this.repetitiveManufacturingProfile);
        this.repetitiveManufacturingProfile = repetitiveManufacturingProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTimeFenceInDays</b>
     * </p>
     *
     * @param planningTimeFenceInDays
     *            Planning time fence
     */
    public void setPlanningTimeFenceInDays( @Nullable final String planningTimeFenceInDays )
    {
        rememberChangedField("PlanningTimeFenceInDays", this.planningTimeFenceInDays);
        this.planningTimeFenceInDays = planningTimeFenceInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @param mRPType
     *            MRP Type
     */
    public void setMRPType( @Nullable final String mRPType )
    {
        rememberChangedField("MRPType", this.mRPType);
        this.mRPType = mRPType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MRPTypeName</b>
     * </p>
     *
     * @param mRPTypeName
     *            Material Requirements Planning Type Description
     */
    public void setMRPTypeName( @Nullable final String mRPTypeName )
    {
        rememberChangedField("MRPTypeName", this.mRPTypeName);
        this.mRPTypeName = mRPTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementProfile</b>
     * </p>
     *
     * @param materialProcurementProfile
     *            Special Procurement Type
     */
    public void setMaterialProcurementProfile( @Nullable final String materialProcurementProfile )
    {
        rememberChangedField("MaterialProcurementProfile", this.materialProcurementProfile);
        this.materialProcurementProfile = materialProcurementProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementProfileName</b>
     * </p>
     *
     * @param materialProcurementProfileName
     *            Material Procurement Profile Name
     */
    public void setMaterialProcurementProfileName( @Nullable final String materialProcurementProfileName )
    {
        rememberChangedField("MaterialProcurementProfileName", this.materialProcurementProfileName);
        this.materialProcurementProfileName = materialProcurementProfileName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupervisor</b>
     * </p>
     *
     * @param productionSupervisor
     *            Production Supervisor
     */
    public void setProductionSupervisor( @Nullable final String productionSupervisor )
    {
        rememberChangedField("ProductionSupervisor", this.productionSupervisor);
        this.productionSupervisor = productionSupervisor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupervisorName</b>
     * </p>
     *
     * @param productionSupervisorName
     *            Production Supervisor Name
     */
    public void setProductionSupervisorName( @Nullable final String productionSupervisorName )
    {
        rememberChangedField("ProductionSupervisorName", this.productionSupervisorName);
        this.productionSupervisorName = productionSupervisorName;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseQuantity</b>
     * </p>
     *
     * @param materialBaseQuantity
     *            Base quantity
     */
    public void setMaterialBaseQuantity( @Nullable final BigDecimal materialBaseQuantity )
    {
        rememberChangedField("MaterialBaseQuantity", this.materialBaseQuantity);
        this.materialBaseQuantity = materialBaseQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionInvtryManagedLoc</b>
     * </p>
     *
     * @param productionInvtryManagedLoc
     *            Issue Storage Location
     */
    public void setProductionInvtryManagedLoc( @Nullable final String productionInvtryManagedLoc )
    {
        rememberChangedField("ProductionInvtryManagedLoc", this.productionInvtryManagedLoc);
        this.productionInvtryManagedLoc = productionInvtryManagedLoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocationName</b>
     * </p>
     *
     * @param storageLocationName
     *            Storage Location Name
     */
    public void setStorageLocationName( @Nullable final String storageLocationName )
    {
        rememberChangedField("StorageLocationName", this.storageLocationName);
        this.storageLocationName = storageLocationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPSafetyStockMethod</b>
     * </p>
     *
     * @param mRPSafetyStockMethod
     *            MRP Safety Stock Method
     */
    public void setMRPSafetyStockMethod( @Nullable final String mRPSafetyStockMethod )
    {
        rememberChangedField("MRPSafetyStockMethod", this.mRPSafetyStockMethod);
        this.mRPSafetyStockMethod = mRPSafetyStockMethod;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_MRPMaterial";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("MRPPlant", getMRPPlant());
        result.put("MRPArea", getMRPArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("MRPPlant", getMRPPlant());
        values.put("MRPArea", getMRPArea());
        values.put("MaterialName", getMaterialName());
        values.put("PlantName", getPlantName());
        values.put("MRPAreaText", getMRPAreaText());
        values.put("MRPAreaCategory", getMRPAreaCategory());
        values.put("MRPAreaCategoryName", getMRPAreaCategoryName());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialGroupName", getMaterialGroupName());
        values.put("MaterialIsMarkedForDeletion", getMaterialIsMarkedForDeletion());
        values.put("PlntMatlIsMarkedForDeletion", getPlntMatlIsMarkedForDeletion());
        values.put("CrossPlantStatus", getCrossPlantStatus());
        values.put("CrossPlantStatusName", getCrossPlantStatusName());
        values.put("BaseUnit", getBaseUnit());
        values.put("UnitOfMeasureName", getUnitOfMeasureName());
        values.put("LowLevelCode", getLowLevelCode());
        values.put("MaterialIsConfigurable", getMaterialIsConfigurable());
        values.put("MaterialUsabilityProfile", getMaterialUsabilityProfile());
        values.put("MaterialUsabilityProfileName", getMaterialUsabilityProfileName());
        values.put("MaterialABCClassification", getMaterialABCClassification());
        values.put("MaterialABCClassificationDesc", getMaterialABCClassificationDesc());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurchasingGroupName", getPurchasingGroupName());
        values.put("MaterialProcurementCategory", getMaterialProcurementCategory());
        values.put("MaterialProcurementCatName", getMaterialProcurementCatName());
        values.put("DependentRequirementsType", getDependentRequirementsType());
        values.put("DependentRequirementsTypeName", getDependentRequirementsTypeName());
        values.put("MatlCompDiscontinuationType", getMatlCompDiscontinuationType());
        values.put("MatlCompDscontnTypeName", getMatlCompDscontnTypeName());
        values.put("EffectiveOutDate", getEffectiveOutDate());
        values.put("MaterialType", getMaterialType());
        values.put("MaterialTypeName", getMaterialTypeName());
        values.put("MRPGroup", getMRPGroup());
        values.put("MRPGroupName", getMRPGroupName());
        values.put("MRPController", getMRPController());
        values.put("MRPControllerName", getMRPControllerName());
        values.put("RangeOfCvrgPrflCode", getRangeOfCvrgPrflCode());
        values.put("SchedulingFloatProfile", getSchedulingFloatProfile());
        values.put("ConfigurableProduct", getConfigurableProduct());
        values.put("ConfigurableProductName", getConfigurableProductName());
        values.put("ProcessingTime", getProcessingTime());
        values.put("SetupAndTeardownTime", getSetupAndTeardownTime());
        values.put("TransitionTime", getTransitionTime());
        values.put("GoodsReceiptDuration", getGoodsReceiptDuration());
        values.put("MaterialPlannedDeliveryDurn", getMaterialPlannedDeliveryDurn());
        values.put("MaterialPlannedProductionDurn", getMaterialPlannedProductionDurn());
        values.put("TotalReplenishmentLeadDuration", getTotalReplenishmentLeadDuration());
        values.put("IsSafetyTime", getIsSafetyTime());
        values.put("MRPSafetyDuration", getMRPSafetyDuration());
        values.put("PerdPrflForSftyTme", getPerdPrflForSftyTme());
        values.put("ReorderThresholdQuantity", getReorderThresholdQuantity());
        values.put("SafetyStockQuantity", getSafetyStockQuantity());
        values.put("LotSizingProcedure", getLotSizingProcedure());
        values.put("MaterialLotSizingProcedureName", getMaterialLotSizingProcedureName());
        values.put("MinimumLotSizeQuantity", getMinimumLotSizeQuantity());
        values.put("MaximumLotSizeQuantity", getMaximumLotSizeQuantity());
        values.put("FixedLotSizeQuantity", getFixedLotSizeQuantity());
        values.put("MaterialMaxStockLevelQuantity", getMaterialMaxStockLevelQuantity());
        values.put("LotSizeIndependentCosts", getLotSizeIndependentCosts());
        values.put("Currency", getCurrency());
        values.put("StorageCostsPercentageCode", getStorageCostsPercentageCode());
        values.put("AssemblyScrapPercent", getAssemblyScrapPercent());
        values.put("TaktTime", getTaktTime());
        values.put("PurOrderQtyRoundingQty", getPurOrderQtyRoundingQty());
        values.put("RoundingProfile", getRoundingProfile());
        values.put("PlanningStrategyGroup", getPlanningStrategyGroup());
        values.put("DfltStorageLocationExtProcmt", getDfltStorageLocationExtProcmt());
        values.put("MRPPlanningCalendar", getMRPPlanningCalendar());
        values.put("RepetitiveManufacturingIsAllwd", getRepetitiveManufacturingIsAllwd());
        values.put("RepetitiveManufacturingProfile", getRepetitiveManufacturingProfile());
        values.put("PlanningTimeFenceInDays", getPlanningTimeFenceInDays());
        values.put("MRPType", getMRPType());
        values.put("MRPTypeName", getMRPTypeName());
        values.put("MaterialProcurementProfile", getMaterialProcurementProfile());
        values.put("MaterialProcurementProfileName", getMaterialProcurementProfileName());
        values.put("ProductionSupervisor", getProductionSupervisor());
        values.put("ProductionSupervisorName", getProductionSupervisorName());
        values.put("MaterialBaseQuantity", getMaterialBaseQuantity());
        values.put("ProductionInvtryManagedLoc", getProductionInvtryManagedLoc());
        values.put("StorageLocationName", getStorageLocationName());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("MRPSafetyStockMethod", getMRPSafetyStockMethod());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MRPPlant") ) {
                final Object value = values.remove("MRPPlant");
                if( (value == null) || (!value.equals(getMRPPlant())) ) {
                    setMRPPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("PlantName") ) {
                final Object value = values.remove("PlantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((String) value));
                }
            }
            if( values.containsKey("MRPAreaText") ) {
                final Object value = values.remove("MRPAreaText");
                if( (value == null) || (!value.equals(getMRPAreaText())) ) {
                    setMRPAreaText(((String) value));
                }
            }
            if( values.containsKey("MRPAreaCategory") ) {
                final Object value = values.remove("MRPAreaCategory");
                if( (value == null) || (!value.equals(getMRPAreaCategory())) ) {
                    setMRPAreaCategory(((String) value));
                }
            }
            if( values.containsKey("MRPAreaCategoryName") ) {
                final Object value = values.remove("MRPAreaCategoryName");
                if( (value == null) || (!value.equals(getMRPAreaCategoryName())) ) {
                    setMRPAreaCategoryName(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupName") ) {
                final Object value = values.remove("MaterialGroupName");
                if( (value == null) || (!value.equals(getMaterialGroupName())) ) {
                    setMaterialGroupName(((String) value));
                }
            }
            if( values.containsKey("MaterialIsMarkedForDeletion") ) {
                final Object value = values.remove("MaterialIsMarkedForDeletion");
                if( (value == null) || (!value.equals(getMaterialIsMarkedForDeletion())) ) {
                    setMaterialIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("PlntMatlIsMarkedForDeletion") ) {
                final Object value = values.remove("PlntMatlIsMarkedForDeletion");
                if( (value == null) || (!value.equals(getPlntMatlIsMarkedForDeletion())) ) {
                    setPlntMatlIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("CrossPlantStatus") ) {
                final Object value = values.remove("CrossPlantStatus");
                if( (value == null) || (!value.equals(getCrossPlantStatus())) ) {
                    setCrossPlantStatus(((String) value));
                }
            }
            if( values.containsKey("CrossPlantStatusName") ) {
                final Object value = values.remove("CrossPlantStatusName");
                if( (value == null) || (!value.equals(getCrossPlantStatusName())) ) {
                    setCrossPlantStatusName(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasureName") ) {
                final Object value = values.remove("UnitOfMeasureName");
                if( (value == null) || (!value.equals(getUnitOfMeasureName())) ) {
                    setUnitOfMeasureName(((String) value));
                }
            }
            if( values.containsKey("LowLevelCode") ) {
                final Object value = values.remove("LowLevelCode");
                if( (value == null) || (!value.equals(getLowLevelCode())) ) {
                    setLowLevelCode(((String) value));
                }
            }
            if( values.containsKey("MaterialIsConfigurable") ) {
                final Object value = values.remove("MaterialIsConfigurable");
                if( (value == null) || (!value.equals(getMaterialIsConfigurable())) ) {
                    setMaterialIsConfigurable(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialUsabilityProfile") ) {
                final Object value = values.remove("MaterialUsabilityProfile");
                if( (value == null) || (!value.equals(getMaterialUsabilityProfile())) ) {
                    setMaterialUsabilityProfile(((String) value));
                }
            }
            if( values.containsKey("MaterialUsabilityProfileName") ) {
                final Object value = values.remove("MaterialUsabilityProfileName");
                if( (value == null) || (!value.equals(getMaterialUsabilityProfileName())) ) {
                    setMaterialUsabilityProfileName(((String) value));
                }
            }
            if( values.containsKey("MaterialABCClassification") ) {
                final Object value = values.remove("MaterialABCClassification");
                if( (value == null) || (!value.equals(getMaterialABCClassification())) ) {
                    setMaterialABCClassification(((String) value));
                }
            }
            if( values.containsKey("MaterialABCClassificationDesc") ) {
                final Object value = values.remove("MaterialABCClassificationDesc");
                if( (value == null) || (!value.equals(getMaterialABCClassificationDesc())) ) {
                    setMaterialABCClassificationDesc(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroupName") ) {
                final Object value = values.remove("PurchasingGroupName");
                if( (value == null) || (!value.equals(getPurchasingGroupName())) ) {
                    setPurchasingGroupName(((String) value));
                }
            }
            if( values.containsKey("MaterialProcurementCategory") ) {
                final Object value = values.remove("MaterialProcurementCategory");
                if( (value == null) || (!value.equals(getMaterialProcurementCategory())) ) {
                    setMaterialProcurementCategory(((String) value));
                }
            }
            if( values.containsKey("MaterialProcurementCatName") ) {
                final Object value = values.remove("MaterialProcurementCatName");
                if( (value == null) || (!value.equals(getMaterialProcurementCatName())) ) {
                    setMaterialProcurementCatName(((String) value));
                }
            }
            if( values.containsKey("DependentRequirementsType") ) {
                final Object value = values.remove("DependentRequirementsType");
                if( (value == null) || (!value.equals(getDependentRequirementsType())) ) {
                    setDependentRequirementsType(((String) value));
                }
            }
            if( values.containsKey("DependentRequirementsTypeName") ) {
                final Object value = values.remove("DependentRequirementsTypeName");
                if( (value == null) || (!value.equals(getDependentRequirementsTypeName())) ) {
                    setDependentRequirementsTypeName(((String) value));
                }
            }
            if( values.containsKey("MatlCompDiscontinuationType") ) {
                final Object value = values.remove("MatlCompDiscontinuationType");
                if( (value == null) || (!value.equals(getMatlCompDiscontinuationType())) ) {
                    setMatlCompDiscontinuationType(((String) value));
                }
            }
            if( values.containsKey("MatlCompDscontnTypeName") ) {
                final Object value = values.remove("MatlCompDscontnTypeName");
                if( (value == null) || (!value.equals(getMatlCompDscontnTypeName())) ) {
                    setMatlCompDscontnTypeName(((String) value));
                }
            }
            if( values.containsKey("EffectiveOutDate") ) {
                final Object value = values.remove("EffectiveOutDate");
                if( (value == null) || (!value.equals(getEffectiveOutDate())) ) {
                    setEffectiveOutDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaterialType") ) {
                final Object value = values.remove("MaterialType");
                if( (value == null) || (!value.equals(getMaterialType())) ) {
                    setMaterialType(((String) value));
                }
            }
            if( values.containsKey("MaterialTypeName") ) {
                final Object value = values.remove("MaterialTypeName");
                if( (value == null) || (!value.equals(getMaterialTypeName())) ) {
                    setMaterialTypeName(((String) value));
                }
            }
            if( values.containsKey("MRPGroup") ) {
                final Object value = values.remove("MRPGroup");
                if( (value == null) || (!value.equals(getMRPGroup())) ) {
                    setMRPGroup(((String) value));
                }
            }
            if( values.containsKey("MRPGroupName") ) {
                final Object value = values.remove("MRPGroupName");
                if( (value == null) || (!value.equals(getMRPGroupName())) ) {
                    setMRPGroupName(((String) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("MRPControllerName") ) {
                final Object value = values.remove("MRPControllerName");
                if( (value == null) || (!value.equals(getMRPControllerName())) ) {
                    setMRPControllerName(((String) value));
                }
            }
            if( values.containsKey("RangeOfCvrgPrflCode") ) {
                final Object value = values.remove("RangeOfCvrgPrflCode");
                if( (value == null) || (!value.equals(getRangeOfCvrgPrflCode())) ) {
                    setRangeOfCvrgPrflCode(((String) value));
                }
            }
            if( values.containsKey("SchedulingFloatProfile") ) {
                final Object value = values.remove("SchedulingFloatProfile");
                if( (value == null) || (!value.equals(getSchedulingFloatProfile())) ) {
                    setSchedulingFloatProfile(((String) value));
                }
            }
            if( values.containsKey("ConfigurableProduct") ) {
                final Object value = values.remove("ConfigurableProduct");
                if( (value == null) || (!value.equals(getConfigurableProduct())) ) {
                    setConfigurableProduct(((String) value));
                }
            }
            if( values.containsKey("ConfigurableProductName") ) {
                final Object value = values.remove("ConfigurableProductName");
                if( (value == null) || (!value.equals(getConfigurableProductName())) ) {
                    setConfigurableProductName(((String) value));
                }
            }
            if( values.containsKey("ProcessingTime") ) {
                final Object value = values.remove("ProcessingTime");
                if( (value == null) || (!value.equals(getProcessingTime())) ) {
                    setProcessingTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("SetupAndTeardownTime") ) {
                final Object value = values.remove("SetupAndTeardownTime");
                if( (value == null) || (!value.equals(getSetupAndTeardownTime())) ) {
                    setSetupAndTeardownTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransitionTime") ) {
                final Object value = values.remove("TransitionTime");
                if( (value == null) || (!value.equals(getTransitionTime())) ) {
                    setTransitionTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("GoodsReceiptDuration") ) {
                final Object value = values.remove("GoodsReceiptDuration");
                if( (value == null) || (!value.equals(getGoodsReceiptDuration())) ) {
                    setGoodsReceiptDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialPlannedDeliveryDurn") ) {
                final Object value = values.remove("MaterialPlannedDeliveryDurn");
                if( (value == null) || (!value.equals(getMaterialPlannedDeliveryDurn())) ) {
                    setMaterialPlannedDeliveryDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialPlannedProductionDurn") ) {
                final Object value = values.remove("MaterialPlannedProductionDurn");
                if( (value == null) || (!value.equals(getMaterialPlannedProductionDurn())) ) {
                    setMaterialPlannedProductionDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("TotalReplenishmentLeadDuration") ) {
                final Object value = values.remove("TotalReplenishmentLeadDuration");
                if( (value == null) || (!value.equals(getTotalReplenishmentLeadDuration())) ) {
                    setTotalReplenishmentLeadDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("IsSafetyTime") ) {
                final Object value = values.remove("IsSafetyTime");
                if( (value == null) || (!value.equals(getIsSafetyTime())) ) {
                    setIsSafetyTime(((String) value));
                }
            }
            if( values.containsKey("MRPSafetyDuration") ) {
                final Object value = values.remove("MRPSafetyDuration");
                if( (value == null) || (!value.equals(getMRPSafetyDuration())) ) {
                    setMRPSafetyDuration(((String) value));
                }
            }
            if( values.containsKey("PerdPrflForSftyTme") ) {
                final Object value = values.remove("PerdPrflForSftyTme");
                if( (value == null) || (!value.equals(getPerdPrflForSftyTme())) ) {
                    setPerdPrflForSftyTme(((String) value));
                }
            }
            if( values.containsKey("ReorderThresholdQuantity") ) {
                final Object value = values.remove("ReorderThresholdQuantity");
                if( (value == null) || (!value.equals(getReorderThresholdQuantity())) ) {
                    setReorderThresholdQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SafetyStockQuantity") ) {
                final Object value = values.remove("SafetyStockQuantity");
                if( (value == null) || (!value.equals(getSafetyStockQuantity())) ) {
                    setSafetyStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("LotSizingProcedure") ) {
                final Object value = values.remove("LotSizingProcedure");
                if( (value == null) || (!value.equals(getLotSizingProcedure())) ) {
                    setLotSizingProcedure(((String) value));
                }
            }
            if( values.containsKey("MaterialLotSizingProcedureName") ) {
                final Object value = values.remove("MaterialLotSizingProcedureName");
                if( (value == null) || (!value.equals(getMaterialLotSizingProcedureName())) ) {
                    setMaterialLotSizingProcedureName(((String) value));
                }
            }
            if( values.containsKey("MinimumLotSizeQuantity") ) {
                final Object value = values.remove("MinimumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMinimumLotSizeQuantity())) ) {
                    setMinimumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumLotSizeQuantity") ) {
                final Object value = values.remove("MaximumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaximumLotSizeQuantity())) ) {
                    setMaximumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedLotSizeQuantity") ) {
                final Object value = values.remove("FixedLotSizeQuantity");
                if( (value == null) || (!value.equals(getFixedLotSizeQuantity())) ) {
                    setFixedLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialMaxStockLevelQuantity") ) {
                final Object value = values.remove("MaterialMaxStockLevelQuantity");
                if( (value == null) || (!value.equals(getMaterialMaxStockLevelQuantity())) ) {
                    setMaterialMaxStockLevelQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("LotSizeIndependentCosts") ) {
                final Object value = values.remove("LotSizeIndependentCosts");
                if( (value == null) || (!value.equals(getLotSizeIndependentCosts())) ) {
                    setLotSizeIndependentCosts(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("StorageCostsPercentageCode") ) {
                final Object value = values.remove("StorageCostsPercentageCode");
                if( (value == null) || (!value.equals(getStorageCostsPercentageCode())) ) {
                    setStorageCostsPercentageCode(((String) value));
                }
            }
            if( values.containsKey("AssemblyScrapPercent") ) {
                final Object value = values.remove("AssemblyScrapPercent");
                if( (value == null) || (!value.equals(getAssemblyScrapPercent())) ) {
                    setAssemblyScrapPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaktTime") ) {
                final Object value = values.remove("TaktTime");
                if( (value == null) || (!value.equals(getTaktTime())) ) {
                    setTaktTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurOrderQtyRoundingQty") ) {
                final Object value = values.remove("PurOrderQtyRoundingQty");
                if( (value == null) || (!value.equals(getPurOrderQtyRoundingQty())) ) {
                    setPurOrderQtyRoundingQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("RoundingProfile") ) {
                final Object value = values.remove("RoundingProfile");
                if( (value == null) || (!value.equals(getRoundingProfile())) ) {
                    setRoundingProfile(((String) value));
                }
            }
            if( values.containsKey("PlanningStrategyGroup") ) {
                final Object value = values.remove("PlanningStrategyGroup");
                if( (value == null) || (!value.equals(getPlanningStrategyGroup())) ) {
                    setPlanningStrategyGroup(((String) value));
                }
            }
            if( values.containsKey("DfltStorageLocationExtProcmt") ) {
                final Object value = values.remove("DfltStorageLocationExtProcmt");
                if( (value == null) || (!value.equals(getDfltStorageLocationExtProcmt())) ) {
                    setDfltStorageLocationExtProcmt(((String) value));
                }
            }
            if( values.containsKey("MRPPlanningCalendar") ) {
                final Object value = values.remove("MRPPlanningCalendar");
                if( (value == null) || (!value.equals(getMRPPlanningCalendar())) ) {
                    setMRPPlanningCalendar(((String) value));
                }
            }
            if( values.containsKey("RepetitiveManufacturingIsAllwd") ) {
                final Object value = values.remove("RepetitiveManufacturingIsAllwd");
                if( (value == null) || (!value.equals(getRepetitiveManufacturingIsAllwd())) ) {
                    setRepetitiveManufacturingIsAllwd(((Boolean) value));
                }
            }
            if( values.containsKey("RepetitiveManufacturingProfile") ) {
                final Object value = values.remove("RepetitiveManufacturingProfile");
                if( (value == null) || (!value.equals(getRepetitiveManufacturingProfile())) ) {
                    setRepetitiveManufacturingProfile(((String) value));
                }
            }
            if( values.containsKey("PlanningTimeFenceInDays") ) {
                final Object value = values.remove("PlanningTimeFenceInDays");
                if( (value == null) || (!value.equals(getPlanningTimeFenceInDays())) ) {
                    setPlanningTimeFenceInDays(((String) value));
                }
            }
            if( values.containsKey("MRPType") ) {
                final Object value = values.remove("MRPType");
                if( (value == null) || (!value.equals(getMRPType())) ) {
                    setMRPType(((String) value));
                }
            }
            if( values.containsKey("MRPTypeName") ) {
                final Object value = values.remove("MRPTypeName");
                if( (value == null) || (!value.equals(getMRPTypeName())) ) {
                    setMRPTypeName(((String) value));
                }
            }
            if( values.containsKey("MaterialProcurementProfile") ) {
                final Object value = values.remove("MaterialProcurementProfile");
                if( (value == null) || (!value.equals(getMaterialProcurementProfile())) ) {
                    setMaterialProcurementProfile(((String) value));
                }
            }
            if( values.containsKey("MaterialProcurementProfileName") ) {
                final Object value = values.remove("MaterialProcurementProfileName");
                if( (value == null) || (!value.equals(getMaterialProcurementProfileName())) ) {
                    setMaterialProcurementProfileName(((String) value));
                }
            }
            if( values.containsKey("ProductionSupervisor") ) {
                final Object value = values.remove("ProductionSupervisor");
                if( (value == null) || (!value.equals(getProductionSupervisor())) ) {
                    setProductionSupervisor(((String) value));
                }
            }
            if( values.containsKey("ProductionSupervisorName") ) {
                final Object value = values.remove("ProductionSupervisorName");
                if( (value == null) || (!value.equals(getProductionSupervisorName())) ) {
                    setProductionSupervisorName(((String) value));
                }
            }
            if( values.containsKey("MaterialBaseQuantity") ) {
                final Object value = values.remove("MaterialBaseQuantity");
                if( (value == null) || (!value.equals(getMaterialBaseQuantity())) ) {
                    setMaterialBaseQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductionInvtryManagedLoc") ) {
                final Object value = values.remove("ProductionInvtryManagedLoc");
                if( (value == null) || (!value.equals(getProductionInvtryManagedLoc())) ) {
                    setProductionInvtryManagedLoc(((String) value));
                }
            }
            if( values.containsKey("StorageLocationName") ) {
                final Object value = values.remove("StorageLocationName");
                if( (value == null) || (!value.equals(getStorageLocationName())) ) {
                    setStorageLocationName(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("MRPSafetyStockMethod") ) {
                final Object value = values.remove("MRPSafetyStockMethod");
                if( (value == null) || (!value.equals(getMRPSafetyStockMethod())) ) {
                    setMRPSafetyStockMethod(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MRPMaterialField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MRPMaterialField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MRPMaterialField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MRPMaterialField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService.DEFAULT_SERVICE_PATH);
    }

}
