/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.field.MaterialCoverageField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.selectable.MaterialCoverageSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Material Coverages
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialCoverage</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialCoverage extends VdmEntity<MaterialCoverage>
{

    /**
     * Selector for all available fields of MaterialCoverage.
     *
     */
    public final static MaterialCoverageSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return The material contained in this entity.
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MATERIAL = new MaterialCoverageField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageProfile</b>
     * </p>
     *
     * @return The materialShortageProfile contained in this entity.
     */
    @Key
    @SerializedName( "MaterialShortageProfile" )
    @JsonProperty( "MaterialShortageProfile" )
    @Nullable
    @ODataField( odataName = "MaterialShortageProfile" )
    private String materialShortageProfile;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageProfile</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MATERIAL_SHORTAGE_PROFILE =
        new MaterialCoverageField<String>("MaterialShortageProfile");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageProfileCount</b>
     * </p>
     *
     * @return The materialShortageProfileCount contained in this entity.
     */
    @Key
    @SerializedName( "MaterialShortageProfileCount" )
    @JsonProperty( "MaterialShortageProfileCount" )
    @Nullable
    @ODataField( odataName = "MaterialShortageProfileCount" )
    private String materialShortageProfileCount;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageProfileCount</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MATERIAL_SHORTAGE_PROFILE_COUNT =
        new MaterialCoverageField<String>("MaterialShortageProfileCount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return The mRPArea contained in this entity.
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_AREA = new MaterialCoverageField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegmentNumber</b>
     * </p>
     *
     * @return The mRPPlanningSegmentNumber contained in this entity.
     */
    @Key
    @SerializedName( "MRPPlanningSegmentNumber" )
    @JsonProperty( "MRPPlanningSegmentNumber" )
    @Nullable
    @ODataField( odataName = "MRPPlanningSegmentNumber" )
    private String mRPPlanningSegmentNumber;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlanningSegmentNumber</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_PLANNING_SEGMENT_NUMBER =
        new MaterialCoverageField<String>("MRPPlanningSegmentNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegmentType</b>
     * </p>
     *
     * @return The mRPPlanningSegmentType contained in this entity.
     */
    @Key
    @SerializedName( "MRPPlanningSegmentType" )
    @JsonProperty( "MRPPlanningSegmentType" )
    @Nullable
    @ODataField( odataName = "MRPPlanningSegmentType" )
    private String mRPPlanningSegmentType;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlanningSegmentType</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_PLANNING_SEGMENT_TYPE =
        new MaterialCoverageField<String>("MRPPlanningSegmentType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @return The mRPPlant contained in this entity.
     */
    @Key
    @SerializedName( "MRPPlant" )
    @JsonProperty( "MRPPlant" )
    @Nullable
    @ODataField( odataName = "MRPPlant" )
    private String mRPPlant;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlant</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_PLANT = new MaterialCoverageField<String>("MRPPlant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HasAcceptedShortage</b>
     * </p>
     *
     * @return The hasAcceptedShortage contained in this entity.
     */
    @SerializedName( "HasAcceptedShortage" )
    @JsonProperty( "HasAcceptedShortage" )
    @Nullable
    @ODataField( odataName = "HasAcceptedShortage" )
    private String hasAcceptedShortage;
    /**
     * Use with available fluent helpers to apply the <b>HasAcceptedShortage</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> HAS_ACCEPTED_SHORTAGE =
        new MaterialCoverageField<String>("HasAcceptedShortage");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TimeHorizonInDays</b>
     * </p>
     *
     * @return Signed INT2 / int16
     */
    @SerializedName( "TimeHorizonInDays" )
    @JsonProperty( "TimeHorizonInDays" )
    @Nullable
    @ODataField( odataName = "TimeHorizonInDays" )
    private Short timeHorizonInDays;
    /**
     * Use with available fluent helpers to apply the <b>TimeHorizonInDays</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<Short> TIME_HORIZON_IN_DAYS =
        new MaterialCoverageField<Short>("TimeHorizonInDays");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageDuration</b>
     * </p>
     *
     * @return The materialShortageDuration contained in this entity.
     */
    @SerializedName( "MaterialShortageDuration" )
    @JsonProperty( "MaterialShortageDuration" )
    @Nullable
    @ODataField( odataName = "MaterialShortageDuration" )
    private Integer materialShortageDuration;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageDuration</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<Integer> MATERIAL_SHORTAGE_DURATION =
        new MaterialCoverageField<Integer>("MaterialShortageDuration");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageDurnInWorkdays</b>
     * </p>
     *
     * @return The materialShortageDurnInWorkdays contained in this entity.
     */
    @SerializedName( "MaterialShortageDurnInWorkdays" )
    @JsonProperty( "MaterialShortageDurnInWorkdays" )
    @Nullable
    @ODataField( odataName = "MaterialShortageDurnInWorkdays" )
    private Integer materialShortageDurnInWorkdays;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageDurnInWorkdays</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<Integer> MATERIAL_SHORTAGE_DURN_IN_WORKDAYS =
        new MaterialCoverageField<Integer>("MaterialShortageDurnInWorkdays");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return The mRPController contained in this entity.
     */
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_CONTROLLER =
        new MaterialCoverageField<String>("MRPController");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPSafetyDuration</b>
     * </p>
     *
     * @return The mRPSafetyDuration contained in this entity.
     */
    @SerializedName( "MRPSafetyDuration" )
    @JsonProperty( "MRPSafetyDuration" )
    @Nullable
    @ODataField( odataName = "MRPSafetyDuration" )
    private String mRPSafetyDuration;
    /**
     * Use with available fluent helpers to apply the <b>MRPSafetyDuration</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_SAFETY_DURATION =
        new MaterialCoverageField<String>("MRPSafetyDuration");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DaysOfSupplyDuration</b>
     * </p>
     *
     * @return The daysOfSupplyDuration contained in this entity.
     */
    @SerializedName( "DaysOfSupplyDuration" )
    @JsonProperty( "DaysOfSupplyDuration" )
    @Nullable
    @ODataField( odataName = "DaysOfSupplyDuration" )
    private Integer daysOfSupplyDuration;
    /**
     * Use with available fluent helpers to apply the <b>DaysOfSupplyDuration</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<Integer> DAYS_OF_SUPPLY_DURATION =
        new MaterialCoverageField<Integer>("DaysOfSupplyDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @return The materialBaseUnit contained in this entity.
     */
    @SerializedName( "MaterialBaseUnit" )
    @JsonProperty( "MaterialBaseUnit" )
    @Nullable
    @ODataField( odataName = "MaterialBaseUnit" )
    private String materialBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseUnit</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MATERIAL_BASE_UNIT =
        new MaterialCoverageField<String>("MaterialBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialExternalID</b>
     * </p>
     *
     * @return The materialExternalID contained in this entity.
     */
    @SerializedName( "MaterialExternalID" )
    @JsonProperty( "MaterialExternalID" )
    @Nullable
    @ODataField( odataName = "MaterialExternalID" )
    private String materialExternalID;
    /**
     * Use with available fluent helpers to apply the <b>MaterialExternalID</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MATERIAL_EXTERNAL_ID =
        new MaterialCoverageField<String>("MaterialExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return The materialName contained in this entity.
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MATERIAL_NAME = new MaterialCoverageField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialReplnmtLeadDurnEndDate</b>
     * </p>
     *
     * @return Time Stamp
     */
    @SerializedName( "MaterialReplnmtLeadDurnEndDate" )
    @JsonProperty( "MaterialReplnmtLeadDurnEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaterialReplnmtLeadDurnEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime materialReplnmtLeadDurnEndDate;
    /**
     * Use with available fluent helpers to apply the <b>MaterialReplnmtLeadDurnEndDate</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<LocalDateTime> MATERIAL_REPLNMT_LEAD_DURN_END_DATE =
        new MaterialCoverageField<LocalDateTime>("MaterialReplnmtLeadDurnEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageDefinitionName</b>
     * </p>
     *
     * @return The materialShortageDefinitionName contained in this entity.
     */
    @SerializedName( "MaterialShortageDefinitionName" )
    @JsonProperty( "MaterialShortageDefinitionName" )
    @Nullable
    @ODataField( odataName = "MaterialShortageDefinitionName" )
    private String materialShortageDefinitionName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageDefinitionName</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MATERIAL_SHORTAGE_DEFINITION_NAME =
        new MaterialCoverageField<String>("MaterialShortageDefinitionName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageEndDate</b>
     * </p>
     *
     * @return Time Stamp
     */
    @SerializedName( "MaterialShortageEndDate" )
    @JsonProperty( "MaterialShortageEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaterialShortageEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime materialShortageEndDate;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageEndDate</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<LocalDateTime> MATERIAL_SHORTAGE_END_DATE =
        new MaterialCoverageField<LocalDateTime>("MaterialShortageEndDate");
    /**
     * Constraints: Not nullable, Precision: 21, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageQuantity</b>
     * </p>
     *
     * @return The materialShortageQuantity contained in this entity.
     */
    @SerializedName( "MaterialShortageQuantity" )
    @JsonProperty( "MaterialShortageQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialShortageQuantity" )
    private BigDecimal materialShortageQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageQuantity</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<BigDecimal> MATERIAL_SHORTAGE_QUANTITY =
        new MaterialCoverageField<BigDecimal>("MaterialShortageQuantity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageStartDate</b>
     * </p>
     *
     * @return Time Stamp
     */
    @SerializedName( "MaterialShortageStartDate" )
    @JsonProperty( "MaterialShortageStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaterialShortageStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime materialShortageStartDate;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageStartDate</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<LocalDateTime> MATERIAL_SHORTAGE_START_DATE =
        new MaterialCoverageField<LocalDateTime>("MaterialShortageStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MRPAreaText</b>
     * </p>
     *
     * @return The mRPAreaText contained in this entity.
     */
    @SerializedName( "MRPAreaText" )
    @JsonProperty( "MRPAreaText" )
    @Nullable
    @ODataField( odataName = "MRPAreaText" )
    private String mRPAreaText;
    /**
     * Use with available fluent helpers to apply the <b>MRPAreaText</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_AREA_TEXT = new MaterialCoverageField<String>("MRPAreaText");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MRPControllerName</b>
     * </p>
     *
     * @return The mRPControllerName contained in this entity.
     */
    @SerializedName( "MRPControllerName" )
    @JsonProperty( "MRPControllerName" )
    @Nullable
    @ODataField( odataName = "MRPControllerName" )
    private String mRPControllerName;
    /**
     * Use with available fluent helpers to apply the <b>MRPControllerName</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_CONTROLLER_NAME =
        new MaterialCoverageField<String>("MRPControllerName");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegmentTypeDesc</b>
     * </p>
     *
     * @return The mRPPlanningSegmentTypeDesc contained in this entity.
     */
    @SerializedName( "MRPPlanningSegmentTypeDesc" )
    @JsonProperty( "MRPPlanningSegmentTypeDesc" )
    @Nullable
    @ODataField( odataName = "MRPPlanningSegmentTypeDesc" )
    private String mRPPlanningSegmentTypeDesc;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlanningSegmentTypeDesc</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_PLANNING_SEGMENT_TYPE_DESC =
        new MaterialCoverageField<String>("MRPPlanningSegmentTypeDesc");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlantName</b>
     * </p>
     *
     * @return The mRPPlantName contained in this entity.
     */
    @SerializedName( "MRPPlantName" )
    @JsonProperty( "MRPPlantName" )
    @Nullable
    @ODataField( odataName = "MRPPlantName" )
    private String mRPPlantName;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlantName</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<String> MRP_PLANT_NAME =
        new MaterialCoverageField<String>("MRPPlantName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MRPSafetyDurationEndDate</b>
     * </p>
     *
     * @return Time Stamp
     */
    @SerializedName( "MRPSafetyDurationEndDate" )
    @JsonProperty( "MRPSafetyDurationEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MRPSafetyDurationEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mRPSafetyDurationEndDate;
    /**
     * Use with available fluent helpers to apply the <b>MRPSafetyDurationEndDate</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<LocalDateTime> MRP_SAFETY_DURATION_END_DATE =
        new MaterialCoverageField<LocalDateTime>("MRPSafetyDurationEndDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VltdUnrestrictedUseStkQty</b>
     * </p>
     *
     * @return The vltdUnrestrictedUseStkQty contained in this entity.
     */
    @SerializedName( "VltdUnrestrictedUseStkQty" )
    @JsonProperty( "VltdUnrestrictedUseStkQty" )
    @Nullable
    @ODataField( odataName = "VltdUnrestrictedUseStkQty" )
    private BigDecimal vltdUnrestrictedUseStkQty;
    /**
     * Use with available fluent helpers to apply the <b>VltdUnrestrictedUseStkQty</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<BigDecimal> VLTD_UNRESTRICTED_USE_STK_QTY =
        new MaterialCoverageField<BigDecimal>("VltdUnrestrictedUseStkQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QualityInspectionStockQuantity</b>
     * </p>
     *
     * @return The qualityInspectionStockQuantity contained in this entity.
     */
    @SerializedName( "QualityInspectionStockQuantity" )
    @JsonProperty( "QualityInspectionStockQuantity" )
    @Nullable
    @ODataField( odataName = "QualityInspectionStockQuantity" )
    private BigDecimal qualityInspectionStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>QualityInspectionStockQuantity</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<BigDecimal> QUALITY_INSPECTION_STOCK_QUANTITY =
        new MaterialCoverageField<BigDecimal>("QualityInspectionStockQuantity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialLastMRPDateTime</b>
     * </p>
     *
     * @return Time Stamp
     */
    @SerializedName( "MaterialLastMRPDateTime" )
    @JsonProperty( "MaterialLastMRPDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaterialLastMRPDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime materialLastMRPDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaterialLastMRPDateTime</b> field to query operations.
     *
     */
    public final static MaterialCoverageField<LocalDateTime> MATERIAL_LAST_MRP_DATE_TIME =
        new MaterialCoverageField<LocalDateTime>("MaterialLastMRPDateTime");

    @Nonnull
    @Override
    public Class<MaterialCoverage> getType()
    {
        return MaterialCoverage.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            The material to set.
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageProfile</b>
     * </p>
     *
     * @param materialShortageProfile
     *            The materialShortageProfile to set.
     */
    public void setMaterialShortageProfile( @Nullable final String materialShortageProfile )
    {
        rememberChangedField("MaterialShortageProfile", this.materialShortageProfile);
        this.materialShortageProfile = materialShortageProfile;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageProfileCount</b>
     * </p>
     *
     * @param materialShortageProfileCount
     *            The materialShortageProfileCount to set.
     */
    public void setMaterialShortageProfileCount( @Nullable final String materialShortageProfileCount )
    {
        rememberChangedField("MaterialShortageProfileCount", this.materialShortageProfileCount);
        this.materialShortageProfileCount = materialShortageProfileCount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            The mRPArea to set.
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegmentNumber</b>
     * </p>
     *
     * @param mRPPlanningSegmentNumber
     *            The mRPPlanningSegmentNumber to set.
     */
    public void setMRPPlanningSegmentNumber( @Nullable final String mRPPlanningSegmentNumber )
    {
        rememberChangedField("MRPPlanningSegmentNumber", this.mRPPlanningSegmentNumber);
        this.mRPPlanningSegmentNumber = mRPPlanningSegmentNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegmentType</b>
     * </p>
     *
     * @param mRPPlanningSegmentType
     *            The mRPPlanningSegmentType to set.
     */
    public void setMRPPlanningSegmentType( @Nullable final String mRPPlanningSegmentType )
    {
        rememberChangedField("MRPPlanningSegmentType", this.mRPPlanningSegmentType);
        this.mRPPlanningSegmentType = mRPPlanningSegmentType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @param mRPPlant
     *            The mRPPlant to set.
     */
    public void setMRPPlant( @Nullable final String mRPPlant )
    {
        rememberChangedField("MRPPlant", this.mRPPlant);
        this.mRPPlant = mRPPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HasAcceptedShortage</b>
     * </p>
     *
     * @param hasAcceptedShortage
     *            The hasAcceptedShortage to set.
     */
    public void setHasAcceptedShortage( @Nullable final String hasAcceptedShortage )
    {
        rememberChangedField("HasAcceptedShortage", this.hasAcceptedShortage);
        this.hasAcceptedShortage = hasAcceptedShortage;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TimeHorizonInDays</b>
     * </p>
     *
     * @param timeHorizonInDays
     *            Signed INT2 / int16
     */
    public void setTimeHorizonInDays( @Nullable final Short timeHorizonInDays )
    {
        rememberChangedField("TimeHorizonInDays", this.timeHorizonInDays);
        this.timeHorizonInDays = timeHorizonInDays;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageDuration</b>
     * </p>
     *
     * @param materialShortageDuration
     *            The materialShortageDuration to set.
     */
    public void setMaterialShortageDuration( @Nullable final Integer materialShortageDuration )
    {
        rememberChangedField("MaterialShortageDuration", this.materialShortageDuration);
        this.materialShortageDuration = materialShortageDuration;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageDurnInWorkdays</b>
     * </p>
     *
     * @param materialShortageDurnInWorkdays
     *            The materialShortageDurnInWorkdays to set.
     */
    public void setMaterialShortageDurnInWorkdays( @Nullable final Integer materialShortageDurnInWorkdays )
    {
        rememberChangedField("MaterialShortageDurnInWorkdays", this.materialShortageDurnInWorkdays);
        this.materialShortageDurnInWorkdays = materialShortageDurnInWorkdays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            The mRPController to set.
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPSafetyDuration</b>
     * </p>
     *
     * @param mRPSafetyDuration
     *            The mRPSafetyDuration to set.
     */
    public void setMRPSafetyDuration( @Nullable final String mRPSafetyDuration )
    {
        rememberChangedField("MRPSafetyDuration", this.mRPSafetyDuration);
        this.mRPSafetyDuration = mRPSafetyDuration;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DaysOfSupplyDuration</b>
     * </p>
     *
     * @param daysOfSupplyDuration
     *            The daysOfSupplyDuration to set.
     */
    public void setDaysOfSupplyDuration( @Nullable final Integer daysOfSupplyDuration )
    {
        rememberChangedField("DaysOfSupplyDuration", this.daysOfSupplyDuration);
        this.daysOfSupplyDuration = daysOfSupplyDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @param materialBaseUnit
     *            The materialBaseUnit to set.
     */
    public void setMaterialBaseUnit( @Nullable final String materialBaseUnit )
    {
        rememberChangedField("MaterialBaseUnit", this.materialBaseUnit);
        this.materialBaseUnit = materialBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialExternalID</b>
     * </p>
     *
     * @param materialExternalID
     *            The materialExternalID to set.
     */
    public void setMaterialExternalID( @Nullable final String materialExternalID )
    {
        rememberChangedField("MaterialExternalID", this.materialExternalID);
        this.materialExternalID = materialExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            The materialName to set.
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialReplnmtLeadDurnEndDate</b>
     * </p>
     *
     * @param materialReplnmtLeadDurnEndDate
     *            Time Stamp
     */
    public void setMaterialReplnmtLeadDurnEndDate( @Nullable final LocalDateTime materialReplnmtLeadDurnEndDate )
    {
        rememberChangedField("MaterialReplnmtLeadDurnEndDate", this.materialReplnmtLeadDurnEndDate);
        this.materialReplnmtLeadDurnEndDate = materialReplnmtLeadDurnEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageDefinitionName</b>
     * </p>
     *
     * @param materialShortageDefinitionName
     *            The materialShortageDefinitionName to set.
     */
    public void setMaterialShortageDefinitionName( @Nullable final String materialShortageDefinitionName )
    {
        rememberChangedField("MaterialShortageDefinitionName", this.materialShortageDefinitionName);
        this.materialShortageDefinitionName = materialShortageDefinitionName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageEndDate</b>
     * </p>
     *
     * @param materialShortageEndDate
     *            Time Stamp
     */
    public void setMaterialShortageEndDate( @Nullable final LocalDateTime materialShortageEndDate )
    {
        rememberChangedField("MaterialShortageEndDate", this.materialShortageEndDate);
        this.materialShortageEndDate = materialShortageEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 21, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageQuantity</b>
     * </p>
     *
     * @param materialShortageQuantity
     *            The materialShortageQuantity to set.
     */
    public void setMaterialShortageQuantity( @Nullable final BigDecimal materialShortageQuantity )
    {
        rememberChangedField("MaterialShortageQuantity", this.materialShortageQuantity);
        this.materialShortageQuantity = materialShortageQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageStartDate</b>
     * </p>
     *
     * @param materialShortageStartDate
     *            Time Stamp
     */
    public void setMaterialShortageStartDate( @Nullable final LocalDateTime materialShortageStartDate )
    {
        rememberChangedField("MaterialShortageStartDate", this.materialShortageStartDate);
        this.materialShortageStartDate = materialShortageStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MRPAreaText</b>
     * </p>
     *
     * @param mRPAreaText
     *            The mRPAreaText to set.
     */
    public void setMRPAreaText( @Nullable final String mRPAreaText )
    {
        rememberChangedField("MRPAreaText", this.mRPAreaText);
        this.mRPAreaText = mRPAreaText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MRPControllerName</b>
     * </p>
     *
     * @param mRPControllerName
     *            The mRPControllerName to set.
     */
    public void setMRPControllerName( @Nullable final String mRPControllerName )
    {
        rememberChangedField("MRPControllerName", this.mRPControllerName);
        this.mRPControllerName = mRPControllerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegmentTypeDesc</b>
     * </p>
     *
     * @param mRPPlanningSegmentTypeDesc
     *            The mRPPlanningSegmentTypeDesc to set.
     */
    public void setMRPPlanningSegmentTypeDesc( @Nullable final String mRPPlanningSegmentTypeDesc )
    {
        rememberChangedField("MRPPlanningSegmentTypeDesc", this.mRPPlanningSegmentTypeDesc);
        this.mRPPlanningSegmentTypeDesc = mRPPlanningSegmentTypeDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlantName</b>
     * </p>
     *
     * @param mRPPlantName
     *            The mRPPlantName to set.
     */
    public void setMRPPlantName( @Nullable final String mRPPlantName )
    {
        rememberChangedField("MRPPlantName", this.mRPPlantName);
        this.mRPPlantName = mRPPlantName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MRPSafetyDurationEndDate</b>
     * </p>
     *
     * @param mRPSafetyDurationEndDate
     *            Time Stamp
     */
    public void setMRPSafetyDurationEndDate( @Nullable final LocalDateTime mRPSafetyDurationEndDate )
    {
        rememberChangedField("MRPSafetyDurationEndDate", this.mRPSafetyDurationEndDate);
        this.mRPSafetyDurationEndDate = mRPSafetyDurationEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VltdUnrestrictedUseStkQty</b>
     * </p>
     *
     * @param vltdUnrestrictedUseStkQty
     *            The vltdUnrestrictedUseStkQty to set.
     */
    public void setVltdUnrestrictedUseStkQty( @Nullable final BigDecimal vltdUnrestrictedUseStkQty )
    {
        rememberChangedField("VltdUnrestrictedUseStkQty", this.vltdUnrestrictedUseStkQty);
        this.vltdUnrestrictedUseStkQty = vltdUnrestrictedUseStkQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QualityInspectionStockQuantity</b>
     * </p>
     *
     * @param qualityInspectionStockQuantity
     *            The qualityInspectionStockQuantity to set.
     */
    public void setQualityInspectionStockQuantity( @Nullable final BigDecimal qualityInspectionStockQuantity )
    {
        rememberChangedField("QualityInspectionStockQuantity", this.qualityInspectionStockQuantity);
        this.qualityInspectionStockQuantity = qualityInspectionStockQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialLastMRPDateTime</b>
     * </p>
     *
     * @param materialLastMRPDateTime
     *            Time Stamp
     */
    public void setMaterialLastMRPDateTime( @Nullable final LocalDateTime materialLastMRPDateTime )
    {
        rememberChangedField("MaterialLastMRPDateTime", this.materialLastMRPDateTime);
        this.materialLastMRPDateTime = materialLastMRPDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialCoverages";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("MaterialShortageProfile", getMaterialShortageProfile());
        result.put("MaterialShortageProfileCount", getMaterialShortageProfileCount());
        result.put("MRPArea", getMRPArea());
        result.put("MRPPlanningSegmentNumber", getMRPPlanningSegmentNumber());
        result.put("MRPPlanningSegmentType", getMRPPlanningSegmentType());
        result.put("MRPPlant", getMRPPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("MaterialShortageProfile", getMaterialShortageProfile());
        values.put("MaterialShortageProfileCount", getMaterialShortageProfileCount());
        values.put("MRPArea", getMRPArea());
        values.put("MRPPlanningSegmentNumber", getMRPPlanningSegmentNumber());
        values.put("MRPPlanningSegmentType", getMRPPlanningSegmentType());
        values.put("MRPPlant", getMRPPlant());
        values.put("HasAcceptedShortage", getHasAcceptedShortage());
        values.put("TimeHorizonInDays", getTimeHorizonInDays());
        values.put("MaterialShortageDuration", getMaterialShortageDuration());
        values.put("MaterialShortageDurnInWorkdays", getMaterialShortageDurnInWorkdays());
        values.put("MRPController", getMRPController());
        values.put("MRPSafetyDuration", getMRPSafetyDuration());
        values.put("DaysOfSupplyDuration", getDaysOfSupplyDuration());
        values.put("MaterialBaseUnit", getMaterialBaseUnit());
        values.put("MaterialExternalID", getMaterialExternalID());
        values.put("MaterialName", getMaterialName());
        values.put("MaterialReplnmtLeadDurnEndDate", getMaterialReplnmtLeadDurnEndDate());
        values.put("MaterialShortageDefinitionName", getMaterialShortageDefinitionName());
        values.put("MaterialShortageEndDate", getMaterialShortageEndDate());
        values.put("MaterialShortageQuantity", getMaterialShortageQuantity());
        values.put("MaterialShortageStartDate", getMaterialShortageStartDate());
        values.put("MRPAreaText", getMRPAreaText());
        values.put("MRPControllerName", getMRPControllerName());
        values.put("MRPPlanningSegmentTypeDesc", getMRPPlanningSegmentTypeDesc());
        values.put("MRPPlantName", getMRPPlantName());
        values.put("MRPSafetyDurationEndDate", getMRPSafetyDurationEndDate());
        values.put("VltdUnrestrictedUseStkQty", getVltdUnrestrictedUseStkQty());
        values.put("QualityInspectionStockQuantity", getQualityInspectionStockQuantity());
        values.put("MaterialLastMRPDateTime", getMaterialLastMRPDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialShortageProfile") ) {
                final Object value = values.remove("MaterialShortageProfile");
                if( (value == null) || (!value.equals(getMaterialShortageProfile())) ) {
                    setMaterialShortageProfile(((String) value));
                }
            }
            if( values.containsKey("MaterialShortageProfileCount") ) {
                final Object value = values.remove("MaterialShortageProfileCount");
                if( (value == null) || (!value.equals(getMaterialShortageProfileCount())) ) {
                    setMaterialShortageProfileCount(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("MRPPlanningSegmentNumber") ) {
                final Object value = values.remove("MRPPlanningSegmentNumber");
                if( (value == null) || (!value.equals(getMRPPlanningSegmentNumber())) ) {
                    setMRPPlanningSegmentNumber(((String) value));
                }
            }
            if( values.containsKey("MRPPlanningSegmentType") ) {
                final Object value = values.remove("MRPPlanningSegmentType");
                if( (value == null) || (!value.equals(getMRPPlanningSegmentType())) ) {
                    setMRPPlanningSegmentType(((String) value));
                }
            }
            if( values.containsKey("MRPPlant") ) {
                final Object value = values.remove("MRPPlant");
                if( (value == null) || (!value.equals(getMRPPlant())) ) {
                    setMRPPlant(((String) value));
                }
            }
            if( values.containsKey("HasAcceptedShortage") ) {
                final Object value = values.remove("HasAcceptedShortage");
                if( (value == null) || (!value.equals(getHasAcceptedShortage())) ) {
                    setHasAcceptedShortage(((String) value));
                }
            }
            if( values.containsKey("TimeHorizonInDays") ) {
                final Object value = values.remove("TimeHorizonInDays");
                if( (value == null) || (!value.equals(getTimeHorizonInDays())) ) {
                    setTimeHorizonInDays(((Short) value));
                }
            }
            if( values.containsKey("MaterialShortageDuration") ) {
                final Object value = values.remove("MaterialShortageDuration");
                if( (value == null) || (!value.equals(getMaterialShortageDuration())) ) {
                    setMaterialShortageDuration(((Integer) value));
                }
            }
            if( values.containsKey("MaterialShortageDurnInWorkdays") ) {
                final Object value = values.remove("MaterialShortageDurnInWorkdays");
                if( (value == null) || (!value.equals(getMaterialShortageDurnInWorkdays())) ) {
                    setMaterialShortageDurnInWorkdays(((Integer) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("MRPSafetyDuration") ) {
                final Object value = values.remove("MRPSafetyDuration");
                if( (value == null) || (!value.equals(getMRPSafetyDuration())) ) {
                    setMRPSafetyDuration(((String) value));
                }
            }
            if( values.containsKey("DaysOfSupplyDuration") ) {
                final Object value = values.remove("DaysOfSupplyDuration");
                if( (value == null) || (!value.equals(getDaysOfSupplyDuration())) ) {
                    setDaysOfSupplyDuration(((Integer) value));
                }
            }
            if( values.containsKey("MaterialBaseUnit") ) {
                final Object value = values.remove("MaterialBaseUnit");
                if( (value == null) || (!value.equals(getMaterialBaseUnit())) ) {
                    setMaterialBaseUnit(((String) value));
                }
            }
            if( values.containsKey("MaterialExternalID") ) {
                final Object value = values.remove("MaterialExternalID");
                if( (value == null) || (!value.equals(getMaterialExternalID())) ) {
                    setMaterialExternalID(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("MaterialReplnmtLeadDurnEndDate") ) {
                final Object value = values.remove("MaterialReplnmtLeadDurnEndDate");
                if( (value == null) || (!value.equals(getMaterialReplnmtLeadDurnEndDate())) ) {
                    setMaterialReplnmtLeadDurnEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaterialShortageDefinitionName") ) {
                final Object value = values.remove("MaterialShortageDefinitionName");
                if( (value == null) || (!value.equals(getMaterialShortageDefinitionName())) ) {
                    setMaterialShortageDefinitionName(((String) value));
                }
            }
            if( values.containsKey("MaterialShortageEndDate") ) {
                final Object value = values.remove("MaterialShortageEndDate");
                if( (value == null) || (!value.equals(getMaterialShortageEndDate())) ) {
                    setMaterialShortageEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaterialShortageQuantity") ) {
                final Object value = values.remove("MaterialShortageQuantity");
                if( (value == null) || (!value.equals(getMaterialShortageQuantity())) ) {
                    setMaterialShortageQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialShortageStartDate") ) {
                final Object value = values.remove("MaterialShortageStartDate");
                if( (value == null) || (!value.equals(getMaterialShortageStartDate())) ) {
                    setMaterialShortageStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MRPAreaText") ) {
                final Object value = values.remove("MRPAreaText");
                if( (value == null) || (!value.equals(getMRPAreaText())) ) {
                    setMRPAreaText(((String) value));
                }
            }
            if( values.containsKey("MRPControllerName") ) {
                final Object value = values.remove("MRPControllerName");
                if( (value == null) || (!value.equals(getMRPControllerName())) ) {
                    setMRPControllerName(((String) value));
                }
            }
            if( values.containsKey("MRPPlanningSegmentTypeDesc") ) {
                final Object value = values.remove("MRPPlanningSegmentTypeDesc");
                if( (value == null) || (!value.equals(getMRPPlanningSegmentTypeDesc())) ) {
                    setMRPPlanningSegmentTypeDesc(((String) value));
                }
            }
            if( values.containsKey("MRPPlantName") ) {
                final Object value = values.remove("MRPPlantName");
                if( (value == null) || (!value.equals(getMRPPlantName())) ) {
                    setMRPPlantName(((String) value));
                }
            }
            if( values.containsKey("MRPSafetyDurationEndDate") ) {
                final Object value = values.remove("MRPSafetyDurationEndDate");
                if( (value == null) || (!value.equals(getMRPSafetyDurationEndDate())) ) {
                    setMRPSafetyDurationEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("VltdUnrestrictedUseStkQty") ) {
                final Object value = values.remove("VltdUnrestrictedUseStkQty");
                if( (value == null) || (!value.equals(getVltdUnrestrictedUseStkQty())) ) {
                    setVltdUnrestrictedUseStkQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("QualityInspectionStockQuantity") ) {
                final Object value = values.remove("QualityInspectionStockQuantity");
                if( (value == null) || (!value.equals(getQualityInspectionStockQuantity())) ) {
                    setQualityInspectionStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialLastMRPDateTime") ) {
                final Object value = values.remove("MaterialLastMRPDateTime");
                if( (value == null) || (!value.equals(getMaterialLastMRPDateTime())) ) {
                    setMaterialLastMRPDateTime(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaterialCoverageField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialCoverageField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialCoverageField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialCoverageField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService.DEFAULT_SERVICE_PATH);
    }

}
