/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.field.SupplyDemandItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.selectable.SupplyDemandItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Supply and Demand
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SupplyDemandItem</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplyDemandItem extends VdmEntity<SupplyDemandItem>
{

    /**
     * Selector for all available fields of SupplyDemandItem.
     *
     */
    public final static SupplyDemandItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return The material contained in this entity.
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MATERIAL = new SupplyDemandItemField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return The mRPArea contained in this entity.
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_AREA = new SupplyDemandItemField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @return The mRPPlant contained in this entity.
     */
    @Key
    @SerializedName( "MRPPlant" )
    @JsonProperty( "MRPPlant" )
    @Nullable
    @ODataField( odataName = "MRPPlant" )
    private String mRPPlant;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlant</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_PLANT = new SupplyDemandItemField<String>("MRPPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegment</b>
     * </p>
     *
     * @return The mRPPlanningSegment contained in this entity.
     */
    @Key
    @SerializedName( "MRPPlanningSegment" )
    @JsonProperty( "MRPPlanningSegment" )
    @Nullable
    @ODataField( odataName = "MRPPlanningSegment" )
    private String mRPPlanningSegment;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlanningSegment</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_PLANNING_SEGMENT =
        new SupplyDemandItemField<String>("MRPPlanningSegment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegmentType</b>
     * </p>
     *
     * @return The mRPPlanningSegmentType contained in this entity.
     */
    @Key
    @SerializedName( "MRPPlanningSegmentType" )
    @JsonProperty( "MRPPlanningSegmentType" )
    @Nullable
    @ODataField( odataName = "MRPPlanningSegmentType" )
    private String mRPPlanningSegmentType;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlanningSegmentType</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_PLANNING_SEGMENT_TYPE =
        new SupplyDemandItemField<String>("MRPPlanningSegmentType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageProfile</b>
     * </p>
     *
     * @return The materialShortageProfile contained in this entity.
     */
    @Key
    @SerializedName( "MaterialShortageProfile" )
    @JsonProperty( "MaterialShortageProfile" )
    @Nullable
    @ODataField( odataName = "MaterialShortageProfile" )
    private String materialShortageProfile;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageProfile</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MATERIAL_SHORTAGE_PROFILE =
        new SupplyDemandItemField<String>("MaterialShortageProfile");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DemandCategoryGroup</b>
     * </p>
     *
     * @return The demandCategoryGroup contained in this entity.
     */
    @SerializedName( "DemandCategoryGroup" )
    @JsonProperty( "DemandCategoryGroup" )
    @Nullable
    @ODataField( odataName = "DemandCategoryGroup" )
    private String demandCategoryGroup;
    /**
     * Use with available fluent helpers to apply the <b>DemandCategoryGroup</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> DEMAND_CATEGORY_GROUP =
        new SupplyDemandItemField<String>("DemandCategoryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DemandCategoryGroupName</b>
     * </p>
     *
     * @return The demandCategoryGroupName contained in this entity.
     */
    @SerializedName( "DemandCategoryGroupName" )
    @JsonProperty( "DemandCategoryGroupName" )
    @Nullable
    @ODataField( odataName = "DemandCategoryGroupName" )
    private String demandCategoryGroupName;
    /**
     * Use with available fluent helpers to apply the <b>DemandCategoryGroupName</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> DEMAND_CATEGORY_GROUP_NAME =
        new SupplyDemandItemField<String>("DemandCategoryGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReceiptCategoryGroup</b>
     * </p>
     *
     * @return The receiptCategoryGroup contained in this entity.
     */
    @SerializedName( "ReceiptCategoryGroup" )
    @JsonProperty( "ReceiptCategoryGroup" )
    @Nullable
    @ODataField( odataName = "ReceiptCategoryGroup" )
    private String receiptCategoryGroup;
    /**
     * Use with available fluent helpers to apply the <b>ReceiptCategoryGroup</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> RECEIPT_CATEGORY_GROUP =
        new SupplyDemandItemField<String>("ReceiptCategoryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ReceiptCategoryGroupName</b>
     * </p>
     *
     * @return The receiptCategoryGroupName contained in this entity.
     */
    @SerializedName( "ReceiptCategoryGroupName" )
    @JsonProperty( "ReceiptCategoryGroupName" )
    @Nullable
    @ODataField( odataName = "ReceiptCategoryGroupName" )
    private String receiptCategoryGroupName;
    /**
     * Use with available fluent helpers to apply the <b>ReceiptCategoryGroupName</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> RECEIPT_CATEGORY_GROUP_NAME =
        new SupplyDemandItemField<String>("ReceiptCategoryGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @return The materialBaseUnit contained in this entity.
     */
    @SerializedName( "MaterialBaseUnit" )
    @JsonProperty( "MaterialBaseUnit" )
    @Nullable
    @ODataField( odataName = "MaterialBaseUnit" )
    private String materialBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseUnit</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MATERIAL_BASE_UNIT =
        new SupplyDemandItemField<String>("MaterialBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureName</b>
     * </p>
     *
     * @return The unitOfMeasureName contained in this entity.
     */
    @SerializedName( "UnitOfMeasureName" )
    @JsonProperty( "UnitOfMeasureName" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureName" )
    private String unitOfMeasureName;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureName</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> UNIT_OF_MEASURE_NAME =
        new SupplyDemandItemField<String>("UnitOfMeasureName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureText</b>
     * </p>
     *
     * @return The unitOfMeasureText contained in this entity.
     */
    @SerializedName( "UnitOfMeasureText" )
    @JsonProperty( "UnitOfMeasureText" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureText" )
    private String unitOfMeasureText;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureText</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> UNIT_OF_MEASURE_TEXT =
        new SupplyDemandItemField<String>("UnitOfMeasureText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialExternalID</b>
     * </p>
     *
     * @return The materialExternalID contained in this entity.
     */
    @SerializedName( "MaterialExternalID" )
    @JsonProperty( "MaterialExternalID" )
    @Nullable
    @ODataField( odataName = "MaterialExternalID" )
    private String materialExternalID;
    /**
     * Use with available fluent helpers to apply the <b>MaterialExternalID</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MATERIAL_EXTERNAL_ID =
        new SupplyDemandItemField<String>("MaterialExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MRPAvailability</b>
     * </p>
     *
     * @return The mRPAvailability contained in this entity.
     */
    @SerializedName( "MRPAvailability" )
    @JsonProperty( "MRPAvailability" )
    @Nullable
    @ODataField( odataName = "MRPAvailability" )
    private String mRPAvailability;
    /**
     * Use with available fluent helpers to apply the <b>MRPAvailability</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_AVAILABILITY =
        new SupplyDemandItemField<String>("MRPAvailability");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSafetyStockQty</b>
     * </p>
     *
     * @return The materialSafetyStockQty contained in this entity.
     */
    @SerializedName( "MaterialSafetyStockQty" )
    @JsonProperty( "MaterialSafetyStockQty" )
    @Nullable
    @ODataField( odataName = "MaterialSafetyStockQty" )
    private BigDecimal materialSafetyStockQty;
    /**
     * Use with available fluent helpers to apply the <b>MaterialSafetyStockQty</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<BigDecimal> MATERIAL_SAFETY_STOCK_QTY =
        new SupplyDemandItemField<BigDecimal>("MaterialSafetyStockQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementOpenQuantity</b>
     * </p>
     *
     * @return The mRPElementOpenQuantity contained in this entity.
     */
    @SerializedName( "MRPElementOpenQuantity" )
    @JsonProperty( "MRPElementOpenQuantity" )
    @Nullable
    @ODataField( odataName = "MRPElementOpenQuantity" )
    private BigDecimal mRPElementOpenQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementOpenQuantity</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<BigDecimal> MRP_ELEMENT_OPEN_QUANTITY =
        new SupplyDemandItemField<BigDecimal>("MRPElementOpenQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPAvailableQuantity</b>
     * </p>
     *
     * @return The mRPAvailableQuantity contained in this entity.
     */
    @SerializedName( "MRPAvailableQuantity" )
    @JsonProperty( "MRPAvailableQuantity" )
    @Nullable
    @ODataField( odataName = "MRPAvailableQuantity" )
    private BigDecimal mRPAvailableQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MRPAvailableQuantity</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<BigDecimal> MRP_AVAILABLE_QUANTITY =
        new SupplyDemandItemField<BigDecimal>("MRPAvailableQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MRPElement</b>
     * </p>
     *
     * @return The mRPElement contained in this entity.
     */
    @SerializedName( "MRPElement" )
    @JsonProperty( "MRPElement" )
    @Nullable
    @ODataField( odataName = "MRPElement" )
    private String mRPElement;
    /**
     * Use with available fluent helpers to apply the <b>MRPElement</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT = new SupplyDemandItemField<String>("MRPElement");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementAvailyOrRqmtDate</b>
     * </p>
     *
     * @return Time Stamp
     */
    @SerializedName( "MRPElementAvailyOrRqmtDate" )
    @JsonProperty( "MRPElementAvailyOrRqmtDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MRPElementAvailyOrRqmtDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mRPElementAvailyOrRqmtDate;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementAvailyOrRqmtDate</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<LocalDateTime> MRP_ELEMENT_AVAILY_OR_RQMT_DATE =
        new SupplyDemandItemField<LocalDateTime>("MRPElementAvailyOrRqmtDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementBusinessPartner</b>
     * </p>
     *
     * @return The mRPElementBusinessPartner contained in this entity.
     */
    @SerializedName( "MRPElementBusinessPartner" )
    @JsonProperty( "MRPElementBusinessPartner" )
    @Nullable
    @ODataField( odataName = "MRPElementBusinessPartner" )
    private String mRPElementBusinessPartner;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementBusinessPartner</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_BUSINESS_PARTNER =
        new SupplyDemandItemField<String>("MRPElementBusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementBusinessPartnerName</b>
     * </p>
     *
     * @return The mRPElementBusinessPartnerName contained in this entity.
     */
    @SerializedName( "MRPElementBusinessPartnerName" )
    @JsonProperty( "MRPElementBusinessPartnerName" )
    @Nullable
    @ODataField( odataName = "MRPElementBusinessPartnerName" )
    private String mRPElementBusinessPartnerName;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementBusinessPartnerName</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_BUSINESS_PARTNER_NAME =
        new SupplyDemandItemField<String>("MRPElementBusinessPartnerName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementBusinessPartnerType</b>
     * </p>
     *
     * @return The mRPElementBusinessPartnerType contained in this entity.
     */
    @SerializedName( "MRPElementBusinessPartnerType" )
    @JsonProperty( "MRPElementBusinessPartnerType" )
    @Nullable
    @ODataField( odataName = "MRPElementBusinessPartnerType" )
    private String mRPElementBusinessPartnerType;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementBusinessPartnerType</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_BUSINESS_PARTNER_TYPE =
        new SupplyDemandItemField<String>("MRPElementBusinessPartnerType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementCategory</b>
     * </p>
     *
     * @return The mRPElementCategory contained in this entity.
     */
    @SerializedName( "MRPElementCategory" )
    @JsonProperty( "MRPElementCategory" )
    @Nullable
    @ODataField( odataName = "MRPElementCategory" )
    private String mRPElementCategory;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementCategory</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_CATEGORY =
        new SupplyDemandItemField<String>("MRPElementCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementCategoryShortName</b>
     * </p>
     *
     * @return The mRPElementCategoryShortName contained in this entity.
     */
    @SerializedName( "MRPElementCategoryShortName" )
    @JsonProperty( "MRPElementCategoryShortName" )
    @Nullable
    @ODataField( odataName = "MRPElementCategoryShortName" )
    private String mRPElementCategoryShortName;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementCategoryShortName</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_CATEGORY_SHORT_NAME =
        new SupplyDemandItemField<String>("MRPElementCategoryShortName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementCategoryName</b>
     * </p>
     *
     * @return The mRPElementCategoryName contained in this entity.
     */
    @SerializedName( "MRPElementCategoryName" )
    @JsonProperty( "MRPElementCategoryName" )
    @Nullable
    @ODataField( odataName = "MRPElementCategoryName" )
    private String mRPElementCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementCategoryName</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_CATEGORY_NAME =
        new SupplyDemandItemField<String>("MRPElementCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementDocumentType</b>
     * </p>
     *
     * @return The mRPElementDocumentType contained in this entity.
     */
    @SerializedName( "MRPElementDocumentType" )
    @JsonProperty( "MRPElementDocumentType" )
    @Nullable
    @ODataField( odataName = "MRPElementDocumentType" )
    private String mRPElementDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementDocumentType</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_DOCUMENT_TYPE =
        new SupplyDemandItemField<String>("MRPElementDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementDocumentTypeName</b>
     * </p>
     *
     * @return The mRPElementDocumentTypeName contained in this entity.
     */
    @SerializedName( "MRPElementDocumentTypeName" )
    @JsonProperty( "MRPElementDocumentTypeName" )
    @Nullable
    @ODataField( odataName = "MRPElementDocumentTypeName" )
    private String mRPElementDocumentTypeName;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementDocumentTypeName</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_DOCUMENT_TYPE_NAME =
        new SupplyDemandItemField<String>("MRPElementDocumentTypeName");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementIsPartiallyDelivered</b>
     * </p>
     *
     * @return Indicator
     */
    @SerializedName( "MRPElementIsPartiallyDelivered" )
    @JsonProperty( "MRPElementIsPartiallyDelivered" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MRPElementIsPartiallyDelivered" )
    private Boolean mRPElementIsPartiallyDelivered;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementIsPartiallyDelivered</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<Boolean> MRP_ELEMENT_IS_PARTIALLY_DELIVERED =
        new SupplyDemandItemField<Boolean>("MRPElementIsPartiallyDelivered");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementIsReleased</b>
     * </p>
     *
     * @return Indicator
     */
    @SerializedName( "MRPElementIsReleased" )
    @JsonProperty( "MRPElementIsReleased" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MRPElementIsReleased" )
    private Boolean mRPElementIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementIsReleased</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<Boolean> MRP_ELEMENT_IS_RELEASED =
        new SupplyDemandItemField<Boolean>("MRPElementIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementItem</b>
     * </p>
     *
     * @return The mRPElementItem contained in this entity.
     */
    @SerializedName( "MRPElementItem" )
    @JsonProperty( "MRPElementItem" )
    @Nullable
    @ODataField( odataName = "MRPElementItem" )
    private String mRPElementItem;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementItem</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_ITEM =
        new SupplyDemandItemField<String>("MRPElementItem");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementQuantityIsFirm</b>
     * </p>
     *
     * @return Indicator
     */
    @SerializedName( "MRPElementQuantityIsFirm" )
    @JsonProperty( "MRPElementQuantityIsFirm" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MRPElementQuantityIsFirm" )
    private Boolean mRPElementQuantityIsFirm;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementQuantityIsFirm</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<Boolean> MRP_ELEMENT_QUANTITY_IS_FIRM =
        new SupplyDemandItemField<Boolean>("MRPElementQuantityIsFirm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementScheduleLine</b>
     * </p>
     *
     * @return The mRPElementScheduleLine contained in this entity.
     */
    @SerializedName( "MRPElementScheduleLine" )
    @JsonProperty( "MRPElementScheduleLine" )
    @Nullable
    @ODataField( odataName = "MRPElementScheduleLine" )
    private String mRPElementScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementScheduleLine</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_ELEMENT_SCHEDULE_LINE =
        new SupplyDemandItemField<String>("MRPElementScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @return The productionVersion contained in this entity.
     */
    @SerializedName( "ProductionVersion" )
    @JsonProperty( "ProductionVersion" )
    @Nullable
    @ODataField( odataName = "ProductionVersion" )
    private String productionVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProductionVersion</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> PRODUCTION_VERSION =
        new SupplyDemandItemField<String>("ProductionVersion");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SourceMRPElement</b>
     * </p>
     *
     * @return The sourceMRPElement contained in this entity.
     */
    @SerializedName( "SourceMRPElement" )
    @JsonProperty( "SourceMRPElement" )
    @Nullable
    @ODataField( odataName = "SourceMRPElement" )
    private String sourceMRPElement;
    /**
     * Use with available fluent helpers to apply the <b>SourceMRPElement</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> SOURCE_MRP_ELEMENT =
        new SupplyDemandItemField<String>("SourceMRPElement");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceMRPElementCategory</b>
     * </p>
     *
     * @return The sourceMRPElementCategory contained in this entity.
     */
    @SerializedName( "SourceMRPElementCategory" )
    @JsonProperty( "SourceMRPElementCategory" )
    @Nullable
    @ODataField( odataName = "SourceMRPElementCategory" )
    private String sourceMRPElementCategory;
    /**
     * Use with available fluent helpers to apply the <b>SourceMRPElementCategory</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> SOURCE_MRP_ELEMENT_CATEGORY =
        new SupplyDemandItemField<String>("SourceMRPElementCategory");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SourceMRPElementItem</b>
     * </p>
     *
     * @return The sourceMRPElementItem contained in this entity.
     */
    @SerializedName( "SourceMRPElementItem" )
    @JsonProperty( "SourceMRPElementItem" )
    @Nullable
    @ODataField( odataName = "SourceMRPElementItem" )
    private String sourceMRPElementItem;
    /**
     * Use with available fluent helpers to apply the <b>SourceMRPElementItem</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> SOURCE_MRP_ELEMENT_ITEM =
        new SupplyDemandItemField<String>("SourceMRPElementItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SourceMRPElementScheduleLine</b>
     * </p>
     *
     * @return The sourceMRPElementScheduleLine contained in this entity.
     */
    @SerializedName( "SourceMRPElementScheduleLine" )
    @JsonProperty( "SourceMRPElementScheduleLine" )
    @Nullable
    @ODataField( odataName = "SourceMRPElementScheduleLine" )
    private String sourceMRPElementScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>SourceMRPElementScheduleLine</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> SOURCE_MRP_ELEMENT_SCHEDULE_LINE =
        new SupplyDemandItemField<String>("SourceMRPElementScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return The storageLocation contained in this entity.
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> STORAGE_LOCATION =
        new SupplyDemandItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TimeHorizonCode</b>
     * </p>
     *
     * @return The timeHorizonCode contained in this entity.
     */
    @SerializedName( "TimeHorizonCode" )
    @JsonProperty( "TimeHorizonCode" )
    @Nullable
    @ODataField( odataName = "TimeHorizonCode" )
    private String timeHorizonCode;
    /**
     * Use with available fluent helpers to apply the <b>TimeHorizonCode</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> TIME_HORIZON_CODE =
        new SupplyDemandItemField<String>("TimeHorizonCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionMessageNumber</b>
     * </p>
     *
     * @return The exceptionMessageNumber contained in this entity.
     */
    @SerializedName( "ExceptionMessageNumber" )
    @JsonProperty( "ExceptionMessageNumber" )
    @Nullable
    @ODataField( odataName = "ExceptionMessageNumber" )
    private String exceptionMessageNumber;
    /**
     * Use with available fluent helpers to apply the <b>ExceptionMessageNumber</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> EXCEPTION_MESSAGE_NUMBER =
        new SupplyDemandItemField<String>("ExceptionMessageNumber");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionMessageText</b>
     * </p>
     *
     * @return The exceptionMessageText contained in this entity.
     */
    @SerializedName( "ExceptionMessageText" )
    @JsonProperty( "ExceptionMessageText" )
    @Nullable
    @ODataField( odataName = "ExceptionMessageText" )
    private String exceptionMessageText;
    /**
     * Use with available fluent helpers to apply the <b>ExceptionMessageText</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> EXCEPTION_MESSAGE_TEXT =
        new SupplyDemandItemField<String>("ExceptionMessageText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionMessageNumber2</b>
     * </p>
     *
     * @return The exceptionMessageNumber2 contained in this entity.
     */
    @SerializedName( "ExceptionMessageNumber2" )
    @JsonProperty( "ExceptionMessageNumber2" )
    @Nullable
    @ODataField( odataName = "ExceptionMessageNumber2" )
    private String exceptionMessageNumber2;
    /**
     * Use with available fluent helpers to apply the <b>ExceptionMessageNumber2</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> EXCEPTION_MESSAGE_NUMBER2 =
        new SupplyDemandItemField<String>("ExceptionMessageNumber2");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionMessageText2</b>
     * </p>
     *
     * @return The exceptionMessageText2 contained in this entity.
     */
    @SerializedName( "ExceptionMessageText2" )
    @JsonProperty( "ExceptionMessageText2" )
    @Nullable
    @ODataField( odataName = "ExceptionMessageText2" )
    private String exceptionMessageText2;
    /**
     * Use with available fluent helpers to apply the <b>ExceptionMessageText2</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> EXCEPTION_MESSAGE_TEXT2 =
        new SupplyDemandItemField<String>("ExceptionMessageText2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PeriodType</b>
     * </p>
     *
     * @return The periodType contained in this entity.
     */
    @SerializedName( "PeriodType" )
    @JsonProperty( "PeriodType" )
    @Nullable
    @ODataField( odataName = "PeriodType" )
    private String periodType;
    /**
     * Use with available fluent helpers to apply the <b>PeriodType</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> PERIOD_TYPE = new SupplyDemandItemField<String>("PeriodType");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>PeriodOrSegment</b>
     * </p>
     *
     * @return Period/Segment
     */
    @SerializedName( "PeriodOrSegment" )
    @JsonProperty( "PeriodOrSegment" )
    @Nullable
    @ODataField( odataName = "PeriodOrSegment" )
    private String periodOrSegment;
    /**
     * Use with available fluent helpers to apply the <b>PeriodOrSegment</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> PERIOD_OR_SEGMENT =
        new SupplyDemandItemField<String>("PeriodOrSegment");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfWorkdaysPerPeriod</b>
     * </p>
     *
     * @return Signed INT2 / int16
     */
    @SerializedName( "NumberOfWorkdaysPerPeriod" )
    @JsonProperty( "NumberOfWorkdaysPerPeriod" )
    @Nullable
    @ODataField( odataName = "NumberOfWorkdaysPerPeriod" )
    private Short numberOfWorkdaysPerPeriod;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfWorkdaysPerPeriod</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<Short> NUMBER_OF_WORKDAYS_PER_PERIOD =
        new SupplyDemandItemField<Short>("NumberOfWorkdaysPerPeriod");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfAggregatedItems</b>
     * </p>
     *
     * @return Signed INT2 / int16
     */
    @SerializedName( "NumberOfAggregatedItems" )
    @JsonProperty( "NumberOfAggregatedItems" )
    @Nullable
    @ODataField( odataName = "NumberOfAggregatedItems" )
    private Short numberOfAggregatedItems;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfAggregatedItems</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<Short> NUMBER_OF_AGGREGATED_ITEMS =
        new SupplyDemandItemField<Short>("NumberOfAggregatedItems");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return The mRPController contained in this entity.
     */
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MRP_CONTROLLER =
        new SupplyDemandItemField<String>("MRPController");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementReschedulingDate</b>
     * </p>
     *
     * @return Time Stamp
     */
    @SerializedName( "MRPElementReschedulingDate" )
    @JsonProperty( "MRPElementReschedulingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MRPElementReschedulingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mRPElementReschedulingDate;
    /**
     * Use with available fluent helpers to apply the <b>MRPElementReschedulingDate</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<LocalDateTime> MRP_ELEMENT_RESCHEDULING_DATE =
        new SupplyDemandItemField<LocalDateTime>("MRPElementReschedulingDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtVersion</b>
     * </p>
     *
     * @return The plndIndepRqmtVersion contained in this entity.
     */
    @SerializedName( "PlndIndepRqmtVersion" )
    @JsonProperty( "PlndIndepRqmtVersion" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtVersion" )
    private String plndIndepRqmtVersion;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtVersion</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> PLND_INDEP_RQMT_VERSION =
        new SupplyDemandItemField<String>("PlndIndepRqmtVersion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageProfileCount</b>
     * </p>
     *
     * @return The materialShortageProfileCount contained in this entity.
     */
    @SerializedName( "MaterialShortageProfileCount" )
    @JsonProperty( "MaterialShortageProfileCount" )
    @Nullable
    @ODataField( odataName = "MaterialShortageProfileCount" )
    private String materialShortageProfileCount;
    /**
     * Use with available fluent helpers to apply the <b>MaterialShortageProfileCount</b> field to query operations.
     *
     */
    public final static SupplyDemandItemField<String> MATERIAL_SHORTAGE_PROFILE_COUNT =
        new SupplyDemandItemField<String>("MaterialShortageProfileCount");

    @Nonnull
    @Override
    public Class<SupplyDemandItem> getType()
    {
        return SupplyDemandItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            The material to set.
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            The mRPArea to set.
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @param mRPPlant
     *            The mRPPlant to set.
     */
    public void setMRPPlant( @Nullable final String mRPPlant )
    {
        rememberChangedField("MRPPlant", this.mRPPlant);
        this.mRPPlant = mRPPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegment</b>
     * </p>
     *
     * @param mRPPlanningSegment
     *            The mRPPlanningSegment to set.
     */
    public void setMRPPlanningSegment( @Nullable final String mRPPlanningSegment )
    {
        rememberChangedField("MRPPlanningSegment", this.mRPPlanningSegment);
        this.mRPPlanningSegment = mRPPlanningSegment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningSegmentType</b>
     * </p>
     *
     * @param mRPPlanningSegmentType
     *            The mRPPlanningSegmentType to set.
     */
    public void setMRPPlanningSegmentType( @Nullable final String mRPPlanningSegmentType )
    {
        rememberChangedField("MRPPlanningSegmentType", this.mRPPlanningSegmentType);
        this.mRPPlanningSegmentType = mRPPlanningSegmentType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageProfile</b>
     * </p>
     *
     * @param materialShortageProfile
     *            The materialShortageProfile to set.
     */
    public void setMaterialShortageProfile( @Nullable final String materialShortageProfile )
    {
        rememberChangedField("MaterialShortageProfile", this.materialShortageProfile);
        this.materialShortageProfile = materialShortageProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DemandCategoryGroup</b>
     * </p>
     *
     * @param demandCategoryGroup
     *            The demandCategoryGroup to set.
     */
    public void setDemandCategoryGroup( @Nullable final String demandCategoryGroup )
    {
        rememberChangedField("DemandCategoryGroup", this.demandCategoryGroup);
        this.demandCategoryGroup = demandCategoryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DemandCategoryGroupName</b>
     * </p>
     *
     * @param demandCategoryGroupName
     *            The demandCategoryGroupName to set.
     */
    public void setDemandCategoryGroupName( @Nullable final String demandCategoryGroupName )
    {
        rememberChangedField("DemandCategoryGroupName", this.demandCategoryGroupName);
        this.demandCategoryGroupName = demandCategoryGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReceiptCategoryGroup</b>
     * </p>
     *
     * @param receiptCategoryGroup
     *            The receiptCategoryGroup to set.
     */
    public void setReceiptCategoryGroup( @Nullable final String receiptCategoryGroup )
    {
        rememberChangedField("ReceiptCategoryGroup", this.receiptCategoryGroup);
        this.receiptCategoryGroup = receiptCategoryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ReceiptCategoryGroupName</b>
     * </p>
     *
     * @param receiptCategoryGroupName
     *            The receiptCategoryGroupName to set.
     */
    public void setReceiptCategoryGroupName( @Nullable final String receiptCategoryGroupName )
    {
        rememberChangedField("ReceiptCategoryGroupName", this.receiptCategoryGroupName);
        this.receiptCategoryGroupName = receiptCategoryGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @param materialBaseUnit
     *            The materialBaseUnit to set.
     */
    public void setMaterialBaseUnit( @Nullable final String materialBaseUnit )
    {
        rememberChangedField("MaterialBaseUnit", this.materialBaseUnit);
        this.materialBaseUnit = materialBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureName</b>
     * </p>
     *
     * @param unitOfMeasureName
     *            The unitOfMeasureName to set.
     */
    public void setUnitOfMeasureName( @Nullable final String unitOfMeasureName )
    {
        rememberChangedField("UnitOfMeasureName", this.unitOfMeasureName);
        this.unitOfMeasureName = unitOfMeasureName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureText</b>
     * </p>
     *
     * @param unitOfMeasureText
     *            The unitOfMeasureText to set.
     */
    public void setUnitOfMeasureText( @Nullable final String unitOfMeasureText )
    {
        rememberChangedField("UnitOfMeasureText", this.unitOfMeasureText);
        this.unitOfMeasureText = unitOfMeasureText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialExternalID</b>
     * </p>
     *
     * @param materialExternalID
     *            The materialExternalID to set.
     */
    public void setMaterialExternalID( @Nullable final String materialExternalID )
    {
        rememberChangedField("MaterialExternalID", this.materialExternalID);
        this.materialExternalID = materialExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MRPAvailability</b>
     * </p>
     *
     * @param mRPAvailability
     *            The mRPAvailability to set.
     */
    public void setMRPAvailability( @Nullable final String mRPAvailability )
    {
        rememberChangedField("MRPAvailability", this.mRPAvailability);
        this.mRPAvailability = mRPAvailability;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSafetyStockQty</b>
     * </p>
     *
     * @param materialSafetyStockQty
     *            The materialSafetyStockQty to set.
     */
    public void setMaterialSafetyStockQty( @Nullable final BigDecimal materialSafetyStockQty )
    {
        rememberChangedField("MaterialSafetyStockQty", this.materialSafetyStockQty);
        this.materialSafetyStockQty = materialSafetyStockQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementOpenQuantity</b>
     * </p>
     *
     * @param mRPElementOpenQuantity
     *            The mRPElementOpenQuantity to set.
     */
    public void setMRPElementOpenQuantity( @Nullable final BigDecimal mRPElementOpenQuantity )
    {
        rememberChangedField("MRPElementOpenQuantity", this.mRPElementOpenQuantity);
        this.mRPElementOpenQuantity = mRPElementOpenQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPAvailableQuantity</b>
     * </p>
     *
     * @param mRPAvailableQuantity
     *            The mRPAvailableQuantity to set.
     */
    public void setMRPAvailableQuantity( @Nullable final BigDecimal mRPAvailableQuantity )
    {
        rememberChangedField("MRPAvailableQuantity", this.mRPAvailableQuantity);
        this.mRPAvailableQuantity = mRPAvailableQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MRPElement</b>
     * </p>
     *
     * @param mRPElement
     *            The mRPElement to set.
     */
    public void setMRPElement( @Nullable final String mRPElement )
    {
        rememberChangedField("MRPElement", this.mRPElement);
        this.mRPElement = mRPElement;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementAvailyOrRqmtDate</b>
     * </p>
     *
     * @param mRPElementAvailyOrRqmtDate
     *            Time Stamp
     */
    public void setMRPElementAvailyOrRqmtDate( @Nullable final LocalDateTime mRPElementAvailyOrRqmtDate )
    {
        rememberChangedField("MRPElementAvailyOrRqmtDate", this.mRPElementAvailyOrRqmtDate);
        this.mRPElementAvailyOrRqmtDate = mRPElementAvailyOrRqmtDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementBusinessPartner</b>
     * </p>
     *
     * @param mRPElementBusinessPartner
     *            The mRPElementBusinessPartner to set.
     */
    public void setMRPElementBusinessPartner( @Nullable final String mRPElementBusinessPartner )
    {
        rememberChangedField("MRPElementBusinessPartner", this.mRPElementBusinessPartner);
        this.mRPElementBusinessPartner = mRPElementBusinessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementBusinessPartnerName</b>
     * </p>
     *
     * @param mRPElementBusinessPartnerName
     *            The mRPElementBusinessPartnerName to set.
     */
    public void setMRPElementBusinessPartnerName( @Nullable final String mRPElementBusinessPartnerName )
    {
        rememberChangedField("MRPElementBusinessPartnerName", this.mRPElementBusinessPartnerName);
        this.mRPElementBusinessPartnerName = mRPElementBusinessPartnerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementBusinessPartnerType</b>
     * </p>
     *
     * @param mRPElementBusinessPartnerType
     *            The mRPElementBusinessPartnerType to set.
     */
    public void setMRPElementBusinessPartnerType( @Nullable final String mRPElementBusinessPartnerType )
    {
        rememberChangedField("MRPElementBusinessPartnerType", this.mRPElementBusinessPartnerType);
        this.mRPElementBusinessPartnerType = mRPElementBusinessPartnerType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementCategory</b>
     * </p>
     *
     * @param mRPElementCategory
     *            The mRPElementCategory to set.
     */
    public void setMRPElementCategory( @Nullable final String mRPElementCategory )
    {
        rememberChangedField("MRPElementCategory", this.mRPElementCategory);
        this.mRPElementCategory = mRPElementCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementCategoryShortName</b>
     * </p>
     *
     * @param mRPElementCategoryShortName
     *            The mRPElementCategoryShortName to set.
     */
    public void setMRPElementCategoryShortName( @Nullable final String mRPElementCategoryShortName )
    {
        rememberChangedField("MRPElementCategoryShortName", this.mRPElementCategoryShortName);
        this.mRPElementCategoryShortName = mRPElementCategoryShortName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementCategoryName</b>
     * </p>
     *
     * @param mRPElementCategoryName
     *            The mRPElementCategoryName to set.
     */
    public void setMRPElementCategoryName( @Nullable final String mRPElementCategoryName )
    {
        rememberChangedField("MRPElementCategoryName", this.mRPElementCategoryName);
        this.mRPElementCategoryName = mRPElementCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementDocumentType</b>
     * </p>
     *
     * @param mRPElementDocumentType
     *            The mRPElementDocumentType to set.
     */
    public void setMRPElementDocumentType( @Nullable final String mRPElementDocumentType )
    {
        rememberChangedField("MRPElementDocumentType", this.mRPElementDocumentType);
        this.mRPElementDocumentType = mRPElementDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementDocumentTypeName</b>
     * </p>
     *
     * @param mRPElementDocumentTypeName
     *            The mRPElementDocumentTypeName to set.
     */
    public void setMRPElementDocumentTypeName( @Nullable final String mRPElementDocumentTypeName )
    {
        rememberChangedField("MRPElementDocumentTypeName", this.mRPElementDocumentTypeName);
        this.mRPElementDocumentTypeName = mRPElementDocumentTypeName;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementIsPartiallyDelivered</b>
     * </p>
     *
     * @param mRPElementIsPartiallyDelivered
     *            Indicator
     */
    public void setMRPElementIsPartiallyDelivered( @Nullable final Boolean mRPElementIsPartiallyDelivered )
    {
        rememberChangedField("MRPElementIsPartiallyDelivered", this.mRPElementIsPartiallyDelivered);
        this.mRPElementIsPartiallyDelivered = mRPElementIsPartiallyDelivered;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementIsReleased</b>
     * </p>
     *
     * @param mRPElementIsReleased
     *            Indicator
     */
    public void setMRPElementIsReleased( @Nullable final Boolean mRPElementIsReleased )
    {
        rememberChangedField("MRPElementIsReleased", this.mRPElementIsReleased);
        this.mRPElementIsReleased = mRPElementIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementItem</b>
     * </p>
     *
     * @param mRPElementItem
     *            The mRPElementItem to set.
     */
    public void setMRPElementItem( @Nullable final String mRPElementItem )
    {
        rememberChangedField("MRPElementItem", this.mRPElementItem);
        this.mRPElementItem = mRPElementItem;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementQuantityIsFirm</b>
     * </p>
     *
     * @param mRPElementQuantityIsFirm
     *            Indicator
     */
    public void setMRPElementQuantityIsFirm( @Nullable final Boolean mRPElementQuantityIsFirm )
    {
        rememberChangedField("MRPElementQuantityIsFirm", this.mRPElementQuantityIsFirm);
        this.mRPElementQuantityIsFirm = mRPElementQuantityIsFirm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementScheduleLine</b>
     * </p>
     *
     * @param mRPElementScheduleLine
     *            The mRPElementScheduleLine to set.
     */
    public void setMRPElementScheduleLine( @Nullable final String mRPElementScheduleLine )
    {
        rememberChangedField("MRPElementScheduleLine", this.mRPElementScheduleLine);
        this.mRPElementScheduleLine = mRPElementScheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @param productionVersion
     *            The productionVersion to set.
     */
    public void setProductionVersion( @Nullable final String productionVersion )
    {
        rememberChangedField("ProductionVersion", this.productionVersion);
        this.productionVersion = productionVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SourceMRPElement</b>
     * </p>
     *
     * @param sourceMRPElement
     *            The sourceMRPElement to set.
     */
    public void setSourceMRPElement( @Nullable final String sourceMRPElement )
    {
        rememberChangedField("SourceMRPElement", this.sourceMRPElement);
        this.sourceMRPElement = sourceMRPElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceMRPElementCategory</b>
     * </p>
     *
     * @param sourceMRPElementCategory
     *            The sourceMRPElementCategory to set.
     */
    public void setSourceMRPElementCategory( @Nullable final String sourceMRPElementCategory )
    {
        rememberChangedField("SourceMRPElementCategory", this.sourceMRPElementCategory);
        this.sourceMRPElementCategory = sourceMRPElementCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SourceMRPElementItem</b>
     * </p>
     *
     * @param sourceMRPElementItem
     *            The sourceMRPElementItem to set.
     */
    public void setSourceMRPElementItem( @Nullable final String sourceMRPElementItem )
    {
        rememberChangedField("SourceMRPElementItem", this.sourceMRPElementItem);
        this.sourceMRPElementItem = sourceMRPElementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SourceMRPElementScheduleLine</b>
     * </p>
     *
     * @param sourceMRPElementScheduleLine
     *            The sourceMRPElementScheduleLine to set.
     */
    public void setSourceMRPElementScheduleLine( @Nullable final String sourceMRPElementScheduleLine )
    {
        rememberChangedField("SourceMRPElementScheduleLine", this.sourceMRPElementScheduleLine);
        this.sourceMRPElementScheduleLine = sourceMRPElementScheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            The storageLocation to set.
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TimeHorizonCode</b>
     * </p>
     *
     * @param timeHorizonCode
     *            The timeHorizonCode to set.
     */
    public void setTimeHorizonCode( @Nullable final String timeHorizonCode )
    {
        rememberChangedField("TimeHorizonCode", this.timeHorizonCode);
        this.timeHorizonCode = timeHorizonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionMessageNumber</b>
     * </p>
     *
     * @param exceptionMessageNumber
     *            The exceptionMessageNumber to set.
     */
    public void setExceptionMessageNumber( @Nullable final String exceptionMessageNumber )
    {
        rememberChangedField("ExceptionMessageNumber", this.exceptionMessageNumber);
        this.exceptionMessageNumber = exceptionMessageNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionMessageText</b>
     * </p>
     *
     * @param exceptionMessageText
     *            The exceptionMessageText to set.
     */
    public void setExceptionMessageText( @Nullable final String exceptionMessageText )
    {
        rememberChangedField("ExceptionMessageText", this.exceptionMessageText);
        this.exceptionMessageText = exceptionMessageText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionMessageNumber2</b>
     * </p>
     *
     * @param exceptionMessageNumber2
     *            The exceptionMessageNumber2 to set.
     */
    public void setExceptionMessageNumber2( @Nullable final String exceptionMessageNumber2 )
    {
        rememberChangedField("ExceptionMessageNumber2", this.exceptionMessageNumber2);
        this.exceptionMessageNumber2 = exceptionMessageNumber2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionMessageText2</b>
     * </p>
     *
     * @param exceptionMessageText2
     *            The exceptionMessageText2 to set.
     */
    public void setExceptionMessageText2( @Nullable final String exceptionMessageText2 )
    {
        rememberChangedField("ExceptionMessageText2", this.exceptionMessageText2);
        this.exceptionMessageText2 = exceptionMessageText2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PeriodType</b>
     * </p>
     *
     * @param periodType
     *            The periodType to set.
     */
    public void setPeriodType( @Nullable final String periodType )
    {
        rememberChangedField("PeriodType", this.periodType);
        this.periodType = periodType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>PeriodOrSegment</b>
     * </p>
     *
     * @param periodOrSegment
     *            Period/Segment
     */
    public void setPeriodOrSegment( @Nullable final String periodOrSegment )
    {
        rememberChangedField("PeriodOrSegment", this.periodOrSegment);
        this.periodOrSegment = periodOrSegment;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfWorkdaysPerPeriod</b>
     * </p>
     *
     * @param numberOfWorkdaysPerPeriod
     *            Signed INT2 / int16
     */
    public void setNumberOfWorkdaysPerPeriod( @Nullable final Short numberOfWorkdaysPerPeriod )
    {
        rememberChangedField("NumberOfWorkdaysPerPeriod", this.numberOfWorkdaysPerPeriod);
        this.numberOfWorkdaysPerPeriod = numberOfWorkdaysPerPeriod;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfAggregatedItems</b>
     * </p>
     *
     * @param numberOfAggregatedItems
     *            Signed INT2 / int16
     */
    public void setNumberOfAggregatedItems( @Nullable final Short numberOfAggregatedItems )
    {
        rememberChangedField("NumberOfAggregatedItems", this.numberOfAggregatedItems);
        this.numberOfAggregatedItems = numberOfAggregatedItems;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            The mRPController to set.
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MRPElementReschedulingDate</b>
     * </p>
     *
     * @param mRPElementReschedulingDate
     *            Time Stamp
     */
    public void setMRPElementReschedulingDate( @Nullable final LocalDateTime mRPElementReschedulingDate )
    {
        rememberChangedField("MRPElementReschedulingDate", this.mRPElementReschedulingDate);
        this.mRPElementReschedulingDate = mRPElementReschedulingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtVersion</b>
     * </p>
     *
     * @param plndIndepRqmtVersion
     *            The plndIndepRqmtVersion to set.
     */
    public void setPlndIndepRqmtVersion( @Nullable final String plndIndepRqmtVersion )
    {
        rememberChangedField("PlndIndepRqmtVersion", this.plndIndepRqmtVersion);
        this.plndIndepRqmtVersion = plndIndepRqmtVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialShortageProfileCount</b>
     * </p>
     *
     * @param materialShortageProfileCount
     *            The materialShortageProfileCount to set.
     */
    public void setMaterialShortageProfileCount( @Nullable final String materialShortageProfileCount )
    {
        rememberChangedField("MaterialShortageProfileCount", this.materialShortageProfileCount);
        this.materialShortageProfileCount = materialShortageProfileCount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SupplyDemandItems";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("MRPArea", getMRPArea());
        result.put("MRPPlant", getMRPPlant());
        result.put("MRPPlanningSegment", getMRPPlanningSegment());
        result.put("MRPPlanningSegmentType", getMRPPlanningSegmentType());
        result.put("MaterialShortageProfile", getMaterialShortageProfile());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("MRPArea", getMRPArea());
        values.put("MRPPlant", getMRPPlant());
        values.put("MRPPlanningSegment", getMRPPlanningSegment());
        values.put("MRPPlanningSegmentType", getMRPPlanningSegmentType());
        values.put("MaterialShortageProfile", getMaterialShortageProfile());
        values.put("DemandCategoryGroup", getDemandCategoryGroup());
        values.put("DemandCategoryGroupName", getDemandCategoryGroupName());
        values.put("ReceiptCategoryGroup", getReceiptCategoryGroup());
        values.put("ReceiptCategoryGroupName", getReceiptCategoryGroupName());
        values.put("MaterialBaseUnit", getMaterialBaseUnit());
        values.put("UnitOfMeasureName", getUnitOfMeasureName());
        values.put("UnitOfMeasureText", getUnitOfMeasureText());
        values.put("MaterialExternalID", getMaterialExternalID());
        values.put("MRPAvailability", getMRPAvailability());
        values.put("MaterialSafetyStockQty", getMaterialSafetyStockQty());
        values.put("MRPElementOpenQuantity", getMRPElementOpenQuantity());
        values.put("MRPAvailableQuantity", getMRPAvailableQuantity());
        values.put("MRPElement", getMRPElement());
        values.put("MRPElementAvailyOrRqmtDate", getMRPElementAvailyOrRqmtDate());
        values.put("MRPElementBusinessPartner", getMRPElementBusinessPartner());
        values.put("MRPElementBusinessPartnerName", getMRPElementBusinessPartnerName());
        values.put("MRPElementBusinessPartnerType", getMRPElementBusinessPartnerType());
        values.put("MRPElementCategory", getMRPElementCategory());
        values.put("MRPElementCategoryShortName", getMRPElementCategoryShortName());
        values.put("MRPElementCategoryName", getMRPElementCategoryName());
        values.put("MRPElementDocumentType", getMRPElementDocumentType());
        values.put("MRPElementDocumentTypeName", getMRPElementDocumentTypeName());
        values.put("MRPElementIsPartiallyDelivered", getMRPElementIsPartiallyDelivered());
        values.put("MRPElementIsReleased", getMRPElementIsReleased());
        values.put("MRPElementItem", getMRPElementItem());
        values.put("MRPElementQuantityIsFirm", getMRPElementQuantityIsFirm());
        values.put("MRPElementScheduleLine", getMRPElementScheduleLine());
        values.put("ProductionVersion", getProductionVersion());
        values.put("SourceMRPElement", getSourceMRPElement());
        values.put("SourceMRPElementCategory", getSourceMRPElementCategory());
        values.put("SourceMRPElementItem", getSourceMRPElementItem());
        values.put("SourceMRPElementScheduleLine", getSourceMRPElementScheduleLine());
        values.put("StorageLocation", getStorageLocation());
        values.put("TimeHorizonCode", getTimeHorizonCode());
        values.put("ExceptionMessageNumber", getExceptionMessageNumber());
        values.put("ExceptionMessageText", getExceptionMessageText());
        values.put("ExceptionMessageNumber2", getExceptionMessageNumber2());
        values.put("ExceptionMessageText2", getExceptionMessageText2());
        values.put("PeriodType", getPeriodType());
        values.put("PeriodOrSegment", getPeriodOrSegment());
        values.put("NumberOfWorkdaysPerPeriod", getNumberOfWorkdaysPerPeriod());
        values.put("NumberOfAggregatedItems", getNumberOfAggregatedItems());
        values.put("MRPController", getMRPController());
        values.put("MRPElementReschedulingDate", getMRPElementReschedulingDate());
        values.put("PlndIndepRqmtVersion", getPlndIndepRqmtVersion());
        values.put("MaterialShortageProfileCount", getMaterialShortageProfileCount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("MRPPlant") ) {
                final Object value = values.remove("MRPPlant");
                if( (value == null) || (!value.equals(getMRPPlant())) ) {
                    setMRPPlant(((String) value));
                }
            }
            if( values.containsKey("MRPPlanningSegment") ) {
                final Object value = values.remove("MRPPlanningSegment");
                if( (value == null) || (!value.equals(getMRPPlanningSegment())) ) {
                    setMRPPlanningSegment(((String) value));
                }
            }
            if( values.containsKey("MRPPlanningSegmentType") ) {
                final Object value = values.remove("MRPPlanningSegmentType");
                if( (value == null) || (!value.equals(getMRPPlanningSegmentType())) ) {
                    setMRPPlanningSegmentType(((String) value));
                }
            }
            if( values.containsKey("MaterialShortageProfile") ) {
                final Object value = values.remove("MaterialShortageProfile");
                if( (value == null) || (!value.equals(getMaterialShortageProfile())) ) {
                    setMaterialShortageProfile(((String) value));
                }
            }
            if( values.containsKey("DemandCategoryGroup") ) {
                final Object value = values.remove("DemandCategoryGroup");
                if( (value == null) || (!value.equals(getDemandCategoryGroup())) ) {
                    setDemandCategoryGroup(((String) value));
                }
            }
            if( values.containsKey("DemandCategoryGroupName") ) {
                final Object value = values.remove("DemandCategoryGroupName");
                if( (value == null) || (!value.equals(getDemandCategoryGroupName())) ) {
                    setDemandCategoryGroupName(((String) value));
                }
            }
            if( values.containsKey("ReceiptCategoryGroup") ) {
                final Object value = values.remove("ReceiptCategoryGroup");
                if( (value == null) || (!value.equals(getReceiptCategoryGroup())) ) {
                    setReceiptCategoryGroup(((String) value));
                }
            }
            if( values.containsKey("ReceiptCategoryGroupName") ) {
                final Object value = values.remove("ReceiptCategoryGroupName");
                if( (value == null) || (!value.equals(getReceiptCategoryGroupName())) ) {
                    setReceiptCategoryGroupName(((String) value));
                }
            }
            if( values.containsKey("MaterialBaseUnit") ) {
                final Object value = values.remove("MaterialBaseUnit");
                if( (value == null) || (!value.equals(getMaterialBaseUnit())) ) {
                    setMaterialBaseUnit(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasureName") ) {
                final Object value = values.remove("UnitOfMeasureName");
                if( (value == null) || (!value.equals(getUnitOfMeasureName())) ) {
                    setUnitOfMeasureName(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasureText") ) {
                final Object value = values.remove("UnitOfMeasureText");
                if( (value == null) || (!value.equals(getUnitOfMeasureText())) ) {
                    setUnitOfMeasureText(((String) value));
                }
            }
            if( values.containsKey("MaterialExternalID") ) {
                final Object value = values.remove("MaterialExternalID");
                if( (value == null) || (!value.equals(getMaterialExternalID())) ) {
                    setMaterialExternalID(((String) value));
                }
            }
            if( values.containsKey("MRPAvailability") ) {
                final Object value = values.remove("MRPAvailability");
                if( (value == null) || (!value.equals(getMRPAvailability())) ) {
                    setMRPAvailability(((String) value));
                }
            }
            if( values.containsKey("MaterialSafetyStockQty") ) {
                final Object value = values.remove("MaterialSafetyStockQty");
                if( (value == null) || (!value.equals(getMaterialSafetyStockQty())) ) {
                    setMaterialSafetyStockQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("MRPElementOpenQuantity") ) {
                final Object value = values.remove("MRPElementOpenQuantity");
                if( (value == null) || (!value.equals(getMRPElementOpenQuantity())) ) {
                    setMRPElementOpenQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MRPAvailableQuantity") ) {
                final Object value = values.remove("MRPAvailableQuantity");
                if( (value == null) || (!value.equals(getMRPAvailableQuantity())) ) {
                    setMRPAvailableQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MRPElement") ) {
                final Object value = values.remove("MRPElement");
                if( (value == null) || (!value.equals(getMRPElement())) ) {
                    setMRPElement(((String) value));
                }
            }
            if( values.containsKey("MRPElementAvailyOrRqmtDate") ) {
                final Object value = values.remove("MRPElementAvailyOrRqmtDate");
                if( (value == null) || (!value.equals(getMRPElementAvailyOrRqmtDate())) ) {
                    setMRPElementAvailyOrRqmtDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MRPElementBusinessPartner") ) {
                final Object value = values.remove("MRPElementBusinessPartner");
                if( (value == null) || (!value.equals(getMRPElementBusinessPartner())) ) {
                    setMRPElementBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("MRPElementBusinessPartnerName") ) {
                final Object value = values.remove("MRPElementBusinessPartnerName");
                if( (value == null) || (!value.equals(getMRPElementBusinessPartnerName())) ) {
                    setMRPElementBusinessPartnerName(((String) value));
                }
            }
            if( values.containsKey("MRPElementBusinessPartnerType") ) {
                final Object value = values.remove("MRPElementBusinessPartnerType");
                if( (value == null) || (!value.equals(getMRPElementBusinessPartnerType())) ) {
                    setMRPElementBusinessPartnerType(((String) value));
                }
            }
            if( values.containsKey("MRPElementCategory") ) {
                final Object value = values.remove("MRPElementCategory");
                if( (value == null) || (!value.equals(getMRPElementCategory())) ) {
                    setMRPElementCategory(((String) value));
                }
            }
            if( values.containsKey("MRPElementCategoryShortName") ) {
                final Object value = values.remove("MRPElementCategoryShortName");
                if( (value == null) || (!value.equals(getMRPElementCategoryShortName())) ) {
                    setMRPElementCategoryShortName(((String) value));
                }
            }
            if( values.containsKey("MRPElementCategoryName") ) {
                final Object value = values.remove("MRPElementCategoryName");
                if( (value == null) || (!value.equals(getMRPElementCategoryName())) ) {
                    setMRPElementCategoryName(((String) value));
                }
            }
            if( values.containsKey("MRPElementDocumentType") ) {
                final Object value = values.remove("MRPElementDocumentType");
                if( (value == null) || (!value.equals(getMRPElementDocumentType())) ) {
                    setMRPElementDocumentType(((String) value));
                }
            }
            if( values.containsKey("MRPElementDocumentTypeName") ) {
                final Object value = values.remove("MRPElementDocumentTypeName");
                if( (value == null) || (!value.equals(getMRPElementDocumentTypeName())) ) {
                    setMRPElementDocumentTypeName(((String) value));
                }
            }
            if( values.containsKey("MRPElementIsPartiallyDelivered") ) {
                final Object value = values.remove("MRPElementIsPartiallyDelivered");
                if( (value == null) || (!value.equals(getMRPElementIsPartiallyDelivered())) ) {
                    setMRPElementIsPartiallyDelivered(((Boolean) value));
                }
            }
            if( values.containsKey("MRPElementIsReleased") ) {
                final Object value = values.remove("MRPElementIsReleased");
                if( (value == null) || (!value.equals(getMRPElementIsReleased())) ) {
                    setMRPElementIsReleased(((Boolean) value));
                }
            }
            if( values.containsKey("MRPElementItem") ) {
                final Object value = values.remove("MRPElementItem");
                if( (value == null) || (!value.equals(getMRPElementItem())) ) {
                    setMRPElementItem(((String) value));
                }
            }
            if( values.containsKey("MRPElementQuantityIsFirm") ) {
                final Object value = values.remove("MRPElementQuantityIsFirm");
                if( (value == null) || (!value.equals(getMRPElementQuantityIsFirm())) ) {
                    setMRPElementQuantityIsFirm(((Boolean) value));
                }
            }
            if( values.containsKey("MRPElementScheduleLine") ) {
                final Object value = values.remove("MRPElementScheduleLine");
                if( (value == null) || (!value.equals(getMRPElementScheduleLine())) ) {
                    setMRPElementScheduleLine(((String) value));
                }
            }
            if( values.containsKey("ProductionVersion") ) {
                final Object value = values.remove("ProductionVersion");
                if( (value == null) || (!value.equals(getProductionVersion())) ) {
                    setProductionVersion(((String) value));
                }
            }
            if( values.containsKey("SourceMRPElement") ) {
                final Object value = values.remove("SourceMRPElement");
                if( (value == null) || (!value.equals(getSourceMRPElement())) ) {
                    setSourceMRPElement(((String) value));
                }
            }
            if( values.containsKey("SourceMRPElementCategory") ) {
                final Object value = values.remove("SourceMRPElementCategory");
                if( (value == null) || (!value.equals(getSourceMRPElementCategory())) ) {
                    setSourceMRPElementCategory(((String) value));
                }
            }
            if( values.containsKey("SourceMRPElementItem") ) {
                final Object value = values.remove("SourceMRPElementItem");
                if( (value == null) || (!value.equals(getSourceMRPElementItem())) ) {
                    setSourceMRPElementItem(((String) value));
                }
            }
            if( values.containsKey("SourceMRPElementScheduleLine") ) {
                final Object value = values.remove("SourceMRPElementScheduleLine");
                if( (value == null) || (!value.equals(getSourceMRPElementScheduleLine())) ) {
                    setSourceMRPElementScheduleLine(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("TimeHorizonCode") ) {
                final Object value = values.remove("TimeHorizonCode");
                if( (value == null) || (!value.equals(getTimeHorizonCode())) ) {
                    setTimeHorizonCode(((String) value));
                }
            }
            if( values.containsKey("ExceptionMessageNumber") ) {
                final Object value = values.remove("ExceptionMessageNumber");
                if( (value == null) || (!value.equals(getExceptionMessageNumber())) ) {
                    setExceptionMessageNumber(((String) value));
                }
            }
            if( values.containsKey("ExceptionMessageText") ) {
                final Object value = values.remove("ExceptionMessageText");
                if( (value == null) || (!value.equals(getExceptionMessageText())) ) {
                    setExceptionMessageText(((String) value));
                }
            }
            if( values.containsKey("ExceptionMessageNumber2") ) {
                final Object value = values.remove("ExceptionMessageNumber2");
                if( (value == null) || (!value.equals(getExceptionMessageNumber2())) ) {
                    setExceptionMessageNumber2(((String) value));
                }
            }
            if( values.containsKey("ExceptionMessageText2") ) {
                final Object value = values.remove("ExceptionMessageText2");
                if( (value == null) || (!value.equals(getExceptionMessageText2())) ) {
                    setExceptionMessageText2(((String) value));
                }
            }
            if( values.containsKey("PeriodType") ) {
                final Object value = values.remove("PeriodType");
                if( (value == null) || (!value.equals(getPeriodType())) ) {
                    setPeriodType(((String) value));
                }
            }
            if( values.containsKey("PeriodOrSegment") ) {
                final Object value = values.remove("PeriodOrSegment");
                if( (value == null) || (!value.equals(getPeriodOrSegment())) ) {
                    setPeriodOrSegment(((String) value));
                }
            }
            if( values.containsKey("NumberOfWorkdaysPerPeriod") ) {
                final Object value = values.remove("NumberOfWorkdaysPerPeriod");
                if( (value == null) || (!value.equals(getNumberOfWorkdaysPerPeriod())) ) {
                    setNumberOfWorkdaysPerPeriod(((Short) value));
                }
            }
            if( values.containsKey("NumberOfAggregatedItems") ) {
                final Object value = values.remove("NumberOfAggregatedItems");
                if( (value == null) || (!value.equals(getNumberOfAggregatedItems())) ) {
                    setNumberOfAggregatedItems(((Short) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("MRPElementReschedulingDate") ) {
                final Object value = values.remove("MRPElementReschedulingDate");
                if( (value == null) || (!value.equals(getMRPElementReschedulingDate())) ) {
                    setMRPElementReschedulingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtVersion") ) {
                final Object value = values.remove("PlndIndepRqmtVersion");
                if( (value == null) || (!value.equals(getPlndIndepRqmtVersion())) ) {
                    setPlndIndepRqmtVersion(((String) value));
                }
            }
            if( values.containsKey("MaterialShortageProfileCount") ) {
                final Object value = values.remove("MaterialShortageProfileCount");
                if( (value == null) || (!value.equals(getMaterialShortageProfileCount())) ) {
                    setMaterialShortageProfileCount(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SupplyDemandItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplyDemandItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplyDemandItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplyDemandItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService.DEFAULT_SERVICE_PATH);
    }

}
