/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MaterialPlanningDataServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService MaterialPlanningDataService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultMaterialPlanningDataServiceBatch
    extends
    BatchFluentHelperBasic<MaterialPlanningDataServiceBatch, MaterialPlanningDataServiceBatchChangeSet>
    implements
    MaterialPlanningDataServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMaterialPlanningDataServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaterialPlanningDataServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMaterialPlanningDataServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaterialPlanningDataServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMaterialPlanningDataServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaterialPlanningDataServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMaterialPlanningDataServiceBatchChangeSet(this, service);
    }

}
