/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link MaterialPlanningDataServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService MaterialPlanningDataService}.
 *
 */
public class DefaultMaterialPlanningDataServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaterialPlanningDataServiceBatch, MaterialPlanningDataServiceBatchChangeSet>
    implements
    MaterialPlanningDataServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaterialPlanningDataServiceBatchChangeSet(
        @Nonnull final DefaultMaterialPlanningDataServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPlanningDataService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaterialPlanningDataServiceBatchChangeSet getThis()
    {
        return this;
    }

}
