/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial MRPMaterial}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.field.MRPMaterialField
 * MRPMaterialField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.link.MRPMaterialLink
 * MRPMaterialLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_PLANT
 * MRP_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PLANT_NAME
 * PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_AREA_TEXT
 * MRP_AREA_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_AREA_CATEGORY
 * MRP_AREA_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_AREA_CATEGORY_NAME
 * MRP_AREA_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_GROUP_NAME
 * MATERIAL_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_IS_MARKED_FOR_DELETION
 * MATERIAL_IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PLNT_MATL_IS_MARKED_FOR_DELETION
 * PLNT_MATL_IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#CROSS_PLANT_STATUS
 * CROSS_PLANT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#CROSS_PLANT_STATUS_NAME
 * CROSS_PLANT_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#UNIT_OF_MEASURE_NAME
 * UNIT_OF_MEASURE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#LOW_LEVEL_CODE
 * LOW_LEVEL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_IS_CONFIGURABLE
 * MATERIAL_IS_CONFIGURABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_USABILITY_PROFILE
 * MATERIAL_USABILITY_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_USABILITY_PROFILE_NAME
 * MATERIAL_USABILITY_PROFILE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_ABC_CLASSIFICATION
 * MATERIAL_ABC_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_ABC_CLASSIFICATION_DESC
 * MATERIAL_ABC_CLASSIFICATION_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PURCHASING_GROUP_NAME
 * PURCHASING_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_PROCUREMENT_CATEGORY
 * MATERIAL_PROCUREMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_PROCUREMENT_CAT_NAME
 * MATERIAL_PROCUREMENT_CAT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#DEPENDENT_REQUIREMENTS_TYPE
 * DEPENDENT_REQUIREMENTS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#DEPENDENT_REQUIREMENTS_TYPE_NAME
 * DEPENDENT_REQUIREMENTS_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATL_COMP_DISCONTINUATION_TYPE
 * MATL_COMP_DISCONTINUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATL_COMP_DSCONTN_TYPE_NAME
 * MATL_COMP_DSCONTN_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#EFFECTIVE_OUT_DATE
 * EFFECTIVE_OUT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_TYPE
 * MATERIAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_TYPE_NAME
 * MATERIAL_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_GROUP
 * MRP_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_GROUP_NAME
 * MRP_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_CONTROLLER_NAME
 * MRP_CONTROLLER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#RANGE_OF_CVRG_PRFL_CODE
 * RANGE_OF_CVRG_PRFL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#SCHEDULING_FLOAT_PROFILE
 * SCHEDULING_FLOAT_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#CONFIGURABLE_PRODUCT
 * CONFIGURABLE_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#CONFIGURABLE_PRODUCT_NAME
 * CONFIGURABLE_PRODUCT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PROCESSING_TIME
 * PROCESSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#SETUP_AND_TEARDOWN_TIME
 * SETUP_AND_TEARDOWN_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#TRANSITION_TIME
 * TRANSITION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#GOODS_RECEIPT_DURATION
 * GOODS_RECEIPT_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_PLANNED_DELIVERY_DURN
 * MATERIAL_PLANNED_DELIVERY_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_PLANNED_PRODUCTION_DURN
 * MATERIAL_PLANNED_PRODUCTION_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#TOTAL_REPLENISHMENT_LEAD_DURATION
 * TOTAL_REPLENISHMENT_LEAD_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#IS_SAFETY_TIME
 * IS_SAFETY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_SAFETY_DURATION
 * MRP_SAFETY_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PERD_PRFL_FOR_SFTY_TME
 * PERD_PRFL_FOR_SFTY_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#REORDER_THRESHOLD_QUANTITY
 * REORDER_THRESHOLD_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#SAFETY_STOCK_QUANTITY
 * SAFETY_STOCK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#LOT_SIZING_PROCEDURE
 * LOT_SIZING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_LOT_SIZING_PROCEDURE_NAME
 * MATERIAL_LOT_SIZING_PROCEDURE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MINIMUM_LOT_SIZE_QUANTITY
 * MINIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MAXIMUM_LOT_SIZE_QUANTITY
 * MAXIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#FIXED_LOT_SIZE_QUANTITY
 * FIXED_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_MAX_STOCK_LEVEL_QUANTITY
 * MATERIAL_MAX_STOCK_LEVEL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#LOT_SIZE_INDEPENDENT_COSTS
 * LOT_SIZE_INDEPENDENT_COSTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#STORAGE_COSTS_PERCENTAGE_CODE
 * STORAGE_COSTS_PERCENTAGE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#ASSEMBLY_SCRAP_PERCENT
 * ASSEMBLY_SCRAP_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#TAKT_TIME
 * TAKT_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PUR_ORDER_QTY_ROUNDING_QTY
 * PUR_ORDER_QTY_ROUNDING_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#ROUNDING_PROFILE
 * ROUNDING_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PLANNING_STRATEGY_GROUP
 * PLANNING_STRATEGY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#DFLT_STORAGE_LOCATION_EXT_PROCMT
 * DFLT_STORAGE_LOCATION_EXT_PROCMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_PLANNING_CALENDAR
 * MRP_PLANNING_CALENDAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#REPETITIVE_MANUFACTURING_IS_ALLWD
 * REPETITIVE_MANUFACTURING_IS_ALLWD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#REPETITIVE_MANUFACTURING_PROFILE
 * REPETITIVE_MANUFACTURING_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PLANNING_TIME_FENCE_IN_DAYS
 * PLANNING_TIME_FENCE_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_TYPE
 * MRP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_TYPE_NAME
 * MRP_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_PROCUREMENT_PROFILE
 * MATERIAL_PROCUREMENT_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_PROCUREMENT_PROFILE_NAME
 * MATERIAL_PROCUREMENT_PROFILE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PRODUCTION_SUPERVISOR
 * PRODUCTION_SUPERVISOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PRODUCTION_SUPERVISOR_NAME
 * PRODUCTION_SUPERVISOR_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MATERIAL_BASE_QUANTITY
 * MATERIAL_BASE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#PRODUCTION_INVTRY_MANAGED_LOC
 * PRODUCTION_INVTRY_MANAGED_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#STORAGE_LOCATION_NAME
 * STORAGE_LOCATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial#MRP_SAFETY_STOCK_METHOD
 * MRP_SAFETY_STOCK_METHOD}</li>
 * </ul>
 *
 */
public interface MRPMaterialSelectable extends EntitySelectable<MRPMaterial>
{

}
