/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage MaterialCoverage}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.field.MaterialCoverageField
 * MaterialCoverageField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.link.MaterialCoverageLink
 * MaterialCoverageLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_SHORTAGE_PROFILE
 * MATERIAL_SHORTAGE_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_SHORTAGE_PROFILE_COUNT
 * MATERIAL_SHORTAGE_PROFILE_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_PLANNING_SEGMENT_NUMBER
 * MRP_PLANNING_SEGMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_PLANNING_SEGMENT_TYPE
 * MRP_PLANNING_SEGMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_PLANT
 * MRP_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#HAS_ACCEPTED_SHORTAGE
 * HAS_ACCEPTED_SHORTAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#TIME_HORIZON_IN_DAYS
 * TIME_HORIZON_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_SHORTAGE_DURATION
 * MATERIAL_SHORTAGE_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_SHORTAGE_DURN_IN_WORKDAYS
 * MATERIAL_SHORTAGE_DURN_IN_WORKDAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_SAFETY_DURATION
 * MRP_SAFETY_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#DAYS_OF_SUPPLY_DURATION
 * DAYS_OF_SUPPLY_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_BASE_UNIT
 * MATERIAL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_EXTERNAL_ID
 * MATERIAL_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_REPLNMT_LEAD_DURN_END_DATE
 * MATERIAL_REPLNMT_LEAD_DURN_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_SHORTAGE_DEFINITION_NAME
 * MATERIAL_SHORTAGE_DEFINITION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_SHORTAGE_END_DATE
 * MATERIAL_SHORTAGE_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_SHORTAGE_QUANTITY
 * MATERIAL_SHORTAGE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_SHORTAGE_START_DATE
 * MATERIAL_SHORTAGE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_AREA_TEXT
 * MRP_AREA_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_CONTROLLER_NAME
 * MRP_CONTROLLER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_PLANNING_SEGMENT_TYPE_DESC
 * MRP_PLANNING_SEGMENT_TYPE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_PLANT_NAME
 * MRP_PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MRP_SAFETY_DURATION_END_DATE
 * MRP_SAFETY_DURATION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#VLTD_UNRESTRICTED_USE_STK_QTY
 * VLTD_UNRESTRICTED_USE_STK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#QUALITY_INSPECTION_STOCK_QUANTITY
 * QUALITY_INSPECTION_STOCK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage#MATERIAL_LAST_MRP_DATE_TIME
 * MATERIAL_LAST_MRP_DATE_TIME}</li>
 * </ul>
 *
 */
public interface MaterialCoverageSelectable extends EntitySelectable<MaterialCoverage>
{

}
