/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem SupplyDemandItem}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.field.SupplyDemandItemField
 * SupplyDemandItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.link.SupplyDemandItemLink
 * SupplyDemandItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_PLANT
 * MRP_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_PLANNING_SEGMENT
 * MRP_PLANNING_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_PLANNING_SEGMENT_TYPE
 * MRP_PLANNING_SEGMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MATERIAL_SHORTAGE_PROFILE
 * MATERIAL_SHORTAGE_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#DEMAND_CATEGORY_GROUP
 * DEMAND_CATEGORY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#DEMAND_CATEGORY_GROUP_NAME
 * DEMAND_CATEGORY_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#RECEIPT_CATEGORY_GROUP
 * RECEIPT_CATEGORY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#RECEIPT_CATEGORY_GROUP_NAME
 * RECEIPT_CATEGORY_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MATERIAL_BASE_UNIT
 * MATERIAL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#UNIT_OF_MEASURE_NAME
 * UNIT_OF_MEASURE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#UNIT_OF_MEASURE_TEXT
 * UNIT_OF_MEASURE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MATERIAL_EXTERNAL_ID
 * MATERIAL_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_AVAILABILITY
 * MRP_AVAILABILITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MATERIAL_SAFETY_STOCK_QTY
 * MATERIAL_SAFETY_STOCK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_OPEN_QUANTITY
 * MRP_ELEMENT_OPEN_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_AVAILABLE_QUANTITY
 * MRP_AVAILABLE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT
 * MRP_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_AVAILY_OR_RQMT_DATE
 * MRP_ELEMENT_AVAILY_OR_RQMT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_BUSINESS_PARTNER
 * MRP_ELEMENT_BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_BUSINESS_PARTNER_NAME
 * MRP_ELEMENT_BUSINESS_PARTNER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_BUSINESS_PARTNER_TYPE
 * MRP_ELEMENT_BUSINESS_PARTNER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_CATEGORY
 * MRP_ELEMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_CATEGORY_SHORT_NAME
 * MRP_ELEMENT_CATEGORY_SHORT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_CATEGORY_NAME
 * MRP_ELEMENT_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_DOCUMENT_TYPE
 * MRP_ELEMENT_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_DOCUMENT_TYPE_NAME
 * MRP_ELEMENT_DOCUMENT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_IS_PARTIALLY_DELIVERED
 * MRP_ELEMENT_IS_PARTIALLY_DELIVERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_IS_RELEASED
 * MRP_ELEMENT_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_ITEM
 * MRP_ELEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_QUANTITY_IS_FIRM
 * MRP_ELEMENT_QUANTITY_IS_FIRM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_SCHEDULE_LINE
 * MRP_ELEMENT_SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#PRODUCTION_VERSION
 * PRODUCTION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#SOURCE_MRP_ELEMENT
 * SOURCE_MRP_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#SOURCE_MRP_ELEMENT_CATEGORY
 * SOURCE_MRP_ELEMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#SOURCE_MRP_ELEMENT_ITEM
 * SOURCE_MRP_ELEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#SOURCE_MRP_ELEMENT_SCHEDULE_LINE
 * SOURCE_MRP_ELEMENT_SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#TIME_HORIZON_CODE
 * TIME_HORIZON_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#EXCEPTION_MESSAGE_NUMBER
 * EXCEPTION_MESSAGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#EXCEPTION_MESSAGE_TEXT
 * EXCEPTION_MESSAGE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#EXCEPTION_MESSAGE_NUMBER2
 * EXCEPTION_MESSAGE_NUMBER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#EXCEPTION_MESSAGE_TEXT2
 * EXCEPTION_MESSAGE_TEXT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#PERIOD_TYPE
 * PERIOD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#PERIOD_OR_SEGMENT
 * PERIOD_OR_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#NUMBER_OF_WORKDAYS_PER_PERIOD
 * NUMBER_OF_WORKDAYS_PER_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#NUMBER_OF_AGGREGATED_ITEMS
 * NUMBER_OF_AGGREGATED_ITEMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MRP_ELEMENT_RESCHEDULING_DATE
 * MRP_ELEMENT_RESCHEDULING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#PLND_INDEP_RQMT_VERSION
 * PLND_INDEP_RQMT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem#MATERIAL_SHORTAGE_PROFILE_COUNT
 * MATERIAL_SHORTAGE_PROFILE_COUNT}</li>
 * </ul>
 *
 */
public interface SupplyDemandItemSelectable extends EntitySelectable<SupplyDemandItem>
{

}
