/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.field.MaterialValuationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.selectable.MaterialValuationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Material Valuation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialValuation</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialValuation extends VdmEntity<MaterialValuation>
{

    /**
     * Selector for all available fields of MaterialValuation.
     *
     */
    public final static MaterialValuationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostEstimate</b>
     * </p>
     *
     * @return Cost EstimateNo
     */
    @Key
    @SerializedName( "CostEstimate" )
    @JsonProperty( "CostEstimate" )
    @Nullable
    @ODataField( odataName = "CostEstimate" )
    private String costEstimate;
    /**
     * Use with available fluent helpers to apply the <b>CostEstimate</b> field to query operations.
     *
     */
    public final static MaterialValuationField<String> COST_ESTIMATE =
        new MaterialValuationField<String>("CostEstimate");

    @Nonnull
    @Override
    public Class<MaterialValuation> getType()
    {
        return MaterialValuation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostEstimate</b>
     * </p>
     *
     * @param costEstimate
     *            Cost EstimateNo
     */
    public void setCostEstimate( @Nullable final String costEstimate )
    {
        rememberChangedField("CostEstimate", this.costEstimate);
        this.costEstimate = costEstimate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialValuationSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CostEstimate", getCostEstimate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CostEstimate", getCostEstimate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CostEstimate") ) {
                final Object value = values.remove("CostEstimate");
                if( (value == null) || (!value.equals(getCostEstimate())) ) {
                    setCostEstimate(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaterialValuationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialValuationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialValuationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialValuationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPriceService.DEFAULT_SERVICE_PATH);
    }

}
