/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>PriceChangeDocument</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PriceChangeDocument extends VdmComplex<PriceChangeDocument>
{

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>MaterialLedgerDocument</b>
     * </p>
     *
     * @param materialLedgerDocument
     *
     * @return Material Ledger Document Number
     */
    @SerializedName( "MaterialLedgerDocument" )
    @JsonProperty( "MaterialLedgerDocument" )
    @Nullable
    @ODataField( odataName = "MaterialLedgerDocument" )
    private String materialLedgerDocument;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialLedgerDocumentYear</b>
     * </p>
     *
     * @param materialLedgerDocumentYear
     *
     * @return Material Ledger Document Year
     */
    @SerializedName( "MaterialLedgerDocumentYear" )
    @JsonProperty( "MaterialLedgerDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialLedgerDocumentYear" )
    private String materialLedgerDocumentYear;

    @Nonnull
    @Override
    public Class<PriceChangeDocument> getType()
    {
        return PriceChangeDocument.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaterialLedgerDocument", getMaterialLedgerDocument());
        values.put("MaterialLedgerDocumentYear", getMaterialLedgerDocumentYear());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaterialLedgerDocument") ) {
                final Object value = values.remove("MaterialLedgerDocument");
                if( (value == null) || (!value.equals(getMaterialLedgerDocument())) ) {
                    setMaterialLedgerDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialLedgerDocumentYear") ) {
                final Object value = values.remove("MaterialLedgerDocumentYear");
                if( (value == null) || (!value.equals(getMaterialLedgerDocumentYear())) ) {
                    setMaterialLedgerDocumentYear(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>MaterialLedgerDocument</b>
     * </p>
     *
     * @param materialLedgerDocument
     *            Material Ledger Document Number
     */
    public void setMaterialLedgerDocument( @Nullable final String materialLedgerDocument )
    {
        rememberChangedField("MaterialLedgerDocument", this.materialLedgerDocument);
        this.materialLedgerDocument = materialLedgerDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialLedgerDocumentYear</b>
     * </p>
     *
     * @param materialLedgerDocumentYear
     *            Material Ledger Document Year
     */
    public void setMaterialLedgerDocumentYear( @Nullable final String materialLedgerDocumentYear )
    {
        rememberChangedField("MaterialLedgerDocumentYear", this.materialLedgerDocumentYear);
        this.materialLedgerDocumentYear = materialLedgerDocumentYear;
    }

}
