/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MaterialPriceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPriceService MaterialPriceService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultMaterialPriceServiceBatch
    extends
    BatchFluentHelperBasic<MaterialPriceServiceBatch, MaterialPriceServiceBatchChangeSet>
    implements
    MaterialPriceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPriceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMaterialPriceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaterialPriceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPriceService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPriceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMaterialPriceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaterialPriceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPriceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMaterialPriceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaterialPriceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMaterialPriceServiceBatchChangeSet(this, service);
    }

}
