/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link MaterialPriceServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPriceService MaterialPriceService}.
 *
 */
public class DefaultMaterialPriceServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaterialPriceServiceBatch, MaterialPriceServiceBatchChangeSet>
    implements
    MaterialPriceServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPriceService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaterialPriceServiceBatchChangeSet(
        @Nonnull final DefaultMaterialPriceServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialPriceService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaterialPriceServiceBatchChangeSet getThis()
    {
        return this;
    }

}
