/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.MaterialValuation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.MaterialValuation MaterialValuation}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.field.MaterialValuationField
 * MaterialValuationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.link.MaterialValuationLink
 * MaterialValuationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.MaterialValuation#COST_ESTIMATE
 * COST_ESTIMATE}</li>
 * </ul>
 *
 */
public interface MaterialValuationSelectable extends EntitySelectable<MaterialValuation>
{

}
