/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.field.MaterialStockField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.link.MaterialStockLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.selectable.MaterialStockSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Material Master
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_MaterialStockType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialStock extends VdmEntity<MaterialStock>
{

    /**
     * Selector for all available fields of MaterialStock.
     *
     */
    public final static MaterialStockSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaterialStockField<String> MATERIAL = new MaterialStockField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "MaterialBaseUnit" )
    @JsonProperty( "MaterialBaseUnit" )
    @Nullable
    @ODataField( odataName = "MaterialBaseUnit" )
    private String materialBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseUnit</b> field to query operations.
     *
     */
    public final static MaterialStockField<String> MATERIAL_BASE_UNIT =
        new MaterialStockField<String>("MaterialBaseUnit");
    /**
     * Navigation property <b>to_MatlStkInAcctMod</b> for <b>MaterialStock</b> to multiple <b>MatlStkInAcctMod</b>.
     *
     */
    @SerializedName( "to_MatlStkInAcctMod" )
    @JsonProperty( "to_MatlStkInAcctMod" )
    @ODataField( odataName = "to_MatlStkInAcctMod" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MatlStkInAcctMod> toMatlStkInAcctMod;
    /**
     * Use with available fluent helpers to apply the <b>to_MatlStkInAcctMod</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialStockLink<MatlStkInAcctMod> TO_MATL_STK_IN_ACCT_MOD =
        new MaterialStockLink<MatlStkInAcctMod>("to_MatlStkInAcctMod");

    @Nonnull
    @Override
    public Class<MaterialStock> getType()
    {
        return MaterialStock.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @param materialBaseUnit
     *            Base Unit of Measure
     */
    public void setMaterialBaseUnit( @Nullable final String materialBaseUnit )
    {
        rememberChangedField("MaterialBaseUnit", this.materialBaseUnit);
        this.materialBaseUnit = materialBaseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_MaterialStock";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("MaterialBaseUnit", getMaterialBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialBaseUnit") ) {
                final Object value = values.remove("MaterialBaseUnit");
                if( (value == null) || (!value.equals(getMaterialBaseUnit())) ) {
                    setMaterialBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MatlStkInAcctMod") ) {
                final Object value = (values).remove("to_MatlStkInAcctMod");
                if( value instanceof Iterable ) {
                    if( toMatlStkInAcctMod == null ) {
                        toMatlStkInAcctMod = Lists.newArrayList();
                    } else {
                        toMatlStkInAcctMod = Lists.newArrayList(toMatlStkInAcctMod);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MatlStkInAcctMod entity;
                        if( toMatlStkInAcctMod.size() > i ) {
                            entity = toMatlStkInAcctMod.get(i);
                        } else {
                            entity = new MatlStkInAcctMod();
                            toMatlStkInAcctMod.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaterialStockField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialStockField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialStockField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialStockField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMatlStkInAcctMod != null ) {
            (values).put("to_MatlStkInAcctMod", toMatlStkInAcctMod);
        }
        return values;
    }

    /**
     * Fetches the <b>MatlStkInAcctMod</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MatlStkInAcctMod</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MatlStkInAcctMod</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MatlStkInAcctMod> fetchMatlStkInAcctMod()
    {
        return fetchFieldAsList("to_MatlStkInAcctMod", MatlStkInAcctMod.class);
    }

    /**
     * Retrieval of associated <b>MatlStkInAcctMod</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_MatlStkInAcctMod</b>.
     * <p>
     * If the navigation property <b>to_MatlStkInAcctMod</b> of a queried <b>MaterialStock</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MatlStkInAcctMod</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MatlStkInAcctMod> getMatlStkInAcctModOrFetch()
    {
        if( toMatlStkInAcctMod == null ) {
            toMatlStkInAcctMod = fetchMatlStkInAcctMod();
        }
        return toMatlStkInAcctMod;
    }

    /**
     * Retrieval of associated <b>MatlStkInAcctMod</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_MatlStkInAcctMod</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialStock</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MatlStkInAcctMod</b> is already loaded, the result will
     *         contain the <b>MatlStkInAcctMod</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MatlStkInAcctMod>> getMatlStkInAcctModIfPresent()
    {
        return Option.of(toMatlStkInAcctMod);
    }

    /**
     * Overwrites the list of associated <b>MatlStkInAcctMod</b> entities for the loaded navigation property
     * <b>to_MatlStkInAcctMod</b>.
     * <p>
     * If the navigation property <b>to_MatlStkInAcctMod</b> of a queried <b>MaterialStock</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MatlStkInAcctMod</b> entities.
     */
    public void setMatlStkInAcctMod( @Nonnull final List<MatlStkInAcctMod> value )
    {
        if( toMatlStkInAcctMod == null ) {
            toMatlStkInAcctMod = Lists.newArrayList();
        }
        toMatlStkInAcctMod.clear();
        toMatlStkInAcctMod.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MatlStkInAcctMod</b> entities. This corresponds to the OData
     * navigation property <b>to_MatlStkInAcctMod</b>.
     * <p>
     * If the navigation property <b>to_MatlStkInAcctMod</b> of a queried <b>MaterialStock</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MatlStkInAcctMod</b> entities.
     */
    public void addMatlStkInAcctMod( MatlStkInAcctMod... entity )
    {
        if( toMatlStkInAcctMod == null ) {
            toMatlStkInAcctMod = Lists.newArrayList();
        }
        toMatlStkInAcctMod.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaterialStock instances.
     *
     */
    public final static class MaterialStockBuilder
    {

        private List<MatlStkInAcctMod> toMatlStkInAcctMod = Lists.newArrayList();

        private MaterialStock.MaterialStockBuilder toMatlStkInAcctMod( final List<MatlStkInAcctMod> value )
        {
            toMatlStkInAcctMod.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MatlStkInAcctMod</b> for <b>MaterialStock</b> to multiple <b>MatlStkInAcctMod</b>.
         *
         * @param value
         *            The MatlStkInAcctMods to build this MaterialStock with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialStock.MaterialStockBuilder matlStkInAcctMod( MatlStkInAcctMod... value )
        {
            return toMatlStkInAcctMod(Lists.newArrayList(value));
        }

    }

}
