/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.field.MatlStkInAcctModField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.link.MatlStkInAcctModOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.selectable.MatlStkInAcctModSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Material Stock
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_MatlStkInAcctModType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MatlStkInAcctMod extends VdmEntity<MatlStkInAcctMod>
{

    /**
     * Selector for all available fields of MatlStkInAcctMod.
     *
     */
    public final static MatlStkInAcctModSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material in Respect of Which Stock is Managed
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> MATERIAL = new MatlStkInAcctModField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> PLANT = new MatlStkInAcctModField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @Key
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> STORAGE_LOCATION =
        new MatlStkInAcctModField<String>("StorageLocation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number (Stock Identifier)
     */
    @Key
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> BATCH = new MatlStkInAcctModField<String>("Batch");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier for Special Stock
     */
    @Key
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> SUPPLIER = new MatlStkInAcctModField<String>("Supplier");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer for Special Stock
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> CUSTOMER = new MatlStkInAcctModField<String>("Customer");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return Valuated Sales Order Stock WBS Element
     */
    @Key
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> WBS_ELEMENT_INTERNAL_ID =
        new MatlStkInAcctModField<String>("WBSElementInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SDDocument</b>
     * </p>
     *
     * @return Sales order number of valuated sales order stock
     */
    @Key
    @SerializedName( "SDDocument" )
    @JsonProperty( "SDDocument" )
    @Nullable
    @ODataField( odataName = "SDDocument" )
    private String sDDocument;
    /**
     * Use with available fluent helpers to apply the <b>SDDocument</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> SD_DOCUMENT = new MatlStkInAcctModField<String>("SDDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentItem</b>
     * </p>
     *
     * @return Sales Order Item of Valuated Sales Order Stock
     */
    @Key
    @SerializedName( "SDDocumentItem" )
    @JsonProperty( "SDDocumentItem" )
    @Nullable
    @ODataField( odataName = "SDDocumentItem" )
    private String sDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentItem</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> SD_DOCUMENT_ITEM =
        new MatlStkInAcctModField<String>("SDDocumentItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @return Special Stock Type
     */
    @Key
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> INVENTORY_SPECIAL_STOCK_TYPE =
        new MatlStkInAcctModField<String>("InventorySpecialStockType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InventoryStockType</b>
     * </p>
     *
     * @return Stock Type of Goods Movement (Stock Identifier)
     */
    @Key
    @SerializedName( "InventoryStockType" )
    @JsonProperty( "InventoryStockType" )
    @Nullable
    @ODataField( odataName = "InventoryStockType" )
    private String inventoryStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryStockType</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> INVENTORY_STOCK_TYPE =
        new MatlStkInAcctModField<String>("InventoryStockType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "MaterialBaseUnit" )
    @JsonProperty( "MaterialBaseUnit" )
    @Nullable
    @ODataField( odataName = "MaterialBaseUnit" )
    private String materialBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseUnit</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<String> MATERIAL_BASE_UNIT =
        new MatlStkInAcctModField<String>("MaterialBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>MatlWrhsStkQtyInMatlBaseUnit</b>
     * </p>
     *
     * @return The matlWrhsStkQtyInMatlBaseUnit contained in this entity.
     */
    @SerializedName( "MatlWrhsStkQtyInMatlBaseUnit" )
    @JsonProperty( "MatlWrhsStkQtyInMatlBaseUnit" )
    @Nullable
    @ODataField( odataName = "MatlWrhsStkQtyInMatlBaseUnit" )
    private BigDecimal matlWrhsStkQtyInMatlBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MatlWrhsStkQtyInMatlBaseUnit</b> field to query operations.
     *
     */
    public final static MatlStkInAcctModField<BigDecimal> MATL_WRHS_STK_QTY_IN_MATL_BASE_UNIT =
        new MatlStkInAcctModField<BigDecimal>("MatlWrhsStkQtyInMatlBaseUnit");
    /**
     * Navigation property <b>to_MaterialStock</b> for <b>MatlStkInAcctMod</b> to single <b>MaterialStock</b>.
     *
     */
    @SerializedName( "to_MaterialStock" )
    @JsonProperty( "to_MaterialStock" )
    @ODataField( odataName = "to_MaterialStock" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaterialStock toMaterialStock;
    /**
     * Use with available fluent helpers to apply the <b>to_MaterialStock</b> navigation property to query operations.
     *
     */
    public final static MatlStkInAcctModOneToOneLink<MaterialStock> TO_MATERIAL_STOCK =
        new MatlStkInAcctModOneToOneLink<MaterialStock>("to_MaterialStock");

    @Nonnull
    @Override
    public Class<MatlStkInAcctMod> getType()
    {
        return MatlStkInAcctMod.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material in Respect of Which Stock is Managed
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number (Stock Identifier)
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier for Special Stock
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer for Special Stock
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            Valuated Sales Order Stock WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SDDocument</b>
     * </p>
     *
     * @param sDDocument
     *            Sales order number of valuated sales order stock
     */
    public void setSDDocument( @Nullable final String sDDocument )
    {
        rememberChangedField("SDDocument", this.sDDocument);
        this.sDDocument = sDDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentItem</b>
     * </p>
     *
     * @param sDDocumentItem
     *            Sales Order Item of Valuated Sales Order Stock
     */
    public void setSDDocumentItem( @Nullable final String sDDocumentItem )
    {
        rememberChangedField("SDDocumentItem", this.sDDocumentItem);
        this.sDDocumentItem = sDDocumentItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Special Stock Type
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InventoryStockType</b>
     * </p>
     *
     * @param inventoryStockType
     *            Stock Type of Goods Movement (Stock Identifier)
     */
    public void setInventoryStockType( @Nullable final String inventoryStockType )
    {
        rememberChangedField("InventoryStockType", this.inventoryStockType);
        this.inventoryStockType = inventoryStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @param materialBaseUnit
     *            Base Unit of Measure
     */
    public void setMaterialBaseUnit( @Nullable final String materialBaseUnit )
    {
        rememberChangedField("MaterialBaseUnit", this.materialBaseUnit);
        this.materialBaseUnit = materialBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>MatlWrhsStkQtyInMatlBaseUnit</b>
     * </p>
     *
     * @param matlWrhsStkQtyInMatlBaseUnit
     *            The matlWrhsStkQtyInMatlBaseUnit to set.
     */
    public void setMatlWrhsStkQtyInMatlBaseUnit( @Nullable final BigDecimal matlWrhsStkQtyInMatlBaseUnit )
    {
        rememberChangedField("MatlWrhsStkQtyInMatlBaseUnit", this.matlWrhsStkQtyInMatlBaseUnit);
        this.matlWrhsStkQtyInMatlBaseUnit = matlWrhsStkQtyInMatlBaseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_MatlStkInAcctMod";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("StorageLocation", getStorageLocation());
        result.put("Batch", getBatch());
        result.put("Supplier", getSupplier());
        result.put("Customer", getCustomer());
        result.put("WBSElementInternalID", getWBSElementInternalID());
        result.put("SDDocument", getSDDocument());
        result.put("SDDocumentItem", getSDDocumentItem());
        result.put("InventorySpecialStockType", getInventorySpecialStockType());
        result.put("InventoryStockType", getInventoryStockType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("Batch", getBatch());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("SDDocument", getSDDocument());
        values.put("SDDocumentItem", getSDDocumentItem());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("InventoryStockType", getInventoryStockType());
        values.put("MaterialBaseUnit", getMaterialBaseUnit());
        values.put("MatlWrhsStkQtyInMatlBaseUnit", getMatlWrhsStkQtyInMatlBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("SDDocument") ) {
                final Object value = values.remove("SDDocument");
                if( (value == null) || (!value.equals(getSDDocument())) ) {
                    setSDDocument(((String) value));
                }
            }
            if( values.containsKey("SDDocumentItem") ) {
                final Object value = values.remove("SDDocumentItem");
                if( (value == null) || (!value.equals(getSDDocumentItem())) ) {
                    setSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("InventoryStockType") ) {
                final Object value = values.remove("InventoryStockType");
                if( (value == null) || (!value.equals(getInventoryStockType())) ) {
                    setInventoryStockType(((String) value));
                }
            }
            if( values.containsKey("MaterialBaseUnit") ) {
                final Object value = values.remove("MaterialBaseUnit");
                if( (value == null) || (!value.equals(getMaterialBaseUnit())) ) {
                    setMaterialBaseUnit(((String) value));
                }
            }
            if( values.containsKey("MatlWrhsStkQtyInMatlBaseUnit") ) {
                final Object value = values.remove("MatlWrhsStkQtyInMatlBaseUnit");
                if( (value == null) || (!value.equals(getMatlWrhsStkQtyInMatlBaseUnit())) ) {
                    setMatlWrhsStkQtyInMatlBaseUnit(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaterialStock") ) {
                final Object value = (values).remove("to_MaterialStock");
                if( value instanceof Map ) {
                    if( toMaterialStock == null ) {
                        toMaterialStock = new MaterialStock();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaterialStock.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MatlStkInAcctModField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MatlStkInAcctModField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MatlStkInAcctModField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MatlStkInAcctModField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaterialStock != null ) {
            (values).put("to_MaterialStock", toMaterialStock);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialStock</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_MaterialStock</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaterialStock</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialStock fetchMaterialStock()
    {
        return fetchFieldAsSingle("to_MaterialStock", MaterialStock.class);
    }

    /**
     * Retrieval of associated <b>MaterialStock</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaterialStock</b>.
     * <p>
     * If the navigation property <b>to_MaterialStock</b> of a queried <b>MatlStkInAcctMod</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialStock</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialStock getMaterialStockOrFetch()
    {
        if( toMaterialStock == null ) {
            toMaterialStock = fetchMaterialStock();
        }
        return toMaterialStock;
    }

    /**
     * Retrieval of associated <b>MaterialStock</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaterialStock</b>.
     * <p>
     * If the navigation property for an entity <b>MatlStkInAcctMod</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaterialStock</b> is already loaded, the result will
     *         contain the <b>MaterialStock</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaterialStock> getMaterialStockIfPresent()
    {
        return Option.of(toMaterialStock);
    }

    /**
     * Overwrites the associated <b>MaterialStock</b> entity for the loaded navigation property <b>to_MaterialStock</b>.
     *
     * @param value
     *            New <b>MaterialStock</b> entity.
     */
    public void setMaterialStock( final MaterialStock value )
    {
        toMaterialStock = value;
    }

    /**
     * Helper class to allow for fluent creation of MatlStkInAcctMod instances.
     *
     */
    public final static class MatlStkInAcctModBuilder
    {

        private MaterialStock toMaterialStock;

        private MatlStkInAcctMod.MatlStkInAcctModBuilder toMaterialStock( final MaterialStock value )
        {
            toMaterialStock = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaterialStock</b> for <b>MatlStkInAcctMod</b> to single <b>MaterialStock</b>.
         *
         * @param value
         *            The MaterialStock to build this MatlStkInAcctMod with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MatlStkInAcctMod.MatlStkInAcctModBuilder materialStock( final MaterialStock value )
        {
            return toMaterialStock(value);
        }

    }

}
