/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MaterialStockDisplayServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService MaterialStockDisplayService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultMaterialStockDisplayServiceBatch
    extends
    BatchFluentHelperBasic<MaterialStockDisplayServiceBatch, MaterialStockDisplayServiceBatchChangeSet>
    implements
    MaterialStockDisplayServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMaterialStockDisplayServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaterialStockDisplayServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMaterialStockDisplayServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaterialStockDisplayServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMaterialStockDisplayServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaterialStockDisplayServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMaterialStockDisplayServiceBatchChangeSet(this, service);
    }

}
