/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link MaterialStockDisplayServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService MaterialStockDisplayService}.
 *
 */
public class DefaultMaterialStockDisplayServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaterialStockDisplayServiceBatch, MaterialStockDisplayServiceBatchChangeSet>
    implements
    MaterialStockDisplayServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaterialStockDisplayServiceBatchChangeSet(
        @Nonnull final DefaultMaterialStockDisplayServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaterialStockDisplayService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaterialStockDisplayServiceBatchChangeSet getThis()
    {
        return this;
    }

}
