/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStock;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStock MaterialStock}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.field.MaterialStockField
 * MaterialStockField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.link.MaterialStockLink
 * MaterialStockLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStock#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStock#MATERIAL_BASE_UNIT
 * MATERIAL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStock#TO_MATL_STK_IN_ACCT_MOD
 * TO_MATL_STK_IN_ACCT_MOD}</li>
 * </ul>
 *
 */
public interface MaterialStockSelectable extends EntitySelectable<MaterialStock>
{

}
