/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod MatlStkInAcctMod}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.field.MatlStkInAcctModField
 * MatlStkInAcctModField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.link.MatlStkInAcctModLink
 * MatlStkInAcctModLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#SD_DOCUMENT
 * SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#SD_DOCUMENT_ITEM
 * SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#INVENTORY_SPECIAL_STOCK_TYPE
 * INVENTORY_SPECIAL_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#INVENTORY_STOCK_TYPE
 * INVENTORY_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#MATERIAL_BASE_UNIT
 * MATERIAL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#MATL_WRHS_STK_QTY_IN_MATL_BASE_UNIT
 * MATL_WRHS_STK_QTY_IN_MATL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod#TO_MATERIAL_STOCK
 * TO_MATERIAL_STOCK}</li>
 * </ul>
 *
 */
public interface MatlStkInAcctModSelectable extends EntitySelectable<MatlStkInAcctMod>
{

}
