/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.field.BOMItemCategoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.link.BOMItemCategoryOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.selectable.BOMItemCategorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Category
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BOMItemCategoryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BOMItemCategory extends VdmEntity<BOMItemCategory>
{

    /**
     * Selector for all available fields of BOMItemCategory.
     *
     */
    public final static BOMItemCategorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @return Item category (bill of material)
     */
    @Key
    @SerializedName( "BillOfMaterialItemCategory" )
    @JsonProperty( "BillOfMaterialItemCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemCategory" )
    private String billOfMaterialItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemCategory</b> field to query operations.
     *
     */
    public final static BOMItemCategoryField<String> BILL_OF_MATERIAL_ITEM_CATEGORY =
        new BOMItemCategoryField<String>("BillOfMaterialItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedItemCategory</b>
     * </p>
     *
     * @return Item category (bill of material)
     */
    @SerializedName( "FixedItemCategory" )
    @JsonProperty( "FixedItemCategory" )
    @Nullable
    @ODataField( odataName = "FixedItemCategory" )
    private String fixedItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>FixedItemCategory</b> field to query operations.
     *
     */
    public final static BOMItemCategoryField<String> FIXED_ITEM_CATEGORY =
        new BOMItemCategoryField<String>("FixedItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategoryDesc</b>
     * </p>
     *
     * @return Item Category Description
     */
    @SerializedName( "BillOfMaterialItemCategoryDesc" )
    @JsonProperty( "BillOfMaterialItemCategoryDesc" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemCategoryDesc" )
    private String billOfMaterialItemCategoryDesc;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemCategoryDesc</b> field to query operations.
     *
     */
    public final static BOMItemCategoryField<String> BILL_OF_MATERIAL_ITEM_CATEGORY_DESC =
        new BOMItemCategoryField<String>("BillOfMaterialItemCategoryDesc");
    /**
     * Navigation property <b>to_BOMItemCategoryText</b> for <b>BOMItemCategory</b> to single
     * <b>BOMItemCategoryText</b>.
     *
     */
    @SerializedName( "to_BOMItemCategoryText" )
    @JsonProperty( "to_BOMItemCategoryText" )
    @ODataField( odataName = "to_BOMItemCategoryText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BOMItemCategoryText toBOMItemCategoryText;
    /**
     * Use with available fluent helpers to apply the <b>to_BOMItemCategoryText</b> navigation property to query
     * operations.
     *
     */
    public final static BOMItemCategoryOneToOneLink<BOMItemCategoryText> TO_BOM_ITEM_CATEGORY_TEXT =
        new BOMItemCategoryOneToOneLink<BOMItemCategoryText>("to_BOMItemCategoryText");

    @Nonnull
    @Override
    public Class<BOMItemCategory> getType()
    {
        return BOMItemCategory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     */
    public void setBillOfMaterialItemCategory( @Nullable final String billOfMaterialItemCategory )
    {
        rememberChangedField("BillOfMaterialItemCategory", this.billOfMaterialItemCategory);
        this.billOfMaterialItemCategory = billOfMaterialItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedItemCategory</b>
     * </p>
     *
     * @param fixedItemCategory
     *            Item category (bill of material)
     */
    public void setFixedItemCategory( @Nullable final String fixedItemCategory )
    {
        rememberChangedField("FixedItemCategory", this.fixedItemCategory);
        this.fixedItemCategory = fixedItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategoryDesc</b>
     * </p>
     *
     * @param billOfMaterialItemCategoryDesc
     *            Item Category Description
     */
    public void setBillOfMaterialItemCategoryDesc( @Nullable final String billOfMaterialItemCategoryDesc )
    {
        rememberChangedField("BillOfMaterialItemCategoryDesc", this.billOfMaterialItemCategoryDesc);
        this.billOfMaterialItemCategoryDesc = billOfMaterialItemCategoryDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BOMItemCategory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillOfMaterialItemCategory", getBillOfMaterialItemCategory());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillOfMaterialItemCategory", getBillOfMaterialItemCategory());
        values.put("FixedItemCategory", getFixedItemCategory());
        values.put("BillOfMaterialItemCategoryDesc", getBillOfMaterialItemCategoryDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillOfMaterialItemCategory") ) {
                final Object value = values.remove("BillOfMaterialItemCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialItemCategory())) ) {
                    setBillOfMaterialItemCategory(((String) value));
                }
            }
            if( values.containsKey("FixedItemCategory") ) {
                final Object value = values.remove("FixedItemCategory");
                if( (value == null) || (!value.equals(getFixedItemCategory())) ) {
                    setFixedItemCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemCategoryDesc") ) {
                final Object value = values.remove("BillOfMaterialItemCategoryDesc");
                if( (value == null) || (!value.equals(getBillOfMaterialItemCategoryDesc())) ) {
                    setBillOfMaterialItemCategoryDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BOMItemCategoryText") ) {
                final Object value = (values).remove("to_BOMItemCategoryText");
                if( value instanceof Map ) {
                    if( toBOMItemCategoryText == null ) {
                        toBOMItemCategoryText = new BOMItemCategoryText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBOMItemCategoryText.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BOMItemCategoryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BOMItemCategoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BOMItemCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BOMItemCategoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBOMItemCategoryText != null ) {
            (values).put("to_BOMItemCategoryText", toBOMItemCategoryText);
        }
        return values;
    }

    /**
     * Fetches the <b>BOMItemCategoryText</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BOMItemCategoryText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BOMItemCategoryText</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BOMItemCategoryText fetchBOMItemCategoryText()
    {
        return fetchFieldAsSingle("to_BOMItemCategoryText", BOMItemCategoryText.class);
    }

    /**
     * Retrieval of associated <b>BOMItemCategoryText</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BOMItemCategoryText</b>.
     * <p>
     * If the navigation property <b>to_BOMItemCategoryText</b> of a queried <b>BOMItemCategory</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BOMItemCategoryText</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BOMItemCategoryText getBOMItemCategoryTextOrFetch()
    {
        if( toBOMItemCategoryText == null ) {
            toBOMItemCategoryText = fetchBOMItemCategoryText();
        }
        return toBOMItemCategoryText;
    }

    /**
     * Retrieval of associated <b>BOMItemCategoryText</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BOMItemCategoryText</b>.
     * <p>
     * If the navigation property for an entity <b>BOMItemCategory</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BOMItemCategoryText</b> is already loaded, the result
     *         will contain the <b>BOMItemCategoryText</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BOMItemCategoryText> getBOMItemCategoryTextIfPresent()
    {
        return Option.of(toBOMItemCategoryText);
    }

    /**
     * Overwrites the associated <b>BOMItemCategoryText</b> entity for the loaded navigation property
     * <b>to_BOMItemCategoryText</b>.
     *
     * @param value
     *            New <b>BOMItemCategoryText</b> entity.
     */
    public void setBOMItemCategoryText( final BOMItemCategoryText value )
    {
        toBOMItemCategoryText = value;
    }

    /**
     * Helper class to allow for fluent creation of BOMItemCategory instances.
     *
     */
    public final static class BOMItemCategoryBuilder
    {

        private BOMItemCategoryText toBOMItemCategoryText;

        private BOMItemCategory.BOMItemCategoryBuilder toBOMItemCategoryText( final BOMItemCategoryText value )
        {
            toBOMItemCategoryText = value;
            return this;
        }

        /**
         * Navigation property <b>to_BOMItemCategoryText</b> for <b>BOMItemCategory</b> to single
         * <b>BOMItemCategoryText</b>.
         *
         * @param value
         *            The BOMItemCategoryText to build this BOMItemCategory with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BOMItemCategory.BOMItemCategoryBuilder bomItemCategoryText( final BOMItemCategoryText value )
        {
            return toBOMItemCategoryText(value);
        }

    }

}
