/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.selectable.SalesOrderBOMSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM SalesOrderBOM} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class SalesOrderBOMByKeyFluentHelper
    extends
    FluentHelperByKey<SalesOrderBOMByKeyFluentHelper, SalesOrderBOM, SalesOrderBOMSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM SalesOrderBOM}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesOrderBOM}
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesOrderBOM}
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public SalesOrderBOMByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String billOfMaterialCategory,
        final String billOfMaterial,
        final String billOfMaterialVariant,
        final String engineeringChangeDocument,
        final String material,
        final String plant )
    {
        super(servicePath, entityCollection);
        this.key.put("BillOfMaterialCategory", billOfMaterialCategory);
        this.key.put("BillOfMaterial", billOfMaterial);
        this.key.put("BillOfMaterialVariant", billOfMaterialVariant);
        this.key.put("EngineeringChangeDocument", engineeringChangeDocument);
        this.key.put("Material", material);
        this.key.put("Plant", plant);
    }

    @Override
    @Nonnull
    protected Class<SalesOrderBOM> getEntityClass()
    {
        return SalesOrderBOM.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
