/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link OrderBillOfMaterialServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService OrderBillOfMaterialService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultOrderBillOfMaterialServiceBatch
    extends
    BatchFluentHelperBasic<OrderBillOfMaterialServiceBatch, OrderBillOfMaterialServiceBatchChangeSet>
    implements
    OrderBillOfMaterialServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultOrderBillOfMaterialServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultOrderBillOfMaterialServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultOrderBillOfMaterialServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultOrderBillOfMaterialServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultOrderBillOfMaterialServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public OrderBillOfMaterialServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultOrderBillOfMaterialServiceBatchChangeSet(this, service);
    }

}
