/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem;

/**
 * Implementation of the {@link OrderBillOfMaterialServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService OrderBillOfMaterialService}.
 *
 */
public class DefaultOrderBillOfMaterialServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<OrderBillOfMaterialServiceBatch, OrderBillOfMaterialServiceBatchChangeSet>
    implements
    OrderBillOfMaterialServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService service;

    @SuppressWarnings( "deprecation" )
    DefaultOrderBillOfMaterialServiceBatchChangeSet(
        @Nonnull final DefaultOrderBillOfMaterialServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultOrderBillOfMaterialServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public OrderBillOfMaterialServiceBatchChangeSet createSalesOrderBOMItem(
        @Nonnull final SalesOrderBOMItem salesOrderBOMItem )
    {
        return addRequestCreate(service::createSalesOrderBOMItem, salesOrderBOMItem);
    }

    @Nonnull
    @Override
    public OrderBillOfMaterialServiceBatchChangeSet updateSalesOrderBOMItem(
        @Nonnull final SalesOrderBOMItem salesOrderBOMItem )
    {
        return addRequestUpdate(service::updateSalesOrderBOMItem, salesOrderBOMItem);
    }

    @Nonnull
    @Override
    public OrderBillOfMaterialServiceBatchChangeSet deleteSalesOrderBOMItem(
        @Nonnull final SalesOrderBOMItem salesOrderBOMItem )
    {
        return addRequestDelete(service::deleteSalesOrderBOMItem, salesOrderBOMItem);
    }

    @Nonnull
    @Override
    public OrderBillOfMaterialServiceBatchChangeSet createSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM )
    {
        return addRequestCreate(service::createSalesOrderBOM, salesOrderBOM);
    }

    @Nonnull
    @Override
    public OrderBillOfMaterialServiceBatchChangeSet updateSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM )
    {
        return addRequestUpdate(service::updateSalesOrderBOM, salesOrderBOM);
    }

    @Nonnull
    @Override
    public OrderBillOfMaterialServiceBatchChangeSet deleteSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM )
    {
        return addRequestDelete(service::deleteSalesOrderBOM, salesOrderBOM);
    }

}
