/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.OrderBillOfMaterialService
 * OrderBillOfMaterialService}.
 *
 */
public interface OrderBillOfMaterialServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<OrderBillOfMaterialServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<OrderBillOfMaterialServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     * SalesOrderBOMItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *            SalesOrderBOMItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OrderBillOfMaterialServiceBatchChangeSet
        createSalesOrderBOMItem( @Nonnull final SalesOrderBOMItem salesOrderBOMItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     * SalesOrderBOMItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *            SalesOrderBOMItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OrderBillOfMaterialServiceBatchChangeSet
        updateSalesOrderBOMItem( @Nonnull final SalesOrderBOMItem salesOrderBOMItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     * SalesOrderBOMItem} entity in the S/4HANA system.
     *
     * @param salesOrderBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *            SalesOrderBOMItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OrderBillOfMaterialServiceBatchChangeSet
        deleteSalesOrderBOMItem( @Nonnull final SalesOrderBOMItem salesOrderBOMItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     * SalesOrderBOM} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *            SalesOrderBOM} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OrderBillOfMaterialServiceBatchChangeSet createSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     * SalesOrderBOM} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *            SalesOrderBOM} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OrderBillOfMaterialServiceBatchChangeSet updateSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     * SalesOrderBOM} entity in the S/4HANA system.
     *
     * @param salesOrderBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *            SalesOrderBOM} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OrderBillOfMaterialServiceBatchChangeSet deleteSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM );

}
